/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsfloader;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.visualweb.palette.api.CodeClipDragAndDropHandler;
import org.netbeans.modules.visualweb.palette.api.CodeClipPaletteActions;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJavaDataObject;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataObject;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspEditorSupport;
import org.netbeans.modules.visualweb.project.jsfloader.OpenEditOverride;
import org.netbeans.modules.visualweb.project.jsfloader.Utils;
import org.netbeans.modules.visualweb.spi.designer.jsf.DesignerJsfServiceProvider;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsfJavaEditorSupport
extends DataEditorSupport
implements EditorCookie.Observable,
CloseCookie,
PrintCookie {
    static final String MV_ID_DESIGNER = "designer";
    static final String MV_ID_JSP = "jsp";
    static final String MV_ID_JAVA = "java";
    private static final int ELEMENT_INDEX_DESIGNER = 0;
    private static final int ELEMENT_INDEX_JSP = 1;
    private static final int ELEMENT_INDEX_JAVA = 2;
    private static final String ICON_PATH_JSF_JSP = "org/netbeans/modules/visualweb/project/jsfloader/resources/jsfJspObject.gif";
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.visualweb.project.jsfloader.JsfJavaEditorSupport");
    private CloneableTopComponent lastMultiView;

    JsfJavaEditorSupport(JsfJavaDataObject jsfJavaDataObject) {
        super((DataObject)jsfJavaDataObject, (CloneableEditorSupport.Env)new Environment(jsfJavaDataObject));
    }

    public void openDesigner() {
        Mutex.EVENT.writeAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                try {
                    jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                    jFrame.getGlassPane().setVisible(true);
                    CloneableTopComponent cloneableTopComponent = JsfJavaEditorSupport.this.doOpenDesigner();
                    MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)cloneableTopComponent);
                    multiViewHandler.requestActive(multiViewHandler.getPerspectives()[0]);
                }
                finally {
                    jFrame.getGlassPane().setCursor(null);
                    jFrame.getGlassPane().setVisible(false);
                }
            }
        });
    }

    CloneableTopComponent doOpenDesigner() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Assertion failed. WindowsAPI is required to be called from AWT thread only, see http://www.netbeans.org/download/dev/javadoc/OpenAPIs/org/openide/doc-files/threading.html"));
        }
        CloneableTopComponent cloneableTopComponent = this.openCloneableTopComponent();
        cloneableTopComponent.requestActive();
        return cloneableTopComponent;
    }

    public void open() {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                CloneableTopComponent cloneableTopComponent = JsfJavaEditorSupport.this.openCloneableTopComponent();
                cloneableTopComponent.requestActive();
                JsfJavaEditorSupport.this.viewJavaSource((TopComponent)cloneableTopComponent);
            }
        });
    }

    protected void openJsp() {
        Mutex.EVENT.writeAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                try {
                    jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                    jFrame.getGlassPane().setVisible(true);
                    CloneableTopComponent cloneableTopComponent = JsfJavaEditorSupport.this.openCloneableTopComponent();
                    cloneableTopComponent.requestActive();
                    JsfJavaEditorSupport.this.viewJspSource((TopComponent)cloneableTopComponent);
                }
                finally {
                    jFrame.getGlassPane().setCursor(null);
                    jFrame.getGlassPane().setVisible(false);
                }
            }
        });
    }

    protected void notifyClosed() {
        super.notifyClosed();
        this.lastMultiView = null;
    }

    protected boolean notifyModified() {
        JsfJavaDataObject jsfJavaDataObject;
        boolean bl = this.isModified();
        boolean bl2 = super.notifyModified();
        if (bl2 && (jsfJavaDataObject = (JsfJavaDataObject)this.getDataObject()).getPureCookie(SaveCookie.class) == null) {
            jsfJavaDataObject.addSaveCookie(new Save());
            jsfJavaDataObject.setModified(true);
        }
        if (bl != bl2) {
            this.updateMultiViewDisplayName();
        }
        return bl2;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        JsfJavaDataObject jsfJavaDataObject = (JsfJavaDataObject)this.getDataObject();
        SaveCookie saveCookie = jsfJavaDataObject.getPureCookie(SaveCookie.class);
        if (saveCookie != null) {
            jsfJavaDataObject.removeSaveCookie(saveCookie);
            jsfJavaDataObject.setModified(false);
        }
        this.updateMultiViewDisplayName();
    }

    protected void updateTitles() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JsfJavaEditorSupport.super.updateTitles();
            }
        });
    }

    private static boolean canCloseAll(JsfJspEditorSupport jsfJspEditorSupport, JsfJavaEditorSupport jsfJavaEditorSupport) {
        if (jsfJavaEditorSupport.env().isModified() && jsfJavaEditorSupport.isEnvReadOnly()) {
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_FileReadOnlyClosing", (Object[])new Object[]{jsfJavaEditorSupport.getDataObject().getPrimaryFile().getNameExt()}), 2, 2));
            return object == NotifyDescriptor.OK_OPTION;
        }
        boolean bl = jsfJspEditorSupport.env().isModified();
        boolean bl2 = jsfJavaEditorSupport.env().isModified();
        if (bl || bl2) {
            String string = jsfJavaEditorSupport.messageSave();
            ResourceBundle resourceBundle = NbBundle.getBundle(CloneableEditorSupport.class);
            JButton jButton = new JButton(resourceBundle.getString("CTL_Save"));
            jButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Save"));
            jButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Save"));
            JButton jButton2 = new JButton(resourceBundle.getString("CTL_Discard"));
            jButton2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Discard"));
            jButton2.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Discard"));
            jButton2.setMnemonic(resourceBundle.getString("CTL_Discard_Mnemonic").charAt(0));
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, resourceBundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton);
            Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
            if (NotifyDescriptor.CANCEL_OPTION.equals(object) || NotifyDescriptor.CLOSED_OPTION.equals(object)) {
                return false;
            }
            if (jButton.equals(object)) {
                if (bl) {
                    try {
                        jsfJspEditorSupport.saveDocument();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                        return false;
                    }
                }
                if (bl2) {
                    try {
                        jsfJavaEditorSupport.saveDocument();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private DataEditorSupport.Env env() {
        return (DataEditorSupport.Env)this.env;
    }

    private boolean isEnvReadOnly() {
        DataEditorSupport.Env env = this.env();
        return env instanceof DataEditorSupport.Env && !this.getDataObject().getPrimaryFile().canWrite();
    }

    protected CloneableEditorSupport.Pane createPane() {
        CloneableTopComponent cloneableTopComponent;
        JsfJavaDataObject jsfJavaDataObject = (JsfJavaDataObject)this.getDataObject();
        JsfJspDataObject jsfJspDataObject = Utils.findCorrespondingJsfJspDataObject(jsfJavaDataObject.getPrimaryFile(), false);
        if (jsfJspDataObject == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can't find jsp data object for " + this.getDataObject()));
            return super.createPane();
        }
        MultiViewDescription[] multiViewDescriptionArray = new MultiViewDescription[]{new DesignerDesc(jsfJspDataObject), new JspDesc(jsfJspDataObject), new JavaDesc(jsfJavaDataObject, jsfJspDataObject)};
        this.lastMultiView = cloneableTopComponent = MultiViewFactory.createCloneableMultiView((MultiViewDescription[])multiViewDescriptionArray, (MultiViewDescription)multiViewDescriptionArray[0], (CloseOperationHandler)new CloseHandler(jsfJavaDataObject.getPrimaryFile()));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JsfJavaEditorSupport.this.updateMultiViewDisplayName();
                JsfJavaEditorSupport.this.updateMultiViewToolTip();
            }
        });
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)cloneableTopComponent);
        }
        return (CloneableEditorSupport.Pane)cloneableTopComponent;
    }

    void updateMultiViewDisplayName() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateMultiViewDisplayName();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JsfJavaEditorSupport.this.doUpdateMultiViewDisplayName();
                }
            });
        }
    }

    private void doUpdateMultiViewDisplayName() {
        FileObject fileObject = Utils.findJspForJava(this.getDataObject().getPrimaryFile());
        if (fileObject == null || !fileObject.isValid()) {
            return;
        }
        JsfJspEditorSupport jsfJspEditorSupport = Utils.findCorrespondingJsfJspEditorSupport(this.getDataObject().getPrimaryFile(), true);
        if (jsfJspEditorSupport == null) {
            return;
        }
        String string = jsfJspEditorSupport.messageName();
        Enumeration<? extends TopComponent> enumeration = this.getMultiViews();
        while (enumeration.hasMoreElements()) {
            TopComponent topComponent = enumeration.nextElement();
            topComponent.setDisplayName(string);
        }
    }

    void updateMultiViewToolTip() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateMultiViewToolTip();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JsfJavaEditorSupport.this.doUpdateMultiViewToolTip();
                }
            });
        }
    }

    private void doUpdateMultiViewToolTip() {
        JsfJspEditorSupport jsfJspEditorSupport = Utils.findCorrespondingJsfJspEditorSupport(this.getDataObject().getPrimaryFile(), true);
        if (jsfJspEditorSupport == null) {
            return;
        }
        String string = jsfJspEditorSupport.messageToolTip();
        Enumeration<? extends TopComponent> enumeration = this.getMultiViews();
        while (enumeration.hasMoreElements()) {
            TopComponent topComponent = enumeration.nextElement();
            topComponent.setToolTipText(string);
        }
    }

    private Enumeration<? extends TopComponent> getMultiViews() {
        CloneableTopComponent cloneableTopComponent = this.lastMultiView;
        if (cloneableTopComponent == null) {
            Set set = Collections.emptySet();
            return Collections.enumeration(set);
        }
        return cloneableTopComponent.getReference().getComponents();
    }

    private void viewJspSource(final TopComponent topComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doViewJspSource(topComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JsfJavaEditorSupport.this.doViewJspSource(topComponent);
                }
            });
        }
    }

    private void doViewJspSource(TopComponent topComponent) {
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler != null) {
            MultiViewPerspective[] multiViewPerspectiveArray = multiViewHandler.getPerspectives();
            for (int i = 0; i < multiViewPerspectiveArray.length; ++i) {
                if (!MV_ID_JSP.equals(multiViewPerspectiveArray[i].preferredID())) continue;
                multiViewHandler.requestActive(multiViewPerspectiveArray[i]);
                break;
            }
        }
    }

    private void viewJavaSource(final TopComponent topComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doViewJavaSource(topComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JsfJavaEditorSupport.this.doViewJavaSource(topComponent);
                }
            });
        }
    }

    private void doViewJavaSource(TopComponent topComponent) {
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler != null) {
            MultiViewPerspective[] multiViewPerspectiveArray = multiViewHandler.getPerspectives();
            for (int i = 0; i < multiViewPerspectiveArray.length; ++i) {
                if (!MV_ID_JAVA.equals(multiViewPerspectiveArray[i].preferredID())) continue;
                multiViewHandler.requestActive(multiViewPerspectiveArray[i]);
                break;
            }
        }
    }

    private void setLastMultiViewFromChild(Component component) {
        if (component == null) {
            return;
        }
        CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)SwingUtilities.getAncestorOfClass(CloneableTopComponent.class, component);
        if (cloneableTopComponent != null) {
            this.lastMultiView = cloneableTopComponent;
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(JsfJavaDataObject jsfJavaDataObject) {
            super((DataObject)jsfJavaDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return this.getFile().lock();
        }
    }

    private static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -3126744315424172415L;
        private FileObject primaryJsfFileObject;

        private CloseHandler() {
        }

        public CloseHandler(FileObject fileObject) {
            this.primaryJsfFileObject = fileObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            boolean bl;
            DataObject dataObject;
            if (!this.primaryJsfFileObject.isValid()) {
                return true;
            }
            try {
                dataObject = DataObject.find((FileObject)this.primaryJsfFileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return true;
            }
            if (!(dataObject instanceof JsfJavaDataObject)) {
                return true;
            }
            JsfJavaDataObject jsfJavaDataObject = (JsfJavaDataObject)dataObject;
            JsfJavaEditorSupport jsfJavaEditorSupport = jsfJavaDataObject.getCookie(JsfJavaEditorSupport.class);
            JsfJspDataObject jsfJspDataObject = Utils.findCorrespondingJsfJspDataObject(jsfJavaDataObject.getPrimaryFile(), true);
            JsfJspEditorSupport jsfJspEditorSupport = jsfJspDataObject == null ? null : jsfJspDataObject.getCookie(JsfJspEditorSupport.class);
            boolean bl2 = jsfJavaEditorSupport != null && jsfJspEditorSupport != null ? JsfJavaEditorSupport.canCloseAll(jsfJspEditorSupport, jsfJavaEditorSupport) : true;
            if (jsfJavaEditorSupport != null) {
                int n = 0;
                Enumeration enumeration = jsfJavaEditorSupport.getMultiViews();
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement();
                    ++n;
                }
                bl = n <= 1;
            } else {
                bl = true;
            }
            if (bl2 && bl) {
                if (jsfJspEditorSupport != null) {
                    jsfJspEditorSupport.notifyClosed();
                }
                if (jsfJavaEditorSupport != null) {
                    jsfJavaEditorSupport.notifyClosed();
                }
            }
            return bl2;
        }
    }

    private static class JavaEditorTopComponent
    extends CloneableEditor
    implements MultiViewElement,
    CloneableEditorSupport.Pane {
        private static final long serialVersionUID = -3126744316624172415L;
        private static final NavigatorLookupHint NAVIGATOR_HINT = new NavigatorLookupHint(){

            public String getContentType() {
                return "text/x-java";
            }
        };
        private transient JComponent toolbar;
        private transient MultiViewElementCallback multiViewObserver;
        private PaletteController javaPaletteController;
        private WeakReference<Lookup> lookupWRef = new WeakReference<Object>(null);

        JavaEditorTopComponent() {
        }

        JavaEditorTopComponent(CloneableEditorSupport cloneableEditorSupport) {
            super(cloneableEditorSupport);
            this.initialize();
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.initialize();
        }

        private void initialize() {
            DataObject dataObject = ((JsfJavaEditorSupport)this.cloneableEditorSupport()).getDataObject();
            if (dataObject != null) {
                this.setActivatedNodes(new Node[]{dataObject.getNodeDelegate()});
            }
            this.initializePalette();
        }

        private void initializePalette() {
            PaletteController paletteController;
            JsfJavaEditorSupport jsfJavaEditorSupport = (JsfJavaEditorSupport)this.cloneableEditorSupport();
            FileObject fileObject = jsfJavaEditorSupport.getDataObject().getPrimaryFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            String string = "1.5".equals(JsfProjectUtils.getJ2eePlatformVersion((Project)project)) ? "CreatorJavaPalette5" : "CreatorJavaPalette";
            try {
                paletteController = PaletteFactory.createPalette((String)string, (PaletteActions)new CodeClipPaletteActions(string, (CloneableEditor)this), null, (DragAndDropHandler)new CodeClipDragAndDropHandler());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                paletteController = null;
            }
            this.javaPaletteController = paletteController;
        }

        public JComponent getToolbarRepresentation() {
            if (this.toolbar == null) {
                Document document;
                JEditorPane jEditorPane = this.getEditorPane();
                if (jEditorPane != null && (document = jEditorPane.getDocument()) instanceof NbDocument.CustomToolbar) {
                    this.toolbar = ((NbDocument.CustomToolbar)document).createToolbar(jEditorPane);
                }
                if (this.toolbar == null) {
                    this.toolbar = new JPanel();
                }
            }
            return this.toolbar;
        }

        public JComponent getVisualRepresentation() {
            return this;
        }

        public void componentDeactivated() {
            super.componentDeactivated();
        }

        public void componentActivated() {
            super.componentActivated();
        }

        public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
            this.multiViewObserver = multiViewElementCallback;
        }

        public void requestVisible() {
            if (this.multiViewObserver != null) {
                this.multiViewObserver.requestVisible();
            } else {
                super.requestVisible();
            }
        }

        public void requestActive() {
            if (this.multiViewObserver != null) {
                this.multiViewObserver.requestActive();
            } else {
                super.requestActive();
            }
        }

        public void componentClosed() {
            super.componentClosed();
        }

        public void componentShowing() {
            super.componentShowing();
        }

        public void componentHidden() {
            super.componentHidden();
        }

        public void componentOpened() {
            super.componentOpened();
        }

        public void updateName() {
            super.updateName();
        }

        protected boolean closeLast() {
            return true;
        }

        public CloseOperationState canCloseElement() {
            if (!JavaEditorTopComponent.isLastView(this.multiViewObserver.getTopComponent())) {
                return CloseOperationState.STATE_OK;
            }
            return MultiViewFactory.createUnsafeCloseState((String)"ID_CLOSING_JAVA", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
        }

        private static boolean isLastView(TopComponent topComponent) {
            if (!(topComponent instanceof CloneableTopComponent)) {
                return false;
            }
            boolean bl = true;
            Enumeration enumeration = ((CloneableTopComponent)topComponent).getReference().getComponents();
            if (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                if (enumeration.hasMoreElements()) {
                    bl = false;
                }
            }
            return bl;
        }

        public Action[] getActions() {
            return this.multiViewObserver != null ? this.multiViewObserver.createDefaultActions() : super.getActions();
        }

        protected boolean isActiveTC() {
            TopComponent topComponent = JavaEditorTopComponent.getRegistry().getActivated();
            if (topComponent == null) {
                return false;
            }
            if (topComponent == this) {
                return true;
            }
            MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
            return multiViewHandler != null && JsfJavaEditorSupport.MV_ID_JAVA.equals(multiViewHandler.getSelectedPerspective().preferredID());
        }

        public String getDisplayName() {
            JsfJavaEditorSupport jsfJavaEditorSupport = (JsfJavaEditorSupport)this.cloneableEditorSupport();
            JsfJspEditorSupport jsfJspEditorSupport = Utils.findCorrespondingJsfJspEditorSupport(jsfJavaEditorSupport.getDataObject().getPrimaryFile(), true);
            if (jsfJspEditorSupport == null) {
                return null;
            }
            return jsfJspEditorSupport.messageName();
        }

        public Lookup getLookup() {
            Lookup lookup = (Lookup)this.lookupWRef.get();
            if (lookup == null) {
                Lookup lookup2 = super.getLookup();
                if (this.javaPaletteController == null) {
                    lookup = new ProxyLookup(new Lookup[]{lookup2, Lookups.singleton((Object)NAVIGATOR_HINT)});
                } else {
                    DataObject dataObject = ((JsfJavaEditorSupport)this.cloneableEditorSupport()).getDataObject();
                    lookup = new ProxyLookup(new Lookup[]{lookup2, Lookups.fixed((Object[])new Object[]{NAVIGATOR_HINT, this.javaPaletteController})});
                }
                this.lookupWRef = new WeakReference<Lookup>(lookup);
            }
            return lookup;
        }
    }

    private static class JavaDesc
    implements MultiViewDescription,
    Serializable {
        private static final long serialVersionUID = -3126744316624172415L;
        private JsfJavaDataObject jsfJavaDataObject;
        private JsfJspDataObject jsfJspDataObject;

        public JavaDesc(JsfJavaDataObject jsfJavaDataObject, JsfJspDataObject jsfJspDataObject) {
            this.jsfJavaDataObject = jsfJavaDataObject;
            this.jsfJspDataObject = jsfJspDataObject;
        }

        public MultiViewElement createElement() {
            DataEditorSupport dataEditorSupport = this.jsfJavaDataObject.getCookie(JsfJavaEditorSupport.class);
            if (dataEditorSupport != null) {
                dataEditorSupport.prepareDocument();
                final JavaEditorTopComponent javaEditorTopComponent = new JavaEditorTopComponent((CloneableEditorSupport)dataEditorSupport);
                MultiViewElement multiViewElement = !this.jsfJspDataObject.isTemplate() ? new OpenEditOverride.MultiViewDelegate(javaEditorTopComponent, this.preferredID(), (DataObject)this.jsfJspDataObject) : javaEditorTopComponent;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        JsfJavaEditorSupport jsfJavaEditorSupport = JavaDesc.this.jsfJavaDataObject.getCookie(JsfJavaEditorSupport.class);
                        if (jsfJavaEditorSupport != null) {
                            jsfJavaEditorSupport.setLastMultiViewFromChild((Component)javaEditorTopComponent);
                            jsfJavaEditorSupport.updateMultiViewDisplayName();
                            jsfJavaEditorSupport.updateMultiViewToolTip();
                        }
                    }
                });
                return multiViewElement;
            }
            return MultiViewFactory.BLANK_ELEMENT;
        }

        public String preferredID() {
            return JsfJavaEditorSupport.MV_ID_JAVA;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)JsfJavaEditorSupport.ICON_PATH_JSF_JSP);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(JsfJavaEditorSupport.class, (String)"CTL_JavaTabCaption");
        }

        public int getPersistenceType() {
            return 1;
        }
    }

    private static class JspDesc
    implements MultiViewDescription,
    Serializable {
        private static final long serialVersionUID = -3126744316624172415L;
        private JsfJspDataObject jsfJspDataObject;

        public JspDesc(JsfJspDataObject jsfJspDataObject) {
            this.jsfJspDataObject = jsfJspDataObject;
        }

        public MultiViewElement createElement() {
            JsfJspEditorSupport jsfJspEditorSupport = this.jsfJspDataObject.getCookie(JsfJspEditorSupport.class);
            if (jsfJspEditorSupport != null) {
                jsfJspEditorSupport.prepareDocument();
                final MultiViewElement multiViewElement = jsfJspEditorSupport.createMultiViewElement();
                MultiViewElement multiViewElement2 = !this.jsfJspDataObject.isTemplate() ? new OpenEditOverride.MultiViewDelegate(multiViewElement, this.preferredID(), (DataObject)this.jsfJspDataObject) : multiViewElement;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        JsfJavaEditorSupport jsfJavaEditorSupport = Utils.findCorrespondingJsfJavaEditorSupport(JspDesc.this.jsfJspDataObject.getPrimaryFile(), false);
                        if (jsfJavaEditorSupport != null) {
                            jsfJavaEditorSupport.setLastMultiViewFromChild((Component)multiViewElement);
                            jsfJavaEditorSupport.updateMultiViewDisplayName();
                            jsfJavaEditorSupport.updateMultiViewToolTip();
                        }
                    }
                });
                return multiViewElement2;
            }
            return MultiViewFactory.BLANK_ELEMENT;
        }

        public String preferredID() {
            return JsfJavaEditorSupport.MV_ID_JSP;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)JsfJavaEditorSupport.ICON_PATH_JSF_JSP);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(JsfJavaEditorSupport.class, (String)"CTL_JspTabCaption");
        }

        public int getPersistenceType() {
            return 1;
        }
    }

    private static class DesignerDesc
    implements MultiViewDescription,
    Serializable {
        private static final long serialVersionUID = -3126744316624172415L;
        private JsfJspDataObject jsfJspDataObject;

        public DesignerDesc(JsfJspDataObject jsfJspDataObject) {
            this.jsfJspDataObject = jsfJspDataObject;
        }

        public MultiViewElement createElement() {
            if (this.jsfJspDataObject.isTemplate()) {
                return MultiViewFactory.BLANK_ELEMENT;
            }
            final MultiViewElement multiViewElement = DesignerJsfServiceProvider.getDesignerJsfService().createDesignerMultiViewElement((DataObject)this.jsfJspDataObject);
            if (multiViewElement != null) {
                MultiViewElement multiViewElement2 = !this.jsfJspDataObject.isTemplate() ? new OpenEditOverride.MultiViewDelegate(multiViewElement, this.preferredID(), (DataObject)this.jsfJspDataObject) : multiViewElement;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        JsfJavaEditorSupport jsfJavaEditorSupport = Utils.findCorrespondingJsfJavaEditorSupport(DesignerDesc.this.jsfJspDataObject.getPrimaryFile(), false);
                        if (jsfJavaEditorSupport != null) {
                            jsfJavaEditorSupport.setLastMultiViewFromChild(multiViewElement.getVisualRepresentation());
                            jsfJavaEditorSupport.updateMultiViewDisplayName();
                            jsfJavaEditorSupport.updateMultiViewToolTip();
                        }
                    }
                });
                return multiViewElement2;
            }
            return MultiViewFactory.BLANK_ELEMENT;
        }

        public String preferredID() {
            return JsfJavaEditorSupport.MV_ID_DESIGNER;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)JsfJavaEditorSupport.ICON_PATH_JSF_JSP);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(JsfJavaEditorSupport.class, (String)"CTL_DesignerTabCaption");
        }

        public int getPersistenceType() {
            return 2;
        }
    }

    private class Save
    implements SaveCookie {
        private Save() {
        }

        public void save() throws IOException {
            JsfJavaEditorSupport.this.saveDocument();
            JsfJavaEditorSupport.this.getDataObject().setModified(false);
        }
    }
}

