/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.microedition.svg.DataListener;
import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGDefaultListCellRenderer;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.SVGListCellRenderer;
import org.netbeans.microedition.svg.input.InputHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

public class SVGList
extends SVGComponent
implements DataListener {
    private static final String CONTENT = "content";
    private static final String SELECTION = "selection";
    private static final String HIDDEN_TEXT = "hidden_text";
    private static final String BOUNDS = "bound";
    private static final String CONTENT_SUFFIX = "_content";
    private static final String SELECTION_SUFFIX = "_selection";
    private static final String BOUNDS_SUFIX = "_bound";
    private static final String HIDDEN_TEXT_SUFFIX = "_hidden_text";
    private SVGListCellRenderer myRenderer;
    private ListModel myModel;
    private SelectionModel mySelectionModel;
    private InputHandler myHandler;
    private SVGLocatableElement myHiddenText;
    private SVGLocatableElement myContent;
    private SVGLocatableElement mySelection;
    private int myTopIndex;
    private int myCurrentIndex;
    private int myCount = -1;
    private boolean isUIAction;
    private Object myUILock = new Object();
    private boolean isSlave;
    static /* synthetic */ Class class$org$netbeans$microedition$svg$SVGList$DefaultSelectionModel;

    public SVGList(SVGForm form, SVGLocatableElement element) {
        super(form, element);
        SVGLocatableElement bounds = this.initNestedElements();
        this.verify(bounds);
        float height = this.myHiddenText.getFloatTrait("font-size");
        this.myCount = (int)(bounds.getBBox().getHeight() / height);
        this.isSlave = "hidden".equals(this.getElement().getTrait("visibility"));
        this.myRenderer = new SVGDefaultListCellRenderer(height);
        this.setSelectionModel(new DefaultSelectionModel());
        this.myHandler = new ListHandler();
    }

    public SVGList(SVGForm form, String elemId) {
        this(form, (SVGLocatableElement)form.getDocument().getElementById(elemId));
    }

    public SVGListCellRenderer getRenderer() {
        return this.myRenderer;
    }

    public ListModel getModel() {
        return this.myModel;
    }

    public void setModel(ListModel model) {
        if (this.myModel != null) {
            this.myModel.removeDataListener(this);
        }
        this.myModel = model;
        this.myModel.addDataListener(this);
        this.renderList();
    }

    public void setRenderer(SVGListCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    public void setSelectionModel(SelectionModel model) {
        if (this.mySelectionModel != null) {
            this.mySelectionModel.removeDataListener(this);
        }
        this.mySelectionModel = model;
        this.mySelectionModel.addDataListener(this);
    }

    public InputHandler getInputHandler() {
        return this.myHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged(Object source) {
        if (source == this.getSelectionModel()) {
            Object object = this.myUILock;
            synchronized (object) {
                if (!this.isUIAction) {
                    this.renderList();
                }
            }
        } else if (source == this.getModel()) {
            this.renderList();
        }
    }

    SVGLocatableElement getHiddenText() {
        return this.myHiddenText;
    }

    SVGLocatableElement getContent() {
        return this.myContent;
    }

    SVGLocatableElement getSelection() {
        return this.mySelection;
    }

    boolean isSlave() {
        return this.isSlave;
    }

    private SVGLocatableElement initNestedElements() {
        SVGLocatableElement bounds = null;
        if (this.getElement().getId() != null) {
            this.myHiddenText = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + HIDDEN_TEXT_SUFFIX);
            bounds = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + BOUNDS_SUFIX);
            this.myContent = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + CONTENT_SUFFIX);
            this.mySelection = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + SELECTION_SUFFIX);
        }
        if (this.myHiddenText == null) {
            this.myHiddenText = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", HIDDEN_TEXT);
        }
        if (bounds == null) {
            bounds = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", BOUNDS);
        }
        if (this.myContent == null) {
            this.myContent = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", CONTENT);
        }
        if (this.mySelection == null) {
            this.mySelection = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", SELECTION);
        }
        return bounds;
    }

    private void verify(SVGLocatableElement bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("Element with id=" + this.getElement().getId() + " couldn't be List element" + " becuase it doesn't contain nested 'bound' " + "element. See javadoc for SVG snippet.");
        }
        if (this.myContent == null) {
            throw new IllegalArgumentException("Element with id=" + this.getElement().getId() + " couldn't be List element" + " becuase it doesn't contain nested 'content' " + " element. See javadoc for SVG snippet.");
        }
    }

    private void renderList() {
        if (this.myCurrentIndex >= this.myTopIndex + this.myCount) {
            ++this.myTopIndex;
        } else if (this.myCurrentIndex < this.myTopIndex) {
            --this.myTopIndex;
        }
        final int top = this.myTopIndex;
        this.getForm().invokeLaterSafely(new Runnable(){

            public void run() {
                SVGList.this.removeContent();
                SVGList.this.hideSelection();
                ListModel model = SVGList.this.getModel();
                int size = model.getSize();
                SVGListCellRenderer renderer = SVGList.this.getRenderer();
                for (int i = top; i < Math.min(top + SVGList.this.myCount, size); ++i) {
                    renderer.getCellRendererComponent(SVGList.this, model.getElementAt(i), i - top, SVGList.this.getSelectionModel().isSelectedIndex(i));
                }
            }
        });
    }

    private void hideSelection() {
        if (!this.isSlave) {
            this.getSelection().setTrait("visibility", "hidden");
        }
    }

    private void removeContent() {
        SVGLocatableElement content = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", CONTENT);
        Element node = content.getFirstElementChild();
        while (node != null) {
            String display;
            Element next = null;
            if (node instanceof SVGElement) {
                next = ((SVGElement)node).getNextElementSibling();
            }
            if (!"text".equals(node.getLocalName())) {
                content.removeChild((Node)node);
            } else if (node instanceof SVGElement && !"none".equals(display = ((SVGElement)node).getTrait("display"))) {
                Element forRemove = node;
                content.removeChild((Node)forRemove);
            }
            node = next;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ListHandler
    extends InputHandler {
        private ListHandler() {
        }

        public boolean handleKeyPress(SVGComponent comp, int keyCode) {
            return comp instanceof SVGList && (keyCode == -3 || keyCode == -4 || keyCode == -5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleKeyRelease(SVGComponent comp, int keyCode) {
            boolean ret = false;
            if (comp instanceof SVGList) {
                if (keyCode == -3) {
                    SVGList.this.myCurrentIndex = Math.max(0, SVGList.this.myCurrentIndex - 1);
                    Object object = SVGList.this.myUILock;
                    synchronized (object) {
                        SVGList.this.isUIAction = true;
                        SVGList.this.getSelectionModel().clearSelection();
                        SVGList.this.getSelectionModel().addSelectionInterval(SVGList.this.myCurrentIndex, SVGList.this.myCurrentIndex);
                        SVGList.this.isUIAction = false;
                    }
                    SVGList.this.renderList();
                    ret = true;
                } else if (keyCode == -4) {
                    SVGList.this.myCurrentIndex = Math.min(SVGList.this.myCurrentIndex + 1, SVGList.this.getModel().getSize() - 1);
                    Object object = SVGList.this.myUILock;
                    synchronized (object) {
                        SVGList.this.isUIAction = true;
                        SVGList.this.getSelectionModel().clearSelection();
                        SVGList.this.getSelectionModel().addSelectionInterval(SVGList.this.myCurrentIndex, SVGList.this.myCurrentIndex);
                        SVGList.this.isUIAction = false;
                    }
                    SVGList.this.renderList();
                    ret = true;
                } else if (keyCode == -5) {
                    SVGList.this.fireActionPerformed();
                }
            }
            return ret;
        }
    }

    private class DefaultSelectionModel
    implements SelectionModel {
        private int mySelectedIndex;
        private Vector myListeners = new Vector(1);

        DefaultSelectionModel() {
        }

        public boolean isSelectedIndex(int index) {
            return index == this.mySelectedIndex;
        }

        public void addSelectionInterval(int from, int to) {
            if (to != from) {
                throw new IllegalArgumentException((class$org$netbeans$microedition$svg$SVGList$DefaultSelectionModel == null ? (class$org$netbeans$microedition$svg$SVGList$DefaultSelectionModel = SVGList.class$("org.netbeans.microedition.svg.SVGList$DefaultSelectionModel")) : class$org$netbeans$microedition$svg$SVGList$DefaultSelectionModel).getName() + " is not designed" + " for multiple selection");
            }
            this.mySelectedIndex = from;
            this.fireDataChanged();
        }

        public void clearSelection() {
            this.mySelectedIndex = -1;
            this.fireDataChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.addElement(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.removeElement(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireDataChanged() {
            Vector vector = this.myListeners;
            synchronized (vector) {
                Enumeration en = this.myListeners.elements();
                while (en.hasMoreElements()) {
                    DataListener listener = (DataListener)en.nextElement();
                    listener.contentsChanged(this);
                }
            }
        }
    }

    public static class DefaultListMoldel
    implements ListModel {
        private Vector myData;
        private Vector myListeners = new Vector(1);

        public DefaultListMoldel(Vector data) {
            this.myData = new Vector();
            for (int i = 0; i < data.size(); ++i) {
                this.myData.addElement(data.elementAt(i));
            }
        }

        public Object getElementAt(int indx) {
            return this.myData.elementAt(indx);
        }

        public int getSize() {
            return this.myData.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.addElement(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void removeDataListener(DataListener listener) {
            Vector vector = this.myListeners;
            synchronized (vector) {
                this.myListeners.removeElement(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireDataChanged() {
            Vector vector = this.myListeners;
            synchronized (vector) {
                Enumeration en = this.myListeners.elements();
                while (en.hasMoreElements()) {
                    DataListener listener = (DataListener)en.nextElement();
                    listener.contentsChanged(this);
                }
            }
        }
    }

    public static interface SelectionModel {
        public void clearSelection();

        public boolean isSelectedIndex(int var1);

        public void addSelectionInterval(int var1, int var2);

        public void addDataListener(DataListener var1);

        public void removeDataListener(DataListener var1);
    }

    public static interface ListModel {
        public Object getElementAt(int var1);

        public int getSize();

        public void addDataListener(DataListener var1);

        public void removeDataListener(DataListener var1);
    }
}

