/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.input.InputHandler;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;

public class SVGSlider
extends SVGComponent {
    private static final String TRANSFORM = "transform";
    private static final int DEFAULT_MAX = 10;
    private static final String KNOB = "knob";
    private static final String RULE = "rule";
    private static final String KNOB_SUFFIX = "_knob";
    private static final String RULE_SUFFIX = "_rule";
    private int myMin;
    private int myMax = 10;
    private int myStep = 1;
    private int myValue;
    private final InputHandler myInputHandler;
    private SVGLocatableElement myKnobElement;
    private SVGLocatableElement myRuleElement;

    public SVGSlider(SVGForm form, String elemId) {
        super(form, elemId);
        this.initNestedElements();
        this.verify();
        this.myInputHandler = new SliderInputHandler();
        this.setValue(this.myMin);
    }

    public SVGSlider(int min, int max, SVGForm form, String elemId) {
        this(form, elemId);
        this.myMin = min;
        this.myMax = max;
    }

    public int getValue() {
        return this.myValue;
    }

    public InputHandler getInputHandler() {
        return this.myInputHandler;
    }

    public void setValue(int value) {
        if (this.myValue > this.myMax || this.myValue < this.myMin) {
            throw new IllegalArgumentException(value + " is out of range");
        }
        final int step = value - this.myValue;
        this.getForm().invokeLaterSafely(new Runnable(){

            public void run() {
                SVGRect rect = SVGSlider.this.myRuleElement.getBBox();
                float width = rect.getWidth();
                SVGMatrix matrix = SVGSlider.this.myKnobElement.getMatrixTrait(SVGSlider.TRANSFORM);
                matrix.mTranslate((float)step * width / (float)(SVGSlider.this.myMax - SVGSlider.this.myMin), 0.0f);
                SVGSlider.this.myKnobElement.setMatrixTrait(SVGSlider.TRANSFORM, matrix);
            }
        });
        this.myValue = value;
        this.fireActionPerformed();
    }

    public void setMin(int min) {
        this.myMin = min;
    }

    public void setMax(int max) {
        this.myMax = max;
    }

    public int getMin() {
        return this.myMin;
    }

    public int getMax() {
        return this.myMax;
    }

    private void initNestedElements() {
        if (this.getElement().getId() != null) {
            this.myKnobElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + KNOB_SUFFIX);
            this.myRuleElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + RULE_SUFFIX);
        }
        if (this.myKnobElement == null) {
            this.myKnobElement = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", KNOB);
        }
        if (this.myRuleElement == null) {
            this.myRuleElement = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", RULE);
        }
    }

    private void verify() {
        if (this.myRuleElement == null || this.myKnobElement == null) {
            throw new IllegalArgumentException("Element with id=" + this.getElement().getId() + " couldn't be used for Slider." + " It doesn't have nested 'rule' or 'knob' elements." + "See javadoc for SVG snippet format");
        }
    }

    private class SliderInputHandler
    extends InputHandler {
        private SliderInputHandler() {
        }

        public boolean handleKeyPress(SVGComponent comp, int keyCode) {
            if (comp instanceof SVGSlider) {
                return keyCode == -3 || keyCode == -4;
            }
            return false;
        }

        public boolean handleKeyRelease(SVGComponent comp, int keyCode) {
            boolean ret = false;
            if (comp instanceof SVGSlider) {
                if (keyCode == -3) {
                    SVGSlider.this.setValue(Math.max(SVGSlider.this.myMin, SVGSlider.this.myValue - SVGSlider.this.myStep));
                    ret = true;
                } else if (keyCode == -4) {
                    SVGSlider.this.setValue(Math.min(SVGSlider.this.myMax, SVGSlider.this.myValue + SVGSlider.this.myStep));
                    ret = true;
                }
            }
            return ret;
        }
    }
}

