/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.bpel.project.BpelProjectOperations;
import org.netbeans.modules.bpel.project.BpelSourcesRegistryHelper;
import org.netbeans.modules.bpel.project.BpelproActionProvider;
import org.netbeans.modules.bpel.project.ProjectCloseListener;
import org.netbeans.modules.bpel.project.ProjectCloseSupport;
import org.netbeans.modules.bpel.project.ProjectPropertyProvider;
import org.netbeans.modules.bpel.project.ui.IcanproLogicalViewProvider;
import org.netbeans.modules.compapp.projects.base.queries.IcanproProjectEncodingQueryImpl;
import org.netbeans.modules.compapp.projects.base.spi.JbiArtifactProvider;
import org.netbeans.modules.compapp.projects.base.ui.IcanproCustomizerProvider;
import org.netbeans.modules.compapp.projects.base.ui.IcanproXmlCustomizerProvider;
import org.netbeans.modules.compapp.projects.base.ui.customizer.IcanproProjectProperties;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class BpelproProject
implements Project,
AntProjectListener,
ProjectPropertyProvider {
    private static final Icon PROJECT_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bpel/project/resources/bpelProject.png"));
    public static final String ARTIFACT_TYPE_JBI_ASA = "CAPS.asa";
    public static final String MODULE_INSTALL_NAME = "modules/org-netbeans-modules-bpel-project.jar";
    public static final String MODULE_INSTALL_CBN = "org.netbeans.modules.bpel.project";
    public static final String MODULE_INSTALL_DIR = "module.install.dir";
    private static final Logger LOG = Logger.getLogger(BpelproProject.class.getName());
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private final BpelSourcesRegistryHelper sourcesRegistryHelper;
    private ProjectCloseSupport projectCloseSupport;
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;

    public BpelproProject(AntProjectHelper antProjectHelper) throws IOException {
        this.helper = antProjectHelper;
        this.eval = this.createEvaluator();
        AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(antProjectHelper, auxiliaryConfiguration, antProjectHelper.getStandardPropertyEvaluator());
        this.genFilesHelper = new GeneratedFilesHelper(antProjectHelper);
        this.lookup = this.createLookup(auxiliaryConfiguration);
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
        this.sourcesRegistryHelper = new BpelSourcesRegistryHelper(this);
        this.projectCloseSupport = new ProjectCloseSupport();
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public String toString() {
        return "BpelproProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        return this.helper.getStandardPropertyEvaluator();
    }

    public ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    PropertyEvaluator evaluator() {
        return this.eval;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createLookup(AuxiliaryConfiguration auxiliaryConfiguration) {
        SubprojectProvider subprojectProvider = this.refHelper.createSubprojectProvider();
        FileBuiltQueryImplementation fileBuiltQueryImplementation = this.helper.createGlobFileBuiltQuery(this.helper.getStandardPropertyEvaluator(), new String[]{"${src.dir}/*.java"}, new String[]{"${build.classes.dir}/*.class"});
        final SourcesHelper sourcesHelper = new SourcesHelper(this.helper, this.evaluator());
        String string = NbBundle.getMessage(IcanproCustomizerProvider.class, (String)"LBL_Node_EJBModule");
        String string2 = NbBundle.getMessage(IcanproCustomizerProvider.class, (String)"LBL_Node_Sources");
        sourcesHelper.addPrincipalSourceRoot("${source.root}", string, null, null);
        sourcesHelper.addPrincipalSourceRoot("${src.dir}", string2, null, null);
        sourcesHelper.addTypedSourceRoot("${src.dir}", "BIZPRO", string2, null, null);
        sourcesHelper.addTypedSourceRoot("${src.dir}", "xml", string2, null, null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                sourcesHelper.registerExternalRoots(0);
            }
        });
        return Lookups.fixed((Object[])new Object[]{new Info(), auxiliaryConfiguration, this.helper.createCacheDirectoryProvider(), this.helper, subprojectProvider, new BpelproActionProvider(this, this.helper, this.refHelper), new IcanproLogicalViewProvider(this, this.helper, this.evaluator(), subprojectProvider, this.refHelper), new IcanproXmlCustomizerProvider((Project)this, this.helper, this.refHelper, "http://www.netbeans.org/ns/j2ee-bpelpro/1"), new JbiArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), new ProjectOpenedHookImpl(this), new BpelProjectOperations(this), fileBuiltQueryImplementation, new RecommendedTemplatesImpl(), this.refHelper, new IcanproProjectEncodingQueryImpl(this.evaluator()), sourcesHelper.createSources(), this.helper.createSharabilityQuery(this.evaluator(), new String[]{"${source.root}"}, new String[]{"${build.dir}", "${dist.dir}"}), new DefaultProjectCatalogSupport((Project)this, this.helper, this.refHelper)});
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        if (antProjectEvent.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    String getBuildXmlName() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("buildfile");
        return string == null ? "build.xml" : string;
    }

    FileObject getSourceDirectory() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
        return this.helper.resolveFileObject(string);
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element element = BpelproProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-bpelpro/1", "name");
                if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    return ((Text)nodeList.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setName(final String string) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element element;
                Element element2 = BpelproProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-bpelpro/1", "name");
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2ee-bpelpro/1", "name");
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string));
                BpelproProject.this.helper.putPrimaryConfigurationData(element2, true);
                return null;
            }
        });
    }

    public void addProjectCloseListener(ProjectCloseListener projectCloseListener) {
        this.projectCloseSupport.addProjectCloseListener(projectCloseListener);
    }

    public void removeProjectCloseListener(ProjectCloseListener projectCloseListener) {
        this.projectCloseSupport.removeProjectCloseListener(projectCloseListener);
    }

    public IcanproProjectProperties getProjectProperties() {
        return new IcanproProjectProperties((Project)this, this.helper, this.refHelper, "http://www.netbeans.org/ns/j2ee-bpelpro/1");
    }

    private static class FileListener
    implements FileChangeListener {
        private boolean myIsValid;
        private FileObject myTarget;

        public FileListener(FileObject fileObject) {
            this.myTarget = fileObject;
            this.myIsValid = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (!this.myIsValid) {
                return;
            }
            if (!this.myTarget.isValid()) {
                return;
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            FileLock fileLock = null;
            try {
                inputStream = fileObject.getInputStream();
                fileLock = this.myTarget.lock();
                outputStream = this.myTarget.getOutputStream(fileLock);
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.myIsValid = false;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.myIsValid = false;
        }
    }

    private static class CatalogListener
    implements FileChangeListener {
        private FileObject myProject;
        private CatalogWriteModel myCatalog;
        private HashMap<FileObject, FileListener> myEntries;

        public CatalogListener(FileObject fileObject, CatalogWriteModel catalogWriteModel) {
            this.myCatalog = catalogWriteModel;
            this.myProject = fileObject;
            this.myEntries = null;
            this.updateEntries();
        }

        public void fileChanged(FileEvent fileEvent) {
            this.updateEntries();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        private void updateEntries() {
            this.removeEntries();
            this.myEntries = new HashMap();
            Collection collection = this.myCatalog.getCatalogEntries();
            for (CatalogEntry catalogEntry : collection) {
                FileObject fileObject;
                String string = this.getFileName(catalogEntry.getSource());
                FileObject fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
                if (fileObject2 == null || (fileObject = this.myProject.getFileObject(catalogEntry.getTarget())) == null) continue;
                FileListener fileListener = new FileListener(fileObject);
                fileObject2.addFileChangeListener((FileChangeListener)fileListener);
                this.myEntries.put(fileObject2, fileListener);
            }
        }

        private void removeEntries() {
            if (this.myEntries == null) {
                return;
            }
            Set<FileObject> set = this.myEntries.keySet();
            for (FileObject fileObject : set) {
                fileObject.removeFileChangeListener((FileChangeListener)this.myEntries.get(fileObject));
            }
            this.myEntries.clear();
        }

        private String getFileName(String string) {
            if ((string = string.replaceAll("%20", " ")).startsWith("file:")) {
                string = string.substring(5);
            }
            return string.replace("\\", "/");
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] TYPES = new String[]{"SOA_BPEL", "XML", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/SOA_BPEL/Process.bpel", "Templates/XML/retrieveXMLResource", "Templates/XML/WSDL.wsdl"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private final class JbiArtifactProviderImpl
    implements JbiArtifactProvider {
        private JbiArtifactProviderImpl() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{BpelproProject.this.helper.createSimpleAntArtifact("CAPS.asa:" + BpelproProject.this.helper.getStandardPropertyEvaluator().getProperty("com.sun.jbi.ui.devtool.jbi.setype.prefix"), "sedeployment.jar", BpelproProject.this.helper.getStandardPropertyEvaluator(), "dist_se", "clean"), BpelproProject.this.helper.createSimpleAntArtifact("jar", "sedeployment.jar", BpelproProject.this.helper.getStandardPropertyEvaluator(), "dist_se", "clean")};
        }

        public String getJbiServiceAssemblyType() {
            return BpelproProject.this.helper.getStandardPropertyEvaluator().getProperty("com.sun.jbi.ui.devtool.jbi.setype.prefix");
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private CatalogListener myCatalogListener;

        ProjectOpenedHookImpl(Project project) {
        }

        protected void projectOpened() {
            try {
                BpelproProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", BpelproProject.class.getResource("resources/build-impl.xsl"), true);
                BpelproProject.this.genFilesHelper.refreshBuildScript(BpelproProject.this.getBuildXmlName(), BpelproProject.class.getResource("resources/build.xsl"), true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    EditableProperties editableProperties = BpelproProject.this.helper.getProperties("nbproject/private/private.properties");
                    editableProperties.setProperty("netbeans.user", System.getProperty("netbeans.user"));
                    File file = InstalledFileLocator.getDefault().locate(BpelproProject.MODULE_INSTALL_NAME, BpelproProject.MODULE_INSTALL_CBN, false);
                    if (file != null) {
                        editableProperties.setProperty(BpelproProject.MODULE_INSTALL_DIR, file.getParentFile().getPath());
                    }
                    BpelproProject.this.helper.putProperties("nbproject/private/private.properties", editableProperties);
                    EditableProperties editableProperties2 = BpelproProject.this.helper.getProperties("nbproject/project.properties");
                    if (editableProperties2.getProperty("source.encoding") == null) {
                        editableProperties2.setProperty("source.encoding", FileEncodingQuery.getDefaultEncoding().name());
                    }
                    BpelproProject.this.helper.putProperties("nbproject/project.properties", editableProperties2);
                    try {
                        ProjectManager.getDefault().saveProject((Project)BpelproProject.this);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    return null;
                }
            });
            if (IcanproLogicalViewProvider.hasBrokenLinks(BpelproProject.this.helper, BpelproProject.this.refHelper)) {
                BrokenReferencesSupport.showAlert();
            }
            this.checkEncoding();
            BpelproProject.this.sourcesRegistryHelper.register();
            this.addListenerOnCatalog();
        }

        private void checkEncoding() {
            String string = BpelproProject.this.eval.getProperty("source.encoding");
            if (string != null) {
                try {
                    Charset charset = Charset.forName(string);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    LOG.warning("Illegal charset: " + string + " in project: " + BpelproProject.this.getProjectDirectory());
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    LOG.warning("Unsupported charset: " + string + " in project: " + BpelproProject.this.getProjectDirectory());
                }
            }
        }

        private void addListenerOnCatalog() {
            if (this.myCatalogListener != null) {
                return;
            }
            CatalogWriteModel catalogWriteModel = this.getCatalog();
            if (catalogWriteModel == null) {
                return;
            }
            this.myCatalogListener = new CatalogListener(BpelproProject.this.getProjectDirectory(), catalogWriteModel);
            catalogWriteModel.getCatalogFileObject().addFileChangeListener((FileChangeListener)this.myCatalogListener);
        }

        private CatalogWriteModel getCatalog() {
            try {
                return CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(BpelproProject.this.getProjectDirectory());
            }
            catch (CatalogModelException catalogModelException) {
                return null;
            }
        }

        protected void projectClosed() {
            if (this.myCatalogListener != null) {
                CatalogWriteModel catalogWriteModel = this.getCatalog();
                if (catalogWriteModel != null) {
                    catalogWriteModel.getCatalogFileObject().removeFileChangeListener((FileChangeListener)this.myCatalogListener);
                }
                this.myCatalogListener = null;
            }
            try {
                ProjectManager.getDefault().saveProject((Project)BpelproProject.this);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            BpelproProject.this.sourcesRegistryHelper.unregister();
            BpelproProject.this.projectCloseSupport.fireProjectClosed();
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
            BpelproProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", BpelproProject.class.getResource("resources/build-impl.xsl"), false);
            BpelproProject.this.genFilesHelper.refreshBuildScript(BpelproProject.this.getBuildXmlName(), BpelproProject.class.getResource("resources/build.xsl"), false);
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private WeakReference<String> cachedName = null;

        Info() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void firePropertyChange(String string) {
            this.pcs.firePropertyChange(string, null, null);
            PropertyChangeSupport propertyChangeSupport = this.pcs;
            synchronized (propertyChangeSupport) {
                this.cachedName = null;
            }
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDisplayName() {
            Object object;
            Object object2 = this.pcs;
            synchronized (object2) {
                if (this.cachedName != null && (object = (String)this.cachedName.get()) != null) {
                    return object;
                }
            }
            object2 = BpelproProject.this.getName();
            object = this.pcs;
            synchronized (object) {
                this.cachedName = new WeakReference<Object>(object2);
            }
            return object2;
        }

        public Icon getIcon() {
            return PROJECT_ICON;
        }

        public Project getProject() {
            return BpelproProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

