/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.context;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xslt.core.context.MapperContextFactory;
import org.netbeans.modules.xslt.mapper.model.MapperContext;
import org.netbeans.modules.xslt.mapper.model.MapperContextChangeListener;
import org.netbeans.modules.xslt.mapper.model.MapperContextChangeSupport;
import org.netbeans.modules.xslt.model.XslModel;
import org.netbeans.modules.xslt.project.spi.ProjectsFilesChangeHandler;
import org.netbeans.modules.xslt.project.spi.ProjectsFilesChangeListener;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.api.VariableReference;
import org.netbeans.modules.xslt.tmap.model.api.WSDLReference;
import org.netbeans.modules.xslt.tmap.model.validation.TransformmapValidator;
import org.netbeans.modules.xslt.tmap.model.validation.TransformmapValidatorImpl;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperContextImpl
implements MapperContext {
    private static final int CONTEXT_CHANGE_TASK_DELAY = 500;
    private transient RequestProcessor.Task myPreviousChangeTask;
    private Transform myTransformContextComponent;
    private XslModel myXslModel;
    private AXIComponent mySourceComponent;
    private AXIModel mySourceAxiModel;
    private WSDLReference<Part> mySourcePart;
    private WSDLModel mySourceModel;
    private AXIComponent myTargetComponent;
    private AXIModel myTargetAxiModel;
    private WSDLReference<Part> myTargetPart;
    private WSDLModel myTargetModel;
    private MapperContextChangeSupport myChangeSupport = new MapperContextChangeSupport();
    private TMapModel myTMapModel;
    private ContextPropertyChangeListener myContextChangeListener = new ContextPropertyChangeListener();
    private FileChangeListener myFileChangeListener = new FileChangeListenerImpl();
    private ProjectsFilesChangeHandler myProjectsFilesChangeHandler;
    private ProjectsFilesChangeListener myProjectsFilesChangeListener = new ProjectsFilesChangeListenerImpl();
    private FileObject myTMapFo;
    private FileObject myXslFo;

    public MapperContextImpl(XslModel xslModel, TMapModel tMapModel) {
        this.init(tMapModel, xslModel);
        this.addContextChangeListeners();
    }

    public MapperContextImpl(Transform transform, XslModel xslModel, AXIComponent aXIComponent, AXIComponent aXIComponent2) {
        this.init(transform, xslModel, aXIComponent, aXIComponent2);
        this.addContextChangeListeners();
    }

    private void init(TMapModel tMapModel, Transform transform, XslModel xslModel, AXIComponent aXIComponent, AXIComponent aXIComponent2) {
        this.myXslModel = xslModel;
        this.myTransformContextComponent = transform;
        this.myTMapModel = tMapModel;
        this.mySourceComponent = aXIComponent;
        this.mySourceAxiModel = this.mySourceComponent != null ? this.mySourceComponent.getModel() : null;
        this.mySourcePart = this.getSourcePart(this.myTransformContextComponent);
        this.mySourceModel = this.getWsdlModel(this.mySourcePart);
        this.myTargetComponent = aXIComponent2;
        this.myTargetAxiModel = this.myTargetComponent != null ? this.myTargetComponent.getModel() : null;
        this.myTargetPart = this.getTargetPart(this.myTransformContextComponent);
        this.myTargetModel = this.getWsdlModel(this.myTargetPart);
        this.myTMapFo = SoaUtil.getFileObjectByModel((Model)this.myTMapModel);
        this.myXslFo = this.myXslModel == null ? null : SoaUtil.getFileObjectByModel((Model)this.myXslModel);
    }

    private void init(Transform transform, XslModel xslModel, AXIComponent aXIComponent, AXIComponent aXIComponent2) {
        this.init(transform == null ? null : transform.getModel(), transform, xslModel, aXIComponent, aXIComponent2);
    }

    private void init(TMapModel tMapModel, XslModel xslModel) {
        this.init(tMapModel, null, xslModel, null, null);
    }

    public void reinit(TMapModel tMapModel, Transform transform, XslModel xslModel, AXIComponent aXIComponent, AXIComponent aXIComponent2, EventObject eventObject) {
        this.setXslModel(xslModel, false);
        this.setTransformContextComponent(tMapModel, transform, false);
        this.setSourceType(aXIComponent, false);
        this.setTargetType(aXIComponent2, false);
        this.fireChanges(eventObject);
    }

    private void fireChanges(EventObject eventObject) {
        this.myChangeSupport.fireMapperContextChanged(null, (Object)eventObject);
    }

    private void setTransformContextComponent(TMapModel tMapModel, Transform transform, boolean bl) {
        TMapModel tMapModel2 = this.myTMapModel;
        this.myTMapModel = tMapModel;
        if (this.myTMapModel != null && !this.myTMapModel.equals(tMapModel2) || tMapModel2 != null && !tMapModel2.equals(this.myTMapModel)) {
            if (tMapModel2 != null) {
                this.myTMapModel.removePropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            }
            if (this.myTMapModel != null) {
                this.myTMapModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            }
        }
        Transform transform2 = this.myTransformContextComponent;
        this.myTransformContextComponent = transform;
        if (this.myTransformContextComponent != null && !this.myTransformContextComponent.equals(transform2) || transform2 != null && !transform2.equals(this.myTransformContextComponent)) {
            if (this.myTMapFo != null) {
                this.myTMapFo.removeFileChangeListener(this.myFileChangeListener);
            }
            this.myTMapFo = SoaUtil.getFileObjectByModel((Model)this.myTMapModel);
            if (this.myTMapFo != null) {
                this.myTMapFo.addFileChangeListener(this.myFileChangeListener);
            }
        }
        this.setSourcePart(this.getSourcePart(this.myTransformContextComponent));
        this.setTargetPart(this.getTargetPart(this.myTransformContextComponent));
    }

    public TMapModel getTMapModel() {
        return this.myTMapModel;
    }

    private void setXslModel(XslModel xslModel, boolean bl) {
        XslModel xslModel2 = this.myXslModel;
        this.myXslModel = xslModel;
        if (this.myXslModel != null && !this.myXslModel.equals(xslModel2) || xslModel2 != null && !xslModel2.equals(this.myXslModel)) {
            if (this.myXslFo != null) {
                this.myXslFo.removeFileChangeListener(this.myFileChangeListener);
            }
            FileObject fileObject = this.myXslFo = this.myXslModel == null ? null : SoaUtil.getFileObjectByModel((Model)this.myXslModel);
            if (this.myXslFo != null) {
                this.myXslFo.addFileChangeListener(this.myFileChangeListener);
            }
        }
    }

    public XslModel getXSLModel() {
        return this.myXslModel;
    }

    public AXIComponent getTargetType() {
        return this.myTargetComponent;
    }

    private void setTargetType(AXIComponent aXIComponent, boolean bl) {
        AXIComponent aXIComponent2 = this.myTargetComponent;
        AXIModel aXIModel = this.myTargetAxiModel;
        this.myTargetComponent = aXIComponent;
        AXIModel aXIModel2 = this.myTargetAxiModel = this.myTargetComponent != null ? this.myTargetComponent.getModel() : null;
        if (this.myTargetAxiModel != null && !this.myTargetAxiModel.equals(aXIModel) || aXIModel != null && !aXIModel.equals(this.myTargetAxiModel) || aXIModel == null && this.myTargetAxiModel == null) {
            if (aXIModel != null) {
                aXIModel.removePropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
                aXIModel.removeComponentListener((ComponentListener)this.myContextChangeListener);
            }
            if (this.myTargetAxiModel != null) {
                this.myTargetAxiModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
                this.myTargetAxiModel.addComponentListener((ComponentListener)this.myContextChangeListener);
            }
            if (bl) {
                this.myChangeSupport.fireMapperContextChanged((Object)aXIModel, (Object)this.myTargetAxiModel);
            }
        }
        if ((this.myTargetComponent != null && !this.myTargetComponent.equals(aXIComponent2) || aXIComponent2 != null && !aXIComponent2.equals(this.myTargetComponent)) && bl) {
            this.myChangeSupport.fireTargetTypeChanged(aXIComponent2, this.myTargetComponent);
        }
    }

    public AXIComponent getSourceType() {
        return this.mySourceComponent;
    }

    private void setSourceType(AXIComponent aXIComponent, boolean bl) {
        AXIComponent aXIComponent2 = this.mySourceComponent;
        AXIModel aXIModel = this.mySourceAxiModel;
        this.mySourceComponent = aXIComponent;
        AXIModel aXIModel2 = this.mySourceAxiModel = this.mySourceComponent != null ? this.mySourceComponent.getModel() : null;
        if (this.mySourceAxiModel != null && !this.mySourceAxiModel.equals(aXIModel) || aXIModel != null && !aXIModel.equals(this.mySourceAxiModel) || aXIModel == null && this.mySourceAxiModel == null) {
            if (aXIModel != null) {
                aXIModel.removePropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
                aXIModel.removeComponentListener((ComponentListener)this.myContextChangeListener);
            }
            if (this.mySourceAxiModel != null) {
                this.mySourceAxiModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
                this.mySourceAxiModel.addComponentListener((ComponentListener)this.myContextChangeListener);
            }
            if (bl) {
                this.myChangeSupport.fireMapperContextChanged((Object)aXIModel, (Object)this.mySourceAxiModel);
            }
        }
        if ((this.mySourceComponent != null && !this.mySourceComponent.equals(aXIComponent2) || aXIComponent2 != null && !aXIComponent2.equals(this.mySourceComponent) || aXIComponent2 == null && this.mySourceComponent == null) && bl) {
            this.myChangeSupport.fireSourceTypeChanged(aXIComponent2, this.mySourceComponent);
        }
    }

    public void addMapperContextChangeListener(MapperContextChangeListener mapperContextChangeListener) {
        this.myChangeSupport.addPropertyChangeListener(mapperContextChangeListener);
    }

    public void removeMapperContextChangeListener(MapperContextChangeListener mapperContextChangeListener) {
        this.myChangeSupport.removePropertyChangeListener(mapperContextChangeListener);
    }

    private void setSourcePart(WSDLReference<Part> wSDLReference) {
        this.mySourcePart = wSDLReference;
        WSDLModel wSDLModel = this.mySourceModel;
        this.mySourceModel = this.getWsdlModel(this.mySourcePart);
        if (this.mySourceModel != null && !this.mySourceModel.equals(wSDLModel) || wSDLModel != null && !wSDLModel.equals(this.mySourcePart)) {
            if (wSDLModel != null) {
                wSDLModel.removePropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            }
            if (this.mySourceModel != null) {
                this.mySourceModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            }
        }
    }

    private WSDLReference<Part> getSourcePart(Transform transform) {
        VariableReference variableReference = transform == null ? null : transform.getSource();
        return variableReference == null ? null : variableReference.getPart();
    }

    private void setTargetPart(WSDLReference<Part> wSDLReference) {
        this.myTargetPart = wSDLReference;
        WSDLModel wSDLModel = this.myTargetModel;
        this.myTargetModel = this.getWsdlModel(this.myTargetPart);
        if (this.myTargetModel != null && !this.myTargetModel.equals(wSDLModel) || wSDLModel != null && !wSDLModel.equals(this.myTargetPart)) {
            if (wSDLModel != null) {
                wSDLModel.removePropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            }
            if (this.myTargetModel != null) {
                this.myTargetModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            }
        }
    }

    private WSDLReference<Part> getTargetPart(Transform transform) {
        VariableReference variableReference = transform == null ? null : transform.getResult();
        return variableReference == null ? null : variableReference.getPart();
    }

    private WSDLModel getWsdlModel(WSDLReference<Part> wSDLReference) {
        WSDLModel wSDLModel = null;
        if (wSDLReference != null) {
            Part part = (Part)wSDLReference.get();
            wSDLModel = part == null ? null : part.getModel();
        }
        return wSDLModel;
    }

    private void addContextChangeListeners() {
        if (this.myTMapModel != null) {
            this.myTMapModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
        }
        if (this.myTMapFo != null) {
            this.myTMapFo.addFileChangeListener(this.myFileChangeListener);
        }
        if (this.myXslFo != null) {
            this.myXslFo.addFileChangeListener(this.myFileChangeListener);
            Project project = FileOwnerQuery.getOwner((FileObject)this.myXslFo);
            this.myProjectsFilesChangeHandler = (ProjectsFilesChangeHandler)project.getLookup().lookup(ProjectsFilesChangeHandler.class);
            if (this.myProjectsFilesChangeHandler != null) {
                this.myProjectsFilesChangeHandler.addProjectsFilesChangeListener(this.myProjectsFilesChangeListener);
            }
        }
        if (this.mySourceAxiModel != null) {
            this.mySourceAxiModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            this.mySourceAxiModel.addComponentListener((ComponentListener)this.myContextChangeListener);
        }
        if (this.myTargetAxiModel != null) {
            this.myTargetAxiModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            this.myTargetAxiModel.addComponentListener((ComponentListener)this.myContextChangeListener);
        }
        if (this.mySourceModel != null) {
            this.mySourceModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
        }
        if (this.myTargetModel != null) {
            this.myTargetModel.addPropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
        }
    }

    public void removeContextChangeListeners() {
        if (this.myTMapModel != null) {
            this.myTMapModel.removePropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
        }
        if (this.myTMapFo != null) {
            this.myTMapFo.removeFileChangeListener(this.myFileChangeListener);
        }
        if (this.myXslFo != null) {
            this.myXslFo.removeFileChangeListener(this.myFileChangeListener);
        }
        if (this.myProjectsFilesChangeHandler != null) {
            this.myProjectsFilesChangeHandler.removeProjectsFilesChangeListener(this.myProjectsFilesChangeListener);
        }
        if (this.mySourceAxiModel != null) {
            this.mySourceAxiModel.removePropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            this.mySourceAxiModel.removeComponentListener((ComponentListener)this.myContextChangeListener);
        }
        if (this.myTargetAxiModel != null) {
            this.myTargetAxiModel.removePropertyChangeListener((PropertyChangeListener)this.myContextChangeListener);
            this.myTargetAxiModel.removeComponentListener((ComponentListener)this.myContextChangeListener);
        }
    }

    private void reinitContext() {
        this.reinitContext(null);
    }

    private void reinitContext(final EventObject eventObject) {
        if (this.myPreviousChangeTask != null) {
            this.myPreviousChangeTask.cancel();
        }
        if (this.myPreviousChangeTask != null && !this.myPreviousChangeTask.isFinished()) {
            this.myPreviousChangeTask.waitFinished();
            this.myPreviousChangeTask = null;
        }
        this.myPreviousChangeTask = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                MapperContextFactory.getInstance().reinitMapperContext(MapperContextImpl.this, MapperContextImpl.this.myXslFo, Util.getProject((FileObject)MapperContextImpl.this.myTMapFo), eventObject);
            }
        }, 500);
    }

    public String getValidationMessage() {
        String string = null;
        TransformmapValidator transformmapValidator = TransformmapValidatorImpl.getInstance();
        if (this.myXslFo != null) {
            AXIComponent aXIComponent;
            string = transformmapValidator.validate(Util.getTransformationDescriptor((Project)Util.getProject((FileObject)this.myXslFo)));
            if (string == null) {
                string = transformmapValidator.validate(this.myTMapModel, this.myXslFo);
            }
            if (string == null) {
                aXIComponent = this.getSourceType();
                string = transformmapValidator.validate(aXIComponent, "source");
            }
            if (string == null) {
                aXIComponent = this.getTargetType();
                string = transformmapValidator.validate(aXIComponent, "target");
            }
        }
        return string;
    }

    private class ProjectsFilesChangeListenerImpl
    implements ProjectsFilesChangeListener {
        private ProjectsFilesChangeListenerImpl() {
        }

        public void fileAdded(FileObject fileObject) {
            if (MapperContextImpl.this.mySourceComponent == null || MapperContextImpl.this.myTargetComponent == null) {
                MapperContextImpl.this.reinitContext();
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            MapperContextImpl.this.reinitContext();
        }

        public void fileDeleted(FileObject fileObject) {
            MapperContextImpl.this.reinitContext();
        }
    }

    private class FileChangeListenerImpl
    implements FileChangeListener {
        private FileChangeListenerImpl() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (fileObject != null && MapperContextImpl.this.myTMapFo == null && fileObject.equals(Util.getTMapFo((Project)Util.getProject((FileObject)fileObject)))) {
                MapperContextImpl.this.reinitContext();
                MapperContextImpl.this.myTMapFo.addFileChangeListener(MapperContextImpl.this.myFileChangeListener);
                if (MapperContextImpl.this.myTMapModel != null) {
                    MapperContextImpl.this.myTMapModel.addPropertyChangeListener((PropertyChangeListener)MapperContextImpl.this.myContextChangeListener);
                }
            }
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (fileObject != null) {
                fileObject.removeFileChangeListener(MapperContextImpl.this.myFileChangeListener);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileObject fileObject = fileRenameEvent.getFile();
            if (fileObject.equals(MapperContextImpl.this.myXslFo)) {
                MapperContextImpl.this.reinitContext();
            }
            if (fileObject.equals(MapperContextImpl.this.myTMapFo)) {
                MapperContextImpl.this.reinitContext();
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }

    private class ContextPropertyChangeListener
    implements PropertyChangeListener,
    ComponentListener {
        private ContextPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MapperContextImpl.this.reinitContext(propertyChangeEvent);
        }

        public void valueChanged(ComponentEvent componentEvent) {
            MapperContextImpl.this.reinitContext((EventObject)componentEvent);
        }

        public void childrenAdded(ComponentEvent componentEvent) {
            MapperContextImpl.this.reinitContext((EventObject)componentEvent);
        }

        public void childrenDeleted(ComponentEvent componentEvent) {
            MapperContextImpl.this.reinitContext((EventObject)componentEvent);
        }
    }
}

