/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.text.NbDocument;

public class XSLTCompletionResultItem
implements CompletionItem,
Runnable {
    private static final Logger _Logger = Logger.getLogger(XSLTCompletionResultItem.class.getName());
    protected static final Color ITEM_TEXT_COLOR = Color.BLUE;
    protected String itemText;
    protected Document document;
    protected int caretOffset;
    protected int sortPriority;
    protected JTextComponent textComponent;
    protected boolean enabled;

    public XSLTCompletionResultItem(String string, Document document, int n) {
        this(string, document, n, true);
    }

    public XSLTCompletionResultItem(String string, Document document, int n, boolean bl) {
        this.itemText = string;
        this.document = document;
        this.caretOffset = n;
        this.enabled = bl;
    }

    private void doSubstitute(JTextComponent jTextComponent) {
        StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
        this.textComponent = jTextComponent;
        this.document = styledDocument;
        try {
            NbDocument.runAtomicAsUser((StyledDocument)styledDocument, (Runnable)this);
        }
        catch (BadLocationException badLocationException) {
            _Logger.log(Level.WARNING, null, badLocationException);
        }
    }

    public void run() {
        if (this.document == null || this.textComponent == null) {
            return;
        }
        String string = this.getText();
        if (string == null) {
            return;
        }
        try {
            StyledDocument styledDocument = (StyledDocument)this.document;
            styledDocument.insertString(this.caretOffset, string, null);
            this.textComponent.setCaretPosition(this.textComponent.getCaretPosition());
        }
        catch (BadLocationException badLocationException) {
            _Logger.log(Level.WARNING, null, badLocationException);
        }
    }

    public void defaultAction(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        if (this.enabled) {
            this.doSubstitute(jTextComponent);
        }
        Completion.get().hideAll();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.itemText, null, (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml(null, (String)this.itemText, null, (Graphics)graphics, (Font)font, (Color)(bl ? Color.white : ITEM_TEXT_COLOR), (int)n, (int)n2, (boolean)bl);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }

    public int getSortPriority() {
        return this.sortPriority;
    }

    public void setSortPriority(int n) {
        this.sortPriority = n;
    }

    public CharSequence getSortText() {
        return this.getText();
    }

    public CharSequence getInsertPrefix() {
        return this.getText();
    }

    public String getText() {
        return this.itemText;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

