/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionResultItem;
import org.netbeans.modules.xslt.core.text.completion.XSLTEditorComponentHolder;
import org.netbeans.modules.xslt.core.text.completion.handler.BaseCompletionHandler;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerCallTemplateName
extends BaseCompletionHandler {
    protected static final String XSLT_TAG_NAME_CALL_TEMPLATE = "call-template";

    @Override
    public List<XSLTCompletionResultItem> getResultItemList(XSLTEditorComponentHolder xSLTEditorComponentHolder) {
        this.initHandler(xSLTEditorComponentHolder);
        return this.getNamedTemplateNameList();
    }

    private List<XSLTCompletionResultItem> getNamedTemplateNameList() {
        if (this.surroundTag == null || this.attributeName == null || this.xslModel == null) {
            return Collections.emptyList();
        }
        String string = this.surroundTag.getTagName();
        if (!string.contains(XSLT_TAG_NAME_CALL_TEMPLATE)) {
            return Collections.emptyList();
        }
        if (!this.attributeName.equals("name")) {
            return Collections.emptyList();
        }
        if (this.xslModel != null && this.xslModel.getState().equals((Object)Model.State.NOT_WELL_FORMED)) {
            return this.getIncorrectDocumentResultItem();
        }
        return this.findNamedTemplates();
    }

    private List<XSLTCompletionResultItem> findNamedTemplates() {
        Stylesheet stylesheet = this.xslModel.getStylesheet();
        List list = stylesheet.getChildren(Template.class);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<XSLTCompletionResultItem> arrayList = new ArrayList<XSLTCompletionResultItem>();
        for (Template template : list) {
            String string;
            QName qName = template.getName();
            if (qName == null || (string = qName.toString()) == null || string.length() <= 0) continue;
            XSLTCompletionResultItem xSLTCompletionResultItem = new XSLTCompletionResultItem(string, this.document, this.caretOffset);
            xSLTCompletionResultItem.setSortPriority(arrayList.size());
            arrayList.add(xSLTCompletionResultItem);
        }
        return arrayList;
    }
}

