/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion.handler;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xslt.core.XSLTDataLoader;
import org.netbeans.modules.xslt.core.text.completion.IllegalXsltVersionException;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionConstants;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionResultItem;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionUtil;
import org.netbeans.modules.xslt.core.text.completion.XSLTEditorComponentHolder;
import org.netbeans.modules.xslt.core.text.completion.handler.BaseCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerCoreXPathFunctions
extends BaseCompletionHandler
implements XSLTCompletionConstants {
    private static Map<String, String> mapXsltFunctionFileNames = new HashMap<String, String>(3);
    private static Map<String, List<String>> mapXsltFunctionNames = new HashMap<String, List<String>>();

    @Override
    public List<XSLTCompletionResultItem> getResultItemList(XSLTEditorComponentHolder xSLTEditorComponentHolder) {
        this.initHandler(xSLTEditorComponentHolder);
        return this.getCoreFunctionList();
    }

    private List<XSLTCompletionResultItem> getCoreFunctionList() {
        if (this.attributeName == null || this.xslModel == null) {
            return Collections.emptyList();
        }
        if (this.schemaModel == null || this.surroundTag == null || this.attributeName == null) {
            return Collections.emptyList();
        }
        if (!this.isAttributeTypeXslExpression()) {
            return Collections.emptyList();
        }
        ArrayList<XSLTCompletionResultItem> arrayList = new ArrayList<XSLTCompletionResultItem>();
        List<String> list = this.getFunctionNameList();
        if (list == null) {
            return Collections.emptyList();
        }
        for (String string : list) {
            if (string == null || string.trim().length() <= 0) continue;
            XSLTCompletionResultItem xSLTCompletionResultItem = new XSLTCompletionResultItem(string.trim(), this.document, this.caretOffset);
            xSLTCompletionResultItem.setSortPriority(arrayList.size());
            arrayList.add(xSLTCompletionResultItem);
        }
        return arrayList;
    }

    private boolean isAttributeTypeXslExpression() {
        NamedReferenceable namedReferenceable = this.schemaModel.findByNameAndType(XSLTCompletionUtil.ignoreNamespace(this.surroundTag.getTagName()), GlobalElement.class);
        if (namedReferenceable == null) {
            return false;
        }
        List list = namedReferenceable.getChildren();
        List<Attribute> list2 = XSLTCompletionUtil.collectChildrenOfType(list, Attribute.class);
        String string = XSLTCompletionUtil.getAttributeType(list2, this.attributeName);
        if (string == null) {
            return false;
        }
        return string.equals("xsl:expression") || string.equals(XSLTCompletionUtil.ignoreNamespace("xsl:expression"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFunctionNameList() {
        InputStream inputStream = null;
        try {
            Object object;
            String string = this.xslModel.getStylesheet().getVersion().toString().trim();
            if (!setSupportedXsltVersions.contains(string)) {
                throw new IllegalXsltVersionException(string);
            }
            List<String> list = mapXsltFunctionNames.get(string);
            if (list == null) {
                object = mapXsltFunctionFileNames.get(string);
                String string2 = "resources/" + (String)object;
                inputStream = XSLTDataLoader.class.getResourceAsStream(string2);
                list = this.getFunctionNameList(inputStream);
                mapXsltFunctionNames.put(string, list);
            }
            object = list;
            return object;
        }
        catch (IllegalXsltVersionException illegalXsltVersionException) {
            Logger.getLogger(HandlerCoreXPathFunctions.class.getName()).log(Level.WARNING, illegalXsltVersionException.getMessage(), illegalXsltVersionException);
            List<String> list = null;
            return list;
        }
        catch (Exception exception) {
            List<String> list = null;
            return list;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private List<String> getFunctionNameList(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (true) {
                String string;
                if ((string = bufferedReader.readLine()) != null && string.trim().length() > 0) {
                    arrayList.add(XSLTCompletionUtil.ignoreNamespace(string).trim());
                    continue;
                }
                if (string == null) break;
            }
            return arrayList;
        }
        catch (Exception exception) {
            Logger.getLogger(HandlerCoreXPathFunctions.class.getName()).log(Level.INFO, exception.getMessage(), exception);
            return null;
        }
    }

    static {
        mapXsltFunctionFileNames.put("1.0", "xslt_1_0_xpath-functions.txt");
        mapXsltFunctionFileNames.put("1.1", "xslt_1_0_xpath-functions.txt");
        mapXsltFunctionFileNames.put("2.0", "xslt_2_0_xpath-functions.txt");
    }
}

