/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionConstants;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionResultItem;
import org.netbeans.modules.xslt.core.text.completion.XSLTEditorComponentHolder;
import org.netbeans.modules.xslt.core.text.completion.XSLTTemplateParameterResultItem;
import org.netbeans.modules.xslt.core.text.completion.XSLTUnnamedTemplateResultItem;
import org.netbeans.modules.xslt.core.text.completion.handler.BaseCompletionHandler;
import org.netbeans.modules.xslt.model.Param;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.Template;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerWithParamName
extends BaseCompletionHandler
implements XSLTCompletionConstants {
    @Override
    public List<XSLTCompletionResultItem> getResultItemList(XSLTEditorComponentHolder xSLTEditorComponentHolder) {
        this.initHandler(xSLTEditorComponentHolder);
        return this.getTemplatesParamNameList();
    }

    private List<XSLTCompletionResultItem> getTemplatesParamNameList() {
        if (this.surroundTag == null || this.attributeName == null || this.xslModel == null) {
            return Collections.emptyList();
        }
        String string = this.surroundTag.getTagName();
        if (!string.contains("with-param")) {
            return Collections.emptyList();
        }
        if (!this.attributeName.equals("name")) {
            return Collections.emptyList();
        }
        if (this.xslModel != null && this.xslModel.getState().equals((Object)Model.State.NOT_WELL_FORMED)) {
            return this.getIncorrectDocumentResultItem();
        }
        Node node = this.surroundTag.getParentNode();
        if (!(node instanceof Tag)) {
            return Collections.emptyList();
        }
        string = ((Tag)node).getTagName();
        if (string.contains("call-template")) {
            String string2 = ((Tag)node).getAttribute("name");
            if (string2 == null || string2.length() < 1) {
                return Collections.emptyList();
            }
            return this.getNamedTemplatesParamNameList(string2);
        }
        if (string.contains("apply-templates")) {
            return this.getUnnamedTemplatesParamNameList();
        }
        return Collections.emptyList();
    }

    private List<XSLTCompletionResultItem> getNamedTemplatesParamNameList(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        Stylesheet stylesheet = this.xslModel.getStylesheet();
        List list = stylesheet.getChildren(Template.class);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Template template = null;
        for (Template template2 : list) {
            QName qName = template2.getName();
            if (qName == null || !string.equals(qName.toString())) continue;
            template = template2;
            break;
        }
        if (template == null) {
            return Collections.emptyList();
        }
        return this.getNamedTemplateParamNameList(new ArrayList<Template>(Arrays.asList(template)));
    }

    private List<XSLTCompletionResultItem> getNamedTemplateParamNameList(List<Template> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<XSLTCompletionResultItem> arrayList = new ArrayList<XSLTCompletionResultItem>();
        for (Template template : list) {
            List list2 = template.getChildren(Param.class);
            if (list2 == null || list2.isEmpty()) {
                return Collections.emptyList();
            }
            for (Param param : list2) {
                QName qName = param.getName();
                if (qName == null) continue;
                XSLTCompletionResultItem xSLTCompletionResultItem = new XSLTCompletionResultItem(qName.toString(), this.document, this.caretOffset);
                xSLTCompletionResultItem.setSortPriority(arrayList.size());
                arrayList.add(xSLTCompletionResultItem);
            }
        }
        return arrayList;
    }

    private List<XSLTCompletionResultItem> getUnnamedTemplatesParamNameList() {
        Stylesheet stylesheet = this.xslModel.getStylesheet();
        List list = stylesheet.getChildren(Template.class);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Template> arrayList = new ArrayList<Template>();
        for (Template template : list) {
            String string = template.getMatch();
            if (string == null) continue;
            arrayList.add(template);
        }
        return this.getUnnamedTemplatesParamNameList(arrayList);
    }

    private List<XSLTCompletionResultItem> getUnnamedTemplatesParamNameList(List<Template> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<XSLTCompletionResultItem> arrayList = new ArrayList<XSLTCompletionResultItem>();
        for (Template template : list) {
            XSLTCompletionResultItem xSLTCompletionResultItem;
            List list2 = template.getChildren(Param.class);
            if (list2 == null || list2.isEmpty() || (xSLTCompletionResultItem = XSLTUnnamedTemplateResultItem.create(template, this.document, this.caretOffset)) == null) continue;
            xSLTCompletionResultItem.setSortPriority(arrayList.size());
            arrayList.add(xSLTCompletionResultItem);
            for (Param param : list2) {
                xSLTCompletionResultItem = XSLTTemplateParameterResultItem.create(param, this.document, this.caretOffset);
                if (xSLTCompletionResultItem == null) continue;
                xSLTCompletionResultItem.setSortPriority(arrayList.size());
                arrayList.add(xSLTCompletionResultItem);
            }
        }
        return arrayList;
    }
}

