/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.XMLRefactoringPlugin;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.visitor.FindUsageVisitor;
import org.netbeans.modules.xml.schema.model.visitor.Preview;
import org.netbeans.modules.xml.schema.refactoring.RefactoringUtil;
import org.netbeans.modules.xml.schema.refactoring.SchemaRefactoringElement;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin,
XMLRefactoringPlugin {
    List<ErrorItem> findErrors;
    public static final String XSD_MIME_TYPE = "application/x-schema+xml";

    public List<SchemaRefactoringElement> find(Referenceable referenceable, Component component) {
        if (referenceable instanceof Model) {
            return this.findUsages((Model)referenceable, component);
        }
        if (referenceable instanceof Component) {
            return this.findUsages((Component)referenceable, component);
        }
        return null;
    }

    public List<SchemaRefactoringElement> findUsages(Model model, Component component) {
        if (!(model instanceof SchemaModel) || !(component instanceof Schema)) {
            return null;
        }
        SchemaModel schemaModel = (SchemaModel)model;
        Schema schema = (Schema)component;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(schema.getImports());
        arrayList.addAll(schema.getIncludes());
        arrayList.addAll(schema.getRedefines());
        for (SchemaModelReference schemaModelReference : arrayList) {
            SchemaModel schemaModel2 = null;
            try {
                schemaModel2 = schemaModelReference.resolveReferencedModel();
            }
            catch (CatalogModelException catalogModelException) {
                this.findErrors.add(new ErrorItem((Object)component, catalogModelException.getMessage()));
            }
            if (!schemaModel.equals(schemaModel2)) continue;
            return Collections.singletonList(new SchemaRefactoringElement((SchemaComponent)schemaModelReference));
        }
        return Collections.emptyList();
    }

    public List<SchemaRefactoringElement> findUsages(Component component, Component component2) {
        if (!(component instanceof ReferenceableSchemaComponent) || !(component2 instanceof Schema)) {
            return Collections.emptyList();
        }
        ReferenceableSchemaComponent referenceableSchemaComponent = (ReferenceableSchemaComponent)component;
        Schema schema = (Schema)component2;
        ArrayList<SchemaRefactoringElement> arrayList = new ArrayList<SchemaRefactoringElement>();
        Preview preview = new FindUsageVisitor().findUsages(Collections.singleton(schema), (NamedReferenceable)referenceableSchemaComponent);
        if (!preview.getUsages().keySet().isEmpty()) {
            for (SchemaComponent schemaComponent : preview.getUsages().keySet()) {
                arrayList.add(new SchemaRefactoringElement(schemaComponent));
            }
        }
        if (arrayList.size() == 0) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public List<Model> getModels(List<SchemaRefactoringElement> list) {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        for (SchemaRefactoringElement schemaRefactoringElement : list) {
            arrayList.add(((Component)schemaRefactoringElement.getLookup().lookup(Component.class)).getModel());
        }
        return arrayList;
    }

    public Set<Component> getSearchRoots(Referenceable referenceable) {
        HashSet<Component> hashSet = new HashSet<Component>();
        Set set = SharedUtils.getSearchFiles((Referenceable)referenceable);
        for (FileObject fileObject : set) {
            try {
                Schema schema = RefactoringUtil.getSchema(fileObject);
                hashSet.add((Component)schema);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(1, iOException.getMessage());
            }
        }
        return hashSet;
    }

    public Problem processErrors(List<ErrorItem> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Problem problem = null;
        Problem problem2 = null;
        Problem problem3 = null;
        for (ErrorItem errorItem : list) {
            if (problem == null) {
                problem2 = problem = new Problem(this.isFatal(errorItem), errorItem.getMessage());
                problem3 = problem;
                continue;
            }
            problem2 = new Problem(this.isFatal(errorItem), errorItem.getMessage());
            problem.setNext(problem2);
            problem = problem2;
        }
        return problem3;
    }

    public boolean isFatal(ErrorItem errorItem) {
        return errorItem.getLevel() == ErrorItem.Level.FATAL;
    }

    public String getModelReference(Component component) {
        if (component instanceof SchemaModelReference) {
            return ((SchemaModelReference)component).getSchemaLocation();
        }
        return null;
    }

    public void setModelReference(Component component, String string) {
    }

    public Collection<Component> getExternalReferences(Model model) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        if (model instanceof SchemaModel) {
            arrayList.addAll(((SchemaModel)model).getSchema().getSchemaReferences());
        }
        return arrayList;
    }

    public Model getModel(ModelSource modelSource) {
        FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        if (XSD_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)fileObject))) {
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
            return schemaModel;
        }
        return null;
    }
}

