/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.validation.reference;

import java.util.List;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xslt.model.CallTemplate;
import org.netbeans.modules.xslt.model.TypeSpec;
import org.netbeans.modules.xslt.model.UseAttributesSetsSpec;
import org.netbeans.modules.xslt.model.UseCharacterMapsSpec;
import org.netbeans.modules.xslt.model.WithParam;
import org.netbeans.modules.xslt.model.XslReference;
import org.netbeans.modules.xslt.model.XslVisitor;
import org.netbeans.modules.xslt.model.XslVisitorAdapter;
import org.netbeans.modules.xslt.validation.core.XsltValidator;

public final class Validator
extends XsltValidator {
    public XslVisitor getVisitor() {
        return new XslVisitorAdapter(){

            public void visit(CallTemplate callTemplate) {
                this.checkReference(callTemplate, (Reference<? extends Component>)callTemplate.getName());
            }

            public void visit(TypeSpec typeSpec) {
                this.checkReference(typeSpec, (Reference<? extends Component>)typeSpec.getType());
            }

            public void visit(UseAttributesSetsSpec useAttributesSetsSpec) {
                List list = useAttributesSetsSpec.getUseAttributeSets();
                for (XslReference xslReference : list) {
                    this.checkReference(useAttributesSetsSpec, (Reference<? extends Component>)xslReference);
                }
            }

            public void visit(UseCharacterMapsSpec useCharacterMapsSpec) {
                List list = useCharacterMapsSpec.getUseCharacterMaps();
                for (XslReference xslReference : list) {
                    this.checkReference(useCharacterMapsSpec, (Reference<? extends Component>)xslReference);
                }
            }

            public void visit(WithParam withParam) {
                this.checkReference(withParam, (Reference<? extends Component>)withParam.getName());
            }

            private void checkReference(Object object, Reference<? extends Component> reference) {
                if (!(object instanceof Component)) {
                    return;
                }
                Component component = (Component)object;
                if (reference == null) {
                    return;
                }
                if (!reference.isBroken()) {
                    return;
                }
                String string = component instanceof DocumentComponent ? ((DocumentComponent)component).getPeer().getLocalName() : "";
                Validator.this.addError("FIX_Reference", component, string);
            }
        };
    }
}

