/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.nbprefuse;

import java.awt.Color;
import org.netbeans.modules.xml.nbprefuse.AnalysisConstants;
import prefuse.Visualization;
import prefuse.action.assignment.ColorAction;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.VisualItem;

public class NodeFillColorAction
extends ColorAction {
    public NodeFillColorAction() {
        super("graph.nodes", VisualItem.FILLCOLOR);
    }

    public int getColor(VisualItem visualItem) {
        if (visualItem.isHighlighted()) {
            return AnalysisConstants.COLOR_HIGHLIGHT;
        }
        String string = null;
        if (visualItem.canGetString("xml-filename")) {
            string = visualItem.getString("xml-filename");
        }
        TupleSet tupleSet = visualItem.getVisualization().getFocusGroup(Visualization.FOCUS_ITEMS);
        boolean bl = false;
        if (visualItem.canGetBoolean("mouseover") && visualItem.getBoolean("mouseover")) {
            bl = true;
        }
        if (tupleSet.containsTuple((Tuple)visualItem) || bl) {
            return AnalysisConstants.COLOR_SELECTED_NODE;
        }
        if (string != null && string.length() > 0) {
            return AnalysisConstants.COLOR_FILE_NODE;
        }
        if (visualItem.canGetBoolean("is-query-node") && visualItem.getBoolean("is-query-node")) {
            return AnalysisConstants.COLOR_QUERY_NODE;
        }
        if (visualItem.canGetBoolean("is-usage-node") && visualItem.getBoolean("is-usage-node")) {
            return AnalysisConstants.COLOR_USAGE_NODE;
        }
        if (visualItem.canGetBoolean("is-head-element") && visualItem.getBoolean("is-head-element")) {
            return AnalysisConstants.COLOR_QUERY_NODE;
        }
        return Color.WHITE.getRGB();
    }
}

