/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.FrameworkStatisticsData;
import com.sun.esb.management.common.data.helper.FrameworkStatisticsDataReader;
import com.sun.esb.management.common.data.helper.FrameworkStatisticsDataXMLConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkStatisticsDataWriter
implements FrameworkStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    static final String FILE_NAME_KEY = "FrameworkStatisticsData.xml";

    public static void writeToFile(Document document, String directoryPath) throws TransformerConfigurationException, TransformerException, Exception {
        File file = new File(directoryPath);
        if (!file.isDirectory() || !file.exists()) {
            throw new Exception("Directory Path: " + directoryPath + " is invalid.");
        }
        String fileLocation = file.getAbsolutePath() + File.separator + FILE_NAME_KEY;
        System.out.println("Writing out to file: " + fileLocation);
        File outputFile = new File(fileLocation);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputFile);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            aFile.createNewFile();
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static String serialize(Map<String, FrameworkStatisticsData> dataMap) throws ParserConfigurationException, TransformerException {
        Document document = null;
        FrameworkStatisticsDataWriter writer = new FrameworkStatisticsDataWriter();
        if (dataMap != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("FrameworkStatisticsDataList");
            root.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/FrameworkStatisticsDataList");
            root.setAttribute("version", "1.0");
            for (String instanceName : dataMap.keySet()) {
                FrameworkStatisticsData data = dataMap.get(instanceName);
                Element frameworkStatisticsDataElementChild = writer.createFrameworkStatisticsDataElement(document, data);
                root.appendChild(frameworkStatisticsDataElementChild);
            }
            document.appendChild(root);
        }
        return writer.writeToString(document);
    }

    protected Element createFrameworkStatisticsDataElement(Document document, FrameworkStatisticsData data) {
        Element frameworkStatisticsDataElement = null;
        if (document != null && data != null) {
            frameworkStatisticsDataElement = document.createElement("FrameworkStatisticsData");
            Element instanceNameElementChild = document.createElement("InstanceName");
            if (instanceNameElementChild != null) {
                instanceNameElementChild.setTextContent(data.getInstanceName());
            }
            frameworkStatisticsDataElement.appendChild(instanceNameElementChild);
            Element startupTimeElementChild = document.createElement("StartupTime");
            if (startupTimeElementChild != null) {
                startupTimeElementChild.setTextContent(data.getStartupTime() + "");
            }
            frameworkStatisticsDataElement.appendChild(startupTimeElementChild);
            Element upTimeElementChild = document.createElement("UpTime");
            if (upTimeElementChild != null) {
                upTimeElementChild.setTextContent(data.getUpTime() + "");
            }
            frameworkStatisticsDataElement.appendChild(upTimeElementChild);
        }
        return frameworkStatisticsDataElement;
    }

    protected String writeToString(Document document) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/frameworkstatistics/FrameworkStatisticsData.xml";
        try {
            Map<String, FrameworkStatisticsData> map = null;
            map = FrameworkStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
            String content = FrameworkStatisticsDataWriter.serialize(map);
            System.out.println(content);
            FrameworkStatisticsDataWriter.setContents(new File(uri), content);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

