/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.beans;

import com.sun.rave.designtime.EventDescriptor;
import java.beans.EventSetDescriptor;
import java.beans.MethodDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.visualweb.extension.openide.util.Trace;
import org.netbeans.modules.visualweb.insync.beans.Bean;
import org.netbeans.modules.visualweb.insync.beans.BeansNode;
import org.netbeans.modules.visualweb.insync.beans.BeansUnit;
import org.netbeans.modules.visualweb.insync.beans.Event;
import org.netbeans.modules.visualweb.insync.beans.Naming;
import org.netbeans.modules.visualweb.insync.java.DelegatorMethod;
import org.netbeans.modules.visualweb.insync.java.JavaClass;
import org.netbeans.modules.visualweb.insync.java.Method;
import org.netbeans.modules.visualweb.insync.java.MethodInfo;
import org.netbeans.modules.visualweb.insync.java.Statement;

public class EventSet
extends BeansNode {
    public static final EventSet[] EMPTY_ARRAY = new EventSet[0];
    protected final Bean bean;
    protected final EventSetDescriptor descriptor;
    protected final List<Event> events = new ArrayList<Event>();
    private Statement stmt;
    private JavaClass adapterClass;
    private boolean inserted;

    protected EventSet(Bean bean, EventSetDescriptor eventSetDescriptor) {
        super(bean.getUnit());
        this.bean = bean;
        this.descriptor = eventSetDescriptor;
    }

    protected EventSet(Bean bean, EventSetDescriptor eventSetDescriptor, Statement statement, JavaClass javaClass) {
        this(bean, eventSetDescriptor);
        this.stmt = statement;
        this.adapterClass = javaClass;
        if (javaClass != null) {
            this.bindEvents();
        }
        assert (Trace.trace((String)"insync.beans", (String)("ES new bound EventSet: " + this)));
    }

    static EventSet newBoundInstance(BeansUnit beansUnit, Statement statement) {
        Bean bean = beansUnit.getBean(statement.getBeanName());
        if (bean == null) {
            return null;
        }
        EventSetDescriptor eventSetDescriptor = bean.getEventSetDescriptorForAdder(statement.getPropertySetterName());
        if (eventSetDescriptor == null) {
            return null;
        }
        JavaClass javaClass = statement.getAdapterClass();
        if (javaClass != null) {
            EventSet eventSet = new EventSet(bean, eventSetDescriptor, statement, javaClass);
            eventSet.setInserted(true);
            return eventSet;
        }
        return null;
    }

    EventSet(Bean bean, EventSetDescriptor eventSetDescriptor, boolean bl) {
        this(bean, eventSetDescriptor);
        assert (Trace.trace((String)"insync.beans", (String)("ES new created EventSet: " + this)));
    }

    protected Event newBoundEvent(MethodDescriptor methodDescriptor, DelegatorMethod delegatorMethod) {
        return Event.newBoundInstance(this, methodDescriptor, delegatorMethod);
    }

    protected void bindEvents() {
        MethodDescriptor[] methodDescriptorArray = this.descriptor.getListenerMethodDescriptors();
        for (int i = 0; i < methodDescriptorArray.length; ++i) {
            Event event;
            DelegatorMethod delegatorMethod = this.adapterClass.getDelegatorMethod(methodDescriptorArray[i].getName(), methodDescriptorArray[i].getMethod().getParameterTypes());
            if (delegatorMethod == null || (event = this.newBoundEvent(methodDescriptorArray[i], delegatorMethod)) == null) continue;
            this.events.add(event);
        }
    }

    protected DelegatorMethod stubDelegatorMethod(MethodDescriptor methodDescriptor) {
        Class<?> clazz = methodDescriptor.getMethod().getReturnType();
        Class[] classArray = methodDescriptor.getMethod().getParameterTypes();
        String[] stringArray = Naming.paramNames(classArray, methodDescriptor.getParameterDescriptors());
        String string = null;
        if (clazz != Void.TYPE) {
            string = "return null;";
        }
        MethodInfo methodInfo = new MethodInfo(methodDescriptor.getName(), clazz, 1, stringArray, classArray, string, null);
        return this.adapterClass.addDelegatorMethod(methodInfo);
    }

    private void stubBody(Method method) {
        Class<?> clazz = this.getMethodDescriptor(method.getName()).getMethod().getReturnType();
        String string = null;
        if (clazz != Void.TYPE) {
            string = "return null;";
        }
        method.replaceBody(string);
    }

    protected DelegatorMethod getDelegatorMethod(MethodDescriptor methodDescriptor) {
        DelegatorMethod delegatorMethod = this.adapterClass.getDelegatorMethod(methodDescriptor.getMethod().getName(), methodDescriptor.getMethod().getParameterTypes());
        if (delegatorMethod == null) {
            delegatorMethod = this.stubDelegatorMethod(methodDescriptor);
        }
        return delegatorMethod;
    }

    protected void removeDelegatorMethod(Method method) {
        Class clazz = this.getAdapterType();
        if (clazz != null) {
            method.remove();
        } else {
            this.stubBody(method);
        }
    }

    public void insertEntry() {
        Class clazz = this.getAdapterType();
        String string = clazz != null ? clazz.getName() : this.getListenerType().getName();
        Method method = this.unit.getPropertiesInitMethod();
        if (this.descriptor.getAddListenerMethod() != null) {
            this.stmt = method.addEventSetStatement(this.bean.getName(), this.descriptor.getAddListenerMethod().getName(), string);
            this.adapterClass = this.stmt.getAdapterClass();
            if (clazz == null) {
                MethodDescriptor[] methodDescriptorArray = this.descriptor.getListenerMethodDescriptors();
                for (int i = 0; i < methodDescriptorArray.length; ++i) {
                    this.stubDelegatorMethod((MethodDescriptor)methodDescriptorArray[i]);
                }
            }
            for (Event event : this.events) {
                event.insertEntry();
                event.setHandler();
            }
            this.inserted = true;
        }
    }

    protected void releaseEntry() {
        this.events.clear();
        this.stmt = null;
    }

    public boolean removeEntry() {
        assert (Trace.trace((String)"insync.beans", (String)("ES.removeEntry: " + this)));
        boolean bl = false;
        this.events.clear();
        if (this.inserted & this.stmt != null) {
            bl = this.stmt.remove();
            this.stmt = null;
        }
        return bl;
    }

    public EventSetDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public JavaClass getAdapter() {
        return this.adapterClass;
    }

    public Class getListenerType() {
        return this.descriptor.getListenerType();
    }

    protected Class getAdapterType() {
        String string = this.getListenerType().getName();
        int n = string.lastIndexOf("Listener");
        if (n >= 0) {
            String string2 = string.substring(0, n) + "Adapter";
            try {
                return this.unit.getBeanClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public MethodDescriptor getMethodDescriptor(String string) {
        MethodDescriptor[] methodDescriptorArray = this.descriptor.getListenerMethodDescriptors();
        for (int i = 0; i < methodDescriptorArray.length; ++i) {
            if (!methodDescriptorArray[i].getName().equals(string)) continue;
            return methodDescriptorArray[i];
        }
        return null;
    }

    public Event[] getEvents() {
        return this.events.toArray(Event.EMPTY_ARRAY);
    }

    public Event getEvent(String string) {
        for (Event event : this.events) {
            if (!event.getName().equals(string)) continue;
            return event;
        }
        return null;
    }

    protected Event newCreatedEvent(MethodDescriptor methodDescriptor, String string) {
        return new Event(this, methodDescriptor, string);
    }

    public Event setEvent(EventDescriptor eventDescriptor, MethodDescriptor methodDescriptor, String string) {
        Event event = this.getEvent(methodDescriptor.getName());
        if (event != null) {
            Object object;
            Object object2;
            Object object3 = eventDescriptor.getEventSetDescriptor().getValue("defaultEventBody");
            if (object3 instanceof String) {
                event.setDefaultBody((String)object3);
            }
            if ((object2 = eventDescriptor.getEventSetDescriptor().getValue("parameterNames")) instanceof String[]) {
                event.setParameterNames((String[])object2);
            }
            if ((object = eventDescriptor.getEventSetDescriptor().getValue("requiredImports")) instanceof String[]) {
                event.setRequiredImports((String[])object);
            }
            event.setHandler(string);
        } else {
            event = this.newCreatedEvent(methodDescriptor, string);
            if (event != null) {
                this.events.add(event);
            }
        }
        return event;
    }

    public void unsetEvent(Event event) {
        if (this.events.remove(event)) {
            event.removeEntry();
            if (this.events.isEmpty()) {
                this.bean.unsetEventSet(this);
            }
        }
    }

    public String getAddListenerMethodName() {
        if (this.descriptor.getAddListenerMethod() != null) {
            return this.descriptor.getAddListenerMethod().getName();
        }
        return null;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void setInserted(boolean bl) {
        this.inserted = bl;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(" n:");
        stringBuffer.append(this.getName());
        stringBuffer.append(" adapter:");
        stringBuffer.append(this.adapterClass);
        stringBuffer.append(" events:");
        Event[] eventArray = this.getEvents();
        for (int i = 0; i < eventArray.length; ++i) {
            stringBuffer.append(eventArray[i].toString());
        }
    }
}

