/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.beans;

import java.beans.PropertyDescriptor;
import org.netbeans.modules.visualweb.extension.openide.util.Trace;
import org.netbeans.modules.visualweb.insync.beans.Bean;
import org.netbeans.modules.visualweb.insync.beans.BeansNode;
import org.netbeans.modules.visualweb.insync.beans.BeansUnit;
import org.netbeans.modules.visualweb.insync.java.JavaClass;
import org.netbeans.modules.visualweb.insync.java.Statement;

public class Property
extends BeansNode {
    public static final Property[] EMPTY_ARRAY = new Property[0];
    final Bean bean;
    final PropertyDescriptor descriptor;
    private JavaClass javaClass;
    private Statement stmt;
    private String valueSource;
    private Object value;
    private boolean inserted;

    protected Property(Bean bean, PropertyDescriptor propertyDescriptor, boolean bl) {
        super(bean.getUnit());
        this.bean = bean;
        this.descriptor = propertyDescriptor;
        this.javaClass = this.unit.getThisClass();
    }

    private Property(Bean bean, PropertyDescriptor propertyDescriptor, Statement statement, Object object) {
        this(bean, propertyDescriptor, false);
        this.stmt = statement;
        assert (Trace.trace((String)"insync.beans", (String)("P new bound Property: " + this)));
    }

    protected static Property newBoundInstance(BeansUnit beansUnit, Statement statement) {
        Bean bean = beansUnit.getBean(statement.getBeanName());
        if (bean == null) {
            return null;
        }
        PropertyDescriptor propertyDescriptor = bean.getPropertyDescriptorForSetter(statement.getPropertySetterName());
        if (propertyDescriptor == null) {
            return null;
        }
        Property property = new Property(bean, propertyDescriptor, statement, null);
        property.setInserted(true);
        return property;
    }

    protected Property(Bean bean, PropertyDescriptor propertyDescriptor) {
        this(bean, propertyDescriptor, false);
        assert (Trace.trace((String)"insync.beans", (String)("P new created Property: " + this)));
    }

    protected boolean removeEntry() {
        boolean bl = false;
        if (this.inserted) {
            if (this.stmt == null) {
                this.stmt = this.getStatement();
            }
            bl = this.stmt.remove();
            this.stmt = null;
        }
        return bl;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public boolean isMarkupProperty() {
        return false;
    }

    public Object getValue(Class clazz) {
        if (this.inserted && this.value == null) {
            if (this.stmt == null) {
                this.stmt = this.getStatement();
            }
            this.value = this.stmt.evaluateArgument();
        }
        return this.value;
    }

    public String getValueSource() {
        if (this.inserted && this.valueSource == null) {
            if (this.stmt == null) {
                this.stmt = this.getStatement();
            }
            this.valueSource = this.stmt.getArgumentSource();
        }
        return this.valueSource;
    }

    public void setValue(Object object, String string) {
        this.valueSource = string;
        if (this.inserted && string != null) {
            if (this.stmt == null) {
                this.stmt = this.getStatement();
            }
            this.stmt.replaceArgument(string);
        }
    }

    public void setBeanName(String string) {
        if (this.inserted) {
            if (this.stmt == null) {
                this.stmt = this.getStatement();
            }
            this.stmt.setBeanName(string);
        }
    }

    private Statement getStatement() {
        return this.bean.unit.getPropertiesInitMethod().findPropertyStatement(this.bean.getName(), this.getWriteMethodName());
    }

    public String getBeanName() {
        return this.bean != null ? this.bean.getName() : null;
    }

    public String getWriteMethodName() {
        return this.descriptor != null ? this.descriptor.getWriteMethod().getName() : null;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void setInserted(boolean bl) {
        this.inserted = bl;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(" n:");
        stringBuffer.append(this.getName());
        stringBuffer.append(" vs:\"");
        stringBuffer.append(this.getValueSource());
        stringBuffer.append("\"");
    }
}

