/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.live;

import com.sun.rave.designtime.ContextMethod;
import com.sun.rave.designtime.DesignContext;
import com.sun.source.tree.MethodTree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.visualweb.insync.java.ClassUtil;
import org.netbeans.modules.visualweb.insync.java.JavaClass;
import org.netbeans.modules.visualweb.insync.java.Method;
import org.netbeans.modules.visualweb.insync.java.ReadTaskWrapper;
import org.netbeans.modules.visualweb.insync.live.LiveUnit;
import org.openide.util.NbBundle;

public class ContextMethodHelper {
    LiveUnit lu;

    public ContextMethodHelper(LiveUnit liveUnit) {
        this.lu = liveUnit;
    }

    public ContextMethod[] getContextMethods() {
        JavaClass javaClass = this.lu.getSourceUnit().getThisClass();
        ArrayList<ContextMethod> arrayList = new ArrayList<ContextMethod>();
        for (Method method : javaClass.getMethods()) {
            ContextMethod contextMethod = this.getContextMethod(method);
            if (contextMethod == null) continue;
            arrayList.add(contextMethod);
        }
        return arrayList.toArray(new ContextMethod[0]);
    }

    public ContextMethod getContextMethod(final Method method) {
        return (ContextMethod)ReadTaskWrapper.execute(new ReadTaskWrapper.Read(){

            public Object run(CompilationInfo compilationInfo) {
                ExecutableElement executableElement = method.getElement(compilationInfo);
                if (executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    List<? extends VariableElement> list = executableElement.getParameters();
                    Class[] classArray = new Class[list.size()];
                    String[] stringArray = new String[list.size()];
                    int n = 0;
                    ClassLoader classLoader = ContextMethodHelper.this.lu.getSourceUnit().getClassLoader();
                    try {
                        for (VariableElement object2 : list) {
                            classArray[n] = ClassUtil.getClass(((Object)object2.asType()).toString(), classLoader);
                            stringArray[n++] = object2.getSimpleName().toString();
                        }
                        MethodTree methodTree = compilationInfo.getTrees().getTree(executableElement);
                        Class clazz = ClassUtil.getClass(((Object)executableElement.getReturnType()).toString(), classLoader);
                        return new ContextMethod((DesignContext)ContextMethodHelper.this.lu, executableElement.getSimpleName().toString(), method.getModifierFlags(methodTree), clazz, classArray, stringArray, Method.getBodyText(compilationInfo, methodTree), method.getCommentText(compilationInfo, methodTree));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return null;
            }
        }, this.lu.getSourceUnit().getJavaUnit().getFileObject());
    }

    public ContextMethod getContextMethod(String string) {
        return this.getContextMethod(string, null);
    }

    public ContextMethod getContextMethod(String string, Class[] classArray) {
        JavaClass javaClass = this.lu.getSourceUnit().getThisClass();
        Method method = javaClass.getMethod(string, classArray);
        return this.getContextMethod(method);
    }

    public boolean createContextMethod(ContextMethod contextMethod) throws IllegalArgumentException {
        if (contextMethod == null || contextMethod.getDesignContext() != this.lu) {
            return false;
        }
        JavaClass javaClass = this.lu.getSourceUnit().getThisClass();
        Method method = javaClass.getPublicMethod(contextMethod.getName(), contextMethod.getParameterTypes());
        if (method != null) {
            throw new IllegalArgumentException(NbBundle.getMessage(LiveUnit.class, (String)"IllegalMethod"));
        }
        method = javaClass.addMethod(contextMethod);
        if (method != null) {
            if (this.lu.getSourceUnit().getJavaUnit().getErrors().length > 0) {
                throw new IllegalArgumentException(NbBundle.getMessage(LiveUnit.class, (String)"IllegalSource"));
            }
            return true;
        }
        return false;
    }

    public ContextMethod updateContextMethod(ContextMethod contextMethod) throws IllegalArgumentException {
        if (contextMethod == null || contextMethod.getDesignContext() != this.lu) {
            return null;
        }
        JavaClass javaClass = this.lu.getSourceUnit().getThisClass();
        Class[] classArray = contextMethod.getParameterTypes();
        Method method = javaClass.getPublicMethod(contextMethod.getName(), classArray);
        if (method != null) {
            method.update(contextMethod);
            ContextMethod contextMethod2 = this.getContextMethod(method);
            return contextMethod2;
        }
        throw new IllegalArgumentException(NbBundle.getMessage(LiveUnit.class, (String)"IllegalMethod"));
    }

    public boolean removeContextMethod(ContextMethod contextMethod) {
        Method method;
        if (contextMethod == null || contextMethod.getDesignContext() != this.lu) {
            return false;
        }
        JavaClass javaClass = this.lu.getSourceUnit().getThisClass();
        Class[] classArray = contextMethod.getParameterTypes();
        if (classArray == null) {
            classArray = new Class[]{};
        }
        if ((method = javaClass.getPublicMethod(contextMethod.getName(), classArray)) == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(LiveUnit.class, (String)"IllegalMethod"));
        }
        method.remove();
        return true;
    }
}

