/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xslt.project.CommandlineTransformmapCatalogModel;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.spi.ExternalModelRetriever;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandlineWSDLModelRetriever
implements ExternalModelRetriever {
    private Logger logger = Logger.getLogger(CommandlineWSDLModelRetriever.class.getName());
    private List<File> myDependentProjectDirs;
    private List<File> mySourceDirs;
    private FileFilter myWsdlFilter;
    private FileFilter myFolderFilter;
    private boolean initialized = false;

    public void init(List<File> list, List<File> list2) {
        this.myDependentProjectDirs = list;
        this.mySourceDirs = list2;
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Collection<WSDLModel> getWSDLModels(TMapModel tMapModel, String string) {
        ArrayList<WSDLModel> arrayList = new ArrayList<WSDLModel>();
        if (!this.isInitialized() || tMapModel == null || string == null) {
            return arrayList;
        }
        List<WSDLModel> list = this.getWsdlModels();
        for (WSDLModel wSDLModel : list) {
            assert (wSDLModel != null);
            Definitions definitions = wSDLModel.getDefinitions();
            if (definitions == null || !string.equals(definitions.getTargetNamespace())) continue;
            arrayList.add(wSDLModel);
        }
        return arrayList;
    }

    protected WSDLModel getWsdlModel(File file) {
        if (file == null) {
            return null;
        }
        WSDLModel wSDLModel = null;
        try {
            wSDLModel = CommandlineTransformmapCatalogModel.getDefault().getWsdlModel(file.toURI());
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Error while getting WSDL Model ", exception);
            throw new RuntimeException("Error while getting WSDL Model ", exception);
        }
        if (wSDLModel != null && !Model.State.VALID.equals((Object)wSDLModel.getState())) {
            return null;
        }
        return wSDLModel;
    }

    private List<File> collectWSDLs(File file) {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file == null || !file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray2 = file.listFiles(this.getWsdlFilter());
        if (fileArray2 != null && fileArray2.length > 0) {
            arrayList.addAll(Arrays.asList(fileArray2));
        }
        if ((fileArray = file.listFiles(this.getFolderFilter())) != null && fileArray.length > 0) {
            for (File file2 : fileArray) {
                arrayList.addAll(this.collectWSDLs(file2));
            }
        }
        return arrayList;
    }

    private List<WSDLModel> getWsdlModels() {
        ArrayList<WSDLModel> arrayList = new ArrayList<WSDLModel>();
        List<File> list = this.getSourceDirs();
        if (list == null || list.size() < 1) {
            return arrayList;
        }
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file : list) {
            arrayList2.addAll(this.collectWSDLs(file));
        }
        for (File file : arrayList2) {
            WSDLModel wSDLModel = this.getWsdlModel(file);
            if (wSDLModel == null) continue;
            arrayList.add(wSDLModel);
        }
        return arrayList;
    }

    public List<File> getDepedentProjectDirs() {
        return this.myDependentProjectDirs;
    }

    public List<File> getSourceDirs() {
        return this.mySourceDirs;
    }

    private FileFilter getFolderFilter() {
        if (this.myFolderFilter == null) {
            this.myFolderFilter = new FoldersFilter();
        }
        return this.myFolderFilter;
    }

    private FileFilter getWsdlFilter() {
        if (this.myWsdlFilter == null) {
            this.myWsdlFilter = new WsdlFileFilter();
        }
        return this.myWsdlFilter;
    }

    private class WsdlFileFilter
    implements FileFilter {
        private WsdlFileFilter() {
        }

        public boolean accept(File file) {
            if (file == null || file.isDirectory()) {
                return false;
            }
            return "wsdl".equals(FileUtil.getExtension((String)file.getName()));
        }
    }

    private class FoldersFilter
    implements FileFilter {
        private FoldersFilter() {
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            return file.isDirectory();
        }
    }
}

