/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xslt.project.nodes.TransformationDescNode;
import org.netbeans.modules.xslt.project.nodes.TransformationUCChildren;
import org.netbeans.modules.xslt.project.nodes.TransformationUCNode;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationDesc;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationUC;
import org.netbeans.modules.xslt.tmap.model.xsltmap.XsltMapModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class TransformationsChildren
extends Children.Keys
implements FileChangeListener {
    private FileObject projectDir;
    private Project project;

    public TransformationsChildren(Project project) {
        this.project = project;
        this.projectDir = project.getProjectDirectory();
    }

    protected Node[] createNodes(Object object) {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        if (object instanceof TransformationUC) {
            arrayList.add(new TransformationUCNode((TransformationUC)object, (Children)new TransformationUCChildren((TransformationUC)object)));
        } else if (object instanceof TransformationDesc) {
            arrayList.add(new TransformationDescNode((TransformationDesc)object));
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private Collection getNodeKeys() {
        if (this.projectDir == null) {
            return Collections.EMPTY_SET;
        }
        try {
            XsltMapModel xsltMapModel = XsltMapModel.getDefault((Project)this.project);
            if (xsltMapModel != null) {
                return xsltMapModel.getTransformationUCs();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return Collections.EMPTY_SET;
    }

    protected void addNotify() {
        super.addNotify();
        this.projectDir.getFileObject("src").addFileChangeListener((FileChangeListener)this);
        this.setKeys(this.getNodeKeys());
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.projectDir.getFileObject("src").removeFileChangeListener((FileChangeListener)this);
        super.removeNotify();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.setKeys(this.getNodeKeys());
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
        this.setKeys(this.getNodeKeys());
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.setKeys(this.getNodeKeys());
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.setKeys(this.getNodeKeys());
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }
}

