/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.xslt.project.spi.ProjectsFilesChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class ProjectsFilesChangesSupport {
    private Lock writeLock = new ReentrantReadWriteLock().writeLock();
    private List<ProjectsFilesChangeListener> myListeners = new ArrayList<ProjectsFilesChangeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(ProjectsFilesChangeListener projectsFilesChangeListener) {
        assert (projectsFilesChangeListener != null) : "Try to add null listener.";
        this.writeLock.lock();
        try {
            this.myListeners.add(projectsFilesChangeListener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(ProjectsFilesChangeListener projectsFilesChangeListener) {
        assert (projectsFilesChangeListener != null) : "Try to remove null listener.";
        this.writeLock.lock();
        try {
            this.myListeners.remove(projectsFilesChangeListener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPropertyChangeListener() {
        this.writeLock.lock();
        try {
            this.myListeners.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFileAdded(FileObject fileObject) {
        ProjectsFilesChangeListener[] projectsFilesChangeListenerArray = new ProjectsFilesChangeListener[this.myListeners.size()];
        ProjectsFilesChangeListener[] projectsFilesChangeListenerArray2 = this.myListeners;
        synchronized (this.myListeners) {
            projectsFilesChangeListenerArray = this.myListeners.toArray(projectsFilesChangeListenerArray);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (ProjectsFilesChangeListener projectsFilesChangeListener : projectsFilesChangeListenerArray) {
                projectsFilesChangeListener.fileAdded(fileObject);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFileRenamed(FileRenameEvent fileRenameEvent) {
        ProjectsFilesChangeListener[] projectsFilesChangeListenerArray = new ProjectsFilesChangeListener[this.myListeners.size()];
        ProjectsFilesChangeListener[] projectsFilesChangeListenerArray2 = this.myListeners;
        synchronized (this.myListeners) {
            projectsFilesChangeListenerArray = this.myListeners.toArray(projectsFilesChangeListenerArray);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (ProjectsFilesChangeListener projectsFilesChangeListener : projectsFilesChangeListenerArray) {
                projectsFilesChangeListener.fileRenamed(fileRenameEvent);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFileDeleted(FileObject fileObject) {
        ProjectsFilesChangeListener[] projectsFilesChangeListenerArray = new ProjectsFilesChangeListener[this.myListeners.size()];
        ProjectsFilesChangeListener[] projectsFilesChangeListenerArray2 = this.myListeners;
        synchronized (this.myListeners) {
            projectsFilesChangeListenerArray = this.myListeners.toArray(projectsFilesChangeListenerArray);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (ProjectsFilesChangeListener projectsFilesChangeListener : projectsFilesChangeListenerArray) {
                projectsFilesChangeListener.fileDeleted(fileObject);
            }
            return;
        }
    }
}

