/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.nodes.actions.OpenURLActionCookie;
import org.netbeans.modules.glassfish.common.nodes.actions.UndeployModuleCookie;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class OpenURLAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        for (Node node : nodeArray) {
            OpenURLActionCookie openURLActionCookie = (OpenURLActionCookie)node.getCookie(OpenURLActionCookie.class);
            if (openURLActionCookie == null) continue;
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(openURLActionCookie.getWebURL()));
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger("glassfish").log(Level.INFO, malformedURLException.getLocalizedMessage(), malformedURLException);
            }
        }
    }

    protected boolean enable(Node[] nodeArray) {
        for (Node node : nodeArray) {
            OpenURLActionCookie openURLActionCookie = (OpenURLActionCookie)node.getCookie(OpenURLActionCookie.class);
            UndeployModuleCookie undeployModuleCookie = (UndeployModuleCookie)node.getCookie(UndeployModuleCookie.class);
            if (undeployModuleCookie != null && undeployModuleCookie.isRunning()) {
                return false;
            }
            if (openURLActionCookie == null || openURLActionCookie.getWebURL() == null) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(OpenURLAction.class, (String)"LBL_OpenInBrowserAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

