/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.bpel.debugger.api.AnnotationType;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.Position;
import org.netbeans.modules.bpel.debugger.api.SourcePath;
import org.netbeans.modules.bpel.debugger.api.pem.PemEntity;
import org.netbeans.modules.bpel.debugger.api.psm.PsmEntity;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BpelLineBreakpointView;
import org.netbeans.modules.bpel.debugger.ui.util.ModelUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.spi.viewmodel.Model;
import org.openide.util.RequestProcessor;

public class CurrentPositionAnnotationListener
extends DebuggerManagerAdapter {
    private transient Object myCurrentPositionAnnotation;
    private transient Object myCurrentlyExecutingAnnotation;
    private Position myCurrentPosition;
    private BpelDebugger myCurrentDebugger;
    private SourcePath mySourcePath;
    private Queue<Position> myPositionsQueue = new LinkedList<Position>();
    private boolean doAnnotate = true;
    private BpelLineBreakpointView myBreakpointsNodeModel;

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("currentEngine".equals(propertyChangeEvent.getPropertyName())) {
            this.updateCurrentDebugger();
            this.updateCurrentPosition();
            this.annotate();
        } else if ("currentPosition".equals(propertyChangeEvent.getPropertyName())) {
            this.updateCurrentPosition();
            this.annotate();
        }
    }

    private void updateCurrentDebugger() {
        BpelDebugger bpelDebugger = CurrentPositionAnnotationListener.getCurrentDebugger();
        if (this.myCurrentDebugger == bpelDebugger) {
            return;
        }
        if (this.myCurrentDebugger != null) {
            this.myCurrentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (bpelDebugger != null) {
            bpelDebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.mySourcePath = CurrentPositionAnnotationListener.getCurrentSourcePath();
        }
        this.myCurrentDebugger = bpelDebugger;
        if (this.myCurrentDebugger == null) {
            this.stopAnnotatingTask();
        } else {
            this.startAnnotatingTask();
        }
    }

    private static BpelDebugger getCurrentDebugger() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return (BpelDebugger)debuggerEngine.lookupFirst(null, BpelDebugger.class);
    }

    private static SourcePath getCurrentSourcePath() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
    }

    private void updateCurrentPosition() {
        this.myCurrentPosition = this.myCurrentDebugger != null ? this.myCurrentDebugger.getCurrentPosition() : null;
        if (this.getBreakpointsNodeModel() != null) {
            this.getBreakpointsNodeModel().setCurrentPosition(this.myCurrentPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate() {
        this.myPositionsQueue.offer(this.myCurrentPosition);
        Queue<Position> queue = this.myPositionsQueue;
        synchronized (queue) {
            this.myPositionsQueue.notifyAll();
        }
    }

    private void startAnnotatingTask() {
        this.doAnnotate = true;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (CurrentPositionAnnotationListener.this.doAnnotate) {
                    Queue queue = CurrentPositionAnnotationListener.this.myPositionsQueue;
                    synchronized (queue) {
                        while (!CurrentPositionAnnotationListener.this.myPositionsQueue.isEmpty()) {
                            PemEntity pemEntity;
                            String string;
                            String string2;
                            Position position = (Position)CurrentPositionAnnotationListener.this.myPositionsQueue.poll();
                            this.removeAnnotations();
                            if (position != null) {
                                string2 = CurrentPositionAnnotationListener.this.mySourcePath.getSourcePath(position.getProcessQName());
                                if (string2 == null) continue;
                                CurrentPositionAnnotationListener.this.myCurrentPositionAnnotation = EditorContextBridge.addAnnotation((String)string2, (String)position.getXpath(), (int)position.getLineNumber(), (AnnotationType)AnnotationType.CURRENT_POSITION);
                                EditorContextBridge.showSource((String)string2, (String)position.getXpath(), null);
                                continue;
                            }
                            if (CurrentPositionAnnotationListener.this.myCurrentDebugger == null || (string2 = CurrentPositionAnnotationListener.this.myCurrentDebugger.getCurrentProcessInstance()) == null || (string = CurrentPositionAnnotationListener.this.mySourcePath.getSourcePath(string2.getProcess().getQName())) == null || (pemEntity = string2.getProcessExecutionModel().getLastStartedEntity()) == null) continue;
                            PsmEntity psmEntity = pemEntity.getPsmEntity();
                            BpelModel bpelModel = ModelUtil.getBpelModel(string2.getProcess().getQName());
                            int n = ModelUtil.getLineNumber(bpelModel, psmEntity.getXpath());
                            CurrentPositionAnnotationListener.this.myCurrentlyExecutingAnnotation = EditorContextBridge.addAnnotation((String)string, (String)psmEntity.getXpath(), (int)n, (AnnotationType)AnnotationType.CURRENTLY_EXECUTING);
                        }
                    }
                    try {
                        queue = CurrentPositionAnnotationListener.this.myPositionsQueue;
                        synchronized (queue) {
                            CurrentPositionAnnotationListener.this.myPositionsQueue.wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                this.removeAnnotations();
            }

            private void removeAnnotations() {
                if (CurrentPositionAnnotationListener.this.myCurrentPositionAnnotation != null) {
                    EditorContextBridge.removeAnnotation((Object)CurrentPositionAnnotationListener.this.myCurrentPositionAnnotation);
                    CurrentPositionAnnotationListener.this.myCurrentPositionAnnotation = null;
                }
                if (CurrentPositionAnnotationListener.this.myCurrentlyExecutingAnnotation != null) {
                    EditorContextBridge.removeAnnotation((Object)CurrentPositionAnnotationListener.this.myCurrentlyExecutingAnnotation);
                    CurrentPositionAnnotationListener.this.myCurrentlyExecutingAnnotation = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAnnotatingTask() {
        this.doAnnotate = false;
        Queue<Position> queue = this.myPositionsQueue;
        synchronized (queue) {
            this.myPositionsQueue.notifyAll();
        }
    }

    private BpelLineBreakpointView getBreakpointsNodeModel() {
        if (this.myBreakpointsNodeModel == null) {
            List list = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", Model.class);
            for (Model model : list) {
                if (!(model instanceof BpelLineBreakpointView)) continue;
                this.myBreakpointsNodeModel = (BpelLineBreakpointView)model;
                break;
            }
        }
        return this.myBreakpointsNodeModel;
    }
}

