/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JEditorPane;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.debugger.ui.util.ModelUtil;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.soa.ui.nodes.InstanceRef;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class RunToCursorUtil {
    private Object currentLock = new Object();
    private EditorCookie currentEditorCookie = null;
    private PropertyChangeListener editorObservableListener;
    public PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String currentURL = null;
    private Lookup.Result resDataObject = Utilities.actionsGlobalContext().lookup(new Lookup.Template(DataObject.class));

    public RunToCursorUtil() {
        this.resDataObject.addLookupListener((LookupListener)new EditorLookupListener(DataObject.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditorCookie getCurrentEditorCookie() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentEditorCookie == null) {
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (topComponent != null) {
                    this.currentEditorCookie = (EditorCookie)topComponent.getLookup().lookup(EditorCookie.class);
                }
                if (this.currentEditorCookie instanceof EditorCookie.Observable) {
                    if (this.editorObservableListener == null) {
                        this.editorObservableListener = new EditorLookupListener(EditorCookie.Observable.class);
                    }
                    ((EditorCookie.Observable)this.currentEditorCookie).addPropertyChangeListener(this.editorObservableListener);
                }
            }
            return this.currentEditorCookie;
        }
    }

    private JEditorPane getCurrentEditor() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    public LineBreakpoint createBreakpointAtCursor() {
        Object object;
        Node node = this.getCurrentNode();
        if (node == null) {
            return null;
        }
        DataObject dataObject = this.getDataObject(node);
        if (dataObject == null) {
            return null;
        }
        String string = FileUtil.toFile((FileObject)dataObject.getPrimaryFile()).getPath();
        if (!string.endsWith(".bpel")) {
            return null;
        }
        string = string.replace("\\", "/");
        UniqueId uniqueId = null;
        int n = -1;
        if (node instanceof InstanceRef && !this.isInSourceEditor()) {
            object = ((InstanceRef)node).getReference();
            if (object == null) {
                return null;
            }
            if (!(object instanceof Activity)) {
                return null;
            }
            Activity activity = (Activity)object;
            uniqueId = activity.getUID();
            n = ModelUtil.getLineNumber(uniqueId);
        } else {
            n = this.getCurrentLineNumber(node);
            if (n > 0) {
                int n2 = EditorContextBridge.translateBreakpointLine((String)string, (int)n);
                StyledDocument styledDocument = EditorUtil.getDocument(dataObject);
                BpelModel bpelModel = EditorUtil.getBpelModel(dataObject);
                if (styledDocument != null && bpelModel != null && n2 > 0) {
                    int n3 = EditorUtil.findOffset(styledDocument, n2);
                    uniqueId = ModelUtil.getBpelEntityId(bpelModel, n3);
                }
                n = n2;
            }
        }
        if (n == -1) {
            return null;
        }
        object = null;
        if (uniqueId != null) {
            object = ModelUtil.getXpath(uniqueId);
        }
        return LineBreakpoint.create((String)string, (String)object, (int)n);
    }

    private Node getCurrentNode() {
        Node[] nodeArray = WindowManager.getDefault().getRegistry().getCurrentNodes();
        if (nodeArray == null) {
            return null;
        }
        if (nodeArray.length == 0) {
            return null;
        }
        if (nodeArray.length != 1) {
            return null;
        }
        return nodeArray[0];
    }

    private boolean isInSourceEditor() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        if (topComponent == null) {
            return false;
        }
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return false;
        }
        MultiViewPerspective multiViewPerspective = multiViewHandler.getSelectedPerspective();
        return multiViewPerspective.preferredID().equals("bpelsource");
    }

    private int getCurrentLineNumber(Node node) {
        EditorCookie editorCookie = (EditorCookie)node.getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null) {
            return -1;
        }
        if (jEditorPaneArray.length == 0) {
            return -1;
        }
        Caret caret = jEditorPaneArray[0].getCaret();
        if (caret == null) {
            return -1;
        }
        int n = caret.getDot();
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n) + 1;
    }

    private DataObject getDataObject(Node node) {
        if (node == null) {
            return null;
        }
        return (DataObject)node.getLookup().lookup(DataObject.class);
    }

    public int getCurrentLineNumber() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentFile() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentURL == null) {
                DataObject[] dataObjectArray = this.resDataObject.allInstances().toArray(new DataObject[0]);
                this.currentURL = "";
                if (dataObjectArray.length != 1) {
                    return this.currentURL;
                }
                DataObject dataObject = dataObjectArray[0];
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                this.currentURL = dataObject.getPrimaryFile().getPath();
            }
            return this.currentURL;
        }
    }

    private class EditorLookupListener
    implements LookupListener,
    PropertyChangeListener {
        private Class type;

        public EditorLookupListener(Class clazz) {
            this.type = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            if (this.type == DataObject.class) {
                Object object = RunToCursorUtil.this.currentLock;
                synchronized (object) {
                    RunToCursorUtil.this.currentURL = null;
                    if (RunToCursorUtil.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)RunToCursorUtil.this.currentEditorCookie).removePropertyChangeListener(RunToCursorUtil.this.editorObservableListener);
                    }
                    RunToCursorUtil.this.currentEditorCookie = null;
                }
                RunToCursorUtil.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == EditorCookie.class) {
                Object object = RunToCursorUtil.this.currentLock;
                synchronized (object) {
                    RunToCursorUtil.this.currentURL = null;
                    if (RunToCursorUtil.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)RunToCursorUtil.this.currentEditorCookie).removePropertyChangeListener(RunToCursorUtil.this.editorObservableListener);
                    }
                    RunToCursorUtil.this.currentEditorCookie = null;
                }
                RunToCursorUtil.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == Node.class) {
                RunToCursorUtil.this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("openedPanes")) {
                RunToCursorUtil.this.pcs.firePropertyChange("openedPanes", null, null);
            }
        }
    }
}

