/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.breakpoint;

import javax.xml.namespace.QName;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.bpel.debugger.api.breakpoints.BpelBreakpoint;
import org.netbeans.modules.bpel.debugger.api.breakpoints.BpelFaultBreakpoint;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;

public class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{LineBreakpoint.class.getName(), BpelFaultBreakpoint.class.getName()};
    }

    public Object read(String string, Properties properties) {
        LineBreakpoint lineBreakpoint = null;
        if (string.equals(LineBreakpoint.class.getName())) {
            lineBreakpoint = LineBreakpoint.create((String)properties.getString("url", null), (String)properties.getString("xpath", null), (int)properties.getInt("lineNumber", -1));
        } else if (string.equals(BpelFaultBreakpoint.class.getName())) {
            String string2 = properties.getString("processQName", null);
            QName qName = null;
            if (string2 != null && !string2.trim().equals("")) {
                qName = QName.valueOf(string2);
            }
            String string3 = properties.getString("faultQName", null);
            QName qName2 = null;
            if (string3 != null && !string3.trim().equals("")) {
                qName2 = QName.valueOf(string3);
            }
            lineBreakpoint = BpelFaultBreakpoint.create((QName)qName, qName2);
        } else assert (false) : "Unexpected breakpoint type: " + string;
        lineBreakpoint.setGroupName(properties.getString("groupName", ""));
        if (properties.getBoolean("enabled", true)) {
            lineBreakpoint.enable();
        } else {
            lineBreakpoint.disable();
        }
        return lineBreakpoint;
    }

    public void write(Object object, Properties properties) {
        BpelBreakpoint bpelBreakpoint = (BpelBreakpoint)object;
        properties.setString("groupName", bpelBreakpoint.getGroupName());
        properties.setBoolean("enabled", bpelBreakpoint.isEnabled());
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)object;
            properties.setString("url", lineBreakpoint.getURL());
            properties.setString("xpath", lineBreakpoint.getXpath());
            properties.setInt("lineNumber", lineBreakpoint.getLineNumber());
        } else if (object instanceof BpelFaultBreakpoint) {
            BpelFaultBreakpoint bpelFaultBreakpoint = (BpelFaultBreakpoint)object;
            if (bpelFaultBreakpoint.getProcessQName() != null) {
                properties.setString("processQName", bpelFaultBreakpoint.getProcessQName().toString());
            }
            if (bpelFaultBreakpoint.getFaultQName() != null) {
                properties.setString("faultQName", bpelFaultBreakpoint.getFaultQName().toString());
            }
        }
    }
}

