/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.process;

import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.BpelProcess;
import org.netbeans.modules.bpel.debugger.api.CorrelationSet;
import org.netbeans.modules.bpel.debugger.api.Fault;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.WaitingCorrelatedMessage;
import org.netbeans.modules.bpel.debugger.ui.process.ProcessesTreeModel;
import org.netbeans.modules.bpel.debugger.ui.util.HtmlUtil;
import org.netbeans.modules.bpel.debugger.ui.util.VariablesUtil;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ProcessesNodeModel
implements NodeModel {
    private BpelDebugger myDebugger;
    private VariablesUtil myVariablesUtil;
    private static final String ICONS_BASE = "org/netbeans/modules/bpel/debugger/ui/resources/image/";
    private static final String PROCESS_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/process";
    private static final String CURRENT_INSTANCE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/current";
    private static final String RUNNING_INSTANCE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/running";
    private static final String SUSPENDED_INSTANCE_ICON = "org/netbeans/modules/bpel/debugger/ui/resources/image/suspended";

    public ProcessesNodeModel() {
    }

    public ProcessesNodeModel(ContextProvider contextProvider) {
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
        this.myVariablesUtil = new VariablesUtil(this.myDebugger);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return NbBundle.getMessage(ProcessesNodeModel.class, (String)"CTL_Process_Column_Name");
        }
        if (object instanceof BpelProcess) {
            BpelProcess bpelProcess = (BpelProcess)object;
            return bpelProcess.getName();
        }
        if (object instanceof ProcessInstance) {
            ProcessInstance processInstance = (ProcessInstance)object;
            String string = processInstance.getName();
            return this.isProcessInstanceCurrent(processInstance) ? HtmlUtil.toBold(string) : string;
        }
        if (object instanceof ProcessesTreeModel.CorrelationSetsWrapper) {
            return NbBundle.getMessage(ProcessesNodeModel.class, (String)"LBL_Correlation_Sets");
        }
        if (object instanceof CorrelationSet) {
            return ((CorrelationSet)object).getName();
        }
        if (object instanceof CorrelationSet.Property) {
            QName qName = ((CorrelationSet.Property)object).getName();
            String string = qName.getPrefix();
            if (string == null || string.equals("")) {
                return qName.getLocalPart();
            }
            return qName.getPrefix() + ":" + qName.getLocalPart();
        }
        if (object instanceof ProcessesTreeModel.NoPropertiesDataMarker) {
            return NbBundle.getMessage(ProcessesNodeModel.class, (String)"LBL_No_Properties_Data_Name");
        }
        if (object instanceof ProcessesTreeModel.WaitingMessagesWrapper) {
            return NbBundle.getMessage(ProcessesNodeModel.class, (String)"LBL_Waiting_Messages");
        }
        if (object instanceof WaitingCorrelatedMessage) {
            return ((WaitingCorrelatedMessage)object).getName();
        }
        if (object instanceof ProcessesTreeModel.FaultsWrapper) {
            return NbBundle.getMessage(ProcessesNodeModel.class, (String)"LBL_Faults");
        }
        if (object instanceof Fault) {
            QName qName = ((Fault)object).getQName();
            String string = qName.getPrefix();
            if (string == null || string.equals("")) {
                return qName.getLocalPart();
            }
            return qName.getPrefix() + ":" + qName.getLocalPart();
        }
        return this.myVariablesUtil.getDisplayName(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return NbBundle.getMessage(ProcessesNodeModel.class, (String)"CTL_Process_Column_Name_Tooltip");
        }
        if (object instanceof CorrelationSet.Property) {
            QName qName = ((CorrelationSet.Property)object).getName();
            if (qName.getNamespaceURI().equals("")) {
                return qName.getLocalPart();
            }
            return "{" + qName.getNamespaceURI() + "} " + qName.getLocalPart();
        }
        if (object instanceof ProcessesTreeModel.NoPropertiesDataMarker) {
            return NbBundle.getMessage(ProcessesNodeModel.class, (String)"LBL_No_Properties_Data_Tooltip");
        }
        if (object instanceof Fault) {
            QName qName = ((Fault)object).getQName();
            if (qName.getNamespaceURI().equals("")) {
                return qName.getLocalPart();
            }
            return "{" + qName.getNamespaceURI() + "} " + qName.getLocalPart();
        }
        return this.getDisplayName(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return CURRENT_INSTANCE_ICON;
        }
        if (object instanceof BpelProcess) {
            return PROCESS_ICON;
        }
        if (object instanceof ProcessInstance) {
            ProcessInstance processInstance = (ProcessInstance)object;
            int n = processInstance.getState();
            if (this.isProcessInstanceCurrent(processInstance)) {
                return CURRENT_INSTANCE_ICON;
            }
            if (n == 2) {
                return SUSPENDED_INSTANCE_ICON;
            }
            return RUNNING_INSTANCE_ICON;
        }
        if (object instanceof ProcessesTreeModel.CorrelationSetsWrapper) {
            return PROCESS_ICON;
        }
        if (object instanceof CorrelationSet) {
            return PROCESS_ICON;
        }
        if (object instanceof CorrelationSet.Property) {
            return PROCESS_ICON;
        }
        if (object instanceof ProcessesTreeModel.NoPropertiesDataMarker) {
            return PROCESS_ICON;
        }
        if (object instanceof ProcessesTreeModel.WaitingMessagesWrapper) {
            return PROCESS_ICON;
        }
        if (object instanceof WaitingCorrelatedMessage) {
            return PROCESS_ICON;
        }
        if (object instanceof ProcessesTreeModel.FaultsWrapper) {
            return PROCESS_ICON;
        }
        if (object instanceof Fault) {
            return PROCESS_ICON;
        }
        return this.myVariablesUtil.getIconBase(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private boolean isProcessInstanceCurrent(ProcessInstance processInstance) {
        if (this.myDebugger == null) {
            return false;
        }
        return processInstance.equals(this.myDebugger.getCurrentProcessInstance());
    }
}

