/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.threads;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Vector;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.pem.ProcessExecutionModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ThreadsTreeModel
implements TreeModel {
    private BpelDebugger myDebugger;
    private PositionListener myListener;
    private Vector<ModelListener> myListeners = new Vector();

    public ThreadsTreeModel(ContextProvider contextProvider) {
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (this.myDebugger.getCurrentProcessInstance() == null) {
            if ("Root".equals(object)) {
                return new Object[]{new Dummy()};
            }
            if (object instanceof Dummy) {
                return new Object[0];
            }
        }
        if ("Root".equals(object)) {
            return this.getBranches(null, n, n2);
        }
        if (object instanceof ProcessExecutionModel.Branch) {
            return this.getBranches((ProcessExecutionModel.Branch)object, n, n2);
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (this.myDebugger.getCurrentProcessInstance() == null) {
            if ("Root".equals(object)) {
                return 1;
            }
            if (object instanceof Dummy) {
                return 0;
            }
        }
        if ("Root".equals(object)) {
            return this.getBranches(null, -1, -1).length;
        }
        if (object instanceof ProcessExecutionModel.Branch) {
            return this.getBranches((ProcessExecutionModel.Branch)object, -1, -1).length;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        return this.getChildrenCount(object) == 0;
    }

    public void addModelListener(ModelListener modelListener) {
        this.myListeners.add(modelListener);
        if (this.myListener == null) {
            this.myListener = new PositionListener(this, this.myDebugger);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        this.myListeners.remove(modelListener);
        if (this.myListeners.size() == 0) {
            this.myListener.destroy();
            this.myListener = null;
        }
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.myListeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private ProcessExecutionModel.Branch[] getBranches(ProcessExecutionModel.Branch branch, int n, int n2) {
        ProcessInstance processInstance = this.myDebugger.getCurrentProcessInstance();
        if (processInstance == null) {
            return new ProcessExecutionModel.Branch[0];
        }
        ProcessExecutionModel.Branch[] branchArray = processInstance.getProcessExecutionModel().getBranches(branch);
        if (n != -1 && n2 != -1 && n2 >= n) {
            ProcessExecutionModel.Branch[] branchArray2 = new ProcessExecutionModel.Branch[n2 - n];
            System.arraycopy(branchArray, n, branchArray2, 0, n2 - n);
            return branchArray2;
        }
        return branchArray;
    }

    static class Dummy {
        Dummy() {
        }
    }

    private static class PositionListener
    implements PropertyChangeListener {
        private BpelDebugger myDebugger;
        private WeakReference<ThreadsTreeModel> myModel;
        private RequestProcessor.Task task;

        private PositionListener(ThreadsTreeModel threadsTreeModel, BpelDebugger bpelDebugger) {
            this.myDebugger = bpelDebugger;
            this.myModel = new WeakReference<ThreadsTreeModel>(threadsTreeModel);
            bpelDebugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private void destroy() {
            this.myDebugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        private ThreadsTreeModel getModel() {
            ThreadsTreeModel threadsTreeModel = (ThreadsTreeModel)this.myModel.get();
            if (threadsTreeModel == null) {
                this.destroy();
            }
            return threadsTreeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("currentPosition".equals(propertyChangeEvent.getPropertyName())) {
                final ThreadsTreeModel threadsTreeModel = this.getModel();
                if (threadsTreeModel == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        threadsTreeModel.fireTreeChanged();
                    }
                }, 500);
            }
        }
    }
}

