/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.watch;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.bpel.debugger.ui.watch.BpelWatch;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WatchesActionsProvider
implements NodeActionsProvider {
    private static final String NEW_WATCH_ACTION_NAME = NbBundle.getMessage(WatchesActionsProvider.class, (String)"CTL_WatchAction_AddNew");
    private static final String DELETE_ALL_ACTION_NAME = NbBundle.getMessage(WatchesActionsProvider.class, (String)"CTL_WatchAction_DeleteAll");
    private static final String DELETE_ACTION_NAME = NbBundle.getMessage(WatchesActionsProvider.class, (String)"CTL_WatchAction_Delete");
    private static final String CUSTOMIZE_ACTION_NAME = NbBundle.getMessage(WatchesActionsProvider.class, (String)"CTL_WatchAction_Customize");
    private static final Models.ActionPerformer DELETE_ACTION_PERFORMER = new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((BpelWatch)objectArray[i]).remove();
            }
        }
    };
    private static final Models.ActionPerformer CUSTOMIZE_ACTION_PERFORMER = new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            WatchesActionsProvider.customize((BpelWatch)objectArray[0]);
        }
    };
    private static final Action NEW_WATCH_ACTION = new AbstractAction(NEW_WATCH_ACTION_NAME){

        public void actionPerformed(ActionEvent actionEvent) {
            WatchesActionsProvider.newWatch();
        }
    };
    private static final Action DELETE_ALL_ACTION = new AbstractAction(DELETE_ALL_ACTION_NAME){

        public void actionPerformed(ActionEvent actionEvent) {
            DebuggerManager.getDebuggerManager().removeAllWatches();
        }
    };
    private static final Action DELETE_ACTION = Models.createAction((String)DELETE_ACTION_NAME, (Models.ActionPerformer)DELETE_ACTION_PERFORMER, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)CUSTOMIZE_ACTION_NAME, (Models.ActionPerformer)CUSTOMIZE_ACTION_PERFORMER, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[]{NEW_WATCH_ACTION, null, DELETE_ALL_ACTION};
        }
        if (object instanceof BpelWatch) {
            return new Action[]{NEW_WATCH_ACTION, null, DELETE_ACTION, DELETE_ALL_ACTION, null, CUSTOMIZE_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof BpelWatch) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    private static void customize(BpelWatch bpelWatch) {
        WatchPanel watchPanel = new WatchPanel(bpelWatch.getExpression());
        JComponent jComponent = watchPanel.getPanel();
        String string = NbBundle.getMessage(WatchesActionsProvider.class, (String)"CTL_Edit_Watch_Dialog_Title", (Object)bpelWatch.getExpression());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, string);
        dialogDescriptor.setHelpCtx(new HelpCtx("debug.customize.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        if (jComponent.getClientProperty("WatchCanceled") != null) {
            return;
        }
        bpelWatch.setExpression(watchPanel.getExpression());
    }

    private static void newWatch() {
        WatchPanel watchPanel = new WatchPanel("");
        JComponent jComponent = watchPanel.getPanel();
        String string = NbBundle.getMessage(WatchesActionsProvider.class, (String)"CTL_New_Watch_Dialog_Title");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, string);
        dialogDescriptor.setHelpCtx(new HelpCtx("debug.new.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        if (jComponent.getClientProperty("WatchCanceled") != null) {
            return;
        }
        DebuggerManager.getDebuggerManager().createWatch(watchPanel.getExpression());
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
    }

    public static class WatchPanel {
        private JPanel panel;
        private JTextField textField;
        private String expression;

        public WatchPanel(String string) {
            this.expression = string;
        }

        public JComponent getPanel() {
            if (this.panel != null) {
                return this.panel;
            }
            ResourceBundle resourceBundle = NbBundle.getBundle(WatchesActionsProvider.class);
            this.panel = new JPanel();
            this.textField = new JTextField(25);
            this.textField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
            this.textField.setBorder(new CompoundBorder(this.textField.getBorder(), new EmptyBorder(2, 0, 2, 0)));
            this.textField.setText(this.expression);
            JLabel jLabel = new JLabel(resourceBundle.getString("CTL_Watch_Name"));
            jLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
            jLabel.setLabelFor(this.textField);
            jLabel.setDisplayedMnemonic(resourceBundle.getString("CTL_Watch_Name_Mnemonic").charAt(0));
            this.panel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
            this.panel.setLayout(new BorderLayout());
            this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
            this.panel.add("West", jLabel);
            this.panel.add("Center", this.textField);
            this.textField.selectAll();
            this.textField.requestFocus();
            return this.panel;
        }

        public String getExpression() {
            return this.textField.getText().trim();
        }
    }
}

