/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JViewport;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssListValue;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.css2.BoxFactory;
import org.netbeans.modules.visualweb.css2.BoxList;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.CreateContext;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.ExternalDocumentBox;
import org.netbeans.modules.visualweb.css2.FloatingBoxInfo;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.css2.FrameBox;
import org.netbeans.modules.visualweb.css2.LineBox;
import org.netbeans.modules.visualweb.css2.LineBoxGroup;
import org.netbeans.modules.visualweb.css2.LineBreakBox;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.css2.SpaceBox;
import org.netbeans.modules.visualweb.css2.TableBox;
import org.netbeans.modules.visualweb.css2.TextBox;
import org.netbeans.modules.visualweb.css2.ViewportBox;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.openide.ErrorManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ContainerBox
extends CssBox {
    static final boolean COLLAPSE = true;
    static Rectangle sharedClipRect = new Rectangle();
    BoxList boxes;
    protected boolean grid = false;
    protected boolean clipOverflow;

    public ContainerBox(WebForm webForm, Element element, BoxType boxType, boolean bl, boolean bl2) {
        super(webForm, element, boxType, bl, bl2);
    }

    protected void initialize() {
        super.initialize();
        this.initializeGrid();
        Element element = this.getElement();
        if (element != null) {
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 43);
            if (!CssProvider.getValueService().isVisibleValue(cssValue)) {
                this.clipOverflow = true;
            }
        }
    }

    protected boolean isOpaqueBox() {
        return false;
    }

    private boolean isAboveImage() {
        for (ContainerBox containerBox = this.getParent(); containerBox != null; containerBox = containerBox.getParent()) {
            if (containerBox.bgPainter != null) {
                return true;
            }
            if (containerBox.bg == null) continue;
            return false;
        }
        return false;
    }

    protected void initializeBackground() {
        super.initializeBackground();
        ContainerBox containerBox = this.getParent();
        if (!(this.isOpaqueBox() || this.inline && !this.boxType.isAbsolutelyPositioned() || this.bg != null || containerBox == null || this.grid || !containerBox.isGrid() && containerBox.tag != HtmlTag.FORM || this.tag == HtmlTag.FORM || this.isAboveImage())) {
            ContainerBox containerBox2;
            for (containerBox2 = containerBox; containerBox2 != null && containerBox2.bg == null; containerBox2 = containerBox2.getParent()) {
            }
            if (containerBox2 != null) {
                this.bg = containerBox2.bg;
            }
        }
    }

    protected void initializeGrid() {
        if (!this.inline) {
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.getElement(), 60);
            if (CssProvider.getValueService().isGridValue(cssValue)) {
                this.setGrid(true);
            }
        }
    }

    public void setGrid(boolean bl) {
        this.grid = bl;
    }

    public boolean isGrid() {
        if (this.tag == HtmlTag.FORM) {
            return this.grid || this.getParent().isGrid();
        }
        return this.grid;
    }

    public int getBoxCount() {
        return this.boxes != null ? this.boxes.size() : 0;
    }

    public CssBox getBox(int n) {
        return this.boxes.get(n);
    }

    protected BoxList getBoxList() {
        return this.boxes;
    }

    public CssBox[] getBoxes() {
        if (this.boxes == null) {
            return new CssBox[0];
        }
        ArrayList<CssBox> arrayList = new ArrayList<CssBox>();
        int n = this.boxes.size();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.boxes.get(i);
            arrayList.add(cssBox);
        }
        return arrayList.toArray(new CssBox[arrayList.size()]);
    }

    boolean containsChild(CssBox cssBox) {
        if (cssBox == null) {
            return false;
        }
        CssBox[] cssBoxArray = this.getBoxes();
        return Arrays.asList(cssBoxArray).contains(cssBox);
    }

    protected void removeBoxes() {
        this.boxes = null;
    }

    protected void addBox(CssBox cssBox, CssBox cssBox2, CssBox cssBox3) {
        if (this.boxes == null) {
            int n = 8;
            this.boxes = new BoxList(n);
            if (this.boxType != BoxType.LINEBOX) {
                this.boxes.setKeepSorted(true);
            }
        }
        this.boxes.add(cssBox, cssBox2, cssBox3);
        cssBox.setParent(this);
        cssBox.setPositionedBy(this);
    }

    protected boolean removeBox(CssBox cssBox) {
        if (this.boxes == null) {
            ErrorManager.getDefault().log("Unexpected box removal - box list is empty already");
            return false;
        }
        return this.boxes.remove(cssBox);
    }

    protected CssBox[] getBoxesToRemove(CssBox cssBox) {
        return new CssBox[]{cssBox};
    }

    protected void setProbableChildCount(int n) {
        if (this.boxes == null) {
            this.boxes = new BoxList(n);
            if (this.boxType != BoxType.LINEBOX) {
                this.boxes.setKeepSorted(true);
            }
        }
    }

    static void printLayout(CssBox cssBox, StringBuffer stringBuffer, int n) {
        int n2;
        stringBuffer.append("\n");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("  [" + cssBox.getX() + "," + cssBox.getY() + "," + cssBox.getWidth() + "," + cssBox.getHeight() + "] ");
        stringBuffer.append("  BoxModel [");
        if (cssBox.boxType != null && cssBox.boxType.isPositioned()) {
            stringBuffer.append(cssBox.left + "," + cssBox.top + "," + cssBox.right + "," + cssBox.bottom + ",");
        }
        stringBuffer.append(cssBox.contentWidth + "," + cssBox.contentHeight + ", mrg=" + cssBox.leftMargin + "," + cssBox.effectiveTopMargin + "] ");
        stringBuffer.append(" CB  [" + cssBox.containingBlockX + "," + cssBox.containingBlockY + "," + cssBox.containingBlockWidth + "," + cssBox.containingBlockHeight + "] ");
        stringBuffer.append("\n");
        if (cssBox.border != null) {
            stringBuffer.append("  Border [" + cssBox.border.toString() + "]\n");
        }
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append(cssBox.toString());
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("  [abs=" + cssBox.getAbsoluteX() + "," + cssBox.getAbsoluteY() + ", rel=" + cssBox.getX() + "," + cssBox.getY() + ", size=" + cssBox.getWidth() + "," + cssBox.getHeight() + "]  ");
        if (cssBox.getBoxCount() > 0) {
            for (n2 = 0; n2 < cssBox.getBoxCount(); ++n2) {
                CssBox cssBox2 = cssBox.getBox(n2);
                stringBuffer.append("\n");
                for (int i = 0; i < n + 1; ++i) {
                    stringBuffer.append("   ");
                }
                stringBuffer.append("Box number " + n2 + "\n");
                ContainerBox.printLayout(cssBox2, stringBuffer, n + 1);
                stringBuffer.append("\n");
            }
        }
    }

    protected void createChildren(CreateContext createContext) {
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        this.setProbableChildCount(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3 && DesignerUtils.onlyWhitespace(node.getNodeValue())) continue;
            this.addNode(createContext, node, null, null, null);
        }
    }

    void addNode(CreateContext createContext, Node node, Element element, CssBox cssBox, CssBox cssBox2) {
        if (node.getNodeType() == 1) {
            Element element2 = (Element)node;
            String string = element2.getTagName();
            HtmlTag htmlTag = HtmlTag.getTag((String)string);
            if (htmlTag == null) {
                NodeList nodeList;
                int n;
                if (string.length() > 0 && Character.isUpperCase(string.charAt(0))) {
                    ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("The element has uppercase tag name, element=" + element2));
                }
                if ((n = (nodeList = element2.getChildNodes()).getLength()) > 0) {
                    this.setProbableChildCount(n);
                    int n2 = n;
                    for (int i = 0; i < n2; ++i) {
                        Node node2 = nodeList.item(i);
                        if (node2.getNodeType() == 3 && DesignerUtils.onlyWhitespace(node2.getNodeValue())) continue;
                        this.addNode(createContext, node2, null, cssBox, cssBox2);
                    }
                }
                return;
            }
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element2, 22);
            if (CssProvider.getValueService().isNoneValue(cssValue)) {
                return;
            }
            boolean bl = ContainerBox.isInlineTag(cssValue, element2, htmlTag);
            BoxType boxType = BoxType.getBoxType(element2);
            boolean bl2 = htmlTag.isReplacedTag();
            CssBox cssBox3 = null;
            cssBox3 = CssProvider.getValueService().isTableValue(cssValue) ? TableBox.getTableBox(this.webform, element2, boxType, bl, bl2) : BoxFactory.create(createContext, htmlTag, this.webform, element2, boxType, bl, bl2);
            if (cssBox3 == null) {
                return;
            }
            if (element != null) {
                this.putBoxReference(element, cssBox3);
            }
            this.addBoxNode(htmlTag, cssBox3, createContext, cssBox, cssBox2);
        } else if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            String string = node.getNodeValue();
            Element element3 = null;
            if (node.getParentNode() != null && node.getParentNode().getNodeType() == 1) {
                element3 = (Element)node.getParentNode();
            }
            Text text = node instanceof Text ? (Text)node : null;
            this.addText(createContext, text, element3, string);
        }
    }

    protected void addBoxNode(HtmlTag htmlTag, CssBox cssBox, CreateContext createContext, CssBox cssBox2, CssBox cssBox3) {
        if (cssBox2 != null || cssBox3 != null) {
            if (!cssBox.getBoxType().isAbsolutelyPositioned()) {
                this.addSiblingBoxNode(htmlTag, cssBox, createContext, cssBox2, cssBox3);
                return;
            }
            cssBox3 = null;
            cssBox2 = null;
        }
        boolean bl = false;
        boolean bl2 = false;
        LineBoxGroup lineBoxGroup = null;
        if (cssBox.getBoxType() == BoxType.ABSOLUTE || cssBox.getBoxType() == BoxType.FIXED) {
            bl = true;
            bl2 = true;
            lineBoxGroup = createContext.lineBox;
            createContext.lineBox = null;
            this.getBlockBox().addBox(cssBox, cssBox2, cssBox3);
            if (cssBox.getBoxType() == BoxType.FIXED) {
                createContext.addFixedBox(cssBox);
            }
        } else if (cssBox.getBoxType() == BoxType.FLOAT) {
            this.addToLineBox(createContext, cssBox, null, null);
            bl2 = true;
            lineBoxGroup = createContext.lineBox;
            createContext.lineBox = null;
        } else if (cssBox.isBlockLevel()) {
            this.finishLineBox(createContext);
            this.getBlockBox().addBox(cssBox, cssBox2, cssBox3);
            bl = true;
        } else {
            this.addToLineBox(createContext, cssBox, null, null);
        }
        if (cssBox instanceof ContainerBox) {
            ((ContainerBox)cssBox).createChildren(createContext);
        }
        if (bl) {
            this.finishLineBox(createContext);
        }
        if (bl2) {
            createContext.lineBox = lineBoxGroup;
        }
    }

    protected void addSiblingBoxNode(HtmlTag htmlTag, CssBox cssBox, CreateContext createContext, CssBox cssBox2, CssBox cssBox3) {
        boolean bl = false;
        boolean bl2 = false;
        LineBoxGroup lineBoxGroup = null;
        if (cssBox.getBoxType() == BoxType.ABSOLUTE || cssBox.getBoxType() == BoxType.FIXED) {
            bl = true;
            bl2 = true;
            lineBoxGroup = createContext.lineBox;
            createContext.lineBox = null;
            this.getBlockBox().addBox(cssBox, cssBox2, cssBox3);
            if (cssBox.getBoxType() == BoxType.FIXED) {
                createContext.addFixedBox(cssBox);
            }
        } else if (cssBox.getBoxType() == BoxType.FLOAT) {
            this.addToLineBox(createContext, cssBox, cssBox2, cssBox3);
            bl2 = true;
            lineBoxGroup = createContext.lineBox;
            createContext.lineBox = null;
        } else if (cssBox.isBlockLevel()) {
            while (cssBox2 != null && !cssBox2.getBoxType().isNormalFlow() && !cssBox2.getBoxType().isInlineTextBox()) {
                cssBox2 = cssBox2.getPrevNormalBox();
            }
            while (cssBox3 != null && !cssBox3.getBoxType().isNormalFlow() && !cssBox3.getBoxType().isInlineTextBox()) {
                cssBox3 = cssBox3.getNextNormalBox();
            }
            if (cssBox2 != null && cssBox3 != null && cssBox2.isInlineBox() && cssBox3.isInlineBox()) {
                LineBoxGroup lineBoxGroup2 = null;
                lineBoxGroup2 = cssBox2 instanceof LineBoxGroup ? (LineBoxGroup)cssBox2 : (cssBox2.getParent() instanceof LineBoxGroup ? (LineBoxGroup)cssBox2.getParent() : (LineBoxGroup)cssBox2.getParent().getParent());
                LineBoxGroup lineBoxGroup3 = lineBoxGroup2.split(cssBox2);
                createContext.prevChangedBox = lineBoxGroup2;
                createContext.nextChangedBox = lineBoxGroup3;
                this.getBlockBox().addBox(cssBox, lineBoxGroup2, null);
                this.getBlockBox().addBox(lineBoxGroup3, cssBox, null);
            } else {
                this.finishLineBox(createContext);
                if (cssBox2 != null && cssBox2.isInlineBox()) {
                    while (cssBox2 != null && !(cssBox2 instanceof LineBoxGroup)) {
                        cssBox2 = cssBox2.getParent();
                    }
                }
                if (cssBox3 != null && cssBox3.isInlineBox()) {
                    while (cssBox3 != null && !(cssBox3 instanceof LineBoxGroup)) {
                        cssBox3 = cssBox3.getParent();
                    }
                }
                this.getBlockBox().addBox(cssBox, cssBox2, cssBox3);
                bl = true;
            }
        } else {
            while (cssBox2 != null && !cssBox2.getBoxType().isNormalFlow() && !cssBox2.getBoxType().isInlineTextBox()) {
                cssBox2 = cssBox2.getPrevNormalBox();
            }
            while (cssBox3 != null && !cssBox3.getBoxType().isNormalFlow() && !cssBox3.getBoxType().isInlineTextBox()) {
                cssBox3 = cssBox3.getNextNormalBox();
            }
            if (cssBox2 != null && cssBox3 != null && cssBox2.isInlineBox() && cssBox3.isInlineBox()) {
                LineBoxGroup lineBoxGroup4 = null;
                lineBoxGroup4 = cssBox2 instanceof LineBoxGroup ? (LineBoxGroup)cssBox2 : (cssBox2.getParent() instanceof LineBoxGroup ? (LineBoxGroup)cssBox2.getParent() : (LineBoxGroup)cssBox2.getParent().getParent());
                lineBoxGroup4.addBox(cssBox, cssBox2, cssBox3);
                bl2 = true;
                lineBoxGroup = createContext.lineBox;
                createContext.lineBox = lineBoxGroup4;
            } else if (cssBox2 != null && cssBox2.isInlineBox()) {
                LineBoxGroup lineBoxGroup5 = null;
                if (cssBox2 instanceof LineBoxGroup) {
                    lineBoxGroup5 = (LineBoxGroup)cssBox2;
                    cssBox2 = null;
                } else if (cssBox2.getParent() instanceof LineBoxGroup) {
                    lineBoxGroup5 = (LineBoxGroup)cssBox2.getParent();
                } else {
                    assert (cssBox2.getParent() != null && cssBox2.getParent().getParent() instanceof LineBoxGroup);
                    lineBoxGroup5 = (LineBoxGroup)cssBox2.getParent().getParent();
                }
                lineBoxGroup5.addBox(cssBox, cssBox2, null);
                bl2 = true;
                lineBoxGroup = createContext.lineBox;
                createContext.lineBox = lineBoxGroup5;
            } else if (cssBox3 != null && cssBox3.isInlineBox()) {
                LineBoxGroup lineBoxGroup6 = null;
                if (cssBox3 instanceof LineBoxGroup) {
                    lineBoxGroup6 = (LineBoxGroup)cssBox3;
                    cssBox3 = null;
                } else if (cssBox3.getParent() instanceof LineBoxGroup) {
                    lineBoxGroup6 = (LineBoxGroup)cssBox3.getParent();
                } else {
                    assert (cssBox3.getParent() != null && cssBox3.getParent().getParent() instanceof LineBoxGroup);
                    lineBoxGroup6 = (LineBoxGroup)cssBox3.getParent().getParent();
                }
                lineBoxGroup6.addBox(cssBox, null, cssBox3);
                bl2 = true;
                lineBoxGroup = createContext.lineBox;
                createContext.lineBox = lineBoxGroup6;
            } else {
                this.addToLineBox(createContext, cssBox, cssBox2, cssBox3);
            }
        }
        if (cssBox instanceof ContainerBox) {
            ((ContainerBox)cssBox).createChildren(createContext);
        }
        if (bl) {
            this.finishLineBox(createContext);
        }
        if (bl2) {
            createContext.lineBox = lineBoxGroup;
        }
    }

    protected void addText(CreateContext createContext, Text text, Element element, String string) {
        int n = 0;
        Color color = Color.black;
        Color color2 = null;
        FontMetrics fontMetrics = createContext.metrics;
        boolean bl = true;
        boolean bl2 = false;
        if (element != null) {
            fontMetrics = CssUtilities.getDesignerFontMetricsForElement(element, string, this.webform.getDefaultFontSize());
            color = CssProvider.getValueService().getColorForElement(element, 20);
            if (color == null) {
                color = Color.black;
            }
            color2 = null;
            for (ContainerBox containerBox = this; containerBox != null && containerBox.inline && !containerBox.replaced; containerBox = containerBox.getParent()) {
                if (containerBox.bg == null) {
                    ((CssBox)containerBox).initializeBackground();
                }
                if (containerBox.bg == null) continue;
                color2 = containerBox.bg;
                break;
            }
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 51);
            CssListValue cssListValue = CssProvider.getValueService().getComputedCssListValue(cssValue);
            if (cssListValue != null) {
                int n2 = cssListValue.getLength();
                block6: for (int i = 0; i < n2; ++i) {
                    CssValue cssValue2 = cssListValue.item(i);
                    String string2 = cssValue2.getStringValue();
                    switch (string2.charAt(0)) {
                        case 'u': {
                            n |= 1;
                            continue block6;
                        }
                        case 'o': {
                            n |= 4;
                            continue block6;
                        }
                        case 'l': {
                            n |= 2;
                        }
                    }
                }
            }
            CssValue cssValue3 = CssProvider.getEngineService().getComputedValueForElement(element, 57);
            if (CssProvider.getValueService().isPreValue(cssValue3) || CssProvider.getValueService().isPreWrapValue(cssValue3)) {
                bl = false;
            }
            CssValue cssValue4 = CssProvider.getEngineService().getComputedValueForElement(this.getElement(), 56);
            bl2 = !CssProvider.getValueService().isVisibleValue(cssValue4);
        } else {
            ErrorManager.getDefault().log("Gotta set font from somewhere else!");
        }
        this.addText(string, element, text, createContext, fontMetrics, color, color2, n, bl, bl2);
    }

    protected void addGrayItalicText(CreateContext createContext, Element element, String string) {
        FontMetrics fontMetrics = null;
        if (element != null) {
            fontMetrics = CssUtilities.getDesignerFontMetricsForElement(element, string, this.webform.getDefaultFontSize());
            Font font = fontMetrics.getFont();
            font = font.deriveFont(2);
            fontMetrics = DesignerUtils.getFontMetrics(font);
        }
        if (fontMetrics == null) {
            fontMetrics = createContext.metrics;
        }
        this.addText(string, element, null, createContext, fontMetrics, Color.GRAY, null, 0, true, false);
    }

    private void addText(String string, Element element, Text text, CreateContext createContext, FontMetrics fontMetrics, Color color, Color color2, int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        Object object;
        String string2 = string;
        if (text != null && MarkupService.isJspxNode((Node)text)) {
            string = this.webform.getDomProviderService().expandHtmlEntities(string, true, element);
        }
        if (element != null) {
            object = CssProvider.getEngineService().getComputedValueForElement(element, 29);
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 53);
            if (CssProvider.getValueService().isSmallCapsValue(object) || CssProvider.getValueService().isUpperCaseValue(cssValue)) {
                string = string.toUpperCase();
            } else if (CssProvider.getValueService().isLowerCaseValue(cssValue)) {
                string = string.toLowerCase();
            } else if (CssProvider.getValueService().isCapitalizeValue(cssValue)) {
                StringBuffer stringBuffer = new StringBuffer(string.length());
                n3 = 0;
                int n4 = string.length();
                for (n2 = 0; n2 < n4; ++n2) {
                    char c = string.charAt(n2);
                    if (Character.isWhitespace(c)) {
                        n3 = 1;
                    } else if (n3 != 0) {
                        c = Character.toUpperCase(c);
                        n3 = 0;
                    }
                    stringBuffer.append(c);
                }
                string = stringBuffer.toString();
            }
        }
        object = null;
        int n5 = string.length();
        int n6 = 0;
        if (!bl) {
            n3 = n5;
            if (object == null) {
                object = string.toCharArray();
            }
            if (string.indexOf(10) != -1) {
                for (n2 = n6; n2 < n3; ++n2) {
                    if (string.charAt(n2) != '\n') continue;
                    if (n2 > n6) {
                        TextBox textBox = new TextBox(this.webform, element, text, (char[])object, string, string2, n6, n2, color, color2, n, fontMetrics, bl2);
                        this.addToLineBox(createContext, textBox, null, null);
                    }
                    this.addToLineBox(createContext, new LineBreakBox(this.webform, element, null), null, null);
                    n6 = n2 + 1;
                }
                if (n3 > n6) {
                    TextBox textBox = new TextBox(this.webform, element, text, (char[])object, string, string2, n6, n3, color, color2, n, fontMetrics, bl2);
                    this.addToLineBox(createContext, textBox, null, null);
                }
                this.addToLineBox(createContext, new LineBreakBox(this.webform, element, null), null, null);
            } else {
                TextBox textBox = new TextBox(this.webform, element, text, (char[])object, string, string2, n6, n3, color, color2, n, fontMetrics, bl2);
                this.addToLineBox(createContext, textBox, null, null);
            }
            return;
        }
        while (n6 < n5) {
            if (Character.isWhitespace(string.charAt(n6))) {
                n2 = n6++;
                while (n6 < n5 && Character.isWhitespace(string.charAt(n6))) {
                    ++n6;
                }
                SpaceBox spaceBox = new SpaceBox(this.webform, element, text, string, string2, n2, n6, color, color2, n, fontMetrics, bl2);
                this.addToLineBox(createContext, spaceBox, null, null);
            }
            for (n3 = n6; n3 < n5 && !Character.isWhitespace(string.charAt(n3)); ++n3) {
            }
            if (n3 <= n6) break;
            if (object == null) {
                object = string.toCharArray();
            }
            TextBox textBox = new TextBox(this.webform, element, text, (char[])object, string, string2, n6, n3, color, color2, n, fontMetrics, bl2);
            this.addToLineBox(createContext, textBox, null, null);
            n6 = n3;
        }
    }

    public void relayout(FormatContext formatContext) {
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            if (cssBox.isPlaceHolder()) continue;
            if (cssBox.getBoxType() == BoxType.LINEBOX || cssBox.getBoxType().isNormalFlow() && formatContext.floats != null) {
                this.positionBox(cssBox, formatContext);
            }
            this.layoutChild(cssBox, formatContext, true);
            if (cssBox.getBoxType() == BoxType.LINEBOX || !cssBox.isBlockLevel() && !cssBox.getBoxType().isAbsolutelyPositioned() && !cssBox.getBoxType().isNormalFlow()) continue;
            this.positionBox(cssBox, formatContext);
        }
    }

    protected void layoutChild(CssBox cssBox, FormatContext formatContext, boolean bl) {
        this.setContainingBlock(cssBox, formatContext);
        cssBox.initialize();
        cssBox.computeHorizontalLengths(formatContext);
        cssBox.width = cssBox.contentWidth != 0x7FFFFFFE ? cssBox.leftBorderWidth + cssBox.leftPadding + cssBox.contentWidth + cssBox.rightPadding + cssBox.rightBorderWidth : 0x7FFFFFFD;
        boolean bl2 = cssBox.getBoxType().isAbsolutelyPositioned();
        List<FloatingBoxInfo> list = null;
        boolean bl3 = false;
        if (bl2) {
            list = formatContext.floats;
            bl3 = formatContext.floating;
            formatContext.floats = null;
            formatContext.floating = false;
        }
        if (bl) {
            cssBox.relayout(formatContext);
        }
        if (bl2) {
            formatContext.floats = list;
            formatContext.floating = bl3;
        }
        cssBox.computeVerticalLengths(formatContext);
        cssBox.height = cssBox.topBorderWidth + cssBox.topPadding + cssBox.contentHeight + cssBox.bottomPadding + cssBox.bottomBorderWidth;
        if (bl && cssBox instanceof ContainerBox) {
            ((ContainerBox)cssBox).finishAllRelatives(formatContext);
        }
    }

    void finishAllRelatives(FormatContext formatContext) {
        for (int i = 0; i < this.getBoxCount(); ++i) {
            CssBox cssBox = this.getBox(i);
            if (!(cssBox instanceof LineBoxGroup)) continue;
            ((LineBoxGroup)cssBox).finishRelatives(formatContext);
        }
    }

    protected void initializeHorizontalWidths(FormatContext formatContext) {
        super.initializeHorizontalWidths(formatContext);
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            if (cssBox.getBoxType().isAbsolutelyPositioned()) continue;
            cssBox.initializeHorizontalWidths(formatContext);
        }
    }

    void setContainingBlock(CssBox cssBox, FormatContext formatContext) {
        BoxType boxType = cssBox.getBoxType();
        if (boxType == BoxType.STATIC || boxType == BoxType.RELATIVE || boxType == BoxType.FLOAT) {
            ContainerBox containerBox;
            for (containerBox = cssBox.getParent(); !(containerBox == null || containerBox instanceof FrameBox || containerBox.isBlockLevel() || (boxType == BoxType.FLOAT || boxType == BoxType.RELATIVE) && containerBox.getBoxType().isAbsolutelyPositioned()); containerBox = containerBox.getParent()) {
            }
            cssBox.containingBlockWidth = containerBox.contentWidth != 0x7FFFFFFE ? containerBox.contentWidth : containerBox.containingBlockWidth - containerBox.leftMargin - containerBox.leftBorderWidth - containerBox.leftPadding - containerBox.rightPadding - containerBox.rightBorderWidth - containerBox.rightMargin;
            cssBox.containingBlockHeight = containerBox.contentHeight != 0x7FFFFFFE ? containerBox.contentHeight : containerBox.containingBlockHeight - containerBox.topMargin - containerBox.topBorderWidth - containerBox.topPadding - containerBox.bottomPadding - containerBox.bottomBorderWidth - containerBox.bottomMargin;
            cssBox.containingBlockX = containerBox.containingBlockX + containerBox.leftMargin + containerBox.leftBorderWidth + containerBox.leftPadding;
            cssBox.containingBlockY = containerBox.containingBlockY + containerBox.topMargin + containerBox.topBorderWidth + containerBox.topPadding;
        } else if (boxType == BoxType.LINEBOX) {
            cssBox.containingBlockX = this.leftMargin + this.leftBorderWidth + this.leftPadding;
            cssBox.containingBlockY = this.topMargin + this.topBorderWidth + this.topPadding;
            cssBox.containingBlockWidth = this.contentWidth;
            cssBox.containingBlockHeight = this.contentHeight;
        } else if (boxType == BoxType.ABSOLUTE) {
            ContainerBox containerBox;
            for (containerBox = cssBox.getParent(); containerBox != null && !containerBox.getBoxType().isPositioned() && containerBox.tag != HtmlTag.FRAME; containerBox = containerBox.getParent()) {
            }
            if (containerBox == null) {
                cssBox.containingBlockX = 0;
                cssBox.containingBlockY = 0;
                cssBox.containingBlockWidth = formatContext.initialWidth;
                cssBox.containingBlockHeight = formatContext.initialHeight;
                cssBox.setPositionedBy(formatContext.initialCB);
            } else if (containerBox.isBlockLevel()) {
                cssBox.containingBlockWidth = containerBox.contentWidth + this.leftPadding + this.rightPadding;
                cssBox.containingBlockHeight = containerBox.contentHeight + this.topPadding + this.bottomPadding;
                cssBox.containingBlockX = this.leftBorderWidth;
                cssBox.containingBlockY = this.topBorderWidth;
            } else {
                LineBoxGroup lineBoxGroup = null;
                if (cssBox.getParent() instanceof LineBoxGroup) {
                    lineBoxGroup = (LineBoxGroup)cssBox.getParent();
                } else if (cssBox.getParent() != null && cssBox.getParent().getParent() instanceof LineBox) {
                    lineBoxGroup = (LineBoxGroup)cssBox.getParent().getParent();
                }
                if (lineBoxGroup != null) {
                    cssBox.containingBlockX = lineBoxGroup.containingBlockX;
                    cssBox.containingBlockY = lineBoxGroup.containingBlockY;
                    cssBox.containingBlockWidth = lineBoxGroup.containingBlockWidth;
                    cssBox.containingBlockHeight = lineBoxGroup.containingBlockHeight;
                }
            }
        } else if (boxType == BoxType.FIXED) {
            cssBox.containingBlockX = 0;
            cssBox.containingBlockY = 0;
            cssBox.containingBlockWidth = formatContext.initialWidth;
            cssBox.containingBlockHeight = formatContext.initialHeight;
            cssBox.setPositionedBy(formatContext.initialCB);
        } else assert (false) : boxType;
    }

    protected void positionBox(CssBox cssBox, FormatContext formatContext) {
        BoxType boxType = cssBox.getBoxType();
        if (boxType == BoxType.STATIC || boxType == BoxType.LINEBOX) {
            this.positionBlockBox(cssBox, formatContext);
        } else if (boxType == BoxType.ABSOLUTE) {
            this.positionAbsoluteBox(cssBox);
        } else if (boxType == BoxType.FLOAT) {
            this.positionFloatBox(cssBox);
        } else if (boxType == BoxType.RELATIVE) {
            this.positionRelativeBox(cssBox, formatContext);
        } else if (boxType == BoxType.FIXED) {
            this.positionFixedBox(cssBox, formatContext);
        } else assert (false) : boxType;
    }

    private int calculateMargin(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            return Math.max(n, n2);
        }
        if (n < 0 && n2 < 0) {
            return Math.min(n, n2);
        }
        if (n >= 0 && n2 < 0) {
            return n + n2;
        }
        assert (n < 0 && n2 >= 0);
        return n2 + n;
    }

    private void positionBlockBox(CssBox cssBox, FormatContext formatContext) {
        int n;
        int n2;
        CssBox cssBox2;
        int n3;
        ContainerBox containerBox = cssBox.getParent();
        assert (containerBox != null);
        cssBox.setX(containerBox.leftPadding + containerBox.leftBorderWidth);
        CssBox cssBox3 = cssBox.getPrevNormalBlockBox();
        if (cssBox3 != null) {
            if (cssBox3 instanceof LineBoxGroup) {
                cssBox3.computeVerticalLengths(formatContext);
            }
            n3 = cssBox3.getY() + cssBox3.getHeight() + this.calculateMargin(cssBox3.getCollapsedBottomMargin(), cssBox.getCollapsedTopMargin());
            cssBox.setY(n3);
            cssBox.effectiveTopMargin = 0;
        } else if (containerBox.topBorderWidth == 0 && containerBox.topPadding == 0) {
            n3 = containerBox.getCollapsedTopMargin();
            cssBox.effectiveTopMargin = 0;
            cssBox.setY(containerBox.topBorderWidth);
        } else {
            cssBox.setY(containerBox.topPadding + containerBox.topBorderWidth + cssBox.effectiveTopMargin);
            containerBox.effectiveTopMargin = containerBox.topMargin;
            cssBox.effectiveTopMargin = 0;
        }
        if (cssBox.isClearBox() && (cssBox2 = formatContext.getPrevFloatingForClear(cssBox)) != null && (n2 = formatContext.adjustY(cssBox2.getHeight() + cssBox2.bottomMargin + cssBox2.topMargin, cssBox2, this) + cssBox.topMargin) > cssBox.getY()) {
            cssBox.setY(n2);
        }
        if (ContainerBox.isIssue120747Box(cssBox) && (n = formatContext.getLeftEdge(cssBox, containerBox, cssBox.getY(), cssBox.getHeight())) != 0x7FFFFFFD && n != 0x7FFFFFFE) {
            cssBox.setX(n);
        }
    }

    private static boolean isIssue120747Box(CssBox cssBox) {
        if (cssBox == null) {
            return false;
        }
        if (!ContainerBox.isContainerBox(cssBox)) {
            return false;
        }
        ContainerBox containerBox = cssBox.getParent();
        if (!ContainerBox.isContainerBox(containerBox)) {
            return false;
        }
        if (cssBox.isInlineBox()) {
            return false;
        }
        int n = cssBox.getBoxCount();
        if (n != 1) {
            return false;
        }
        CssBox cssBox2 = cssBox.getBox(0);
        if (cssBox2 == null) {
            return false;
        }
        Element element = cssBox2.getElement();
        if (element == null || element != cssBox.getElement()) {
            return false;
        }
        if (element.getParentNode() != containerBox.getElement()) {
            return false;
        }
        return cssBox2 instanceof LineBoxGroup;
    }

    private static boolean isContainerBox(CssBox cssBox) {
        return cssBox != null && cssBox.getClass() == ContainerBox.class;
    }

    private void positionRelativeBox(CssBox cssBox, FormatContext formatContext) {
        this.positionBlockBox(cssBox, formatContext);
        cssBox.setLocation(cssBox.getX() + cssBox.left, cssBox.getY() + cssBox.top);
    }

    private void positionAbsoluteBox(CssBox cssBox) {
        cssBox.setLocation(cssBox.left + this.leftBorderWidth, cssBox.top + this.topBorderWidth);
    }

    private void positionFixedBox(CssBox cssBox, FormatContext formatContext) {
        ViewportBox viewportBox = formatContext.initialCB;
        JViewport jViewport = viewportBox.getViewport();
        if (jViewport != null) {
            Point point = jViewport.getViewPosition();
            cssBox.setLocation(cssBox.left + point.x, cssBox.top + point.y);
        } else {
            cssBox.setLocation(cssBox.left, cssBox.top);
        }
    }

    private void positionFloatBox(CssBox cssBox) {
        boolean bl;
        ContainerBox containerBox = cssBox.getParent();
        assert (containerBox != null);
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(cssBox.getElement(), 23);
        if (CssProvider.getValueService().isLeftValue(cssValue)) {
            bl = true;
        } else if (CssProvider.getValueService().isRightValue(cssValue)) {
            bl = false;
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unexpected value, cssFloating=" + cssValue));
            return;
        }
        if (bl) {
            cssBox.setX(containerBox.leftPadding + containerBox.leftBorderWidth);
        } else {
            cssBox.setX(containerBox.width - containerBox.rightPadding - containerBox.rightBorderWidth);
        }
        CssBox cssBox2 = cssBox.getPrevNormalBox();
        if (cssBox2 != null) {
            int n;
            int n2 = cssBox2.getCollapsedBottomMargin();
            int n3 = cssBox.getCollapsedTopMargin();
            if (n2 >= 0 && n3 >= 0) {
                n = Math.max(n2, n3);
            } else if (n2 < 0 && n3 < 0) {
                n = Math.min(n2, n3);
            } else if (n2 >= 0 && n3 < 0) {
                n = n2 + n3;
            } else {
                assert (n2 < 0 && n3 >= 0);
                n = n3 + n2;
            }
            cssBox.setY(cssBox2.getY() + cssBox2.getHeight() + n);
            cssBox.effectiveTopMargin = 0;
        } else if (containerBox.topBorderWidth == 0 && containerBox.topPadding == 0) {
            int n;
            containerBox.effectiveTopMargin = n = containerBox.getCollapsedTopMargin();
            cssBox.effectiveTopMargin = 0;
            cssBox.setY(containerBox.topBorderWidth);
        } else {
            cssBox.setY(containerBox.topPadding + containerBox.topBorderWidth + cssBox.effectiveTopMargin);
            containerBox.effectiveTopMargin = containerBox.topMargin;
            cssBox.effectiveTopMargin = 0;
        }
    }

    private void addToLineBox(CreateContext createContext, CssBox cssBox, CssBox cssBox2, CssBox cssBox3) {
        if (createContext.lineBox == null) {
            FontMetrics fontMetrics = createContext.metrics;
            if (cssBox.getBoxType() == BoxType.TEXT) {
                fontMetrics = ((TextBox)cssBox).getMetrics();
            } else if (cssBox.getBoxType() == BoxType.SPACE) {
                fontMetrics = ((SpaceBox)cssBox).getMetrics();
            }
            createContext.lineBox = new LineBoxGroup(this.webform, this.getElement(), fontMetrics);
            this.getBlockBox().addBox(createContext.lineBox, cssBox2, cssBox3);
        }
        createContext.lineBox.addBox(cssBox, null, null);
    }

    void finishLineBox(CreateContext createContext) {
        if (createContext.lineBox == null) {
            return;
        }
        if (createContext.lineBox.isEmpty()) {
            return;
        }
        createContext.lineBox = null;
    }

    public int getPrefMinWidth() {
        int n;
        if (this.inline) {
            CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(this.getElement(), 57);
            if (CssProvider.getValueService().isPreValue(cssValue) || CssProvider.getValueService().isNoWrapValue(cssValue)) {
                return this.getPrefWidth();
            }
        }
        int n2 = 0;
        int n3 = this.getBoxCount();
        for (n = 0; n < n3; ++n) {
            int n4;
            CssBox cssBox = this.getBox(n);
            if (cssBox.getBoxType().isAbsolutelyPositioned() || (n4 = cssBox.getPrefMinWidth()) <= n2) continue;
            n2 = n4;
        }
        if (this.leftMargin != 0x7FFFFFFE) {
            n2 += this.leftMargin;
        }
        if (this.rightMargin != 0x7FFFFFFE) {
            n2 += this.rightMargin;
        }
        if ((n = super.getPrefMinWidth()) > (n2 += this.leftBorderWidth + this.leftPadding + this.rightBorderWidth + this.rightPadding)) {
            n2 = n;
        }
        return n2;
    }

    public int getPrefWidth() {
        int n;
        int n2 = 0;
        int n3 = this.getBoxCount();
        if (this.inline && !this.boxType.isAbsolutelyPositioned()) {
            ContainerBox containerBox;
            for (containerBox = this.getParent(); containerBox != null && !(containerBox instanceof LineBoxGroup); containerBox = containerBox.getParent()) {
            }
            if (containerBox != null) {
                n2 = ((LineBoxGroup)containerBox).getPrefWidth(this.boxes);
            } else {
                for (int i = 0; i < n3; ++i) {
                    CssBox cssBox = this.getBox(i);
                    if (cssBox.getBoxType().isAbsolutelyPositioned()) continue;
                    n2 += cssBox.getPrefWidth();
                }
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                int n4;
                CssBox cssBox = this.getBox(i);
                if (cssBox.getBoxType().isAbsolutelyPositioned() || (n4 = cssBox.getPrefWidth()) <= n2) continue;
                n2 = n4;
            }
        }
        if (this.leftMargin != 0x7FFFFFFE) {
            n2 += this.leftMargin;
        }
        if (this.rightMargin != 0x7FFFFFFE) {
            n2 += this.rightMargin;
        }
        if (!this.isBorderSizeIncluded()) {
            n2 += this.leftBorderWidth + this.leftPadding + this.rightBorderWidth + this.rightPadding;
        }
        if ((n = super.getPrefWidth()) > n2) {
            n2 = n;
        }
        return n2;
    }

    protected boolean hasNormalBlockLevelChildren() {
        int n = this.getBoxCount();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox = this.getBox(i);
            if (!cssBox.getBoxType().isNormalFlow() || cssBox.isInlineBox()) continue;
            return true;
        }
        return false;
    }

    protected CssBox notifyChildResize(CssBox cssBox, FormatContext formatContext) {
        ContainerBox containerBox;
        int n;
        if (cssBox.getParentIndex() != -1) {
            this.positionBox(cssBox, formatContext);
        }
        if (cssBox.getBoxType().isAbsolutelyPositioned()) {
            return cssBox;
        }
        if (cssBox.getBoxType().isNormalFlow()) {
            n = this.getBoxCount();
            for (int i = cssBox.getParentIndex() + 1; i < n; ++i) {
                CssBox cssBox2 = this.getBox(i);
                if (!cssBox2.getBoxType().isNormalFlow()) continue;
                this.positionBox(cssBox2, formatContext);
            }
        }
        if ((containerBox = this.getParent()) == null) {
            return this;
        }
        n = this.contentWidth;
        int n2 = this.contentHeight;
        containerBox.layoutChild(this, formatContext, false);
        if (this.contentWidth == n && this.contentHeight == n2) {
            return cssBox;
        }
        return containerBox.notifyChildResize(this, formatContext);
    }

    protected void paintBox(Graphics graphics, int n, int n2, int n3, int n4) {
        super.paintBox(graphics, n, n2, n3, n4);
        if (this.grid && this.webform.isGridShow()) {
            if (this.hidden && !(this instanceof PageBox)) {
                return;
            }
            this.paintGrid(graphics, n, n2, n3, n4);
        }
    }

    protected void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = n3;
        int n9 = n4;
        Color color = graphics.getColor();
        Color color2 = this.webform.getColors().gridColor;
        assert (color2 != null);
        graphics.setColor(color2);
        int n10 = this.webform.getGridWidth();
        int n11 = this.webform.getGridHeight();
        int n12 = this.webform.getGridTraceWidth();
        int n13 = this.webform.getGridTraceHeight();
        for (n7 = n6 = 0; n7 < n8; n7 += n10) {
            for (n5 = n13; n5 < n9; n5 += n13) {
                graphics.fillRect(n + n7, n2 + n5, 1, 1);
            }
        }
        n7 = 0;
        for (n5 = n12; n5 < n8; n5 += n12) {
            for (int i = n7; i < n9; i += n11) {
                graphics.fillRect(n + n5, n2 + i, 1, 1);
            }
        }
        graphics.setColor(color);
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.clipOverflow) {
            graphics.getClipBounds(sharedClipRect);
            int n3 = ContainerBox.sharedClipRect.x;
            int n4 = ContainerBox.sharedClipRect.y;
            int n5 = ContainerBox.sharedClipRect.width;
            int n6 = ContainerBox.sharedClipRect.height;
            graphics.clipRect(n + this.leftMargin + this.getX(), n2 + this.effectiveTopMargin + this.getY(), this.width, this.height);
            super.paint(graphics, n, n2);
            graphics.setClip(n3, n4, n5, n6);
        } else {
            super.paint(graphics, n, n2);
        }
    }

    public void list(PrintStream printStream, int n) {
        super.list(printStream, n);
        CssBox[] cssBoxArray = this.getBoxes();
        for (int i = 0; i < cssBoxArray.length; ++i) {
            CssBox cssBox = cssBoxArray[i];
            if (cssBox == null) continue;
            cssBox.list(printStream, n + 1);
        }
    }

    public void list(PrintWriter printWriter, int n) {
        super.list(printWriter, n);
        CssBox[] cssBoxArray = this.getBoxes();
        for (int i = 0; i < cssBoxArray.length; ++i) {
            CssBox cssBox = cssBoxArray[i];
            if (cssBox == null) continue;
            cssBox.list(printWriter, n + 1);
        }
    }

    public WebForm[] findExternalForms() {
        CssBox[] cssBoxArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (CssBox cssBox : cssBoxArray = this.getBoxes()) {
            WebForm[] webFormArray;
            ContainerBox containerBox;
            if (cssBox instanceof ExternalDocumentBox) {
                containerBox = (ExternalDocumentBox)cssBox;
                webFormArray = ((ExternalDocumentBox)containerBox).getExternalForm();
                if (webFormArray == null) continue;
                arrayList.add(webFormArray);
                continue;
            }
            if (!(cssBox instanceof ContainerBox)) continue;
            containerBox = (ContainerBox)cssBox;
            webFormArray = containerBox.findExternalForms();
            arrayList.addAll(Arrays.asList(webFormArray));
        }
        return arrayList.toArray(new WebForm[arrayList.size()]);
    }

    private static boolean isInlineTag(CssValue cssValue, Element element, HtmlTag htmlTag) {
        return CssProvider.getValueService().isInlineTag(cssValue, element, htmlTag);
    }

    private ContainerBox getBlockBox() {
        ContainerBox containerBox;
        if (!this.inline || this.boxType.isAbsolutelyPositioned()) {
            return this;
        }
        ContainerBox containerBox2 = this;
        while ((containerBox2.inline && !containerBox2.boxType.isAbsolutelyPositioned() && !containerBox2.replaced || !(containerBox2 instanceof ContainerBox)) && (containerBox = containerBox2.getParent()) != null) {
            containerBox2 = containerBox;
        }
        return containerBox2;
    }
}

