/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.UIManager;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CssBorder;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.w3c.dom.Element;

public class CustomButtonBox
extends CssBox {
    private String string;
    private Color fg;
    private char[] stringChars;
    private FontMetrics fm;
    private int textWidth;
    private int prefWidth;
    private int prefHeight;

    public CustomButtonBox(WebForm webForm, Element element, BoxType boxType, String string, CssBorder cssBorder) {
        this(webForm, element, boxType, string, cssBorder, true);
    }

    public CustomButtonBox(WebForm webForm, Element element, BoxType boxType, String string, CssBorder cssBorder, boolean bl) {
        super(webForm, element, boxType, bl, true);
        this.string = string;
        this.stringChars = string.toCharArray();
        this.border = cssBorder;
        Font font = CssProvider.getEngineService().isInheritedStyleValueForElement(element, 25) ? UIManager.getFont("Button.font") : CssUtilities.getDesignerFontForElement(element, string, webForm.getDefaultFontSize());
        this.fm = DesignerUtils.getFontMetrics(font);
        this.prefWidth = this.textWidth = DesignerUtils.getNonTabbedTextWidth(this.stringChars, 0, this.stringChars.length, this.fm);
        this.prefHeight = this.fm.getHeight();
        this.width = this.prefWidth;
        this.height = this.prefHeight;
        this.contentWidth = this.width;
        this.contentHeight = this.height;
        if (CssProvider.getEngineService().isInheritedStyleValueForElement(element, 20)) {
            this.fg = Color.black;
        } else {
            this.fg = CssProvider.getValueService().getColorForElement(element, 20);
            if (this.fg == null && this.fg == null) {
                this.fg = Color.black;
            }
        }
    }

    protected void initializeBorder() {
        if (this.border == null) {
            super.initializeBorder();
        }
        if (this.border == null) {
            this.border = CssBorder.getDesignerBorder();
        }
        this.leftBorderWidth = this.border.getLeftBorderWidth();
        this.topBorderWidth = this.border.getTopBorderWidth();
        this.bottomBorderWidth = this.border.getBottomBorderWidth();
        this.rightBorderWidth = this.border.getRightBorderWidth();
    }

    public int getIntrinsicWidth() {
        return this.prefWidth;
    }

    public int getIntrinsicHeight() {
        return this.prefHeight;
    }

    protected void updateAutoContentSize() {
        if (this.contentWidth == 0x7FFFFFFE) {
            this.contentWidth = this.getIntrinsicWidth();
        }
        if (this.contentHeight == 0x7FFFFFFE) {
            this.contentHeight = this.getIntrinsicHeight();
        }
    }

    public int getBaseline() {
        return this.height;
    }

    protected String paramString() {
        return super.paramString() + ", " + this.string;
    }

    protected void paintBackground(Graphics graphics, int n, int n2) {
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.hidden) {
            return;
        }
        n += this.getX();
        n2 += this.getY();
        super.paintBackground(graphics, n += this.leftMargin, n2 += this.effectiveTopMargin);
        this.paintDecoration(graphics, n + this.getWidth(), n2);
        int n3 = (this.width - this.textWidth) / 2;
        int n4 = (this.height - this.fm.getHeight()) / 2;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        n3 += n;
        graphics.setColor(this.fg);
        graphics.setFont(this.fm.getFont());
        int n5 = (n4 += n2) + this.fm.getHeight() - this.fm.getDescent();
        Rectangle rectangle = ContainerBox.sharedClipRect;
        graphics.getClipBounds(rectangle);
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        graphics.clipRect(n, n2, this.width, this.height);
        graphics.drawChars(this.stringChars, 0, this.stringChars.length, n3, n5);
        graphics.setClip(n6, n7, n8, n9);
    }

    public boolean isBorderSizeIncluded() {
        return true;
    }

    public Insets getCssSizeInsets() {
        return new Insets(0, 0, 0, 0);
    }
}

