/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.ContainerBox;
import org.netbeans.modules.visualweb.css2.CreateContext;
import org.netbeans.modules.visualweb.css2.CssBorder;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.CustomButtonBox;
import org.netbeans.modules.visualweb.css2.ImageBox;
import org.netbeans.modules.visualweb.designer.CssUtilities;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.ImageCache;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlAttribute;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormComponentBox
extends ContainerBox {
    private static final boolean MAC_STYLE_BUTTONS = System.getProperty("rave.macButtons") != null;
    private static boolean sCreateChildren;
    private JComponent createdC;
    private boolean nonrectangular;
    private boolean createChildren;
    private Image image = null;
    private AffineTransform transform = new AffineTransform();
    private boolean attempted = false;
    private int imageWidth = -1;
    private int imageHeight = -1;
    private int baseline;
    private static final int DEFAULT_INPUT_COMPONENT_SIZE = 20;

    private FormComponentBox(WebForm webForm, Element element, JComponent jComponent, BoxType boxType, boolean bl, boolean bl2, boolean bl3) {
        super(webForm, element, boxType, bl, bl2);
        this.createdC = jComponent;
        this.nonrectangular = !jComponent.isOpaque();
        this.createChildren = bl3;
    }

    public static CssBox getBox(WebForm webForm, Element element, HtmlTag htmlTag, BoxType boxType, boolean bl, boolean bl2) {
        Object object;
        if (htmlTag == HtmlTag.INPUT || htmlTag == HtmlTag.BUTTON) {
            object = element.getAttribute("type");
            if ("image".equals(object)) {
                DesignerPane designerPane = webForm.getPane();
                return ImageBox.getImageBox(webForm, element, designerPane, boxType, bl);
            }
            if (("submit".equals(object) || "button".equals(object) || "reset".equals(object)) && (!MAC_STYLE_BUTTONS || Utilities.getOperatingSystem() != 4096)) {
                ImageIcon imageIcon;
                Object object2;
                URL uRL = CssProvider.getEngineService().getBackgroundImageUrlForElement(element, webForm.getBaseUrl());
                if (uRL != null) {
                    object2 = webForm.getImageCache();
                    imageIcon = ((ImageCache)object2).get(uRL);
                    if (imageIcon == null) {
                        imageIcon = new ImageIcon(uRL);
                        ((ImageCache)object2).put(uRL, imageIcon);
                    }
                } else {
                    imageIcon = null;
                }
                if (imageIcon != null) {
                    object2 = CssBorder.getBorder(element, 2, 8, 143);
                    String string = FormComponentBox.getButtonLabel(element, (String)object);
                    return new CustomButtonBox(webForm, element, boxType, string, (CssBorder)object2, bl);
                }
            }
        }
        if ((object = FormComponentBox.createComponent(htmlTag, webForm, element)) == null) {
            return null;
        }
        return new FormComponentBox(webForm, element, (JComponent)object, boxType, bl, bl2, sCreateChildren);
    }

    @Override
    protected void initialize() {
        Serializable serializable;
        super.initialize();
        if (this.createdC != null) {
            Serializable serializable2;
            serializable = this.createdC;
            Element element = this.getElement();
            int n = CssUtilities.getCssLength(element, 58);
            if (n != 0x7FFFFFFE && serializable instanceof JTextField) {
                ((JTextField)serializable).setColumns(0);
            }
            int n2 = CssUtilities.getCssLength(element, 31);
            if (n != 0x7FFFFFFE || n2 != 0x7FFFFFFE) {
                if (n == 0x7FFFFFFE) {
                    n = (int)((JComponent)serializable).getPreferredSize().getWidth();
                } else if (n2 == 0x7FFFFFFE) {
                    n2 = (int)((JComponent)serializable).getPreferredSize().getHeight();
                }
                ((JComponent)serializable).setPreferredSize(new Dimension(n, n2));
            }
            if (serializable instanceof JScrollPane) {
                serializable = (JComponent)((JScrollPane)serializable).getViewport().getView();
            }
            Element element2 = this.getElement();
            if (!CssProvider.getEngineService().isInheritedStyleValueForElement(element2, 20) && (serializable2 = CssProvider.getValueService().getColorForElement(element2, 20)) != null) {
                ((JComponent)serializable).setForeground((Color)serializable2);
            }
            if (this.bg != null) {
                ((JComponent)serializable).setBackground(this.bg);
            }
            if (!CssProvider.getEngineService().isInheritedStyleValueForElement(element2, 25)) {
                serializable2 = CssUtilities.getDesignerFontForElement(element, FormComponentBox.getTextFromComponent((Component)serializable), this.webform.getDefaultFontSize());
                FormComponentBox.setFontForComponent((JComponent)serializable, (Font)serializable2);
            }
        }
        if (this.createdC != null) {
            this.getImage();
            this.contentWidth = this.width = this.getWidth();
            this.contentHeight = this.height = this.getHeight();
            this.baseline = this.height;
            serializable = this.createdC.getFont();
        }
    }

    private static void setFontForComponent(JComponent jComponent, Font font) {
        if (jComponent instanceof JScrollPane) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)jComponent;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                component.setFont(font);
            }
        } else {
            jComponent.setFont(font);
        }
    }

    private static String getTextFromComponent(Component component) {
        if (component instanceof AbstractButton) {
            return ((AbstractButton)component).getText();
        }
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText();
        }
        if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            ComboBoxModel comboBoxModel = jComboBox.getModel();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                Object object = comboBoxModel.getElementAt(i);
                if (object == null) continue;
                arrayList.add(object.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : arrayList) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
        if (component instanceof JList) {
            JList jList = (JList)component;
            ListModel listModel = jList.getModel();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object object = listModel.getElementAt(i);
                if (object == null) continue;
                arrayList.add(object.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : arrayList) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
        if (component instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)component;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null) {
                return null;
            }
            return FormComponentBox.getTextFromComponent(jViewport.getView());
        }
        return null;
    }

    @Override
    public boolean isBorderSizeIncluded() {
        return true;
    }

    @Override
    public Insets getCssSizeInsets() {
        return new Insets(0, 0, 0, 0);
    }

    private static JComponent createComponent(HtmlTag htmlTag, WebForm webForm, Element element) {
        Element element2 = element;
        JComponent jComponent = null;
        if (htmlTag == HtmlTag.INPUT || htmlTag == HtmlTag.BUTTON) {
            jComponent = FormComponentBox.createInputComponent(htmlTag, element2);
        } else if (htmlTag == HtmlTag.SELECT) {
            sCreateChildren = false;
            int n = HtmlAttribute.getIntegerAttributeValue((Element)element2, (String)"size", (int)1);
            boolean bl = element2.hasAttribute("multiple");
            if (n > 1 || bl) {
                JList<String> jList;
                Vector<String> vector = new Vector<String>();
                int[] nArray = FormComponentBox.populateOptions(webForm, element, vector);
                if (vector.size() == 0) {
                    if (n == 1) {
                        vector.addElement("        ");
                    } else {
                        vector.addElement("    ");
                    }
                    jList = new JList<String>(new DefaultComboBoxModel<String>(vector));
                    jList.setVisibleRowCount(n > 0 ? n : 2);
                } else {
                    jList = new JList<String>(new DefaultComboBoxModel<String>(vector));
                    jList.setVisibleRowCount(n);
                }
                if (nArray != null && nArray.length > 0) {
                    jList.setSelectedIndices(nArray);
                }
                JScrollPane jScrollPane = new JScrollPane(jList);
                if (jList.getVisibleRowCount() > 1) {
                    jScrollPane.setVerticalScrollBarPolicy(22);
                }
                jComponent = jScrollPane;
            } else {
                JComboBox<String> jComboBox;
                Vector<String> vector = new Vector<String>();
                int[] nArray = FormComponentBox.populateOptions(webForm, element, vector);
                if (vector.size() == 0) {
                    vector.addElement("    ");
                    jComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(vector));
                    jComboBox.setEditable(false);
                } else {
                    jComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(vector));
                    jComboBox.setEditable(false);
                }
                jComponent = jComboBox;
                if (nArray != null && nArray.length > 0) {
                    jComboBox.setSelectedIndex(nArray[0]);
                }
            }
        } else if (htmlTag == HtmlTag.TEXTAREA) {
            sCreateChildren = false;
            PlainDocument plainDocument = new PlainDocument();
            StringBuffer stringBuffer = new StringBuffer();
            FormComponentBox.populateText(element, stringBuffer);
            if (stringBuffer.length() == 0) {
                stringBuffer.append("          ");
            }
            try {
                plainDocument.insertString(0, stringBuffer.toString(), null);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            }
            JTextAreaColumnWidth jTextAreaColumnWidth = new JTextAreaColumnWidth(plainDocument);
            int n = HtmlAttribute.getIntegerAttributeValue((Element)element2, (String)"rows", (int)3);
            jTextAreaColumnWidth.setRows(n);
            int n2 = HtmlAttribute.getIntegerAttributeValue((Element)element2, (String)"cols", (int)22);
            jTextAreaColumnWidth.setColumns(n2);
            int n3 = Utilities.isWindows() ? 22 : 21;
            JScrollPane jScrollPane = new JScrollPane(jTextAreaColumnWidth, n3, 31);
            jComponent = jScrollPane;
        }
        if (jComponent != null) {
            jComponent.setAlignmentY(1.0f);
        }
        return jComponent;
    }

    public static int[] populateOptions(WebForm webForm, Element element, Vector<String> vector) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(HtmlTag.OPTION.getTagName())) continue;
            NodeList nodeList2 = element2.getChildNodes();
            int n2 = nodeList2.getLength();
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < n2; ++j) {
                Text text;
                String string;
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 3 && node2.getNodeType() != 4 || (string = node2.getNodeValue()) == null) continue;
                string = string.trim();
                Text text2 = text = node2 instanceof Text ? (Text)node2 : null;
                if (text != null && MarkupService.isJspxNode((Node)text)) {
                    string = webForm.getDomProviderService().expandHtmlEntities(string, true, element);
                }
                stringBuffer.append(string);
            }
            if (stringBuffer.length() <= 0) continue;
            Attr attr = element2.getAttributeNode("selected");
            if (attr != null) {
                arrayList.add(new Integer(vector.size()));
            }
            vector.addElement(stringBuffer.toString());
        }
        if (arrayList != null) {
            int[] nArray = new int[arrayList.size()];
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            return nArray;
        }
        return null;
    }

    private static void populateText(Element element, StringBuffer stringBuffer) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3 && node.getNodeType() != 4 || (string = node.getNodeValue()) == null) continue;
            string = string.trim();
            stringBuffer.append(string);
        }
    }

    @Override
    protected void createChildren(CreateContext createContext) {
        if (this.createChildren) {
            super.createChildren(createContext);
        }
    }

    @Override
    protected boolean isOpaqueBox() {
        return true;
    }

    private static JComponent createInputComponent(HtmlTag htmlTag, Element element) {
        JComponent jComponent = null;
        String string = element.getAttribute("type");
        sCreateChildren = true;
        if (htmlTag == HtmlTag.INPUT && (string == null || string.length() == 0 || string.equals("text"))) {
            JTextFieldColumnWidth jTextFieldColumnWidth = new JTextFieldColumnWidth();
            jComponent = jTextFieldColumnWidth;
            int n = HtmlAttribute.getIntegerAttributeValue((Element)element, (String)"size", (int)-1);
            jTextFieldColumnWidth.setColumns(n > 0 ? n : 20);
            String string2 = element.getAttribute("value");
            if (string2 != null && string2.length() > 0) {
                jTextFieldColumnWidth.setText(string2);
            }
            if (CssProvider.getValueService().isColorTransparentForElement(element, 0)) {
                jTextFieldColumnWidth.setOpaque(false);
            }
        } else if (htmlTag == HtmlTag.BUTTON || string.equals("submit") || string.equals("reset") || string.equals("button")) {
            String string3 = FormComponentBox.getButtonLabel(element, string);
            JButton jButton = new JButton(string3);
            Insets insets = jButton.getMargin();
            if (insets != null) {
                jButton.setMargin(new Insets(insets.top / 2, insets.left / 2, insets.bottom / 2, insets.right / 2));
            }
            if (Utilities.getOperatingSystem() == 4096) {
                jButton.setOpaque(false);
            }
            jComponent = jButton;
        } else if (string.equals("checkbox")) {
            String string4;
            JCheckBox jCheckBox = new JCheckBox();
            jComponent = jCheckBox;
            jCheckBox.setVerticalAlignment(3);
            Insets insets = jCheckBox.getMargin();
            if (insets != null) {
                jCheckBox.setMargin(new Insets(0, 0, 0, 0));
            }
            if ((string4 = element.getAttribute("checked")) != null && string4.length() > 0) {
                jCheckBox.setSelected(true);
            }
            jCheckBox.setOpaque(false);
        } else if (string.equals("radio")) {
            String string5;
            JRadioButton jRadioButton = new JRadioButton();
            jComponent = jRadioButton;
            jRadioButton.setVerticalAlignment(3);
            Insets insets = jRadioButton.getMargin();
            if (insets != null) {
                jRadioButton.setMargin(new Insets(0, 0, 0, 0));
            }
            if ((string5 = element.getAttribute("checked")) != null && string5.length() > 0) {
                jRadioButton.setSelected(true);
            }
            jRadioButton.setOpaque(false);
        } else if (string.equals("password")) {
            JPasswordFieldColumnWidth jPasswordFieldColumnWidth = new JPasswordFieldColumnWidth();
            jComponent = jPasswordFieldColumnWidth;
            int n = HtmlAttribute.getIntegerAttributeValue((Element)element, (String)"size", (int)-1);
            jPasswordFieldColumnWidth.setColumns(n > 0 ? n : 20);
            String string6 = element.getAttribute("value");
            if (string6 != null && string6.length() > 0) {
                jPasswordFieldColumnWidth.setText(string6);
            } else {
                jPasswordFieldColumnWidth.setText("abcdefghijk");
            }
        } else if (string.equals("file")) {
            JTextFieldColumnWidth jTextFieldColumnWidth = new JTextFieldColumnWidth();
            int n = HtmlAttribute.getIntegerAttributeValue((Element)element, (String)"size", (int)-1);
            jTextFieldColumnWidth.setColumns(n > 0 ? n : 20);
            JButton jButton = new JButton(UIManager.getString("FormView.browseFileButtonText"));
            Box box = Box.createHorizontalBox();
            box.add(jTextFieldColumnWidth);
            box.add(Box.createHorizontalStrut(5));
            box.add(jButton);
            jComponent = box;
            jComponent.setOpaque(false);
        }
        return jComponent;
    }

    private static String getButtonLabel(Element element, String string) {
        if (element.getTagName().equals(HtmlTag.BUTTON.name)) {
            StringBuffer stringBuffer = new StringBuffer();
            FormComponentBox.addNodeText(stringBuffer, element, true);
            return stringBuffer.toString().trim();
        }
        Attr attr = element.getAttributeNode("value");
        String string2 = null;
        if (attr != null) {
            string2 = attr.getValue();
            if (string2.length() == 0) {
                string2 = " ";
            }
        } else {
            string2 = string.equals("reset") ? NbBundle.getMessage(FormComponentBox.class, (String)"Reset") : NbBundle.getMessage(FormComponentBox.class, (String)"Submit");
        }
        return string2;
    }

    private static void addNodeText(StringBuffer stringBuffer, Node node, boolean bl) {
        short s = node.getNodeType();
        if (s == 3) {
            if (bl && DesignerUtils.onlyWhitespace(node.getNodeValue())) {
                return;
            }
            stringBuffer.append(node.getNodeValue());
        } else if (s == 8) {
            String string = node.getNodeValue();
            int n = string.indexOf(10);
            if (n != -1) {
                stringBuffer.append(string.substring(n + 1));
            }
        } else if (s == 4) {
            if (bl && DesignerUtils.onlyWhitespace(node.getNodeValue())) {
                return;
            }
            stringBuffer.append(node.getNodeValue());
        } else {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                FormComponentBox.addNodeText(stringBuffer, nodeList.item(i), bl);
            }
        }
    }

    @Override
    protected void paintBackground(Graphics graphics, int n, int n2) {
        if (this.createChildren && this.getBoxCount() > 0) {
            super.paintBackground(graphics, n, n2);
        }
    }

    @Override
    public void paint(Graphics graphics, int n, int n2) {
        Image image;
        super.paint(graphics, n, n2);
        if (this.hidden) {
            return;
        }
        n += this.leftMargin;
        n2 += this.effectiveTopMargin;
        if (this.getComponent() != null && (image = this.getImage()) != null) {
            if (this.hasInitialFocus() && this.webform.getInitialFocusMarkCssBox() == null) {
                this.webform.setInitialFocusMarkCssBox(this);
                Graphics graphics2 = image.getGraphics();
                this.paintFocusWaterMark(graphics2, 0, 0);
            }
            this.transform.setToTranslation(n + this.getX(), n2 + this.getY());
            ((Graphics2D)graphics).drawImage(image, this.transform, null);
        }
    }

    private Image getImage() {
        Serializable serializable;
        if (this.image != null || this.attempted) {
            return this.image;
        }
        if (this.getComponent() == null) {
            return null;
        }
        this.attempted = true;
        JComponent jComponent = this.getComponent();
        Dimension dimension = jComponent.getPreferredSize();
        this.imageWidth = dimension.width;
        this.imageHeight = dimension.height;
        if (this.imageWidth == 0 || this.imageHeight == 0) {
            ErrorManager.getDefault().log("Component has 0 size - " + this + " w=" + this.imageWidth + " h=" + this.imageHeight);
            this.attempted = false;
            return null;
        }
        jComponent.setSize(dimension);
        this.image = jComponent.createImage(this.imageWidth, this.imageHeight);
        if (this.image == null) {
            this.image = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            if (this.image == null) {
                return null;
            }
        }
        Graphics graphics = this.image.getGraphics();
        if (this.nonrectangular) {
            ContainerBox containerBox;
            serializable = this.bg;
            for (containerBox = this; containerBox != null && containerBox.bg == null; containerBox = containerBox.getParent()) {
            }
            this.bg = containerBox != null ? containerBox.bg : Color.white;
            super.paintBackground(graphics, 0, 0);
            this.bg = serializable;
        }
        if ((serializable = this.webform.getRenderPane()) == null) {
            graphics.drawString("Error", 0, this.imageHeight / 2);
            return this.image;
        }
        ((CellRendererPane)serializable).paintComponent(graphics, jComponent, null, 0, 0, this.imageWidth, this.imageHeight, true);
        ((Container)serializable).removeAll();
        return this.image;
    }

    private static Dimension computeSizeForTextComponent(JTextComponent jTextComponent) {
        JTextArea jTextArea;
        int n;
        if (jTextComponent instanceof JTextField) {
            JTextField jTextField = (JTextField)jTextComponent;
            int n2 = jTextField.getColumns();
            if (n2 > 0) {
                return FormComponentBox.computeSizeForTextComponentColumns(jTextComponent, n2);
            }
        } else if (jTextComponent instanceof JTextArea && (n = (jTextArea = (JTextArea)jTextComponent).getColumns()) > 0) {
            return FormComponentBox.computeSizeForTextComponentColumns(jTextComponent, n);
        }
        return jTextComponent.getPreferredSize();
    }

    private static Dimension computeSizeForTextComponentColumns(JTextComponent jTextComponent, int n) {
        Dimension dimension = jTextComponent.getPreferredSize();
        Font font = jTextComponent.getFont();
        if (font == null) {
            return dimension;
        }
        FontMetrics fontMetrics = jTextComponent.getFontMetrics(font);
        if (fontMetrics == null) {
            return dimension;
        }
        dimension.width = n * fontMetrics.charWidth('a');
        return dimension;
    }

    public float getPreferredSpan(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        if (this.imageWidth != -1) {
            return n == 0 ? (float)this.imageWidth : (float)this.imageHeight;
        }
        if (this.createdC != null) {
            Dimension dimension = this.createdC.getPreferredSize();
            if (n == 0) {
                return dimension.width;
            }
            return dimension.height;
        }
        return 0.0f;
    }

    public float getMinimumSpan(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        if (this.imageWidth != -1) {
            return n == 0 ? (float)this.imageWidth : (float)this.imageHeight;
        }
        if (this.createdC != null) {
            Dimension dimension = this.createdC.getMinimumSize();
            if (n == 0) {
                return dimension.width;
            }
            return dimension.height;
        }
        return 0.0f;
    }

    public float getMaximumSpan(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        if (this.imageWidth != -1) {
            return n == 0 ? (float)this.imageWidth : (float)this.imageHeight;
        }
        if (this.createdC != null) {
            Dimension dimension = this.createdC.getMaximumSize();
            if (n == 0) {
                return dimension.width;
            }
            return dimension.height;
        }
        return 0.0f;
    }

    public final JComponent getComponent() {
        return this.createdC;
    }

    @Override
    public int getWidth() {
        return (int)this.getPreferredSpan(0);
    }

    @Override
    public int getHeight() {
        return (int)this.getPreferredSpan(1);
    }

    @Override
    protected String paramString() {
        Element element = this.getElement();
        return "value=" + (element == null ? null : element.getAttribute("value")) + ", " + super.paramString() + ", component=" + this.createdC;
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)this.getPreferredSpan(0);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)this.getPreferredSpan(1);
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    public static JTextField createTextField() {
        return new JTextFieldColumnWidth();
    }

    public static JTextField createTextField(String string, int n) {
        return new JTextFieldColumnWidth(string, n);
    }

    public static JTextArea createTextArea(String string, int n, int n2) {
        return new JTextAreaColumnWidth(string, n, n2);
    }

    private static class JTextAreaColumnWidth
    extends JTextArea {
        private int columnWidth;

        public JTextAreaColumnWidth(Document document) {
            super(document);
        }

        public JTextAreaColumnWidth(String string, int n, int n2) {
            super(string, n, n2);
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.columnWidth = 0;
        }

        protected int getColumnWidth() {
            if (this.columnWidth == 0) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                this.columnWidth = fontMetrics.charWidth('a');
            }
            return this.columnWidth;
        }
    }

    private static class JPasswordFieldColumnWidth
    extends JPasswordField {
        private int columnWidth;

        public JPasswordFieldColumnWidth() {
        }

        public JPasswordFieldColumnWidth(String string, int n) {
            super(string, n);
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.columnWidth = 0;
        }

        protected int getColumnWidth() {
            if (this.columnWidth == 0) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                this.columnWidth = fontMetrics.charWidth('a');
            }
            return this.columnWidth;
        }
    }

    private static class JTextFieldColumnWidth
    extends JTextField {
        private int columnWidth;

        public JTextFieldColumnWidth() {
        }

        public JTextFieldColumnWidth(String string, int n) {
            super(string, n);
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.columnWidth = 0;
        }

        protected int getColumnWidth() {
            if (this.columnWidth == 0) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                this.columnWidth = fontMetrics.charWidth('a');
            }
            return this.columnWidth;
        }
    }
}

