/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.css2;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.FormatContext;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SpaceBox
extends CssBox {
    private int beginDomOffset = -1;
    private int endDomOffset = -1;
    private int beginOffset;
    private int endOffset;
    private String xhtml;
    private String jspx;
    private FontMetrics metrics;
    private int decoration;
    private Text node;
    private Color fg;

    public SpaceBox(WebForm webForm, Element element, Text text, String string, String string2, int n, int n2, Color color, Color color2, int n3, FontMetrics fontMetrics, boolean bl) {
        super(webForm, element, BoxType.SPACE, true, true);
        this.beginOffset = n;
        this.endOffset = n2;
        this.node = text;
        this.decoration = n3;
        this.fg = color;
        this.bg = color2;
        this.metrics = fontMetrics;
        this.xhtml = string;
        this.jspx = string2;
        this.hidden = bl;
        this.contentWidth = this.width = fontMetrics.charWidth(' ');
        this.contentHeight = this.height = fontMetrics.getHeight();
    }

    protected void initialize() {
    }

    protected void initializeDesignBean() {
    }

    protected void initializeInvariants() {
    }

    protected void initializeHorizontalWidths(FormatContext formatContext) {
    }

    protected String paramString() {
        return "space, " + super.paramString() + ", " + (this.metrics == null ? "" : "font ascent=" + this.metrics.getAscent() + ", descent=" + this.metrics.getDescent() + ", height=" + this.metrics.getHeight() + ", " + "font=" + this.metrics.getFont()) + ", boffset=" + this.beginOffset + ", eoffset=" + this.endOffset;
    }

    protected void paintBackground(Graphics graphics, int n, int n2) {
        if (this.hidden) {
            return;
        }
        if (this.bg != null) {
            int n3 = this.getX() + n;
            int n4 = this.getY() + n2;
            graphics.setColor(this.bg);
            graphics.fillRect(n3, n4, this.width, this.height);
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3;
        if (this.hidden) {
            return;
        }
        int n4 = this.getX() + n;
        int n5 = this.getY() + n2;
        graphics.setColor(this.fg);
        graphics.setFont(this.metrics.getFont());
        if ((this.decoration & 1) != 0) {
            n3 = n5 + this.metrics.getHeight() - this.metrics.getDescent() + 1;
            graphics.drawLine(n4, n3, n4 + this.getWidth(), n3);
        }
        if ((this.decoration & 2) != 0) {
            n3 = n5 + this.metrics.getHeight() - this.metrics.getDescent();
            graphics.drawLine(n4, n3 -= (int)((float)this.metrics.getAscent() * 0.4f), n4 + this.getWidth(), n3);
        }
        if ((this.decoration & 4) != 0) {
            graphics.drawLine(n4, n5, n4 + this.getWidth(), n5);
        }
        if (CssBox.paintSpaces) {
            graphics.setColor(Color.GREEN);
            graphics.drawRect(this.getAbsoluteX(), this.getAbsoluteY(), this.width, this.height);
        }
    }

    public FontMetrics getMetrics() {
        return this.metrics;
    }

    public boolean isUnderline() {
        return (this.decoration & 1) != 0;
    }

    public boolean isStrikeThrough() {
        return (this.decoration & 2) != 0;
    }

    public boolean isOverline() {
        return (this.decoration & 4) != 0;
    }

    public Color getTextColor() {
        return this.fg;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public int getBaseline() {
        return this.metrics.getHeight() - this.metrics.getDescent();
    }

    public DomProvider.DomPosition getFirstPosition() {
        if (this.node != null) {
            return this.webform.createDomPosition(this.node, this.getDomStartOffset(), DomProvider.DomPosition.Bias.FORWARD);
        }
        return DomProvider.DomPosition.NONE;
    }

    public DomProvider.DomPosition getLastPosition() {
        if (this.node != null) {
            return this.webform.createDomPosition(this.node, this.getDomEndOffset(), DomProvider.DomPosition.Bias.BACKWARD);
        }
        return DomProvider.DomPosition.NONE;
    }

    public DomProvider.DomPosition computePosition(int n) {
        if (this.node == null) {
            return DomProvider.DomPosition.NONE;
        }
        int n2 = this.getDomStartOffset();
        return this.webform.createDomPosition(this.node, n2, DomProvider.DomPosition.Bias.FORWARD);
    }

    public Rectangle getBoundingBox(DomProvider.DomPosition domPosition) {
        assert (domPosition.getNode() == this.node);
        if (domPosition.getOffset() == this.beginOffset) {
            return new Rectangle(this.getAbsoluteX(), this.getAbsoluteY(), this.width, this.height);
        }
        return new Rectangle(this.getAbsoluteX() + this.width, this.getAbsoluteY(), this.width, this.height);
    }

    public Text getNode() {
        return this.node;
    }

    public int getDomStartOffset() {
        if (this.beginDomOffset == -1) {
            this.beginDomOffset = this.jspx == this.xhtml || this.jspx.indexOf(38) == -1 ? this.beginOffset : this.webform.getDomProviderService().getUnexpandedOffset(this.jspx, this.beginOffset);
        }
        return this.beginDomOffset;
    }

    public int getDomEndOffset() {
        if (this.endDomOffset == -1) {
            this.endDomOffset = this.jspx == this.xhtml || this.jspx.indexOf(38) == -1 ? this.endOffset : this.webform.getDomProviderService().getUnexpandedOffset(this.jspx, this.endOffset);
        }
        return this.endDomOffset;
    }

    public DomProvider.DomPosition getPrev(DomProvider.DomPosition domPosition) {
        if (this.node == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (domPosition.getOffset() > this.getDomStartOffset()) {
            int n = this.getDomStartOffset();
            return this.webform.createDomPosition(this.node, n, DomProvider.DomPosition.Bias.BACKWARD);
        }
        return DomProvider.DomPosition.NONE;
    }

    public DomProvider.DomPosition getNext(DomProvider.DomPosition domPosition) {
        if (this.node == null) {
            return DomProvider.DomPosition.NONE;
        }
        if (domPosition.getOffset() < this.getDomEndOffset()) {
            int n = this.getDomEndOffset();
            return this.webform.createDomPosition(this.node, n, DomProvider.DomPosition.Bias.FORWARD);
        }
        return DomProvider.DomPosition.NONE;
    }
}

