/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Action;
import javax.swing.JRootPane;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.SpaceBox;
import org.netbeans.modules.visualweb.css2.TextBox;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.InlineEditor;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AttributeInlineEditor
extends InlineEditor {
    private final FocusListener focusListener = new AttributeInlineEditorFocusListener(this);

    AttributeInlineEditor(WebForm webForm, DomProvider.InlineEditorSupport inlineEditorSupport) {
        super(webForm, inlineEditorSupport);
    }

    public static AttributeInlineEditor get(WebForm webForm, Element element, DomProvider.InlineEditorSupport inlineEditorSupport) {
        if (!inlineEditorSupport.isEditingAllowed()) {
            return null;
        }
        if (!AttributeInlineEditor.isEscaped(webForm, element)) {
            return null;
        }
        return new AttributeInlineEditor(webForm, inlineEditorSupport);
    }

    public void start(boolean bl, String string) {
        bl = this.inlineEditorSupport.prepareAttributeInlineEditor(bl);
        DesignerPane designerPane = this.webform.getPane();
        if (!designerPane.hasCaret()) {
            designerPane.createCaret();
        }
        boolean bl2 = false;
        DomProvider.DomPosition domPosition = this.inlineEditorSupport.getBeginPosition();
        DomProvider.DomPosition domPosition2 = this.inlineEditorSupport.getEndPosition();
        String string2 = this.inlineEditorSupport.getSpecialInitValue();
        if (string2 != null) {
            designerPane.select(domPosition, domPosition2);
            designerPane.replaceSelection(string2);
            bl2 = true;
        }
        if (!bl2) {
            if (string != null && string.length() > 0) {
                String string3 = this.inlineEditorSupport.getValueSource();
                if (string3 == null) {
                    designerPane.select(domPosition, domPosition2);
                    designerPane.replaceSelection(string);
                } else {
                    designerPane.setCaretDot(domPosition2);
                    designerPane.replaceSelection(string);
                }
            } else if (bl) {
                designerPane.select(domPosition, domPosition2);
            } else {
                designerPane.showCaret(domPosition2);
            }
        }
        this.webform.getPane().addFocusListener(this.focusListener);
    }

    public void finish(boolean bl) {
        this.webform.getPane().removeFocusListener(this.focusListener);
        this.webform.getPane().setCaret(null);
        this.inlineEditorSupport.cleanAttributeInlineEditor(bl);
    }

    public boolean isDocumentEditor() {
        return true;
    }

    public boolean isEscaped() {
        return this.inlineEditorSupport.isEscaped();
    }

    private static boolean isEscaped(WebForm webForm, Element element) {
        return webForm.getDomProviderService().isEscapedComponent(element);
    }

    public boolean isMultiLine() {
        return !this.isEscaped();
    }

    public boolean checkPosition(DomProvider.DomPosition domPosition) {
        Node node = domPosition.getNode();
        if (node == null) {
            return false;
        }
        if (this.webform.isRenderedNode(domPosition.getNode())) {
            domPosition = domPosition.getSourcePosition();
            node = domPosition.getNode();
        }
        if (node == null) {
            return false;
        }
        DocumentFragment documentFragment = this.inlineEditorSupport.getFragment();
        for (Node node2 = node.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            if (node2 != documentFragment) continue;
            return true;
        }
        return false;
    }

    public Transferable copyText(boolean bl) {
        DesignerPane designerPane = this.webform.getPane();
        if (designerPane.hasCaret()) {
            return designerPane.copySelection(bl);
        }
        return null;
    }

    public void invokeDeleteNextCharAction(ActionEvent actionEvent) {
        Action[] actionArray;
        DesignerPane designerPane = this.webform.getPane();
        for (Action action : actionArray = designerPane.getActions()) {
            if (action == null || action.getValue("Name") != "delete-next") continue;
            ActionEvent actionEvent2 = new ActionEvent(designerPane, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers());
            action.actionPerformed(actionEvent2);
            break;
        }
    }

    public boolean isEdited(CssBox cssBox) {
        Node node;
        if (cssBox instanceof TextBox) {
            node = ((TextBox)cssBox).getNode();
        } else if (cssBox instanceof SpaceBox) {
            node = ((SpaceBox)cssBox).getNode();
        } else {
            return false;
        }
        Node node2 = this.inlineEditorSupport.getText();
        Node node3 = MarkupService.getRenderedNodeForNode((Node)node2);
        if (node3 == null) {
            return false;
        }
        while (node != null) {
            if (node == node3) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    private static class AttributeInlineEditorFocusListener
    implements FocusListener {
        private final AttributeInlineEditor attributeInlineEditor;

        public AttributeInlineEditorFocusListener(AttributeInlineEditor attributeInlineEditor) {
            this.attributeInlineEditor = attributeInlineEditor;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component;
            if (!focusEvent.isTemporary() || focusEvent.getComponent() instanceof JRootPane) {
                this.attributeInlineEditor.webform.getManager().finishInlineEditing(false);
                focusEvent.getComponent().removeFocusListener(this);
                return;
            }
            if (focusEvent.isTemporary() && (component = focusEvent.getOppositeComponent()) instanceof JRootPane) {
                component.addFocusListener(this);
            }
        }
    }
}

