/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.Color;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.SelectionManager;
import org.netbeans.modules.visualweb.designer.WebForm;

public class ColorManager {
    private WebForm webform;
    private PageBox pageBox;
    public Color insertColor;
    public Color selectionColor;
    public Color selectionColorReverse;
    public Color selectionBoundsColor;
    public Color primaryColor;
    public Color dropTargetColor;
    public Color hierarchyForegroundColor;
    public Color hierarchyBackgroundColor;
    public Color draggerColor;
    public Color draggerColorBorder;
    public Color resizerColor;
    public Color resizerColorBorder;
    public Color marqueeColor;
    public Color marqueeColorBorder;
    public Color gridColor;

    public ColorManager(WebForm webForm) {
        this.webform = webForm;
    }

    public void resetPageBox() {
        this.pageBox = null;
    }

    public void sync() {
        DesignerPane designerPane = this.webform.getPane();
        if (designerPane != null && designerPane.getPageBox() != this.pageBox) {
            this.pageBox = designerPane.getPageBox();
            this.initializeColors();
        }
    }

    private void initializeColors() {
        PageBox pageBox = this.webform.getPane().getPageBox();
        if (pageBox != null && pageBox.isDarkBackground()) {
            this.setDarkBackgroundColors();
        } else {
            this.setLightBackgroundColors();
        }
    }

    private void setLightBackgroundColors() {
        this.insertColor = Color.LIGHT_GRAY;
        this.gridColor = Color.GRAY;
        this.selectionColor = Color.BLACK;
        this.selectionColorReverse = Color.WHITE;
        this.selectionBoundsColor = Color.DARK_GRAY;
        this.primaryColor = Color.YELLOW;
        this.dropTargetColor = Color.BLUE;
        this.draggerColor = new Color(0, 0, 0, 30);
        this.draggerColorBorder = new Color(0, 0, 0, 100);
        this.marqueeColor = this.draggerColor;
        this.marqueeColorBorder = this.draggerColorBorder;
        this.resizerColor = this.draggerColor;
        this.resizerColorBorder = this.draggerColorBorder;
        if (SelectionManager.PAINT_SELECTION_HIERARCHY) {
            this.hierarchyForegroundColor = Color.BLACK;
            this.hierarchyBackgroundColor = new Color(200, 200, 200, 128);
        }
    }

    private void setDarkBackgroundColors() {
        this.insertColor = Color.LIGHT_GRAY;
        this.gridColor = Color.GRAY;
        this.selectionColor = Color.WHITE;
        this.selectionColorReverse = Color.BLACK;
        this.selectionBoundsColor = Color.DARK_GRAY;
        this.primaryColor = Color.YELLOW;
        this.dropTargetColor = Color.BLUE;
        this.draggerColor = new Color(200, 200, 200, 30);
        this.draggerColorBorder = new Color(200, 200, 200, 100);
        this.marqueeColor = this.draggerColor;
        this.marqueeColorBorder = this.draggerColorBorder;
        this.resizerColor = this.draggerColor;
        this.resizerColorBorder = this.draggerColorBorder;
        if (SelectionManager.PAINT_SELECTION_HIERARCHY) {
            this.hierarchyForegroundColor = Color.WHITE;
            this.hierarchyBackgroundColor = new Color(200, 200, 200, 128);
        }
    }

    public static boolean isDark(Color color) {
        float f = 0.27f * (float)color.getRed() + 0.67f * (float)color.getGreen() + 0.06f * (float)color.getBlue();
        return f < 64.0f;
    }
}

