/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.DndHandler;
import org.netbeans.modules.visualweb.designer.Interaction;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.openide.ErrorManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dragger
extends Interaction
implements KeyListener {
    private static final int THRESHOLD = 2;
    private static final boolean DISPLAY_IMAGES = System.getProperty("rave.disableImageDrags") == null;
    private static final int DRAG_GRID = 0;
    private static final int DRAG_FREE = 1;
    private static final int LINKING = 2;
    protected transient Cursor previousCursor;
    private WebForm webform;
    private List<CssBox> boxes;
    private List<Rectangle> selections;
    private Element[] componentRootElements;
    private List<Image> images;
    private DomProvider.DomPosition pos;
    private int prevX = -500;
    private int prevY = -500;
    private int prevAction;
    private int startX;
    private int startY;
    private int prevMouseX = -500;
    private int prevMouseY = -500;
    private int action;
    private BasicStroke linkStroke;
    private boolean alreadyMoved = false;
    private AffineTransform transform;
    private AlphaComposite alpha;

    public Dragger(WebForm webForm, List<CssBox> list, List<Rectangle> list2, Element[] elementArray) {
        if (DesignerUtils.DEBUG) {
            DesignerUtils.debugLog(this.getClass().getName() + "()");
        }
        if (webForm == null) {
            throw new IllegalArgumentException("Null webform.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Null boxes list.");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Null selections list.");
        }
        if (elementArray == null) {
            throw new IllegalArgumentException("Null componentRootElements list.");
        }
        this.webform = webForm;
        this.boxes = list;
        this.selections = list2;
        this.componentRootElements = elementArray;
    }

    private void cleanup(DesignerPane designerPane, int n) {
        designerPane.setCursor(this.previousCursor);
        if (this.webform.isGridMode()) {
            this.webform.getPane().hideCaret();
        }
        designerPane.clearDirty();
        if (this.selections == null) {
            designerPane.repaint();
            return;
        }
        int n2 = this.selections.size();
        if (n == 2) {
            designerPane.addDirtyPoint(this.startX - 1, this.startY - 1);
            designerPane.addDirtyPoint(this.startX + 1, this.startY + 1);
            designerPane.addDirtyPoint(this.prevX - 1, this.prevY - 1);
            designerPane.addDirtyPoint(this.prevX + 1, this.prevY + 1);
        } else {
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4;
                Rectangle rectangle = this.selections.get(i);
                if (n == 1) {
                    n4 = rectangle.x + this.prevX;
                    n3 = rectangle.y + this.prevY;
                } else if (this.hasMoved(this.prevX, this.prevY)) {
                    n4 = this.webform.snapX(rectangle.x + this.prevX, this.getPositionedBy(i));
                    n3 = this.webform.snapY(rectangle.y + this.prevY, this.getPositionedBy(i));
                } else {
                    n4 = rectangle.x + this.startX;
                    n3 = rectangle.y + this.startY;
                }
                designerPane.addDirtyPoint(n4, n3);
                designerPane.addDirtyPoint(n4 + rectangle.width + 1, n3 + rectangle.height + 1);
            }
        }
        designerPane.repaintDirty(false);
    }

    @Override
    public void cancel(DesignerPane designerPane) {
        designerPane.removeKeyListener(this);
        this.cleanup(designerPane, this.action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            DesignerPane designerPane = this.webform.getPane();
            designerPane.removeKeyListener(this);
            if (mouseEvent != null && !mouseEvent.isConsumed()) {
                int n = this.action;
                this.updateSnapState(mouseEvent);
                Point point = mouseEvent.getPoint();
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
                this.cleanup(designerPane, n);
                if (this.action == 2) {
                    int n2;
                    DndHandler dndHandler = this.webform.getPane().getDndHandler();
                    Element element = ModelViewMapper.findElement(this.webform.getPane().getPageBox(), this.startX, this.startY);
                    if (element == null) {
                        if (this.componentRootElements.length > 0) {
                            element = this.componentRootElements[0];
                        } else {
                            dndHandler.clearDropMatch();
                            return;
                        }
                    }
                    if ((n2 = dndHandler.getDropTypeForComponent(point, element, true)) == 2) {
                        CssBox cssBox = ModelViewMapper.findBox(this.webform.getPane().getPageBox(), point.x, point.y);
                        Element element2 = cssBox.getElement();
                        if (element2 != null) {
                            this.webform.processLinks(element2, element);
                        }
                    } else {
                        CssBox cssBox;
                        Element element3;
                        element = ModelViewMapper.findElement(this.webform.getPane().getPageBox(), point.x, point.y);
                        if (element != null) {
                            n2 = dndHandler.getDropTypeForComponent(new Point(this.startX, this.startY), element, true);
                        }
                        if (n2 == 2 && (element3 = (cssBox = ModelViewMapper.findBox(this.webform.getPane().getPageBox(), this.startX, this.startY)).getElement()) != null) {
                            this.webform.processLinks(element3, element);
                        }
                    }
                    dndHandler.clearDropMatch();
                } else if (point.x != this.startX || point.y != this.startY) {
                    this.prevX = point.x;
                    this.prevY = point.y;
                    boolean bl = this.isOverGrid(this.prevX, this.prevY);
                    if (bl) {
                        this.pos = DomProvider.DomPosition.NONE;
                    } else {
                        this.pos = this.getPosition(this.prevX, this.prevY);
                        if (this.pos == DomProvider.DomPosition.NONE && this.webform.isGridMode()) {
                            bl = true;
                        }
                    }
                    if (this.pos != DomProvider.DomPosition.NONE || bl && this.hasMoved(this.prevX, this.prevY)) {
                        ArrayList<Point> arrayList = new ArrayList<Point>();
                        if (this.selections != null) {
                            for (Rectangle rectangle : this.selections) {
                                arrayList.add(new Point(rectangle.x, rectangle.y));
                            }
                            this.webform.getDomDocument().moveComponents(this.webform, this.boxes.toArray(new CssBox[this.boxes.size()]), arrayList.toArray(new Point[arrayList.size()]), this.pos, this.prevX, this.prevY, this.action != 1);
                        }
                    }
                }
                mouseEvent.consume();
            }
        }
        finally {
            this.selections = null;
            this.previousCursor = null;
            this.images = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        this.prevMouseX = point.x;
        this.prevMouseY = point.y;
        this.update(mouseEvent, point.x, point.y);
        this.webform.getPane().scrollRectToVisible(new Rectangle(point));
    }

    private CssBox getPositionedBy(int n) {
        CssBox cssBox = this.boxes.get(n);
        return cssBox.getPositionedBy();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.prevX;
        int n2 = this.prevY;
        if (this.action == 2) {
            if (this.webform.getManager().isHighlighted()) {
                graphics.setColor(Color.BLUE);
            } else {
                graphics.setColor(Color.BLACK);
            }
            if (this.linkStroke == null) {
                int n3 = 1;
                this.linkStroke = new BasicStroke(n3, 2, 0, 10.0f, new float[]{4 * n3, 4 * n3 + n3}, 0.0f);
            }
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.linkStroke);
            graphics.drawLine(this.startX, this.startY, n, n2);
            graphics2D.setStroke(stroke);
            return;
        }
        if (!this.hasMoved(n, n2)) {
            return;
        }
        if (this.pos != DomProvider.DomPosition.NONE) {
            return;
        }
        if (this.selections == null) {
            return;
        }
        int n4 = this.selections.size();
        Composite composite = null;
        if (DISPLAY_IMAGES) {
            composite = graphics2D.getComposite();
            if (this.alpha == null) {
                this.alpha = AlphaComposite.getInstance(3, 0.7f);
            }
            graphics2D.setComposite(this.alpha);
        }
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            Rectangle rectangle = this.selections.get(i);
            if (this.action == 1) {
                n6 = rectangle.x + n;
                n5 = rectangle.y + n2;
            } else if (this.hasMoved(n, n2)) {
                n6 = this.webform.snapX(rectangle.x + n, this.getPositionedBy(i));
                n5 = this.webform.snapY(rectangle.y + n2, this.getPositionedBy(i));
            } else {
                n6 = rectangle.x + this.startX;
                n5 = rectangle.y + this.startY;
            }
            List<Image> list = null;
            if (DISPLAY_IMAGES) {
                list = this.getImages();
            }
            if (list != null && list.get(i) != null) {
                Image image = list.get(i);
                if (image == null) continue;
                this.transform.setToTranslation(n6, n5);
                graphics2D.drawImage(image, this.transform, null);
                continue;
            }
            if (DesignerPane.useAlpha) {
                graphics.setColor(this.webform.getColors().draggerColor);
                graphics.fillRect(n6 + 1, n5 + 1, rectangle.width - 1, rectangle.height - 1);
                graphics.setColor(this.webform.getColors().draggerColorBorder);
            } else {
                graphics.setColor(Color.BLACK);
            }
            graphics.drawRect(n6, n5, rectangle.width, rectangle.height);
        }
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
    }

    private boolean hasMoved(int n, int n2) {
        int n3;
        if (this.alreadyMoved) {
            return true;
        }
        if (!this.webform.isGridSnap() || this.action == 1) {
            return n != this.startX || n2 != this.startY;
        }
        int n4 = n - this.startX;
        if (n4 < 0) {
            n4 = -n4;
        }
        if ((n3 = n2 - this.startY) < 0) {
            n3 = -n3;
        }
        this.alreadyMoved = n4 > 2 || n3 > 2;
        return this.alreadyMoved;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            this.updateSnapState(mouseEvent);
            Point point = mouseEvent.getPoint();
            DesignerPane designerPane = this.webform.getPane();
            designerPane.addKeyListener(this);
            this.previousCursor = designerPane.getCursor();
            designerPane.setCursor(Cursor.getPredefinedCursor(13));
            this.startX = point.x;
            this.startY = point.y;
            this.prevX = point.x;
            this.prevY = point.y;
            this.prevAction = this.getDragAction(mouseEvent);
            this.prevMouseX = point.x;
            this.prevMouseY = point.y;
            ImageIcon imageIcon = new ImageIcon(Dragger.class.getResource("/org/netbeans/modules/visualweb/designer/resources/drag_position.gif"));
            mouseEvent.consume();
        }
    }

    public boolean hasMoved() {
        return this.hasMoved(this.prevX, this.prevY);
    }

    private List<Image> getImages() {
        if (this.images == null) {
            this.initializeImages();
        }
        return this.images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeImages() {
        this.transform = new AffineTransform();
        int n = this.selections.size();
        this.images = new ArrayList<Image>(n);
        for (int i = 0; i < n; ++i) {
            BufferedImage bufferedImage;
            block12: {
                bufferedImage = null;
                CssBox cssBox = this.boxes.get(i);
                Rectangle rectangle = this.selections.get(i);
                if (rectangle.width > 0 && rectangle.height > 0 && (float)rectangle.width * (float)rectangle.height < 2.1474836E9f && (bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1)) != null) {
                    Graphics graphics = ((Image)bufferedImage).getGraphics();
                    try {
                        graphics.setClip(0, 0, rectangle.width, rectangle.height);
                        PageBox pageBox = cssBox.getWebForm().getPane().getPageBox();
                        graphics.setColor(pageBox.getBackground());
                        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
                        DesignerPane.clip.setBounds(0, 0, rectangle.width, rectangle.height);
                        DesignerPane.clipBr.x = rectangle.width;
                        DesignerPane.clipBr.y = rectangle.height;
                        boolean bl = DesignerPane.INCREMENTAL_LAYOUT;
                        DesignerPane.INCREMENTAL_LAYOUT = false;
                        if (cssBox.getX() == 0x7FFFFFFD) {
                            try {
                                pageBox.paint(graphics, -(this.startX + rectangle.x), -(this.startY + rectangle.y));
                                break block12;
                            }
                            finally {
                                DesignerPane.INCREMENTAL_LAYOUT = bl;
                            }
                        }
                        int n2 = cssBox.getX();
                        int n3 = cssBox.getY();
                        int n4 = cssBox.getLeftMargin();
                        int n5 = cssBox.getEffectiveTopMargin();
                        cssBox.setLocation(0, 0);
                        cssBox.setMargins(0, 0);
                        try {
                            cssBox.paint(graphics, 0, 0);
                        }
                        finally {
                            DesignerPane.INCREMENTAL_LAYOUT = bl;
                            cssBox.setLocation(n2, n3);
                            cssBox.setMargins(n4, n5);
                        }
                    }
                    finally {
                        graphics.dispose();
                    }
                }
            }
            this.images.add(bufferedImage);
        }
    }

    private void updateSnapState(InputEvent inputEvent) {
        int n = this.action;
        this.action = this.getDragAction(inputEvent);
        if (n == 2 && this.action != 2) {
            this.webform.getPane().getDndHandler().clearDropMatch();
        }
    }

    private DomProvider.DomPosition getPosition(int n, int n2) {
        CssBox cssBox = ModelViewMapper.findBox(this.webform.getPane().getPageBox(), n, n2);
        if (cssBox.getWebForm() != this.webform) {
            return DomProvider.DomPosition.NONE;
        }
        if (this.isBelowDragged(cssBox)) {
            return DomProvider.DomPosition.NONE;
        }
        if (cssBox.isGrid()) {
            return DomProvider.DomPosition.NONE;
        }
        DomProvider.DomPosition domPosition = this.webform.getManager().findTextPosition(n, n2);
        if (domPosition == DomProvider.DomPosition.NONE || this.canDropAt(domPosition)) {
            return domPosition;
        }
        return DomProvider.DomPosition.NONE;
    }

    private boolean canDropAt(DomProvider.DomPosition domPosition) {
        if (domPosition == DomProvider.DomPosition.NONE) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Invalid position, pos=" + domPosition));
            return false;
        }
        Node node = domPosition.getNode();
        return this.webform.canDropComponentsAtNode((Element[])this.componentRootElements.clone(), node);
    }

    private boolean isBelowDragged(CssBox cssBox) {
        int n = this.boxes.size();
        for (int i = 0; i < n; ++i) {
            CssBox cssBox2 = this.boxes.get(i);
            for (CssBox cssBox3 = cssBox; cssBox3 != null; cssBox3 = cssBox3.getParent()) {
                if (cssBox3 != cssBox2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOverGrid(int n, int n2) {
        CssBox cssBox;
        for (CssBox cssBox2 = cssBox = ModelViewMapper.findBox(this.webform.getPane().getPageBox(), n, n2); cssBox2 != null; cssBox2 = cssBox2.getParent()) {
            Element element = CssBox.getElementForComponentRootCssBox(cssBox2);
            if (element == null) continue;
            if (this.isDraggedComponent(element)) {
                cssBox = cssBox2.getParent();
                continue;
            }
            if (this.webform.getDomProviderService().isContainerComponent(element)) continue;
            cssBox = cssBox2.getParent();
        }
        return cssBox == null || cssBox.isGrid();
    }

    private boolean isDraggedComponent(Element element) {
        for (Element element2 : this.componentRootElements) {
            if (element2 != element) continue;
            return true;
        }
        Element element3 = this.webform.getDomProviderService().getParentComponent(element);
        return element3 == null ? false : this.isDraggedComponent(element3);
    }

    private void update(InputEvent inputEvent, int n, int n2) {
        if (!inputEvent.isConsumed()) {
            int n3;
            int n4;
            Object object;
            int n5;
            int n6;
            int n7 = this.action;
            this.updateSnapState(inputEvent);
            DesignerPane designerPane = this.webform.getPane();
            designerPane.clearDirty();
            if (this.selections == null) {
                return;
            }
            if (!DesignerPane.INCREMENTAL_LAYOUT) {
                designerPane.addDirtyPoint(0, 0);
            }
            if (this.prevAction == 2) {
                designerPane.addDirtyPoint(this.startX - 1, this.startY - 1);
                designerPane.addDirtyPoint(this.startX + 1, this.startY + 1);
                designerPane.addDirtyPoint(this.prevX - 1, this.prevY - 1);
                designerPane.addDirtyPoint(this.prevX + 1, this.prevY + 1);
            } else if (this.prevX != -500) {
                n6 = this.selections.size();
                for (n5 = 0; n5 < n6; ++n5) {
                    object = this.selections.get(n5);
                    if (n7 == 1) {
                        n4 = ((Rectangle)object).x + this.prevX;
                        n3 = ((Rectangle)object).y + this.prevY;
                    } else if (this.hasMoved(this.prevX, this.prevY)) {
                        n4 = this.webform.snapX(((Rectangle)object).x + this.prevX, this.getPositionedBy(n5));
                        n3 = this.webform.snapY(((Rectangle)object).y + this.prevY, this.getPositionedBy(n5));
                    } else {
                        n4 = ((Rectangle)object).x + this.startX;
                        n3 = ((Rectangle)object).y + this.startY;
                    }
                    designerPane.addDirtyPoint(n4, n3);
                    designerPane.addDirtyPoint(n4 + ((Rectangle)object).width + 1, n3 + ((Rectangle)object).height + 1);
                }
            }
            this.prevX = n;
            this.prevY = n2;
            this.prevAction = this.action;
            n6 = this.selections.size();
            if (this.action == 2) {
                designerPane.addDirtyPoint(this.startX - 1, this.startY - 1);
                designerPane.addDirtyPoint(this.startX + 1, this.startY + 1);
                designerPane.addDirtyPoint(n - 1, n2 - 1);
                designerPane.addDirtyPoint(n + 1, n2 + 1);
            } else {
                for (n5 = 0; n5 < n6; ++n5) {
                    object = this.selections.get(n5);
                    if (this.action == 1) {
                        n4 = ((Rectangle)object).x + this.prevX;
                        n3 = ((Rectangle)object).y + this.prevY;
                    } else if (this.hasMoved(this.prevX, this.prevY)) {
                        n4 = this.webform.snapX(((Rectangle)object).x + this.prevX, this.getPositionedBy(n5));
                        n3 = this.webform.snapY(((Rectangle)object).y + this.prevY, this.getPositionedBy(n5));
                    } else {
                        n4 = ((Rectangle)object).x + this.startX;
                        n3 = ((Rectangle)object).y + this.startY;
                    }
                    designerPane.addDirtyPoint(n4, n3);
                    designerPane.addDirtyPoint(n4 + ((Rectangle)object).width + 1, n3 + ((Rectangle)object).height + 1);
                }
            }
            n5 = this.isOverGrid(n, n2) ? 1 : 0;
            if (n5 != 0) {
                this.pos = DomProvider.DomPosition.NONE;
            } else {
                this.pos = this.getPosition(n, n2);
                if (this.pos == DomProvider.DomPosition.NONE && this.webform.isGridMode()) {
                    n5 = 1;
                }
            }
            if (this.action == 2) {
                this.webform.getPane().hideCaret();
                object = ModelViewMapper.findElement(this.webform.getPane().getPageBox(), this.startX, this.startY);
                if (object == null || this.webform.getPane().getDndHandler().getDropTypeForComponent(new Point(n, n2), (Element)object, true) != 2) {
                    object = ModelViewMapper.findElement(this.webform.getPane().getPageBox(), n, n2);
                    if (object == null || this.webform.getPane().getDndHandler().getDropTypeForComponent(new Point(this.startX, this.startY), (Element)object, true) != 2) {
                        this.webform.getPane().getDndHandler().clearDropMatch();
                        designerPane.setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        designerPane.setCursor(this.webform.getManager().getLinkedCursor());
                    }
                } else {
                    designerPane.setCursor(this.webform.getManager().getLinkedCursor());
                }
            } else if (n5 == 0) {
                object = ModelViewMapper.viewToModel(this.webform, n, n2);
                if (object != DomProvider.DomPosition.NONE) {
                    this.webform.getPane().showCaret((DomProvider.DomPosition)object);
                    designerPane.setCursor(Cursor.getPredefinedCursor(2));
                } else {
                    this.webform.getPane().hideCaret();
                    designerPane.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                this.webform.getPane().hideCaret();
                designerPane.setCursor(Cursor.getPredefinedCursor(13));
            }
            designerPane.repaintDirty(false);
            inputEvent.consume();
            if (n6 > 0 && this.action != 2) {
                int n8 = 0;
                Rectangle rectangle = this.selections.get(n8);
                if (this.action == 1) {
                    n3 = rectangle.x + this.prevX;
                    int n9 = rectangle.y + this.prevY;
                } else if (this.hasMoved(this.prevX, this.prevY)) {
                    n3 = this.webform.snapX(rectangle.x + this.prevX, this.getPositionedBy(n8));
                    int n10 = this.webform.snapY(rectangle.y + this.prevY, this.getPositionedBy(n8));
                } else {
                    n3 = rectangle.x + this.startX;
                    int n11 = rectangle.y + this.startY;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.action != this.getDragAction(keyEvent)) {
            this.update(keyEvent, this.prevMouseX, this.prevMouseY);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.action != this.getDragAction(keyEvent)) {
            this.update(keyEvent, this.prevMouseX, this.prevMouseY);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private int getDragAction(InputEvent inputEvent) {
        if (inputEvent.isShiftDown()) {
            if (inputEvent.isControlDown()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}

