/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.DomProviderService;
import org.netbeans.modules.visualweb.css2.BoxType;
import org.netbeans.modules.visualweb.css2.CssBox;
import org.netbeans.modules.visualweb.css2.ExternalDocumentBox;
import org.netbeans.modules.visualweb.css2.ModelViewMapper;
import org.netbeans.modules.visualweb.css2.PageBox;
import org.netbeans.modules.visualweb.designer.ColorManager;
import org.netbeans.modules.visualweb.designer.DesignerPane;
import org.netbeans.modules.visualweb.designer.DesignerUtils;
import org.netbeans.modules.visualweb.designer.Resizer;
import org.netbeans.modules.visualweb.designer.WebForm;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.openide.ErrorManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionManager {
    private static final int NODE_REFRESH_DELAY = 300;
    static final boolean PAINT_SELECTION_HIERARCHY = System.getProperty("designer.paintSelHierarchy") != null;
    private static final int BARSIZE = 5;
    private static final int SELECTIONVIEW_LEFT = 1;
    private BasicStroke selStroke;
    private final WebForm webform;
    private final List<SelectedComponent> selectedComponents = new ArrayList<SelectedComponent>();
    private Element primary = null;
    private Element leaf = null;
    private AffineTransform transform = new AffineTransform();
    private boolean paintBeanIcon = false;
    int selectionViewPos = Integer.MAX_VALUE;
    private Timer refreshTimer;

    SelectionManager(WebForm webForm) {
        this.webform = webForm;
        webForm.getPane();
    }

    public void clearSelection(boolean bl) {
        this.selectionViewPos = Integer.MAX_VALUE;
        this.leaf = null;
        if (this.selectedComponents.isEmpty()) {
            if (bl) {
                this.updateNodes();
            }
            return;
        }
        this.selectedComponents.clear();
        this.primary = null;
        if (bl) {
            this.updateNodes();
            this.webform.getPane().repaint();
        }
    }

    public void clearSelectionImmediate() {
        this.selectionViewPos = Integer.MAX_VALUE;
        this.leaf = null;
        if (this.selectedComponents.isEmpty()) {
            this.updateSelectionImmediate();
            return;
        }
        this.selectedComponents.clear();
        this.primary = null;
        this.updateSelectionImmediate();
        this.webform.getPane().repaint();
    }

    public void updateSelectionImmediate() {
        this.updateNodesImmediate();
    }

    public void syncSelection(boolean bl) {
        if (this.selectedComponents.isEmpty()) {
            return;
        }
        this.leaf = null;
        this.selectionViewPos = Integer.MAX_VALUE;
        this.primary = null;
        ArrayList<SelectedComponent> arrayList = new ArrayList<SelectedComponent>();
        for (SelectedComponent selectedComponent : this.selectedComponents) {
            if (selectedComponent.componentRootElement == null) continue;
            Element element = selectedComponent.componentRootElement;
            selectedComponent.componentRootElement = this.webform.getComponentRootElementEquivalentTo(element);
            if (selectedComponent.componentRootElement != null) continue;
            arrayList.add(selectedComponent);
        }
        for (SelectedComponent selectedComponent : arrayList) {
            this.selectedComponents.remove(selectedComponent);
        }
        this.webform.getPane().repaint();
        if (bl) {
            this.updateNodes();
        }
    }

    public void addSelected(Element element, boolean bl) {
        boolean bl2 = this.selectedComponents.isEmpty();
        SelectedComponent selectedComponent = new SelectedComponent();
        selectedComponent.componentRootElement = element;
        this.primary = selectedComponent.componentRootElement;
        if (selectedComponent.componentRootElement == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("ComponentRootElement is null!"));
        }
        SelectedComponent.access$202(selectedComponent, Resizer.getResizeConstraints(this.webform, element));
        if (!this.selectedComponents.contains(selectedComponent)) {
            this.selectedComponents.add(selectedComponent);
        }
        this.leaf = selectedComponent.componentRootElement;
        if (bl) {
            this.updateNodes();
        }
        if (bl2) {
            // empty if block
        }
    }

    public void setSelected(Element element, boolean bl) {
        Element element2 = this.leaf;
        this.primary = element;
        this.clearSelection(false);
        this.addSelected(element, bl);
        if (PAINT_SELECTION_HIERARCHY) {
            Element element3 = element2;
            while (element3 != null) {
                if (element == element3) {
                    this.leaf = element2;
                    return;
                }
                element3 = this.webform.getDomProviderService().getParentComponent(element3);
            }
            if (this.leaf != element) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Leaf is different from expected, leaf=" + this.leaf + ", expected=" + element));
            }
        }
    }

    public void removeSelected(Element element, boolean bl) {
        boolean bl2 = this.selectedComponents.isEmpty();
        if (!bl2) {
            for (SelectedComponent selectedComponent : this.selectedComponents) {
                if (selectedComponent.componentRootElement != element) continue;
                this.selectedComponents.remove(selectedComponent);
                break;
            }
        }
        if (element == this.primary) {
            this.primary = null;
            if (this.selectedComponents.size() > 1) {
                this.pickPrimary();
            }
        }
        if (bl) {
            this.updateNodes();
        }
        if (!bl2 || this.selectedComponents.isEmpty()) {
            // empty if block
        }
    }

    public boolean isSelected(Element element) {
        if (element == null || this.selectedComponents.isEmpty()) {
            return false;
        }
        for (SelectedComponent selectedComponent : this.selectedComponents) {
            if (selectedComponent.componentRootElement != element) continue;
            return true;
        }
        return false;
    }

    public boolean isBelowSelected(CssBox cssBox) {
        Element element;
        if (cssBox.getBoxType() == BoxType.TEXT) {
            cssBox = cssBox.getParent();
        }
        if (this.isSelected(element = CssBox.getElementForComponentRootCssBox(cssBox))) {
            return true;
        }
        return this.getSelectedAncestor(cssBox) != null;
    }

    public CssBox getSelectedAncestor(CssBox cssBox) {
        if (cssBox != null) {
            cssBox = cssBox.getParent();
        }
        while (cssBox != null) {
            Element element = CssBox.getElementForComponentRootCssBox(cssBox);
            if (this.isSelected(element)) {
                return cssBox;
            }
            cssBox = cssBox.getParent();
        }
        return null;
    }

    public Element getSelectedContainer() {
        for (SelectedComponent selectedComponent : this.selectedComponents) {
            if (!this.webform.getDomProviderService().isContainerTypeComponent(selectedComponent.componentRootElement)) continue;
            return selectedComponent.componentRootElement;
        }
        for (SelectedComponent selectedComponent : this.selectedComponents) {
            Element element = this.webform.getDomProviderService().getParentComponent(selectedComponent.componentRootElement);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    Element getPositionElement() {
        for (SelectedComponent selectedComponent : this.selectedComponents) {
            CssBox cssBox = ModelViewMapper.findBoxForComponentRootElement(this.webform.getPane().getPageBox(), selectedComponent.componentRootElement);
            if (cssBox == null || !cssBox.getBoxType().isPositioned()) continue;
            return CssBox.getElementForComponentRootCssBox(cssBox);
        }
        return null;
    }

    public void selectAll() {
        Element element = this.webform.getHtmlBody();
        if (element == null) {
            return;
        }
        this.clearSelection(false);
        Element[] elementArray = this.webform.getDomProviderService().getChildComponents(element);
        for (Element element2 : elementArray) {
            this.selectAll(element2);
        }
        if (!this.webform.isGridMode() && !this.selectedComponents.isEmpty()) {
            Element element3 = this.selectedComponents.get(0).componentRootElement;
            Element element4 = this.selectedComponents.get(this.selectedComponents.size() - 1).componentRootElement;
            if (element3 != null && HtmlTag.BR.name.equals(element3.getTagName())) {
                this.removeSelected(element3, false);
            }
            if (element4 != null && HtmlTag.BR.name.equals(element4.getTagName())) {
                this.removeSelected(element4, false);
            }
        }
        this.updateNodes();
        if (!this.selectedComponents.isEmpty()) {
            // empty if block
        }
        this.webform.getPane().repaint();
    }

    private void selectAll(Element element) {
        Element[] elementArray;
        if (!this.webform.getDomProviderService().isSpecialComponent(element)) {
            this.addSelected(element, false);
        }
        for (Element element2 : elementArray = this.webform.getDomProviderService().getChildComponents(element)) {
            this.selectAll(element2);
        }
    }

    public void selectComponentRectangle(Rectangle rectangle, boolean bl) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        DesignerPane designerPane = this.webform.getPane();
        SelectionManager.selectViews(designerPane.getPageBox(), arrayList, rectangle, bl, 0);
        this.clearSelection(false);
        for (Element element : arrayList) {
            this.addSelected(element, false);
        }
        this.updateNodes();
        designerPane.repaint();
    }

    private static void selectViews(CssBox cssBox, List<Element> list, Rectangle rectangle, boolean bl, int n) {
        Element element;
        if (DesignerUtils.intersects(rectangle, cssBox.getAbsoluteX(), cssBox.getAbsoluteY(), cssBox.getWidth(), cssBox.getHeight()) && (bl && rectangle.contains(cssBox.getAbsoluteX(), cssBox.getAbsoluteY(), cssBox.getWidth(), cssBox.getHeight()) || !bl && DesignerUtils.intersects(rectangle, cssBox.getAbsoluteX(), cssBox.getAbsoluteY(), cssBox.getWidth(), cssBox.getHeight())) && (element = CssBox.getElementForComponentRootCssBox(cssBox)) != null) {
            list.add(element);
        }
        int n2 = cssBox.getBoxCount();
        for (int i = 0; i < n2; ++i) {
            CssBox cssBox2 = cssBox.getBox(i);
            if (cssBox2 instanceof ExternalDocumentBox) continue;
            SelectionManager.selectViews(cssBox2, list, rectangle, bl, n + 1);
        }
    }

    public boolean focusDefaultProperty(ActionEvent actionEvent) {
        if (!this.selectedComponents.isEmpty()) {
            DesignerPane designerPane = this.webform.getPane();
            for (SelectedComponent selectedComponent : this.selectedComponents) {
                Node node;
                CssBox cssBox = ModelViewMapper.findBoxForComponentRootElement(this.webform.getPane().getPageBox(), selectedComponent.componentRootElement);
                boolean bl = this.webform.getManager().startInlineEditing(selectedComponent.componentRootElement, null, cssBox, true, false, actionEvent.getActionCommand(), false);
                if (bl) {
                    return true;
                }
                if (this.webform.getDomProviderService().hasDefaultProperty(selectedComponent.componentRootElement)) {
                    return this.webform.getDomProviderService().focusDefaultProperty(selectedComponent.componentRootElement, actionEvent.getActionCommand());
                }
                Element element = this.webform.getDomProviderService().getSourceElement(selectedComponent.componentRootElement);
                if (element == null || (node = SelectionManager.findFirstTextChild(element)) == null) continue;
                designerPane.createCaret();
                DomProvider.DomPosition domPosition = this.webform.createDomPosition(node, 0, DomProvider.DomPosition.Bias.FORWARD);
                designerPane.setCaretDot(domPosition);
                String string = actionEvent.getActionCommand();
                designerPane.replaceSelection(string);
                return true;
            }
        }
        return false;
    }

    private static Node findFirstTextChild(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = SelectionManager.findFirstTextChild(nodeList.item(i));
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    public int getSelectionHandleDir(int n, int n2, int n3, int n4) {
        for (SelectedComponent selectedComponent : this.selectedComponents) {
            List<Rectangle> list = ModelViewMapper.getComponentRectangles(this.webform.getPane().getPageBox(), selectedComponent.componentRootElement);
            for (int i = 0; i < list.size(); ++i) {
                int n5 = this.overSelection(n, n2, list.get(i), selectedComponent.resizeConstraints, n3, n4);
                if (n5 == 0) continue;
                return n5;
            }
        }
        return 0;
    }

    public Element getSelectionHandleView(int n, int n2, int n3, int n4) {
        for (SelectedComponent selectedComponent : this.selectedComponents) {
            List<Rectangle> list = ModelViewMapper.getComponentRectangles(this.webform.getPane().getPageBox(), selectedComponent.componentRootElement);
            for (Rectangle rectangle : list) {
                int n5 = this.overSelection(n, n2, rectangle, selectedComponent.resizeConstraints, n3, n4);
                if (n5 == 0) continue;
                return selectedComponent.componentRootElement;
            }
        }
        return null;
    }

    public boolean isSelectionEmpty() {
        return this.selectedComponents.isEmpty();
    }

    public int getNumSelected() {
        return this.selectedComponents.size();
    }

    public void selectComponents(final Element[] elementArray, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object object;
                SelectionManager.this.clearSelection(false);
                if (elementArray != null) {
                    object = elementArray;
                    int n = ((Element[])object).length;
                    for (int i = 0; i < n; ++i) {
                        Object object2 = object[i];
                        if (object2 == null) continue;
                        SelectionManager.this.addSelected((Element)object2, false);
                    }
                }
                if (bl) {
                    SelectionManager.this.updateNodes();
                }
                if ((object = SelectionManager.this.webform.getPane()) != null) {
                    ((DesignerPane)object).repaint();
                }
            }
        });
    }

    public void enlarge(Rectangle rectangle) {
        rectangle.x -= 6;
        rectangle.y -= 6;
        rectangle.width += 12;
        rectangle.height += 12;
    }

    private BasicStroke getSelectionStroke() {
        if (this.selStroke == null) {
            int n = 1;
            this.selStroke = new BasicStroke(n, 2, 0, 10.0f, new float[]{6 * n, 6 * n + n}, 0.0f);
        }
        return this.selStroke;
    }

    public void paintSelection(Graphics2D graphics2D) {
        if (this.webform.getManager().isInlineEditing()) {
            return;
        }
        if (!this.selectedComponents.isEmpty()) {
            Object object;
            boolean bl = this.selectedComponents.size() > 1;
            ColorManager colorManager = this.webform.getColors();
            PageBox pageBox = this.webform.getPane().getPageBox();
            int n = pageBox.getWidth();
            int n2 = pageBox.getHeight();
            if (this.primary != null && (object = this.webform.getComponentRootElementEquivalentTo(this.primary)) != null && object != this.primary) {
                this.primary = object;
            }
            for (SelectedComponent selectedComponent : this.selectedComponents) {
                Element element = this.webform.getComponentRootElementEquivalentTo(selectedComponent.componentRootElement);
                if (element != null && element != selectedComponent.componentRootElement) {
                    selectedComponent.componentRootElement = element;
                }
                List<Rectangle> list = ModelViewMapper.getComponentRectangles(pageBox, selectedComponent.componentRootElement);
                Rectangle rectangle = ModelViewMapper.getComponentBounds(pageBox, selectedComponent.componentRootElement);
                int n3 = list.size();
                if (n3 > 0) {
                    Rectangle rectangle2 = list.get(0);
                    if (rectangle2.x != rectangle.x || rectangle2.y != rectangle.y || rectangle2.width != rectangle.width || rectangle2.height != rectangle.height) {
                        graphics2D.setColor(colorManager.selectionBoundsColor);
                        Stroke stroke = graphics2D.getStroke();
                        BasicStroke basicStroke = this.getSelectionStroke();
                        graphics2D.setStroke(basicStroke);
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        graphics2D.setStroke(stroke);
                    }
                }
                for (int i = 0; i < n3; ++i) {
                    this.paintSelected(graphics2D, bl && selectedComponent.componentRootElement == this.primary, list.get(i), selectedComponent.resizeConstraints, n, n2);
                }
            }
        }
    }

    private void paintSelected(Graphics2D graphics2D, boolean bl, Rectangle rectangle, DomProviderService.ResizeConstraint[] resizeConstraintArray, int n, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (n3 < 6) {
            n5 -= 6 - n3;
            n3 = 6;
        }
        if (n4 < 6) {
            n6 -= 6 - n4;
            n4 = 6;
        }
        if (n3 + n5 + 5 > n) {
            n5 = n - 5 - n3;
        }
        if (n4 + n6 + 5 > n2) {
            n6 = n2 - 5 - n4;
        }
        int n7 = n5 / 2 - 2;
        int n8 = n6 / 2 - 2;
        ColorManager colorManager = this.webform.getColors();
        graphics2D.setColor(colorManager.selectionColor);
        graphics2D.drawRect(n3 - 5 - 1, n4 - 5 - 1, 5, 5);
        graphics2D.drawRect(n3 + n5, n4 - 5 - 1, 5, 5);
        graphics2D.drawRect(n3 + n5, n4 + n6, 5, 5);
        graphics2D.drawRect(n3 - 5 - 1, n4 + n6, 5, 5);
        if (Resizer.hasTopResizeConstraint(resizeConstraintArray)) {
            graphics2D.drawRect(n3 + n7, n4 - 5 - 1, 5, 5);
        }
        if (Resizer.hasLeftResizeConstraint(resizeConstraintArray)) {
            graphics2D.drawRect(n3 - 5 - 1, n4 + n8, 5, 5);
        }
        if (Resizer.hasBottomResizeConstraint(resizeConstraintArray)) {
            graphics2D.drawRect(n3 + n7, n4 + n6, 5, 5);
        }
        if (Resizer.hasRightResizeConstraint(resizeConstraintArray)) {
            graphics2D.drawRect(n3 + n5, n4 + n8, 5, 5);
        }
        graphics2D.setColor(colorManager.selectionColorReverse);
        graphics2D.drawRect(n3 - 5 - 1 + 1, n4 - 5 - 1 + 1, 3, 3);
        graphics2D.drawRect(n3 + n5 + 1, n4 - 5 - 1 + 1, 3, 3);
        graphics2D.drawRect(n3 + n5 + 1, n4 + n6 + 1, 3, 3);
        graphics2D.drawRect(n3 - 5 - 1 + 1, n4 + n6 + 1, 3, 3);
        if (Resizer.hasTopResizeConstraint(resizeConstraintArray)) {
            graphics2D.drawRect(n3 + n7 + 1, n4 - 5 - 1 + 1, 3, 3);
        }
        if (Resizer.hasLeftResizeConstraint(resizeConstraintArray)) {
            graphics2D.drawRect(n3 - 5 - 1 + 1, n4 + n8 + 1, 3, 3);
        }
        if (Resizer.hasBottomResizeConstraint(resizeConstraintArray)) {
            graphics2D.drawRect(n3 + n7 + 1, n4 + n6 + 1, 3, 3);
        }
        if (Resizer.hasRightResizeConstraint(resizeConstraintArray)) {
            graphics2D.drawRect(n3 + n5 + 1, n4 + n8 + 1, 3, 3);
        }
        if (bl) {
            graphics2D.setColor(colorManager.primaryColor);
            graphics2D.fillRect(n3 - 5 - 1 + 1, n4 - 5 - 1 + 1, 4, 4);
            graphics2D.fillRect(n3 + n5 + 1, n4 - 5 - 1 + 1, 4, 4);
            graphics2D.fillRect(n3 + n5 + 1, n4 + n6 + 1, 4, 4);
            graphics2D.fillRect(n3 - 5 - 1 + 1, n4 + n6 + 1, 4, 4);
            if (Resizer.hasTopResizeConstraint(resizeConstraintArray)) {
                graphics2D.drawRect(n3 + n7 + 1, n4 - 5 - 1 + 1, 3, 3);
            }
            if (Resizer.hasLeftResizeConstraint(resizeConstraintArray)) {
                graphics2D.drawRect(n3 - 5 - 1 + 1, n4 + n8 + 1, 3, 3);
            }
            if (Resizer.hasBottomResizeConstraint(resizeConstraintArray)) {
                graphics2D.drawRect(n3 + n7 + 1, n4 + n6 + 1, 3, 3);
            }
            if (Resizer.hasRightResizeConstraint(resizeConstraintArray)) {
                graphics2D.drawRect(n3 + n5 + 1, n4 + n8 + 1, 3, 3);
            }
        }
    }

    void paintInlineEditorBox(Graphics2D graphics2D, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (n < 6) {
            n3 -= 6 - n;
            n = 6;
        }
        if (n2 < 6) {
            n4 -= 6 - n2;
            n2 = 6;
        }
        PageBox pageBox = this.webform.getPane().getPageBox();
        int n5 = pageBox.getWidth();
        int n6 = pageBox.getHeight();
        if (n + n3 + 5 > n5) {
            n3 = n5 - 5 - n;
        }
        if (n2 + n4 + 5 > n6) {
            n4 = n6 - 5 - n2;
        }
        ColorManager colorManager = this.webform.getColors();
        graphics2D.setColor(colorManager.selectionColor);
        graphics2D.drawRect(n - 5 - 1, n2 - 5 - 1, 5, 5);
        graphics2D.drawRect(n + n3, n2 - 5 - 1, 5, 5);
        graphics2D.drawRect(n + n3, n2 + n4, 5, 5);
        graphics2D.drawRect(n - 5 - 1, n2 + n4, 5, 5);
        graphics2D.setColor(colorManager.selectionColorReverse);
        graphics2D.drawRect(n - 5 - 1 + 1, n2 - 5 - 1 + 1, 3, 3);
        graphics2D.drawRect(n + n3 + 1, n2 - 5 - 1 + 1, 3, 3);
        graphics2D.drawRect(n + n3 + 1, n2 + n4 + 1, 3, 3);
        graphics2D.drawRect(n - 5 - 1 + 1, n2 + n4 + 1, 3, 3);
        graphics2D.setColor(colorManager.insertColor);
        graphics2D.fillRect(n + 1, n2 - 5 - 1, n3 - 2, 5);
        graphics2D.fillRect(n + 1, n2 + n4 + 1, n3 - 2, 5);
        graphics2D.fillRect(n - 5 - 1, n2 + 1, 5, n4 - 2);
        graphics2D.fillRect(n + n3 + 1, n2 + 1, 5, n4 - 2);
    }

    private int overSelection(int n, int n2, Rectangle rectangle, DomProviderService.ResizeConstraint[] resizeConstraintArray, int n3, int n4) {
        if (n2 >= this.selectionViewPos) {
            return 0;
        }
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        if (n5 < 6) {
            n7 -= 6 - n5;
            n5 = 6;
        }
        if (n6 < 6) {
            n8 -= 6 - n6;
            n6 = 6;
        }
        if (n < n5 - 5 - 1) {
            return 0;
        }
        if (n2 < n6 - 5 - 1) {
            return 0;
        }
        if (n5 + n7 + 5 > n3) {
            n7 = n3 - 5 - n5;
        }
        if (n6 + n8 + 5 > n4) {
            n8 = n4 - 5 - n6;
        }
        if (n > n5 + n7 + 5) {
            return 0;
        }
        if (n2 > n6 + n8 + 5) {
            return 0;
        }
        if (DesignerUtils.inside(n, n2, n5 - 5 - 1, n6 - 5 - 1, 5, 5)) {
            if (Resizer.hasTopResizeConstraint(resizeConstraintArray) && Resizer.hasLeftResizeConstraint(resizeConstraintArray)) {
                return 6;
            }
            if (Resizer.hasTopResizeConstraint(resizeConstraintArray)) {
                return 8;
            }
            if (Resizer.hasLeftResizeConstraint(resizeConstraintArray)) {
                return 10;
            }
        }
        if (DesignerUtils.inside(n, n2, n5 + n7, n6 - 5 - 1, 5, 5)) {
            if (Resizer.hasTopResizeConstraint(resizeConstraintArray) && Resizer.hasRightResizeConstraint(resizeConstraintArray)) {
                return 7;
            }
            if (Resizer.hasTopResizeConstraint(resizeConstraintArray)) {
                return 8;
            }
            if (Resizer.hasRightResizeConstraint(resizeConstraintArray)) {
                return 11;
            }
        }
        if (DesignerUtils.inside(n, n2, n5 + n7, n6 + n8, 5, 5)) {
            if (Resizer.hasBottomResizeConstraint(resizeConstraintArray) && Resizer.hasRightResizeConstraint(resizeConstraintArray)) {
                return 5;
            }
            if (Resizer.hasBottomResizeConstraint(resizeConstraintArray)) {
                return 9;
            }
            if (Resizer.hasRightResizeConstraint(resizeConstraintArray)) {
                return 11;
            }
        }
        if (DesignerUtils.inside(n, n2, n5 - 5 - 1, n6 + n8, 5, 5)) {
            if (Resizer.hasBottomResizeConstraint(resizeConstraintArray) && Resizer.hasLeftResizeConstraint(resizeConstraintArray)) {
                return 4;
            }
            if (Resizer.hasBottomResizeConstraint(resizeConstraintArray)) {
                return 9;
            }
            if (Resizer.hasLeftResizeConstraint(resizeConstraintArray)) {
                return 10;
            }
        }
        if (this.webform.getManager().isInlineEditing() && DesignerUtils.inside(n, n2, n5 - 5 - 1, n6 - 5 - 1, n7 + 10, n8 + 10) && !DesignerUtils.inside(n, n2, n5, n6, n7, n8)) {
            return 13;
        }
        int n9 = n7 / 2 - 2;
        int n10 = n8 / 2 - 2;
        if (Resizer.hasTopResizeConstraint(resizeConstraintArray) && DesignerUtils.inside(n, n2, n5 + n9 - 2, n6 - 5 - 1, 5, 5)) {
            return 8;
        }
        if (Resizer.hasLeftResizeConstraint(resizeConstraintArray) && DesignerUtils.inside(n, n2, n5 - 5 - 1, n6 + n10 - 2, 5, 5)) {
            return 10;
        }
        if (Resizer.hasBottomResizeConstraint(resizeConstraintArray) && DesignerUtils.inside(n, n2, n5 + n9 - 2, n6 + n8, 5, 5)) {
            return 9;
        }
        if (Resizer.hasRightResizeConstraint(resizeConstraintArray) && DesignerUtils.inside(n, n2, n5 + n7, n6 + n10 - 2, 5, 5)) {
            return 11;
        }
        return 0;
    }

    public void paintSelHierarchy(Graphics2D graphics2D) {
        if (!PAINT_SELECTION_HIERARCHY) {
            return;
        }
        if (this.isSelectionEmpty()) {
            return;
        }
        PageBox pageBox = this.webform.getPane().getPageBox();
        if (pageBox == null) {
            return;
        }
        JViewport jViewport = pageBox.getViewport();
        Dimension dimension = jViewport.getExtentSize();
        Point point = jViewport.getViewPosition();
        FontMetrics fontMetrics = this.webform.getPane().getMetrics();
        FontMetrics fontMetrics2 = this.webform.getPane().getBoldMetrics();
        int n = fontMetrics.getHeight() + 1;
        int n2 = 1;
        int n3 = point.y + dimension.height - n;
        int n4 = n3 + fontMetrics.getHeight() - fontMetrics.getDescent();
        this.selectionViewPos = n3;
        ColorManager colorManager = this.webform.getColors();
        graphics2D.setColor(colorManager.hierarchyBackgroundColor);
        graphics2D.fillRect(n2, n3, dimension.width, n);
        graphics2D.setColor(colorManager.hierarchyForegroundColor);
        Iterator<SelectedComponent> iterator = this.selectedComponents.iterator();
        assert (iterator.hasNext());
        SelectedComponent selectedComponent = iterator.next();
        if (this.leaf == null) {
            this.leaf = selectedComponent.componentRootElement;
        }
        this.paintOrSelectAncestor(graphics2D, fontMetrics, fontMetrics2, this.leaf, n2, n3, n4, selectedComponent.componentRootElement, -1);
    }

    public void notifyScrolled() {
        if (!PAINT_SELECTION_HIERARCHY) {
            return;
        }
        if (this.isSelectionEmpty()) {
            return;
        }
        PageBox pageBox = this.webform.getPane().getPageBox();
        if (pageBox == null) {
            return;
        }
        JViewport jViewport = pageBox.getViewport();
        Point point = jViewport.getViewPosition();
        Dimension dimension = jViewport.getExtentSize();
        FontMetrics fontMetrics = this.webform.getPane().getMetrics();
        int n = fontMetrics.getHeight() + 1;
        int n2 = point.y + dimension.height - n;
        if (n2 != this.selectionViewPos) {
            this.webform.getPane().repaint();
        }
    }

    private int paintOrSelectAncestor(Graphics2D graphics2D, FontMetrics fontMetrics, FontMetrics fontMetrics2, Element element, int n, int n2, int n3, Element element2, int n4) {
        Image image;
        if (!this.webform.getDomProviderService().isSpecialComponent(element) && (n = this.paintOrSelectAncestor(graphics2D, fontMetrics, fontMetrics2, this.webform.getDomProviderService().getParentComponent(element), n, n2, n3, element2, n4)) < 0) {
            return n;
        }
        String string = this.webform.getDomProviderService().getInstanceName(element);
        if (string == null) {
            string = "<unknown>";
        }
        if (graphics2D != null) {
            if (element == element2) {
                graphics2D.setFont(fontMetrics2.getFont());
            } else {
                graphics2D.setFont(fontMetrics.getFont());
            }
        }
        if (this.paintBeanIcon && (image = this.webform.getDomProviderService().getIcon(element)) != null) {
            if (graphics2D != null) {
                float f = n;
                float f2 = n2;
                this.transform.setToTranslation(f, f2);
                graphics2D.drawImage(image, this.transform, null);
            }
            n += 18;
        }
        if (graphics2D != null) {
            graphics2D.drawString(string, n, n3);
        }
        n = element == element2 ? (n += fontMetrics2.stringWidth(string)) : (n += fontMetrics.stringWidth(string));
        if (graphics2D == null && (n += 5) > n4) {
            this.setSelected(element, true);
            return -1;
        }
        return n;
    }

    void selectAncestor(int n, int n2) {
        if (this.isSelectionEmpty()) {
            return;
        }
        PageBox pageBox = this.webform.getPane().getPageBox();
        if (pageBox == null) {
            return;
        }
        FontMetrics fontMetrics = this.webform.getPane().getMetrics();
        FontMetrics fontMetrics2 = this.webform.getPane().getBoldMetrics();
        int n3 = 1;
        int n4 = this.selectionViewPos;
        int n5 = n4 + fontMetrics.getHeight() - fontMetrics.getDescent();
        Iterator<SelectedComponent> iterator = this.selectedComponents.iterator();
        assert (iterator.hasNext());
        SelectedComponent selectedComponent = iterator.next();
        if (this.leaf == null) {
            this.leaf = selectedComponent.componentRootElement;
        }
        this.paintOrSelectAncestor(null, fontMetrics, fontMetrics2, this.leaf, n3, n4, n5, selectedComponent.componentRootElement, n);
    }

    public void updateNodes() {
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
            this.refreshTimer = null;
        }
        this.refreshTimer = new Timer(300, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionManager.this.refreshTimer = null;
                SelectionManager.this.updateNodesImmediate();
            }
        });
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.refreshTimer.start();
    }

    public boolean isNodeUpdatePending() {
        return this.refreshTimer != null;
    }

    public void updateNodesImmediate() {
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
            this.refreshTimer = null;
        }
        this.webform.fireSelectionChanged(new SelectionDesignerEvent(this.webform));
    }

    public Element getPrimary() {
        return this.primary;
    }

    public void setPrimary(Element element) {
        this.primary = element;
    }

    public void pickPrimary() {
        if (this.primary == null && !this.selectedComponents.isEmpty()) {
            Iterator<SelectedComponent> iterator = this.selectedComponents.iterator();
            SelectedComponent selectedComponent = iterator.next();
            this.primary = selectedComponent.componentRootElement;
        }
    }

    public Element[] getSelectedComponentRootElements() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        ArrayList<SelectedComponent> arrayList2 = new ArrayList<SelectedComponent>(this.selectedComponents);
        for (SelectedComponent selectedComponent : arrayList2) {
            Element element;
            if (selectedComponent == null || (element = selectedComponent.componentRootElement) == null) continue;
            arrayList.add(element);
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    void selectBean(Element element) {
        if (element != null) {
            this.selectComponents(new Element[]{element}, true);
        }
    }

    void selectComponent(Element element) {
        if (element == null) {
            return;
        }
        CssBox cssBox = ModelViewMapper.findBox(this.webform.getPane().getPageBox(), element);
        if (cssBox != null) {
            this.selectComponents(new Element[]{element}, true);
        }
    }

    private static class SelectedComponent {
        private Element componentRootElement;
        private DomProviderService.ResizeConstraint[] resizeConstraints;

        private SelectedComponent() {
        }

        static /* synthetic */ DomProviderService.ResizeConstraint[] access$202(SelectedComponent selectedComponent, DomProviderService.ResizeConstraint[] resizeConstraintArray) {
            selectedComponent.resizeConstraints = resizeConstraintArray;
            return resizeConstraintArray;
        }
    }

    private static class SelectionDesignerEvent
    implements Designer.DesignerEvent {
        private final WebForm webForm;

        public SelectionDesignerEvent(WebForm webForm) {
            this.webForm = webForm;
        }

        public Designer getDesigner() {
            return this.webForm;
        }

        public Designer.Box getBox() {
            return null;
        }
    }
}

