/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.util;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.modules.sun.manager.jbi.util.ComparableAttribute;
import org.openide.util.ImageUtilities;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static Image getBadgedIcon(Class clazz, String string, String string2, String string3) {
        Image image;
        Image image2 = new ImageIcon(clazz.getResource(string)).getImage();
        if (string2 != null) {
            image = new ImageIcon(clazz.getResource(string2)).getImage();
            image2 = ImageUtilities.mergeImages((Image)image2, (Image)image, (int)7, (int)7);
        }
        if (string3 != null) {
            image = new ImageIcon(clazz.getResource(string3)).getImage();
            image2 = ImageUtilities.mergeImages((Image)image2, (Image)image, (int)15, (int)8);
        }
        return image2;
    }

    public static void runInEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static Map<Attribute, MBeanAttributeInfo> getIntrospectedPropertyMap(Object object, boolean bl) {
        return Utils.getIntrospectedPropertyMap(object, bl, null);
    }

    public static Map<Attribute, MBeanAttributeInfo> getIntrospectedPropertyMap(Object object, boolean bl, String string) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        BeanInfo beanInfo = null;
        try {
            if (string != null) {
                Introspector.setBeanInfoSearchPath(new String[]{string});
            }
            beanInfo = Introspector.getBeanInfo(clazz, Object.class);
        }
        catch (IntrospectionException introspectionException) {
            System.err.println("Couldn't introspect " + clazz.getName());
            return null;
        }
        TreeMap<Attribute, MBeanAttributeInfo> treeMap = bl ? new TreeMap() : new LinkedHashMap();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Class<?> clazz2 = propertyDescriptorArray[i].getPropertyType();
            Method method = propertyDescriptorArray[i].getReadMethod();
            Method method2 = propertyDescriptorArray[i].getWriteMethod();
            String string2 = clazz2.getName();
            String string3 = propertyDescriptorArray[i].getName();
            String string4 = propertyDescriptorArray[i].getShortDescription();
            Object object2 = null;
            try {
                object2 = method.invoke(object, (Object[])null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Attribute attribute = new Attribute(string3, object2);
            if (bl) {
                attribute = new ComparableAttribute(attribute);
            }
            treeMap.put(attribute, new MBeanAttributeInfo(string3, string2, string4, method != null, method2 != null, method.getName().startsWith("is")));
        }
        return treeMap;
    }

    public static String wordWrapString(String string, int n, String string2) {
        String string3 = "";
        String string4 = "(.{1," + n + "}$)|" + "(.{1," + n + "}\\b\\s*)|(.{" + n + "}\\B)";
        Pattern pattern = Pattern.compile(string4);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string3 = string3 + string.substring(matcher.start(), matcher.end());
            string3 = string3 + string2;
        }
        return string3;
    }

    public static String getTooltip(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() > 80) {
            String string2 = "<HTML>";
            string2 = string2 + Utils.wordWrapString(string, 80, "<br>");
            string2 = string2 + "</HTML>";
            return string2;
        }
        return string;
    }

    private static Document getDocument(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            System.out.println("Error parsing XML string: " + exception);
            return null;
        }
    }
}

