/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.Node;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.FunctionElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionAstElement
extends AstElement
implements FunctionElement {
    private FunctionNode func;
    private List<String> parameters;
    private String extend;

    FunctionAstElement(CompilationInfo compilationInfo, FunctionNode functionNode) {
        super(compilationInfo, (Node)functionNode);
        this.func = functionNode;
    }

    @Override
    public String toString() {
        return "JsFunctionElement:" + this.getSignature();
    }

    @Override
    public String getSignature() {
        if (this.signature == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getIn();
            if (string != null && string.length() > 0) {
                stringBuilder.append(string);
                stringBuilder.append(".");
            }
            stringBuilder.append(this.getName());
            stringBuilder.append("(");
            int n = this.func.getParamCount();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.func.getParamOrVarName(i));
            }
            stringBuilder.append(")");
            this.signature = stringBuilder.toString();
        }
        return this.signature;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.func.getFunctionName();
            if (this.name == null || this.name.length() == 0) {
                this.name = "<default>";
            } else {
                int n = this.name.lastIndexOf(46);
                if (n != -1) {
                    this.name = this.name.substring(n + 1);
                }
            }
        }
        return this.name;
    }

    @Override
    public String getIn() {
        if (this.in == null) {
            int n;
            this.in = "";
            String string = this.func.getFunctionName();
            if (string != null && string.length() > 0 && (n = string.lastIndexOf(46)) != -1) {
                this.in = string.substring(0, n);
                if ("Element.Methods".equals(this.in)) {
                    this.in = "Element";
                }
            }
        }
        return this.in;
    }

    @Override
    public List<String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>(this.func.getParamCount());
            int n = this.func.getParamCount();
            for (int i = 0; i < n; ++i) {
                this.parameters.add(this.func.getParamOrVarName(i));
            }
        }
        return this.parameters;
    }

    @Override
    public ElementKind getKind() {
        if (this.kind == null) {
            if (Character.isUpperCase(this.getName().charAt(0))) {
                this.kind = ElementKind.CONSTRUCTOR;
            } else if (this.getName().equals("initialize")) {
                this.kind = ElementKind.CONSTRUCTOR;
            } else {
                return ElementKind.METHOD;
            }
        }
        return this.kind;
    }

    public void setExtends(String string) {
        this.extend = string;
    }

    public String getExtends() {
        return this.extend;
    }
}

