/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.spi.DefaultParserFile;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.IndexedFunction;
import org.netbeans.modules.javascript.editing.IndexedPackage;
import org.netbeans.modules.javascript.editing.IndexedProperty;
import org.netbeans.modules.javascript.editing.JsElement;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexedElement
extends JsElement {
    protected ElementKind kind;
    protected String fqn;
    protected String name;
    protected String in;
    protected JsIndex index;
    protected String fileUrl;
    protected Document document;
    protected FileObject fileObject;
    protected int flags;
    protected String attributes;
    protected EnumSet<BrowserVersion> compatibility;
    protected String signature;
    protected boolean smart;
    protected boolean inherited = true;
    protected static final int NAME_INDEX = 0;
    protected static final int IN_INDEX = 1;
    protected static final int CASE_SENSITIVE_INDEX = 2;
    protected static final int FLAG_INDEX = 3;
    protected static final int ARG_INDEX = 4;
    protected static final int NODE_INDEX = 5;
    protected static final int DOC_INDEX = 6;
    protected static final int BROWSER_INDEX = 7;
    protected static final int TYPE_INDEX = 8;
    public static final int DOCUMENTED = 1;
    public static final int PRIVATE = 4;
    public static final int FUNCTION = 8;
    public static final int STATIC = 16;
    public static final int NODOC = 32;
    public static final int GLOBAL = 64;
    public static final int CONSTRUCTOR = 128;
    public static final int DEPRECATED = 256;
    public static final int DOC_ONLY = 512;
    public static final int FINAL = 1024;

    IndexedElement(String string, String string2, String string3, JsIndex jsIndex, String string4, String string5, int n, ElementKind elementKind) {
        this.fqn = string;
        this.name = string2;
        this.in = string3;
        this.index = jsIndex;
        this.fileUrl = string4;
        this.attributes = string5;
        this.flags = n;
        this.kind = elementKind;
    }

    static IndexedElement create(String string, String string2, String string3, String string4, String string5, int n, JsIndex jsIndex, boolean bl) {
        int n2 = IndexedElement.decode(string, n, 0);
        if (bl) {
            IndexedPackage indexedPackage = new IndexedPackage(string3, string4, string5, jsIndex, string2, string, n2, ElementKind.PACKAGE);
            return indexedPackage;
        }
        if ((n2 & 8) != 0) {
            ElementKind elementKind = (n2 & 0x80) != 0 ? ElementKind.CONSTRUCTOR : ElementKind.METHOD;
            IndexedFunction indexedFunction = new IndexedFunction(string3, string4, string5, jsIndex, string2, string, n2, elementKind);
            return indexedFunction;
        }
        if ((n2 & 0x40) != 0) {
            ElementKind elementKind = Character.isUpperCase(string4.charAt(0)) ? ElementKind.CLASS : ElementKind.GLOBAL;
            IndexedProperty indexedProperty = new IndexedProperty(string3, string4, string5, jsIndex, string2, string, n2, elementKind);
            return indexedProperty;
        }
        IndexedProperty indexedProperty = new IndexedProperty(string3, string4, string5, jsIndex, string2, string, n2, ElementKind.PROPERTY);
        return indexedProperty;
    }

    static IndexedElement create(String string, String string2, String string3, JsIndex jsIndex, boolean bl) {
        int n;
        String string4 = null;
        int n2 = string2.indexOf(59);
        assert (n2 != -1);
        string4 = string2.substring(0, n2);
        String string5 = null;
        int n3 = string2.indexOf(59, ++n2);
        assert (n3 != -1);
        if (n3 > n2 + 1) {
            string5 = string2.substring(n2, n3);
        }
        int n4 = ++n3;
        n3 = string2.indexOf(59, n4);
        assert (n3 != -1);
        if (n3 > n4) {
            string4 = string2.substring(n4, n3);
        }
        ++n3;
        String string6 = null;
        int n5 = string4.lastIndexOf(46);
        if (string.length() < n5 && (n = string4.indexOf(46, string.length())) != -1) {
            String string7 = string4.substring(0, n);
            IndexedPackage indexedPackage = new IndexedPackage(null, string7, string6, jsIndex, string3, string2, IndexedElement.decode(string2, n3, 0), ElementKind.PACKAGE);
            return indexedPackage;
        }
        IndexedElement indexedElement = IndexedElement.create(string2, string3, string6, string4, string5, n3, jsIndex, bl);
        return indexedElement;
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.in != null) {
                stringBuilder.append(this.in);
                stringBuilder.append('.');
            }
            stringBuilder.append(this.name);
            this.signature = stringBuilder.toString();
        }
        return this.signature;
    }

    public JsIndex getIndex() {
        return this.index;
    }

    @Override
    public String getFqn() {
        if (this.fqn == null) {
            this.fqn = this.in != null && this.in.length() > 0 ? this.in + "." + this.name : this.name;
        }
        return this.fqn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIn() {
        return this.in;
    }

    void setKind(ElementKind elementKind) {
        this.kind = elementKind;
    }

    @Override
    public ElementKind getKind() {
        return this.kind;
    }

    @Override
    public Set<Modifier> getModifiers() {
        if (this.isStatic()) {
            if (this.isPrivate()) {
                return AstElement.STATIC_PRIVATE;
            }
            return AstElement.STATIC;
        }
        if (this.isPrivate()) {
            return AstElement.PRIVATE;
        }
        return Collections.emptySet();
    }

    public String getFilenameUrl() {
        return this.fileUrl;
    }

    public Document getDocument() {
        if (this.document == null) {
            FileObject fileObject = this.getFileObject();
            if (fileObject == null) {
                return null;
            }
            this.document = GsfUtilities.getDocument((FileObject)this.fileObject, (boolean)true);
        }
        return this.document;
    }

    public ParserFile getFile() {
        boolean bl = false;
        return new DefaultParserFile(this.getFileObject(), null, bl);
    }

    @Override
    public FileObject getFileObject() {
        if (this.fileObject == null && this.fileUrl != null) {
            this.fileObject = JsIndex.getFileObject(this.fileUrl);
            if (this.fileObject == null) {
                this.fileUrl = null;
            }
        }
        return this.fileObject;
    }

    protected int getAttributeSection(int n) {
        assert (n != 0);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = this.attributes.indexOf(59, n2 + 1);
        }
        assert (n2 != -1);
        return n2 + 1;
    }

    int getDocOffset() {
        int n = this.getAttributeSection(6);
        if (n != -1) {
            int n2 = IndexedElement.decode(this.attributes, n, -1);
            return n2;
        }
        return -1;
    }

    protected int getNodeOffset() {
        int n = this.getAttributeSection(5);
        if (n != -1) {
            return IndexedElement.decode(this.attributes, n, -1);
        }
        return -1;
    }

    protected List<String> getComments() {
        int n = this.getAttributeSection(6);
        if (n != -1) {
            int n2 = IndexedElement.decode(this.attributes, n, -1);
            if (n2 == -1) {
                return null;
            }
            try {
                BaseDocument baseDocument = (BaseDocument)this.getDocument();
                if (baseDocument == null) {
                    return null;
                }
                if (n2 < baseDocument.getLength()) {
                    OffsetRange offsetRange = LexUtilities.getCommentBlock(baseDocument, n2, false);
                    if (offsetRange != OffsetRange.NONE) {
                        String string = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength());
                        String[] stringArray = string.split("\n");
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int n3 = stringArray.length;
                        for (int i = 0; i < n3; ++i) {
                            String string2 = stringArray[i];
                            string2 = string2.trim();
                            if (i == n3 - 1 && string2.endsWith("*/")) {
                                string2 = string2.substring(0, string2.length() - 2);
                            }
                            if (string2.startsWith("/**")) {
                                arrayList.add(string2.substring(3));
                                continue;
                            }
                            if (string2.startsWith("/*")) {
                                arrayList.add(string2.substring(2));
                                continue;
                            }
                            if (string2.startsWith("//")) {
                                arrayList.add(string2.substring(2));
                                continue;
                            }
                            if (string2.startsWith("*")) {
                                arrayList.add(string2.substring(1));
                                continue;
                            }
                            arrayList.add(string2);
                        }
                        return arrayList;
                    }
                    return Collections.emptyList();
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return null;
    }

    public EnumSet<BrowserVersion> getCompatibility() {
        if (this.compatibility == null) {
            int n = this.getAttributeSection(7);
            if (n != -1) {
                int n2 = this.attributes.indexOf(59, n);
                assert (n2 != -1);
                if (n2 == n) {
                    return BrowserVersion.ALL;
                }
                String string = this.attributes.substring(n, n2);
                this.compatibility = BrowserVersion.fromCompactFlags(string);
            } else {
                this.compatibility = BrowserVersion.ALL;
            }
        }
        return this.compatibility;
    }

    public String getType() {
        if (this.kind == ElementKind.CLASS || this.kind == ElementKind.PACKAGE) {
            return null;
        }
        int n = this.getAttributeSection(8);
        int n2 = this.attributes.indexOf(59, n);
        if (n2 > n) {
            return this.attributes.substring(n, n2);
        }
        return null;
    }

    public void setSmart(boolean bl) {
        this.smart = bl;
    }

    public boolean isSmart() {
        return this.smart;
    }

    public void setInherited(boolean bl) {
        this.inherited = bl;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public IndexedElement findDocumentedSibling() {
        if (!this.isDocumented()) {
            String string = null;
            String string2 = this.getFqn();
            if (string2.indexOf(46) == -1) {
                string = string2;
                string2 = null;
            }
            Set<IndexedElement> set = this.getIndex().getAllElements(string, string2, NameKind.EXACT_NAME, JsIndex.ALL_SCOPE, null);
            for (IndexedElement indexedElement : set) {
                if (!indexedElement.isDocumented()) continue;
                return indexedElement;
            }
        }
        return null;
    }

    public IndexedElement findRealFileElement() {
        if (this.isDocOnly()) {
            String string = null;
            String string2 = this.getFqn();
            if (string2.indexOf(46) == -1) {
                string = string2;
                string2 = null;
            }
            Set<IndexedElement> set = this.getIndex().getAllElements(string, string2, NameKind.EXACT_NAME, JsIndex.ALL_SCOPE, null);
            for (IndexedElement indexedElement : set) {
                if (indexedElement.isDocOnly()) continue;
                return indexedElement;
            }
        }
        return null;
    }

    public static String encode(int n) {
        return Integer.toString(n, 16);
    }

    public static int decode(String string, int n, int n2) {
        int n3 = 0;
        int n4 = string.length();
        for (int i = n; i < n4; ++i) {
            char c = string.charAt(i);
            if (c == ';') {
                if (i != n) break;
                return n2;
            }
            n3 <<= 4;
            if (c > '9') {
                n3 += c - 97 + 10;
                continue;
            }
            n3 += c - 48;
        }
        return n3;
    }

    public static int getFlags(AstElement astElement) {
        int n = 0;
        ElementKind elementKind = astElement.getKind();
        if (elementKind == ElementKind.CONSTRUCTOR) {
            n |= 0x80;
        }
        if (elementKind == ElementKind.METHOD || elementKind == ElementKind.CONSTRUCTOR) {
            n |= 8;
        } else if (elementKind == ElementKind.GLOBAL) {
            n |= 0x40;
        }
        if (astElement.getModifiers().contains(Modifier.STATIC)) {
            n |= 0x10;
        }
        if (astElement.getModifiers().contains(Modifier.DEPRECATED)) {
            n |= 0x100;
        }
        if (astElement.getModifiers().contains(Modifier.PRIVATE)) {
            n |= 4;
        }
        return n;
    }

    public boolean isDocumented() {
        return (this.flags & 1) != 0;
    }

    public boolean isPublic() {
        return (this.flags & 4) == 0;
    }

    public boolean isPrivate() {
        return (this.flags & 4) != 0;
    }

    public boolean isFunction() {
        return (this.flags & 8) != 0;
    }

    public boolean isStatic() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isNoDoc() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isFinal() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isConstructor() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isDeprecated() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isDocOnly() {
        return (this.flags & 0x200) != 0;
    }

    public static String decodeFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 1) != 0) {
            stringBuilder.append("|DOCUMENTED");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("|PRIVATE");
        }
        if ((n & 0x80) != 0) {
            stringBuilder.append("|CONSTRUCTOR");
        } else if ((n & 8) != 0) {
            stringBuilder.append("|FUNCTION");
        } else if ((n & 0x40) != 0) {
            stringBuilder.append("|GLOBAL");
        } else {
            stringBuilder.append("|PROPERTY");
        }
        if ((n & 0x10) != 0) {
            stringBuilder.append("|STATIC");
        }
        if ((n & 0x20) != 0) {
            stringBuilder.append("|NODOC");
        }
        if ((n & 0x100) != 0) {
            stringBuilder.append("|DEPRECATED");
        }
        if ((n & 0x200) != 0) {
            stringBuilder.append("|DOC_ONLY");
        }
        if ((n & 0x400) != 0) {
            stringBuilder.append("|FINAL");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IndexedElement indexedElement = (IndexedElement)object;
        if (!this.getSignature().equals(indexedElement.getSignature())) {
            return false;
        }
        return this.getKind().equals((Object)indexedElement.getKind());
    }

    public int hashCode() {
        int n = 7;
        n = 53 * n + this.getSignature().hashCode();
        n = 53 * n + this.getKind().hashCode();
        return n;
    }

    public String getOrigin() {
        String string = this.getFilenameUrl();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n == -1) {
                return null;
            }
            if (string.startsWith("stub_core", ++n)) {
                return "Core JS";
            }
            if (string.startsWith("stub_", n)) {
                return "DOM";
            }
            if (string.startsWith("jquery", n)) {
                return "jQuery";
            }
            if (string.startsWith("dojo", n)) {
                return "dojo";
            }
            if (string.startsWith("yui", n)) {
                return "YUI";
            }
        }
        return null;
    }
}

