/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsOccurrenceFinder
implements OccurrencesFinder {
    private boolean cancelled;
    private int caretPosition;
    private Map<OffsetRange, ColoringAttributes> occurrences;
    private FileObject file;

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.occurrences;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    public void setCaretPosition(int n) {
        this.caretPosition = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo compilationInfo) {
        Object object2;
        JsParseResult jsParseResult;
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        FileObject fileObject = compilationInfo.getFileObject();
        if (fileObject != this.file) {
            this.occurrences = null;
            this.file = fileObject;
        }
        if ((jsParseResult = AstUtilities.getParseResult(compilationInfo)) == null) {
            return;
        }
        Node node = jsParseResult.getRootNode();
        if (node == null) {
            return;
        }
        Object object3 = new HashMap(100);
        int n = AstUtilities.getAstOffset(compilationInfo, this.caretPosition);
        if (n == -1) {
            return;
        }
        AstPath astPath = new AstPath(node, n);
        Node node2 = astPath.leaf();
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        OffsetRange offsetRange2 = jsParseResult.getSanitizedRange();
        if (offsetRange2.containsInclusive(n)) {
            node2 = null;
        }
        if (node2 != null) {
            object2 = (BaseDocument)compilationInfo.getDocument();
            if (object2 == null) {
                return;
            }
            try {
                boolean bl;
                Token<? extends JsTokenId> token;
                object2.readLock();
                int n2 = object2.getLength();
                OffsetRange object4 = AstUtilities.getRange(node2);
                OffsetRange offsetRange = LexUtilities.getLexerOffsets(compilationInfo, object4);
                int n3 = offsetRange.getStart();
                int n4 = offsetRange.getEnd();
                if (n3 > n2) {
                    n3 = n2;
                }
                if (n4 > n2) {
                    n4 = n2;
                }
                boolean bl2 = (token = LexUtilities.getToken((BaseDocument)object2, this.caretPosition)) != null && token.id() == JsTokenId.FUNCTION;
                boolean bl3 = node2.getType() == 156;
                boolean bl4 = bl = node2.getType() == 4 && n < node2.getSourceStart() + "return".length();
                if (bl2 || bl3 || bl) {
                    Node node3 = node2;
                    if (bl2) {
                        int n5 = n + "function".length();
                        astPath = new AstPath(node, n5);
                        node3 = astPath.leaf();
                        if (node3.getType() == 155) {
                            node3 = node3.getParentNode();
                        }
                    } else if (node3.getType() == 156) {
                        node3 = node3.getParentNode();
                    } else if (bl) {
                        Node node4;
                        for (node4 = node3.getParentNode(); node4 != null && node4.getType() != 105; node4 = node4.getParentNode()) {
                        }
                        if (node4 != null) {
                            node3 = node4;
                        }
                    }
                    this.highlightExits(node3, (Map<OffsetRange, ColoringAttributes>)object3, compilationInfo);
                    node2 = null;
                } else if (node2.getType() == 37 && n3 != -1 && n4 != -1 && Utilities.getRowStart((BaseDocument)object2, (int)n3) != Utilities.getRowStart((BaseDocument)object2, (int)n4)) {
                    node2 = null;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                object2.readUnlock();
            }
        }
        if (node2 != null && AstUtilities.isNameNode(node2)) {
            object2 = node2.getString();
            List<Node> list = variableVisitor.getVarOccurrences(node2);
            if (list != null) {
                for (Node node5 : list) {
                    OffsetRange offsetRange = AstUtilities.getNameRange(node5);
                    object3.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
                }
            } else {
                Node node6 = variableVisitor.getDefiningScope(node2);
                this.addNodes(node6 != null ? node6 : node, (String)object2, (Map<OffsetRange, ColoringAttributes>)object3);
            }
            node2 = null;
        }
        if (this.isCancelled()) {
            return;
        }
        if (object3.size() > 0) {
            if (jsParseResult.getTranslatedSource() != null) {
                object2 = new HashMap(2 * object3.size());
                for (Map.Entry entry : object3.entrySet()) {
                    OffsetRange offsetRange = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)entry.getKey());
                    if (offsetRange == OffsetRange.NONE) continue;
                    object2.put(offsetRange, entry.getValue());
                }
                object3 = object2;
            }
            this.occurrences = object3;
        } else {
            this.occurrences = null;
        }
    }

    private void addNodes(Node node, String string, Map<OffsetRange, ColoringAttributes> map) {
        Node node2;
        if (AstUtilities.isNameNode(node) && string.equals(node.getString())) {
            node2 = AstUtilities.getNameRange(node);
            map.put((OffsetRange)node2, ColoringAttributes.MARK_OCCURRENCES);
        }
        if (node.hasChildren()) {
            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                this.addNodes(node2, string, map);
            }
        }
    }

    private void highlightExits(Node node, Map<OffsetRange, ColoringAttributes> map, CompilationInfo compilationInfo) {
        if (node.hasChildren()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                this.highlightExitPoints(node2, map, compilationInfo);
            }
        }
    }

    private void highlightExitPoints(Node node, Map<OffsetRange, ColoringAttributes> map, CompilationInfo compilationInfo) {
        OffsetRange offsetRange;
        int n = node.getType();
        if (n == 49 || n == 50 || n == 4 && node.getSourceEnd() > node.getSourceStart()) {
            offsetRange = AstUtilities.getRange(node);
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            if (baseDocument != null) {
                try {
                    int n2;
                    int n3;
                    OffsetRange offsetRange2 = LexUtilities.getLexerOffsets(compilationInfo, offsetRange);
                    if (offsetRange2 != OffsetRange.NONE && (n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)offsetRange2.getStart())) != (n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)offsetRange2.getEnd()))) {
                        offsetRange2 = new OffsetRange(offsetRange2.getStart(), Utilities.getRowEnd((BaseDocument)baseDocument, (int)offsetRange2.getStart()));
                        offsetRange = AstUtilities.getAstOffsets(compilationInfo, offsetRange2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                if (offsetRange != OffsetRange.NONE) {
                    map.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
                }
            }
        } else if (n == 105 || n == 132) {
            return;
        }
        if (node.hasChildren()) {
            for (offsetRange = node.getFirstChild(); offsetRange != null; offsetRange = offsetRange.getNext()) {
                this.highlightExitPoints((Node)offsetRange, map, compilationInfo);
            }
        }
    }
}

