/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import org.mozilla.nb.javascript.CompilerEnvirons;
import org.mozilla.nb.javascript.ErrorReporter;
import org.mozilla.nb.javascript.EvaluatorException;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.Node;
import org.mozilla.nb.javascript.Parser;
import org.mozilla.nb.javascript.ScriptOrFnNode;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.IncrementalParser;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.PositionManager;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.spi.DefaultError;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstNodeAdapter;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.JsElement;
import org.netbeans.modules.javascript.editing.JsIndexer;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsPositionManager;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.openide.util.Exceptions;

public class JsParser
implements IncrementalParser {
    private final PositionManager positions = this.createPositionManager();
    static RuntimeException runtimeException;

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    public void parseFiles(Parser.Job job) {
        ParseListener parseListener = job.listener;
        SourceFileReader sourceFileReader = job.reader;
        for (ParserFile parserFile : job.files) {
            CharSequence charSequence;
            ParseEvent parseEvent = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, null);
            parseListener.started(parseEvent);
            JsParseResult jsParseResult = null;
            try {
                charSequence = sourceFileReader.read(parserFile);
                String string = JsParser.asString(charSequence);
                int n = sourceFileReader.getCaretOffset(parserFile);
                if (n != -1 && job.translatedSource != null) {
                    n = job.translatedSource.getAstOffset(n);
                }
                Context context = new Context(parserFile, parseListener, string, n, job.translatedSource, job);
                jsParseResult = this.parseBuffer(context, Sanitize.NONE);
            }
            catch (IOException iOException) {
                parseListener.exception((Exception)iOException);
                jsParseResult = this.createParseResult(parserFile, null, null);
            }
            charSequence = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, (ParserResult)jsParseResult);
            parseListener.finished((ParseEvent)charSequence);
        }
    }

    protected PositionManager createPositionManager() {
        return new JsPositionManager();
    }

    private boolean sanitizeSource(Context context, Sanitize sanitize) {
        block25: {
            if (sanitize == Sanitize.MISSING_END) {
                context.sanitizedSource = context.source + "}";
                int n = context.source.length();
                context.sanitizedRange = new OffsetRange(n, n + 4);
                context.sanitizedContents = "";
                return true;
            }
            int n = context.caretOffset;
            if (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.ERROR_LINE) {
                n = context.errorOffset;
            }
            if (n == -1) {
                return false;
            }
            String string = context.source;
            if (n > string.length()) {
                return false;
            }
            try {
                int n2;
                int n3;
                int n4;
                StringBuilder stringBuilder;
                block27: {
                    boolean bl;
                    String string2;
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    int n5;
                                    if ((GsfUtilities.isRowEmpty((String)string, (int)n) || GsfUtilities.isRowWhite((String)string, (int)n)) && (n = GsfUtilities.getRowStart((String)string, (int)n) - 1) < 0) {
                                        n = 0;
                                    }
                                    if (GsfUtilities.isRowEmpty((String)string, (int)n) || GsfUtilities.isRowWhite((String)string, (int)n)) break block25;
                                    if (sanitize == Sanitize.EDITED_LINE || sanitize == Sanitize.ERROR_LINE) {
                                        int n6 = GsfUtilities.getRowLastNonWhite((String)string, (int)n);
                                        if (n6 != -1) {
                                            StringBuilder stringBuilder2 = new StringBuilder(string.length());
                                            int n7 = GsfUtilities.getRowStart((String)string, (int)n);
                                            if (++n6 >= n7 + 2) {
                                                stringBuilder2.append(string.substring(0, n7));
                                                stringBuilder2.append("//");
                                                int n8 = n7 + 2;
                                                if (n8 < string.length()) {
                                                    stringBuilder2.append(string.substring(n8, string.length()));
                                                }
                                            } else {
                                                stringBuilder2.append(string.substring(0, n7));
                                                stringBuilder2.append(" ");
                                                int n9 = n7 + 1;
                                                if (n9 < string.length()) {
                                                    stringBuilder2.append(string.substring(n9, string.length()));
                                                }
                                            }
                                            assert (stringBuilder2.length() == string.length());
                                            context.sanitizedRange = new OffsetRange(n7, n6);
                                            context.sanitizedSource = stringBuilder2.toString();
                                            context.sanitizedContents = string.substring(n7, n6);
                                            return true;
                                        }
                                        break block25;
                                    }
                                    assert (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.EDITED_DOT);
                                    int n10 = GsfUtilities.getRowStart((String)string, (int)n);
                                    for (n5 = n - 1; n5 >= n10 && n5 < string.length() && Character.isWhitespace(string.charAt(n5)); --n5) {
                                    }
                                    if (n5 <= n10) break block25;
                                    stringBuilder = new StringBuilder(string.length());
                                    string2 = string.substring(n10, n5 + 1);
                                    n4 = 0;
                                    n3 = n5 + 1;
                                    boolean bl2 = bl = GsfUtilities.getRowLastNonWhite((String)context.source, (int)n5) <= n5;
                                    if (!string2.endsWith(".")) break block26;
                                    n4 = 1;
                                    break block27;
                                }
                                if (!string2.endsWith("(")) break block28;
                                if (!bl) break block27;
                                n4 = 1;
                                break block27;
                            }
                            if (!string2.endsWith(",")) break block29;
                            if (bl) break block27;
                            n4 = 1;
                            break block27;
                        }
                        if (!string2.endsWith(", ")) break block30;
                        if (bl) break block27;
                        n4 = 2;
                        break block27;
                    }
                    if (string2.endsWith(",)")) {
                        n4 = 1;
                        --n3;
                    } else if (string2.endsWith(", )")) {
                        n4 = 1;
                        n3 -= 2;
                    } else {
                        String[] stringArray = JsUtils.JAVASCRIPT_KEYWORDS;
                        n2 = stringArray.length;
                        for (int i = 0; i < n2; ++i) {
                            String string3 = stringArray[i];
                            if (!string2.endsWith(string3) || "var".equals(string3) && !bl) continue;
                            n4 = 1;
                            break;
                        }
                    }
                }
                if (n4 == 0) {
                    return false;
                }
                int n11 = n3 - n4;
                stringBuilder.append(string.substring(0, n11));
                for (n2 = 0; n2 < n4; ++n2) {
                    stringBuilder.append(' ');
                }
                if (n3 < string.length()) {
                    stringBuilder.append(string.substring(n3, string.length()));
                }
                assert (stringBuilder.length() == string.length());
                context.sanitizedRange = new OffsetRange(n11, n3);
                context.sanitizedSource = stringBuilder.toString();
                context.sanitizedContents = string.substring(n11, n3);
                return true;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return false;
    }

    private final int lexToAst(TranslatedSource translatedSource, int n) {
        if (translatedSource != null) {
            return translatedSource.getAstOffset(n);
        }
        return n;
    }

    private final int astToLex(TranslatedSource translatedSource, int n) {
        if (translatedSource != null) {
            return translatedSource.getLexicalOffset(n);
        }
        return n;
    }

    public ParserResult parse(ParserFile parserFile, SourceFileReader sourceFileReader, TranslatedSource translatedSource, EditHistory editHistory, ParserResult parserResult) {
        if (editHistory == null) {
            return null;
        }
        if ("json".equals(parserFile.getExtension())) {
            return null;
        }
        int n = sourceFileReader.getCaretOffset(parserFile);
        if (n != -1 && translatedSource != null) {
            n = translatedSource.getAstOffset(n);
        }
        JsParseResult jsParseResult = (JsParseResult)parserResult;
        if (editHistory.getStart() == -1) {
            return jsParseResult;
        }
        Node node = jsParseResult.getRootNode();
        if (jsParseResult != null && node != null) {
            Object object;
            JsParseResult jsParseResult2 = jsParseResult;
            assert (jsParseResult2 != null);
            int n2 = this.lexToAst(translatedSource, editHistory.getStart());
            if (n2 == -1) {
                return null;
            }
            AstPath astPath = new AstPath(node, n2);
            ListIterator<Node> listIterator = astPath.leafToRoot();
            FunctionNode functionNode = null;
            while (listIterator.hasNext()) {
                Node node2 = listIterator.next();
                if (node2.getType() != 105) continue;
                functionNode = (FunctionNode)node2;
                break;
            }
            if (functionNode == null) {
                return null;
            }
            final int n3 = functionNode.getSourceStart();
            int n4 = functionNode.getSourceEnd();
            int n5 = this.lexToAst(translatedSource, editHistory.getOriginalEnd());
            if (n2 == -1) {
                return null;
            }
            if (n5 > n4) {
                return null;
            }
            int n6 = this.astToLex(translatedSource, n4);
            if (n6 == -1) {
                return null;
            }
            int n7 = editHistory.convertOriginalToEdited(n6);
            int n8 = this.lexToAst(translatedSource, n7);
            if (n8 == -1) {
                return null;
            }
            String string = null;
            try {
                object = sourceFileReader.read(parserFile);
                string = JsParser.asString((CharSequence)object);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
            object = new Context(parserFile, null, string, n, translatedSource, null);
            int n9 = ((Context)object).source.length();
            if (n8 > n9 || n8 <= 0) {
                return null;
            }
            if (((Context)object).source.charAt(n8 - 1) != '}') {
                return null;
            }
            String string2 = ((Context)object).source.substring(n3, n8);
            Sanitize sanitize = Sanitize.NEVER;
            boolean bl = false;
            Parser parser = this.createParser((Context)object, string2, bl, sanitize);
            ((Context)object).parser = parser;
            if (sanitize == Sanitize.NONE) {
                ((Context)object).errorOffset = -1;
            }
            int n10 = 0;
            try {
                OffsetRange offsetRange;
                final ArrayList<DefaultError> arrayList = new ArrayList<DefaultError>();
                ((Context)object).listener = new ParseListener(){

                    public void started(ParseEvent parseEvent) {
                    }

                    public void finished(ParseEvent parseEvent) {
                    }

                    public void error(Error error) {
                        DefaultError defaultError = (DefaultError)error;
                        int n = defaultError.getStartPosition();
                        int n2 = defaultError.getEndPosition();
                        if (n != -1) {
                            n += n3;
                        }
                        if (n2 != -1) {
                            n2 += n3;
                        }
                        defaultError.setOffsets(n, n2);
                        arrayList.add(defaultError);
                    }

                    public void exception(Exception exception) {
                    }
                };
                String string3 = ((Context)object).source;
                int n11 = ((Context)object).caretOffset;
                ((Context)object).source = string2;
                if (((Context)object).caretOffset >= n3 && ((Context)object).caretOffset <= n8) {
                    ((Context)object).caretOffset -= n3;
                    boolean bl2 = this.sanitizeSource((Context)object, Sanitize.EDITED_DOT);
                    if (bl2) {
                        assert (((Context)object).sanitizedSource != null);
                        bl = true;
                        string2 = ((Context)object).sanitizedSource;
                        ((Context)object).sanitized = Sanitize.EDITED_DOT;
                    }
                }
                ((Context)object).source = string3;
                ((Context)object).caretOffset = n11;
                FunctionNode functionNode2 = parser.parseFunction(string2, ((Context)object).file.getNameExt(), n10);
                if (functionNode2 == null) {
                    return null;
                }
                this.adjustOffsets((Node)functionNode2, 0, n3);
                int n12 = this.lexToAst(translatedSource, editHistory.getOriginalEnd());
                if (n12 == -1) {
                    return null;
                }
                int n13 = editHistory.getSizeDelta();
                this.adjustOffsets(node, n12, n13);
                this.setParentRefs((Node)functionNode2, functionNode.getParentNode());
                functionNode.getParentNode().replaceChild((Node)functionNode, (Node)functionNode2);
                if (functionNode.labelNode != null) {
                    functionNode2.labelNode = functionNode.labelNode;
                    functionNode.labelNode.setLabelledNode((Node)functionNode2);
                }
                ((Context)object).sanitized = sanitize;
                AstNodeAdapter astNodeAdapter = new AstNodeAdapter(null, node);
                JsParseResult jsParseResult3 = this.createParseResult(((Context)object).file, node, astNodeAdapter);
                JsParseResult.IncrementalParse incrementalParse = new JsParseResult.IncrementalParse(functionNode, functionNode2, n3, n12, n13, jsParseResult);
                jsParseResult3.setIncrementalParse(incrementalParse);
                if (bl) {
                    offsetRange = new OffsetRange(((Context)object).sanitizedRange.getStart() + n3, ((Context)object).sanitizedRange.getEnd() + n3);
                    jsParseResult3.setSanitized(((Context)object).sanitized, offsetRange, ((Context)object).sanitizedContents);
                }
                jsParseResult3.setSource(string2);
                for (Error error : jsParseResult2.getDiagnostics()) {
                    DefaultError defaultError = (DefaultError)error;
                    int n14 = defaultError.getStartPosition();
                    int n15 = defaultError.getEndPosition();
                    if (n14 >= n3 && n14 <= n4) continue;
                    if (n14 >= n12 || n15 >= n12) {
                        if (n14 >= n12) {
                            n14 += n13;
                        }
                        if (n15 >= n12) {
                            n15 += n13;
                        }
                        defaultError.setOffsets(n14, n15);
                    }
                    arrayList.add(defaultError);
                }
                for (Error error : arrayList) {
                    jsParseResult3.addError(error);
                }
                while (functionNode.hasChildren()) {
                    offsetRange = functionNode.getFirstChild();
                    functionNode.removeChild((Node)offsetRange);
                }
                jsParseResult3.setUpdateState(ParserResult.UpdateState.UPDATED);
                return jsParseResult3;
            }
            catch (IllegalStateException illegalStateException) {
                runtimeException = illegalStateException;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                JsParser.runtimeException = runtimeException;
            }
        }
        return null;
    }

    private void adjustOffsets(Node node, int n, int n2) {
        int n3 = node.getSourceStart();
        int n4 = node.getSourceEnd();
        if (n3 >= n) {
            n3 += n2;
        }
        if (n4 >= n) {
            n4 += n2;
        }
        node.setSourceBounds(n3, n4);
        if (node.hasChildren()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (node2.getSourceEnd() < n) continue;
                this.adjustOffsets(node2, n, n2);
            }
        }
    }

    private JsParseResult sanitize(Context context, Sanitize sanitize) {
        switch (sanitize) {
            case NEVER: {
                return this.createParseResult(context.file, null, null);
            }
            case NONE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_DOT);
                }
            }
            case EDITED_DOT: {
                if (context.errorOffset != -1 && context.errorOffset != context.caretOffset) {
                    return this.parseBuffer(context, Sanitize.ERROR_DOT);
                }
            }
            case ERROR_DOT: {
                if (context.errorOffset != -1) {
                    return this.parseBuffer(context, Sanitize.ERROR_LINE);
                }
            }
            case ERROR_LINE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_LINE);
                }
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.MISSING_END);
            }
        }
        return this.createParseResult(context.file, null, null);
    }

    protected void notifyError(Context context, String string, String string2, int n, String string3, int n2, Sanitize sanitize, Severity severity, String string4, Object object) {
        if (JsIndexer.PREINDEXING && severity == Severity.ERROR && context.file.getNameExt().startsWith("stub_")) {
            System.err.println("\n\n\n**********************************************************\n**********************************************************\nParsing error for " + string + ", sourceName= " + string2 + ", line= " + n + ", lineSource=" + string3 + ", lineOffset=" + n2 + ", key=" + string4 + "\n" + "**********************************************************\n**********************************************************\n");
            System.exit(0);
        }
        int n3 = context.parser.getTokenStream().getBufferOffset();
        if ("msg.unexpected.eof".equals(string4) && n3 > 0) {
            --n3;
        }
        DefaultError defaultError = new DefaultError(string4, string, null, context.file.getFileObject(), n3, n3, severity);
        if (object != null) {
            if (object instanceof Object[]) {
                defaultError.setParameters((Object[])object);
            } else {
                defaultError.setParameters(new Object[]{object});
            }
        }
        context.listener.error((Error)defaultError);
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = n3;
        }
    }

    protected JsParseResult parseBuffer(Context context, Sanitize sanitize) {
        boolean bl = false;
        String string = context.source;
        if (sanitize != Sanitize.NONE && sanitize != Sanitize.NEVER) {
            boolean bl2 = this.sanitizeSource(context, sanitize);
            if (bl2) {
                assert (context.sanitizedSource != null);
                bl = true;
                string = context.sanitizedSource;
            } else {
                return this.sanitize(context, sanitize);
            }
        }
        Parser parser = this.createParser(context, string, bl, sanitize);
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = -1;
        }
        int n = 0;
        ScriptOrFnNode scriptOrFnNode = null;
        try {
            scriptOrFnNode = this.isJson(context) ? parser.parseJson(string, context.file.getNameExt(), n) : parser.parse(string, context.file.getNameExt(), n);
        }
        catch (IllegalStateException illegalStateException) {
            runtimeException = illegalStateException;
        }
        catch (RuntimeException runtimeException) {
            JsParser.runtimeException = runtimeException;
        }
        if (scriptOrFnNode != null) {
            this.setParentRefs((Node)scriptOrFnNode, null);
            context.sanitized = sanitize;
            AstNodeAdapter astNodeAdapter = new AstNodeAdapter(null, (Node)scriptOrFnNode);
            JsParseResult jsParseResult = this.createParseResult(context.file, (Node)scriptOrFnNode, astNodeAdapter);
            jsParseResult.setSanitized(context.sanitized, context.sanitizedRange, context.sanitizedContents);
            jsParseResult.setSource(string);
            return jsParseResult;
        }
        return this.sanitize(context, sanitize);
    }

    protected Parser createParser(final Context context, String string, boolean bl, final Sanitize sanitize) {
        final boolean bl2 = bl;
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        ErrorReporter errorReporter = new ErrorReporter(){

            public void error(String string, String string2, int n, String string3, int n2, String string4, Object object) {
                if (!bl2) {
                    JsParser.this.notifyError(context, string, string2, n, string3, n2, sanitize, Severity.ERROR, string4, object);
                }
            }

            public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
                if (!bl2) {
                    JsParser.this.notifyError(context, string, string2, n, string3, n2, sanitize, Severity.ERROR, "", null);
                }
                return null;
            }

            public void warning(String string, String string2, int n, String string3, int n2, String string4, Object object) {
                if (!bl2) {
                    JsParser.this.notifyError(context, string, string2, n, string3, n2, sanitize, Severity.WARNING, string4, object);
                }
            }
        };
        org.mozilla.nb.javascript.Context context2 = new org.mozilla.nb.javascript.Context();
        compilerEnvirons.initFromContext(context2);
        compilerEnvirons.setErrorReporter(errorReporter);
        int n = SupportedBrowsers.getInstance().getLanguageVersion();
        compilerEnvirons.setLanguageVersion(n);
        if (n >= 170) {
            compilerEnvirons.setXmlAvailable(true);
        }
        compilerEnvirons.setStrictMode(true);
        compilerEnvirons.setGeneratingSource(false);
        compilerEnvirons.setGenerateDebugInfo(false);
        compilerEnvirons.setReservedKeywordAsIdentifier(true);
        Parser parser = new Parser(compilerEnvirons, errorReporter);
        context.parser = parser;
        return parser;
    }

    private boolean isJson(Context context) {
        return "json".equals(context.file.getExtension());
    }

    private JsParseResult createParseResult(ParserFile parserFile, Node node, AstNodeAdapter astNodeAdapter) {
        return new JsParseResult(this, parserFile, node, astNodeAdapter);
    }

    public PositionManager getPositionManager() {
        return this.positions;
    }

    private void setParentRefs(Node node, Node node2) {
        assert (node.getParentNode() == null);
        node.setParentNode(node2);
        if (node.hasChildren()) {
            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                this.setParentRefs(node3, node);
            }
        }
    }

    public static Element resolveHandle(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        if (elementHandle instanceof AstElement) {
            AstElement astElement = (AstElement)elementHandle;
            CompilationInfo compilationInfo2 = astElement.getInfo();
            if (compilationInfo2 == compilationInfo) {
                return astElement;
            }
            Node node = astElement.getNode();
            Node node2 = AstUtilities.getRoot(compilationInfo2);
            Node node3 = AstUtilities.getRoot(compilationInfo);
            if (node3 == null) {
                return null;
            }
            Node node4 = JsParser.find(node2, node, node3);
            if (node4 != null) {
                AstElement astElement2 = AstElement.getElement(compilationInfo, node4);
                return astElement2;
            }
        } else if (elementHandle instanceof JsElement) {
            return (JsElement)elementHandle;
        }
        return null;
    }

    private static Node find(Node node, Node node2, Node node3) {
        if (node == node2) {
            return node3;
        }
        Node node4 = node.getFirstChild();
        Node node5 = node3.getFirstChild();
        if (node4 == null || node5 == null) {
            return null;
        }
        while (node4 != null) {
            if (node5 == null) {
                return null;
            }
            if (node4 == node2) {
                return node5;
            }
            Node node6 = JsParser.find(node4, node2, node5);
            if (node6 != null) {
                return node6;
            }
            node4 = node4.getNext();
            node5 = node5.getNext();
        }
        if (node5 != null) {
            return null;
        }
        return null;
    }

    public static class Context {
        private Parser parser;
        private final ParserFile file;
        private ParseListener listener;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;
        private TranslatedSource translatedSource;
        private Parser.Job job;

        public Context(ParserFile parserFile, ParseListener parseListener, String string, int n, TranslatedSource translatedSource, Parser.Job job) {
            this.file = parserFile;
            this.listener = parseListener;
            this.source = string;
            this.caretOffset = n;
            this.translatedSource = translatedSource;
            this.job = job;
        }

        public String toString() {
            return "JsParser.Context(" + this.file.toString() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        public Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sanitize {
        NEVER,
        NONE,
        EDITED_DOT,
        ERROR_DOT,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_END;

    }
}

