/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.modules.project.ant.ProjectLibraryProvider;
import org.netbeans.modules.project.ant.ProjectXMLCatalogReader;
import org.netbeans.modules.project.ant.UserQuestionHandler;
import org.netbeans.modules.project.ant.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.AuxiliaryPropertiesImpl;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ExtensibleMetadataProviderImpl;
import org.netbeans.spi.project.support.ant.GlobFileBuiltQuery;
import org.netbeans.spi.project.support.ant.ProjectProperties;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.SharabilityQueryImpl;
import org.netbeans.spi.project.support.ant.SimpleAntArtifact;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AntProjectHelper {
    public static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    public static final String PRIVATE_PROPERTIES_PATH = "nbproject/private/private.properties";
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PRIVATE_XML_PATH = "nbproject/private/private.xml";
    static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    static final String PRIVATE_NS = "http://www.netbeans.org/ns/project-private/1";
    private static RequestProcessor RP;
    private final FileObject dir;
    private final ProjectState state;
    private final AntBasedProjectType type;
    private static final Document NONEXISTENT;
    private Document projectXml;
    private boolean projectXmlValid;
    private Document privateXml;
    private boolean privateXmlValid;
    private final Set<String> modifiedMetadataPaths = new HashSet<String>();
    private final List<AntProjectListener> listeners = new ArrayList<AntProjectListener>();
    private final ProjectProperties properties;
    private final FileChangeSupportListener fileListener;
    private boolean writingXML = false;
    private ProjectXmlSavedHook pendingHook;
    private int pendingHookCount;
    static boolean QUIETLY_SWALLOW_XML_LOAD_ERRORS;
    private static final DocumentBuilder db;

    private AntProjectHelper(FileObject fileObject, Document document, ProjectState projectState, AntBasedProjectType antBasedProjectType) {
        this.dir = fileObject;
        assert (fileObject != null && FileUtil.toFile((FileObject)fileObject) != null);
        this.state = projectState;
        assert (projectState != null);
        this.type = antBasedProjectType;
        assert (antBasedProjectType != null);
        this.projectXml = document;
        this.projectXmlValid = true;
        assert (document != null);
        this.properties = new ProjectProperties(this);
        this.fileListener = new FileListener();
        FileChangeSupport.DEFAULT.addListener(this.fileListener, this.resolveFile(PROJECT_XML_PATH));
        FileChangeSupport.DEFAULT.addListener(this.fileListener, this.resolveFile(PRIVATE_XML_PATH));
    }

    AntBasedProjectType getType() {
        return this.type;
    }

    private Document getConfigurationXml(boolean bl) {
        Object object;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        if (!(!bl ? this.privateXmlValid : this.projectXmlValid)) {
            object = bl ? PROJECT_XML_PATH : PRIVATE_XML_PATH;
            Document document = this.loadXml((String)object);
            if (document != null && document != NONEXISTENT) {
                if (bl) {
                    this.projectXml = document;
                } else {
                    this.privateXml = document;
                }
            } else if (document == NONEXISTENT && !bl) {
                this.privateXml = null;
            }
        }
        if (!bl && this.privateXml == null) {
            this.privateXml = XMLUtil.createDocument((String)"project-private", (String)PRIVATE_NS, null, null);
        }
        if (bl) {
            this.projectXmlValid = true;
        } else {
            this.privateXmlValid = true;
        }
        Object object2 = object = bl ? this.projectXml : this.privateXml;
        assert (object != null) : "shared=" + bl + " projectXml=" + this.projectXml + " privateXml=" + this.privateXml + " projectXmlValid=" + this.projectXmlValid + " privateXmlValid=" + this.privateXmlValid;
        return object;
    }

    private Document loadXml(String string) {
        block8: {
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            assert (Thread.holdsLock(this.modifiedMetadataPaths));
            FileObject fileObject = this.dir.getFileObject(string);
            if (fileObject == null || !fileObject.isData()) {
                return NONEXISTENT;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            assert (file != null);
            try {
                Document document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
                ProjectXMLCatalogReader.validate(document.getDocumentElement());
                return document;
            }
            catch (IOException iOException) {
                if (!QUIETLY_SWALLOW_XML_LOAD_ERRORS) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            catch (SAXException sAXException) {
                if (QUIETLY_SWALLOW_XML_LOAD_ERRORS) break block8;
                ErrorManager.getDefault().notify(1, (Throwable)sAXException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock saveXml(final Document document, final String string) throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        assert (!this.writingXML);
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        try {
            ProjectXMLCatalogReader.validate(document.getDocumentElement());
        }
        catch (SAXException sAXException) {
            Exceptions.attachMessage((Throwable)sAXException, (String)("Saving " + string + " in " + FileUtil.getFileDisplayName((FileObject)this.dir)));
            throw (IOException)new IOException(sAXException.getMessage()).initCause(sAXException);
        }
        final FileLock[] fileLockArray = new FileLock[1];
        this.writingXML = true;
        try {
            this.dir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    XMLUtil.write((Document)document, (OutputStream)byteArrayOutputStream, (String)"UTF-8");
                    final byte[] byArray = byteArrayOutputStream.toByteArray();
                    final FileObject fileObject = FileUtil.createData((FileObject)AntProjectHelper.this.dir, (String)string);
                    try {
                        fileLockArray[0] = fileObject.lock();
                        OutputStream outputStream = fileObject.getOutputStream(fileLockArray[0]);
                        try {
                            outputStream.write(byArray);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    catch (UserQuestionException userQuestionException) {
                        AntProjectHelper.this.needPendingHook();
                        UserQuestionHandler.handle(userQuestionException, new UserQuestionHandler.Callback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void accepted() {
                                assert (!AntProjectHelper.this.writingXML);
                                AntProjectHelper.this.writingXML = true;
                                try {
                                    FileLock fileLock = fileObject.lock();
                                    try {
                                        OutputStream outputStream = fileObject.getOutputStream(fileLock);
                                        try {
                                            outputStream.write(byArray);
                                        }
                                        finally {
                                            outputStream.close();
                                        }
                                    }
                                    finally {
                                        fileLock.releaseLock();
                                    }
                                    AntProjectHelper.this.maybeCallPendingHook();
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify((Throwable)iOException);
                                    this.reload();
                                }
                                finally {
                                    AntProjectHelper.this.writingXML = false;
                                }
                            }

                            public void denied() {
                                this.reload();
                            }

                            public void error(IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                                this.reload();
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            private void reload() {
                                if (string.equals(AntProjectHelper.PROJECT_XML_PATH)) {
                                    Set set = AntProjectHelper.this.modifiedMetadataPaths;
                                    synchronized (set) {
                                        AntProjectHelper.this.projectXmlValid = false;
                                    }
                                }
                                assert (string.equals(AntProjectHelper.PRIVATE_XML_PATH)) : string;
                                Set set = AntProjectHelper.this.modifiedMetadataPaths;
                                synchronized (set) {
                                    AntProjectHelper.this.privateXmlValid = false;
                                }
                                AntProjectHelper.this.fireExternalChange(string);
                                AntProjectHelper.this.cancelPendingHook();
                            }
                        });
                    }
                }
            });
        }
        finally {
            this.writingXML = false;
        }
        return fileLockArray[0];
    }

    private Element getConfigurationDataRoot(boolean bl) {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        Document document = this.getConfigurationXml(bl);
        if (bl) {
            Element element = document.getDocumentElement();
            Element element2 = Util.findElement(element, "configuration", PROJECT_NS);
            assert (element2 != null);
            return element2;
        }
        return document.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAntProjectListener(AntProjectListener antProjectListener) {
        List<AntProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(antProjectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAntProjectListener(AntProjectListener antProjectListener) {
        List<AntProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(antProjectListener);
        }
    }

    void fireExternalChange(String string) {
        ActionImpl actionImpl = new ActionImpl(this, string);
        if (ProjectManager.mutex().isWriteAccess() || ProjectLibraryProvider.FIRE_CHANGES_SYNCH) {
            ProjectManager.mutex().readAccess((Mutex.Action)actionImpl);
        } else if (ProjectManager.mutex().isReadAccess()) {
            actionImpl.run();
        } else {
            AntProjectHelper.rp().post((Runnable)new RunnableImpl(actionImpl));
        }
    }

    private static synchronized RequestProcessor rp() {
        if (RP == null) {
            RP = new RequestProcessor("AntProjectHelper.RP");
        }
        return RP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String string, boolean bl) {
        AntProjectListener[] antProjectListenerArray;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        Object object = this.listeners;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return;
            }
            antProjectListenerArray = this.listeners.toArray(new AntProjectListener[this.listeners.size()]);
        }
        object = new AntProjectEvent(this, string, bl);
        final boolean bl2 = string.equals(PROJECT_XML_PATH) || string.equals(PRIVATE_XML_PATH);
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>((AntProjectEvent)object){
            final /* synthetic */ AntProjectEvent val$ev;
            {
                this.val$ev = antProjectEvent;
            }

            public Void run() {
                for (AntProjectListener antProjectListener : antProjectListenerArray) {
                    try {
                        if (bl2) {
                            antProjectListener.configurationXmlChanged(this.val$ev);
                            continue;
                        }
                        antProjectListener.propertiesChanged(this.val$ev);
                    }
                    catch (RuntimeException runtimeException) {
                        ErrorManager.getDefault().notify((Throwable)runtimeException);
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifying(String string) {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            this.modifiedMetadataPaths.add(string);
        }
        this.fireChange(string, true);
    }

    public FileObject getProjectDirectory() {
        return this.dir;
    }

    public void notifyDeleted() {
        this.state.notifyDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markModified() {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            this.modifiedMetadataPaths.add(PROJECT_XML_PATH);
        }
    }

    boolean isProjectXmlModified() {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        return this.modifiedMetadataPaths.contains(PROJECT_XML_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        if (!this.getProjectDirectory().isValid()) {
            return;
        }
        HashSet<FileLock> hashSet = new HashSet<FileLock>();
        try {
            Set<String> set = this.modifiedMetadataPaths;
            synchronized (set) {
                assert (!this.modifiedMetadataPaths.isEmpty());
                assert (this.pendingHook == null);
                if (this.modifiedMetadataPaths.contains(PROJECT_XML_PATH)) {
                    Project object = AntBasedProjectFactorySingleton.getProjectFor(this);
                    this.pendingHook = (ProjectXmlSavedHook)object.getLookup().lookup(ProjectXmlSavedHook.class);
                }
                Iterator<String> iterator = this.modifiedMetadataPaths.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    if (string.equals(PROJECT_XML_PATH)) {
                        assert (this.projectXml != null);
                        hashSet.add(this.saveXml(this.projectXml, string));
                    } else if (string.equals(PRIVATE_XML_PATH)) {
                        assert (this.privateXml != null);
                        hashSet.add(this.saveXml(this.privateXml, string));
                    } else {
                        hashSet.add(this.properties.write(string));
                    }
                    iterator.remove();
                }
                if (this.pendingHook != null && this.pendingHookCount == 0) {
                    try {
                        this.pendingHook.projectXmlSaved();
                    }
                    catch (IOException iOException) {
                        this.modifiedMetadataPaths.add(PROJECT_XML_PATH);
                        throw iOException;
                    }
                }
            }
        }
        finally {
            hashSet.remove(null);
            for (FileLock fileLock : hashSet) {
                fileLock.releaseLock();
            }
            if (this.pendingHookCount == 0) {
                this.pendingHook = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeCallPendingHook() {
        assert (this.pendingHookCount > 0);
        --this.pendingHookCount;
        if (this.pendingHookCount == 0 && this.pendingHook != null) {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws IOException {
                        AntProjectHelper.this.pendingHook.projectXmlSaved();
                        return null;
                    }
                });
            }
            catch (MutexException mutexException) {
                ErrorManager.getDefault().notify((Throwable)mutexException);
            }
            finally {
                this.pendingHook = null;
            }
        }
    }

    void cancelPendingHook() {
        assert (this.pendingHookCount > 0);
        --this.pendingHookCount;
        if (this.pendingHookCount == 0) {
            this.pendingHook = null;
        }
    }

    void needPendingHook() {
        ++this.pendingHookCount;
    }

    public EditableProperties getProperties(final String string) {
        if (string.equals(PROJECT_XML_PATH) || string.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to load properties from a project XML file");
        }
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            public EditableProperties run() {
                return AntProjectHelper.this.properties.getProperties(string);
            }
        });
    }

    public void putProperties(final String string, final EditableProperties editableProperties) {
        if (string.equals(PROJECT_XML_PATH) || string.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to store properties from a project XML file");
        }
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                if (AntProjectHelper.this.properties.putProperties(string, editableProperties)) {
                    AntProjectHelper.this.modifying(string);
                }
                return null;
            }
        });
    }

    public PropertyProvider getPropertyProvider(final String string) {
        if (string.equals(PROJECT_XML_PATH) || string.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to store properties from a project XML file");
        }
        return (PropertyProvider)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<PropertyProvider>(){

            public PropertyProvider run() {
                return AntProjectHelper.this.properties.getPropertyProvider(string);
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean bl) {
        final String string = this.type.getPrimaryConfigurationDataElementName(bl);
        assert (string.indexOf(58) == -1);
        final String string2 = this.type.getPrimaryConfigurationDataElementNamespace(bl);
        assert (string2 != null && string2.length() > 0);
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Element run() {
                Set set = AntProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element element = AntProjectHelper.this.getConfigurationFragment(string, string2, bl);
                    if (element != null) {
                        return element;
                    }
                    return AntProjectHelper.cloneSafely(AntProjectHelper.this.getConfigurationXml(bl).createElementNS(string2, string));
                }
            }
        });
    }

    public void putPrimaryConfigurationData(Element element, boolean bl) throws IllegalArgumentException {
        String string = this.type.getPrimaryConfigurationDataElementName(bl);
        assert (string.indexOf(58) == -1);
        String string2 = this.type.getPrimaryConfigurationDataElementNamespace(bl);
        assert (string2 != null && string2.length() > 0);
        if (!string.equals(element.getLocalName()) || !string2.equals(element.getNamespaceURI())) {
            throw new IllegalArgumentException("Wrong name/namespace: expected {" + string2 + "}" + string + " but was {" + element.getNamespaceURI() + "}" + element.getLocalName());
        }
        this.putConfigurationFragment(element, bl);
    }

    Element getConfigurationFragment(final String string, final String string2, final boolean bl) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Element run() {
                Set set = AntProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element element = AntProjectHelper.this.getConfigurationDataRoot(bl);
                    Element element2 = Util.findElement(element, string, string2);
                    if (element2 != null) {
                        return AntProjectHelper.cloneSafely(element2);
                    }
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element cloneSafely(Element element) {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            Document document = db.newDocument();
            return (Element)document.importNode(element, true);
        }
    }

    void putConfigurationFragment(final Element element, final boolean bl) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                Set set = AntProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element element3 = AntProjectHelper.this.getConfigurationDataRoot(bl);
                    Element element2 = Util.findElement(element3, element.getLocalName(), element.getNamespaceURI());
                    if (element2 != null) {
                        element3.removeChild(element2);
                    }
                    Node node = null;
                    NodeList nodeList = element3.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node2 = nodeList.item(i);
                        if (node2.getNodeType() != 1) continue;
                        int n = node2.getNodeName().compareTo(element.getNodeName());
                        if (n == 0) {
                            n = node2.getNamespaceURI().compareTo(element.getNamespaceURI());
                        }
                        if (n <= 0) continue;
                        node = node2;
                        break;
                    }
                    element3.insertBefore(element3.getOwnerDocument().importNode(element, true), node);
                    AntProjectHelper.this.modifying(bl ? AntProjectHelper.PROJECT_XML_PATH : AntProjectHelper.PRIVATE_XML_PATH);
                }
                return null;
            }
        });
    }

    boolean removeConfigurationFragment(final String string, final String string2, final boolean bl) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                Set set = AntProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element element = AntProjectHelper.this.getConfigurationDataRoot(bl);
                    Element element2 = Util.findElement(element, string, string2);
                    if (element2 != null) {
                        element.removeChild(element2);
                        AntProjectHelper.this.modifying(bl ? AntProjectHelper.PROJECT_XML_PATH : AntProjectHelper.PRIVATE_XML_PATH);
                        return true;
                    }
                    return false;
                }
            }
        });
    }

    public AuxiliaryConfiguration createAuxiliaryConfiguration() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    public CacheDirectoryProvider createCacheDirectoryProvider() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    public AuxiliaryProperties createAuxiliaryProperties() {
        return new AuxiliaryPropertiesImpl(this);
    }

    public FileBuiltQueryImplementation createGlobFileBuiltQuery(PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
        return new GlobFileBuiltQuery(this, propertyEvaluator, stringArray, stringArray2);
    }

    public AntArtifact createSimpleAntArtifact(String string, String string2, PropertyEvaluator propertyEvaluator, String string3, String string4) {
        return this.createSimpleAntArtifact(string, string2, propertyEvaluator, string3, string4, null);
    }

    public AntArtifact createSimpleAntArtifact(String string, String string2, PropertyEvaluator propertyEvaluator, String string3, String string4, String string5) {
        return new SimpleAntArtifact(this, string, string2, propertyEvaluator, string3, string4, string5);
    }

    public SharabilityQueryImplementation createSharabilityQuery(PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        stringArray3[stringArray.length] = "";
        String[] stringArray4 = new String[stringArray2.length + 1];
        System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray2.length);
        stringArray4[stringArray2.length] = "nbproject/private";
        return new SharabilityQueryImpl(this, propertyEvaluator, stringArray3, stringArray4);
    }

    public PropertyProvider getStockPropertyPreprovider() {
        return this.properties.getStockPropertyPreprovider();
    }

    public PropertyProvider getProjectLibrariesPropertyProvider() {
        return ProjectLibraryProvider.createPropertyProvider(this);
    }

    public boolean isSharableProject() {
        return this.getLibrariesLocation() != null;
    }

    public String getLibrariesLocation() {
        return ProjectLibraryProvider.getLibrariesLocationText(this.createAuxiliaryConfiguration());
    }

    public void setLibrariesLocation(String string) {
        ProjectLibraryProvider.setLibrariesLocation(this, string);
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        return this.properties.getStandardPropertyEvaluator();
    }

    public File resolveFile(String string) {
        if (string == null) {
            throw new NullPointerException("Attempted to pass a null filename to resolveFile");
        }
        return PropertyUtils.resolveFile(FileUtil.toFile((FileObject)this.dir), string);
    }

    public FileObject resolveFileObject(String string) {
        if (string == null) {
            throw new NullPointerException("Must pass a non-null filename");
        }
        return PropertyUtils.resolveFileObject(this.dir, string);
    }

    public String resolvePath(String string) {
        if (string == null) {
            throw new NullPointerException("Must pass a non-null path");
        }
        return PropertyUtils.resolvePath(FileUtil.toFile((FileObject)this.dir), string);
    }

    public String toString() {
        return "AntProjectHelper[" + this.getProjectDirectory() + "]";
    }

    static {
        AntBasedProjectFactorySingleton.HELPER_CALLBACK = new AntBasedProjectFactorySingleton.AntProjectHelperCallback(){

            public AntProjectHelper createHelper(FileObject fileObject, Document document, ProjectState projectState, AntBasedProjectType antBasedProjectType) {
                return new AntProjectHelper(fileObject, document, projectState, antBasedProjectType);
            }

            public void save(AntProjectHelper antProjectHelper) throws IOException {
                antProjectHelper.save();
            }
        };
        NONEXISTENT = XMLUtil.createDocument((String)"does-not-exist", null, null, null);
        QUIETLY_SWALLOW_XML_LOAD_ERRORS = false;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionImpl
    implements Mutex.Action<Void> {
        private final String path;
        private AntProjectHelper helper;

        public ActionImpl(AntProjectHelper antProjectHelper, String string) {
            this.path = string;
            this.helper = antProjectHelper;
        }

        public Void run() {
            this.helper.fireChange(this.path, false);
            this.helper = null;
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RunnableImpl
    implements Runnable {
        private final Mutex.Action<Void> action;

        public RunnableImpl(Mutex.Action<Void> action) {
            this.action = action;
        }

        @Override
        public void run() {
            ProjectManager.mutex().readAccess(this.action);
        }
    }

    private final class FileListener
    implements FileChangeSupportListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void change(File file) {
            String string;
            if (AntProjectHelper.this.writingXML) {
                return;
            }
            Set set = AntProjectHelper.this.modifiedMetadataPaths;
            synchronized (set) {
                if (file.equals(AntProjectHelper.this.resolveFile(AntProjectHelper.PROJECT_XML_PATH))) {
                    if (AntProjectHelper.this.modifiedMetadataPaths.contains(AntProjectHelper.PROJECT_XML_PATH)) {
                        return;
                    }
                    string = AntProjectHelper.PROJECT_XML_PATH;
                    AntProjectHelper.this.projectXmlValid = false;
                } else if (file.equals(AntProjectHelper.this.resolveFile(AntProjectHelper.PRIVATE_XML_PATH))) {
                    if (AntProjectHelper.this.modifiedMetadataPaths.contains(AntProjectHelper.PRIVATE_XML_PATH)) {
                        return;
                    }
                    string = AntProjectHelper.PRIVATE_XML_PATH;
                    AntProjectHelper.this.privateXmlValid = false;
                } else {
                    throw new AssertionError((Object)("Unexpected file change in " + file));
                }
            }
            AntProjectHelper.this.fireExternalChange(string);
        }

        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            this.change(fileChangeSupportEvent.getPath());
        }

        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            this.change(fileChangeSupportEvent.getPath());
        }

        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            this.change(fileChangeSupportEvent.getPath());
        }
    }
}

