/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.derby.ui.CreateDatabasePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DerbyPropertiesPanel
extends JPanel {
    private DialogDescriptor descriptor;
    private Color nbErrorForeground;
    private DocumentListener docListener = new DocumentListener(){

        public void removeUpdate(DocumentEvent documentEvent) {
            DerbyPropertiesPanel.this.validatePanel();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DerbyPropertiesPanel.this.validatePanel();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DerbyPropertiesPanel.this.validatePanel();
        }
    };
    public JButton browseButton;
    public JTextField derbyInstall;
    public JTextPane derbyInstallInfo;
    public JLabel derbySystemHomeLabel;
    public JTextField derbySystemHomeTextField;
    public JLabel installLabel;
    public JButton jButton1;
    public JTextPane messageLabel;

    public static boolean showDerbyProperties() {
        assert (SwingUtilities.isEventDispatchThread());
        DerbyPropertiesPanel derbyPropertiesPanel = new DerbyPropertiesPanel();
        String string = NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_SetDerbySystemHome");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)derbyPropertiesPanel, string);
        derbyPropertiesPanel.setDialogDescriptor(dialogDescriptor);
        while (true) {
            boolean bl;
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            String string2 = NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSD_DerbySystemHomePanel");
            dialog.getAccessibleContext().setAccessibleDescription(string2);
            dialog.setVisible(true);
            dialog.dispose();
            if (!DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
                return false;
            }
            File file = new File(derbyPropertiesPanel.getDerbySystemHome());
            if (file.exists() || (bl = file.mkdirs())) break;
            String string3 = NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ERR_DerbySystemHomeCantCreate");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        new RegisterSampleDatabase();
        DerbyOptions.getDefault().setSystemHome(derbyPropertiesPanel.getDerbySystemHome());
        DerbyOptions.getDefault().setLocation(derbyPropertiesPanel.getInstallLocation());
        return true;
    }

    private DerbyPropertiesPanel() {
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.derbyInstallInfo.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.derbySystemHomeTextField.getDocument().addDocumentListener(this.docListener);
        this.derbySystemHomeTextField.setText(DerbyOptions.getDefault().getSystemHome());
        this.derbyInstall.getDocument().addDocumentListener(this.docListener);
        this.derbyInstall.setText(DerbyOptions.getDefault().getLocation());
    }

    private void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
        this.validatePanel();
    }

    private String getDerbySystemHome() {
        return this.derbySystemHomeTextField.getText().trim();
    }

    private String getInstallLocation() {
        return this.derbyInstall.getText().trim();
    }

    private void setInstallLocation(String string) {
        this.derbyInstall.setText(string);
    }

    private void setDerbySystemHome(String string) {
        this.derbySystemHomeTextField.setText(string);
    }

    private void validatePanel() {
        File file;
        if (this.descriptor == null) {
            return;
        }
        String string = null;
        String string2 = this.getInstallLocation();
        if (string2 != null && string2.length() > 0) {
            file = new File(string2).getAbsoluteFile();
            if (!file.exists()) {
                string = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_DirectoryDoesNotExist", (Object)file);
            }
            if (!Util.isDerbyInstallLocation(file)) {
                string = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_InvalidDerbyLocation", (Object)file);
            }
        }
        if (string == null) {
            file = new File(this.getDerbySystemHome());
            if (file.getPath().length() <= 0) {
                string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DerbySystemHomeNotEntered");
            } else if (file.exists() && !file.isDirectory()) {
                string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DerbySystemHomeNotDirectory");
            } else if (!file.isAbsolute()) {
                string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DerbySystemHomeNotAbsolute");
            }
        }
        if (string != null) {
            this.messageLabel.setText(string);
            this.descriptor.setValid(false);
        } else {
            this.messageLabel.setText(" ");
            this.descriptor.setValid(true);
        }
    }

    private void initComponents() {
        this.derbySystemHomeLabel = new JLabel();
        this.derbySystemHomeTextField = new JTextField();
        this.browseButton = new JButton();
        this.installLabel = new JLabel();
        this.derbyInstall = new JTextField();
        this.jButton1 = new JButton();
        this.derbyInstallInfo = new JTextPane();
        this.messageLabel = new JTextPane();
        this.derbySystemHomeLabel.setLabelFor(this.derbySystemHomeTextField);
        Mnemonics.setLocalizedText((JLabel)this.derbySystemHomeLabel, (String)NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_DerbySystemHome"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DerbyPropertiesPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.installLabel.setLabelFor(this.derbyInstall);
        Mnemonics.setLocalizedText((JLabel)this.installLabel, (String)NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_Install"));
        this.derbyInstall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DerbyPropertiesPanel.this.derbyInstallActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_Browse2"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DerbyPropertiesPanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.derbyInstallInfo.setEditable(false);
        this.derbyInstallInfo.setText(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"LBL_InstallationInfo"));
        this.derbyInstallInfo.setAutoscrolls(false);
        this.messageLabel.setEditable(false);
        this.messageLabel.setForeground(this.nbErrorForeground);
        this.messageLabel.setText(" ");
        this.messageLabel.setFocusable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.messageLabel, -1, 493, Short.MAX_VALUE).add((Component)this.derbyInstallInfo, -1, 493, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.derbySystemHomeLabel).addPreferredGap(1).add((Component)this.derbySystemHomeTextField, -1, 266, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.installLabel).addPreferredGap(0).add((Component)this.derbyInstall, -1, 265, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.derbyInstallInfo, -2, 57, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.installLabel).add((Component)this.derbyInstall, -2, -1, -2).add((Component)this.jButton1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.derbySystemHomeLabel).add((Component)this.derbySystemHomeTextField, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0).add((Component)this.messageLabel, -1, 61, Short.MAX_VALUE).addContainerGap()));
        this.derbySystemHomeTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSN_CreateDatabasePanel_databaseLocationTextField"));
        this.derbySystemHomeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSD_DerbySystemHomePanel_derbySystemHomeTextField"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSD_DerbySystemHomePanel_browseButton"));
        this.derbyInstall.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSD_DerbySystemHomePanel_derbySystemHomeTextField"));
        this.derbyInstallInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSN_DerbySystemHomePanel_derbyInstallInfoTextField"));
        this.messageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DerbyPropertiesPanel.class, (String)"ACSN_DerbySystemHomePanel_messageLabel"));
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        String string = this.getInstallLocation();
        if (string.length() > 0) {
            jFileChooser.setSelectedFile(new File(string));
        } else {
            jFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        if (jFileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.setInstallLocation(jFileChooser.getSelectedFile().getAbsolutePath());
    }

    private void derbyInstallActionPerformed(ActionEvent actionEvent) {
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        String string = this.getDerbySystemHome();
        if (string.length() > 0) {
            jFileChooser.setSelectedFile(new File(string));
        } else {
            jFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        if (jFileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.setDerbySystemHome(jFileChooser.getSelectedFile().getAbsolutePath());
    }

    private static class RegisterSampleDatabase {
        private static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
        private static final String CONN_NAME = "jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/sample [app on APP]";
        private boolean registered;
        private final JDBCDriverListener jdbcDriverListener = new JDBCDriverListener(){

            public void driversChanged() {
                RegisterSampleDatabase.this.registerDatabase();
            }
        };

        RegisterSampleDatabase() {
            if (JDBCDriverManager.getDefault().getDrivers(DRIVER_CLASS_NET).length == 0) {
                JDBCDriverManager.getDefault().addDriverListener(this.jdbcDriverListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerDatabase() {
            RegisterSampleDatabase registerSampleDatabase = this;
            synchronized (registerSampleDatabase) {
                if (this.registered) {
                    return;
                }
                this.registered = true;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(RegisterSampleDatabase.DRIVER_CLASS_NET);
                        if (jDBCDriverArray.length > 0 && ConnectionManager.getDefault().getConnection(CONN_NAME) == null) {
                            DerbyDatabases.createSampleDatabase();
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (DatabaseException databaseException) {
                        Exceptions.printStackTrace((Throwable)databaseException);
                    }
                    finally {
                        JDBCDriverManager.getDefault().removeDriverListener(RegisterSampleDatabase.this.jdbcDriverListener);
                    }
                }
            });
        }
    }
}

