/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.TestNotifier;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.spi.project.ActionProvider;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class RunFocusedTest
extends BaseAction {
    public RunFocusedTest() {
        super("run-focused-spec", 0);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        RunFocusedTest.runTest(jTextComponent, false);
    }

    public Class getShortDescriptionBundleClass() {
        return RunFocusedTest.class;
    }

    public boolean isEnabled() {
        return true;
    }

    static void runTest(JTextComponent jTextComponent, boolean bl) {
        Project project;
        if (jTextComponent.getCaret() == null) {
            return;
        }
        FileObject fileObject = GsfUtilities.findFileObject((JTextComponent)jTextComponent);
        if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
            int n = jTextComponent.getCaret().getDot();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            FileLocator fileLocator = (FileLocator)project.getLookup().lookup(FileLocator.class);
            try {
                RSpecSupport rSpecSupport = new RSpecSupport(project);
                if (rSpecSupport.isRSpecInstalled() && RSpecSupport.isSpecFile(fileObject)) {
                    int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
                    if (n2 >= 0) {
                        LifecycleManager.getDefault().saveAll();
                        TestRunner testRunner = RunFocusedTest.getTestRunner(TestRunner.TestType.RSPEC);
                        if (testRunner != null) {
                            testRunner.runSingleTest(fileObject, String.valueOf(n2 + 1), bl);
                        } else {
                            rSpecSupport.runRSpec(null, fileObject, n2 + 1, fileObject.getName(), fileLocator, true, bl, new String[0]);
                        }
                        return;
                    }
                } else {
                    String string = AstUtilities.getTestName((FileObject)fileObject, (int)n);
                    if (string != null) {
                        LifecycleManager.getDefault().saveAll();
                        TestRunner testRunner = RunFocusedTest.getTestRunner(TestRunner.TestType.TEST_UNIT);
                        if (testRunner != null) {
                            testRunner.runSingleTest(fileObject, string, bl);
                        } else {
                            RunFocusedTest.runTest(project, null, fileObject, string, fileObject.getName(), fileLocator, true, bl, new String[0]);
                        }
                        return;
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    private static void runTest(Project project, File file, FileObject fileObject, String string, String string2, FileLocator fileLocator, boolean bl, boolean bl2, String ... stringArray) {
        RubyPlatform rubyPlatform;
        FileObject fileObject2 = null;
        if (project != null) {
            fileObject2 = project.getProjectDirectory();
        }
        if (file == null) {
            rubyPlatform = fileObject2 != null ? fileObject2 : fileObject.getParent();
            file = FileUtil.toFile((FileObject)rubyPlatform);
        }
        if (!(rubyPlatform = RubyPlatform.platformFor((Project)project)).isValidRuby(bl)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-n");
        arrayList.add(string);
        if (stringArray != null && stringArray.length > 0) {
            for (String object : stringArray) {
                arrayList.add(object);
            }
        }
        String[] stringArray2 = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        ExecutionDescriptor executionDescriptor = null;
        String string3 = null;
        if (project != null) {
            ActionProvider actionProvider;
            PropertyEvaluator propertyEvaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
            if (propertyEvaluator != null) {
                string3 = propertyEvaluator.getProperty("source.encoding");
            }
            if ((actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class)) instanceof ScriptDescProvider) {
                ScriptDescProvider scriptDescProvider = (ScriptDescProvider)actionProvider;
                OutputRecognizer[] outputRecognizerArray = new OutputRecognizer[]{new TestNotifier(true, true)};
                executionDescriptor = scriptDescProvider.getScriptDescriptor(file, fileObject, (String)stringArray2, string2, project.getLookup(), bl2, outputRecognizerArray);
                executionDescriptor.additionalArgs(arrayList.toArray(new String[arrayList.size()]));
            }
        } else {
            executionDescriptor = new ExecutionDescriptor(rubyPlatform, string2, file, (String)stringArray2);
            executionDescriptor.additionalArgs(arrayList.toArray(new String[arrayList.size()]));
            executionDescriptor.debug(bl2);
            executionDescriptor.allowInput();
            executionDescriptor.fileLocator(fileLocator);
            executionDescriptor.addStandardRecognizers();
            executionDescriptor.addOutputRecognizer((OutputRecognizer)new TestNotifier(true, true));
        }
        new RubyExecution(executionDescriptor, string3).run();
    }

    private static TestRunner getTestRunner(TestRunner.TestType testType) {
        Collection collection = Lookup.getDefault().lookupAll(TestRunner.class);
        for (TestRunner testRunner : collection) {
            if (!testRunner.supports(testType)) continue;
            return testRunner;
        }
        return null;
    }
}

