/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectEvent;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectListener;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SourceRoots {
    public static final String PROP_ROOT_PROPERTIES = "rootProperties";
    public static final String PROP_ROOTS = "roots";
    public static final String DEFAULT_SOURCE_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"SourceRoots.source.files");
    public static final String DEFAULT_TEST_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"SourceRoots.test.files");
    public static final String DEFAULT_SPEC_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"SourceRoots.spec.files");
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final String elementName;
    private final String newRootNameTemplate;
    private List<String> sourceRootProperties;
    private List<String> sourceRootNames;
    private List<FileObject> sourceRoots;
    private List<URL> sourceRootURLs;
    private final PropertyChangeSupport support;
    private final ProjectMetadataListener listener;
    private final boolean isTest;
    private final File projectDir;

    SourceRoots(UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, String string, boolean bl, String string2) {
        assert (updateHelper != null && propertyEvaluator != null && referenceHelper != null && string != null && string2 != null);
        this.helper = updateHelper;
        this.evaluator = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.elementName = string;
        this.isTest = bl;
        this.newRootNameTemplate = string2;
        this.projectDir = FileUtil.toFile((FileObject)this.helper.getRakeProjectHelper().getProjectDirectory());
        this.support = new PropertyChangeSupport(this);
        this.listener = new ProjectMetadataListener();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.evaluator));
        this.helper.getRakeProjectHelper().addRakeProjectListener((RakeProjectListener)WeakListeners.create(RakeProjectListener.class, (EventListener)this.listener, (Object)this.helper));
    }

    public String[] getRootNames() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootNames == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                }
                return SourceRoots.this.sourceRootNames.toArray(new String[SourceRoots.this.sourceRootNames.size()]);
            }
        });
    }

    public String[] getRootProperties() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootProperties == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                    return SourceRoots.this.sourceRootProperties.toArray(new String[SourceRoots.this.sourceRootProperties.size()]);
                }
            }
        });
    }

    public FileObject[] getRoots() {
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRoots == null) {
                        String[] stringArray = SourceRoots.this.getRootProperties();
                        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                        for (String string : stringArray) {
                            FileObject fileObject;
                            String string2 = SourceRoots.this.evaluator.getProperty(string);
                            if (string2 == null || (fileObject = SourceRoots.this.helper.getRakeProjectHelper().resolveFileObject(string2)) == null) continue;
                            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
                            }
                            arrayList.add(fileObject);
                        }
                        SourceRoots.this.sourceRoots = Collections.unmodifiableList(arrayList);
                    }
                }
                return SourceRoots.this.sourceRoots.toArray(new FileObject[SourceRoots.this.sourceRoots.size()]);
            }
        });
    }

    public URL[] getRootURLs() {
        return (URL[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<URL[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public URL[] run() {
                4 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRootURLs == null) {
                        String[] stringArray = SourceRoots.this.getRootProperties();
                        ArrayList<URL> arrayList = new ArrayList<URL>();
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string = SourceRoots.this.evaluator.getProperty(stringArray[i]);
                            if (string == null) continue;
                            File file = SourceRoots.this.helper.getRakeProjectHelper().resolveFile(string);
                            try {
                                URL uRL = file.toURI().toURL();
                                if (!file.exists()) {
                                    uRL = new URL(uRL.toExternalForm() + "/");
                                }
                                arrayList.add(uRL);
                                continue;
                            }
                            catch (MalformedURLException malformedURLException) {
                                ErrorManager.getDefault().notify((Throwable)malformedURLException);
                            }
                        }
                        SourceRoots.this.sourceRootURLs = Collections.unmodifiableList(arrayList);
                    }
                }
                return SourceRoots.this.sourceRootURLs.toArray(new URL[SourceRoots.this.sourceRootURLs.size()]);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void putRoots(final URL[] uRLArray, final String[] stringArray) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Object object;
                String[] stringArray3 = SourceRoots.this.getRootProperties();
                URL[] uRLArray2 = SourceRoots.this.getRootURLs();
                HashMap<URL, String> hashMap = new HashMap<URL, String>();
                for (int i = 0; i < stringArray3.length; ++i) {
                    hashMap.put(uRLArray2[i], stringArray3[i]);
                }
                HashMap<URL, String> hashMap2 = new HashMap<URL, String>();
                for (int i = 0; i < uRLArray.length; ++i) {
                    hashMap2.put(uRLArray[i], stringArray[i]);
                }
                Element element = SourceRoots.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", SourceRoots.this.elementName);
                assert (nodeList.getLength() == 1) : "Illegal project.xml. Expected exactly one <" + SourceRoots.access$800(SourceRoots.this) + '>';
                Element element2 = (Element)nodeList.item(0);
                NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", "root");
                while (nodeList2.getLength() > 0) {
                    object = (Element)nodeList2.item(0);
                    element2.removeChild((Node)object);
                }
                object = Arrays.asList(uRLArray);
                HashMap hashMap3 = new HashMap(hashMap);
                hashMap3.keySet().removeAll((Collection<?>)object);
                EditableProperties editableProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                editableProperties.keySet().removeAll(hashMap3.values());
                SourceRoots.this.helper.putProperties("nbproject/project.properties", editableProperties);
                Document document = element2.getOwnerDocument();
                hashMap.keySet().retainAll((Collection<?>)object);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String[] stringArray2;
                    URL uRL = (URL)iterator.next();
                    String string = (String)hashMap.get(uRL);
                    if (string == null) {
                        String string2;
                        editableProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        stringArray2 = uRL.getPath().split("/");
                        string = MessageFormat.format(SourceRoots.this.newRootNameTemplate, stringArray2[stringArray2.length - 1], "");
                        int n = 1;
                        while (editableProperties.containsKey((Object)string)) {
                            string = MessageFormat.format(SourceRoots.this.newRootNameTemplate, stringArray2[stringArray2.length - 1], ++n);
                        }
                        File file = FileUtil.normalizeFile((File)new File(URI.create(uRL.toExternalForm())));
                        File file2 = FileUtil.toFile((FileObject)SourceRoots.this.helper.getRakeProjectHelper().getProjectDirectory());
                        String string3 = file.getAbsolutePath();
                        if (string3.startsWith(string2 = file2.getAbsolutePath() + File.separatorChar)) {
                            string3 = string3.substring(string2.length());
                        } else {
                            string3 = SourceRoots.this.refHelper.createForeignFileReference(file, "ruby");
                            editableProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        }
                        editableProperties.put(string, string3);
                        SourceRoots.this.helper.putProperties("nbproject/project.properties", editableProperties);
                    }
                    stringArray2 = document.createElementNS("http://www.netbeans.org/ns/ruby-project/1", "root");
                    stringArray2.setAttribute("id", string);
                    String string4 = (String)hashMap2.get(uRL);
                    if (string4 != null && string4.length() > 0 && !string4.equals(SourceRoots.this.getRootDisplayName(null, string))) {
                        stringArray2.setAttribute("name", string4);
                    }
                    element2.appendChild((Node)stringArray2);
                }
                SourceRoots.this.helper.putPrimaryConfigurationData(element, true);
                return null;
            }
        });
    }

    public String getRootDisplayName(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (this.isTest && "test.src.dir".equals(string2)) {
                string = DEFAULT_TEST_LABEL;
            } else if (this.isTest && "spec.src.dir".equals(string2)) {
                string = DEFAULT_SPEC_LABEL;
            } else if (!this.isTest && "src.dir".equals(string2)) {
                string = DEFAULT_SOURCE_LABEL;
            } else {
                String string3 = this.evaluator.getProperty(string2);
                File file = string3 == null ? null : this.helper.getRakeProjectHelper().resolveFile(string3);
                string = this.createInitialDisplayName(file);
            }
        }
        return string;
    }

    public String createInitialDisplayName(File file) {
        String string;
        String string2;
        String string3 = file != null ? ((string2 = file.getAbsolutePath()).startsWith(string = this.projectDir.getAbsolutePath() + File.separatorChar) ? string2.substring(string.length()) : file.getAbsolutePath()) : (this.isTest ? DEFAULT_TEST_LABEL : DEFAULT_SOURCE_LABEL);
        return string3;
    }

    public boolean isTest() {
        return this.isTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(boolean bl, String string) {
        boolean bl2 = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (bl) {
                this.sourceRootProperties = null;
                this.sourceRootNames = null;
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                bl2 = true;
            } else if (string == null || this.sourceRootProperties != null && this.sourceRootProperties.contains(string)) {
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                this.support.firePropertyChange(PROP_ROOT_PROPERTIES, null, null);
            }
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    private void readProjectMetadata() {
        Element element = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", this.elementName);
        assert (nodeList.getLength() == 0 || nodeList.getLength() == 1) : "Illegal project.xml";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (nodeList.getLength() == 1) {
            NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagNameNS("http://www.netbeans.org/ns/ruby-project/1", "root");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element2 = (Element)nodeList2.item(i);
                String string = element2.getAttribute("id");
                assert (string.length() > 0) : "Illegal project.xml";
                arrayList.add(string);
                string = element2.getAttribute("name");
                arrayList2.add(string);
            }
        }
        this.sourceRootProperties = Collections.unmodifiableList(arrayList);
        this.sourceRootNames = Collections.unmodifiableList(arrayList2);
    }

    private class ProjectMetadataListener
    implements PropertyChangeListener,
    RakeProjectListener {
        private ProjectMetadataListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourceRoots.this.resetCache(false, propertyChangeEvent.getPropertyName());
        }

        public void configurationXmlChanged(RakeProjectEvent rakeProjectEvent) {
            SourceRoots.this.resetCache(true, null);
        }

        public void propertiesChanged(RakeProjectEvent rakeProjectEvent) {
        }
    }
}

