/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.IOException;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UpdateHelper {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("j2seproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private final Project project;
    private final RakeProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private final GeneratedFilesHelper genFileHelper;
    private final Notifier notifier;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private Element cachedElement;
    private final String projectConfigurationNamespace;

    UpdateHelper(Project project, RakeProjectHelper rakeProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration, GeneratedFilesHelper generatedFilesHelper, Notifier notifier, String string) {
        assert (project != null && rakeProjectHelper != null && auxiliaryConfiguration != null && generatedFilesHelper != null && notifier != null);
        this.project = project;
        this.helper = rakeProjectHelper;
        this.cfg = auxiliaryConfiguration;
        this.genFileHelper = generatedFilesHelper;
        this.notifier = notifier;
        this.projectConfigurationNamespace = string;
    }

    public EditableProperties getProperties(final String string) {
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            public EditableProperties run() {
                if (!UpdateHelper.this.isCurrent() && "nbproject/project.properties".equals(string)) {
                    return UpdateHelper.this.getUpdatedProjectProperties();
                }
                return UpdateHelper.this.helper.getProperties(string);
            }
        });
    }

    public void putProperties(final String string, final EditableProperties editableProperties) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(string)) {
                    UpdateHelper.this.helper.putProperties(string, editableProperties);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate();
                        UpdateHelper.this.helper.putProperties(string, editableProperties);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean bl) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            public Element run() {
                if (!bl || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(bl);
                }
                return UpdateHelper.this.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean bl) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (!bl || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, bl);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate();
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, bl);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
        });
    }

    public RakeProjectHelper getRakeProjectHelper() {
        return this.helper;
    }

    public boolean requestSave() throws IOException {
        if (this.isCurrent()) {
            return true;
        }
        if (!this.canUpdate()) {
            return false;
        }
        this.saveUpdate();
        return true;
    }

    public synchronized boolean isCurrent() {
        return true;
    }

    private boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean bl = this.notifier.canUpdate();
        if (!bl) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                public void run() {
                    UpdateHelper.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUpdate() throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        ProjectManager.getDefault().saveProject(this.project);
        UpdateHelper updateHelper = this;
        synchronized (updateHelper) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    private synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            // empty if block
        }
        return this.cachedElement;
    }

    private synchronized EditableProperties getUpdatedProjectProperties() {
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        return editableProperties;
    }

    private static void copyDocument(Document document, Element element, Element element2, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            Node node2 = null;
            switch (node.getNodeType()) {
                case 1: {
                    Node node3;
                    Element element3 = (Element)node;
                    node2 = document.createElementNS(string, element3.getTagName());
                    NamedNodeMap namedNodeMap = element3.getAttributes();
                    Element element4 = (Element)node2;
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        node3 = namedNodeMap.item(j);
                        element4.setAttribute(node3.getNodeName(), node3.getNodeValue());
                    }
                    UpdateHelper.copyDocument(document, element3, element4, string);
                    break;
                }
                case 3: {
                    Text text = (Text)node;
                    node2 = document.createTextNode(text.getData());
                    break;
                }
                case 8: {
                    Node node3 = (Comment)node;
                    node2 = document.createComment(node3.getData());
                }
            }
            if (node2 == null) continue;
            element2.appendChild(node2);
        }
    }

    public static Notifier createDefaultNotifier() {
        return new Notifier(){

            public boolean canUpdate() {
                JButton jButton = new JButton(NbBundle.getMessage(UpdateHelper.class, (String)"CTL_UpdateOption"));
                jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateHelper.class, (String)"AD_UpdateOption"));
                return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton)) == jButton;
            }
        };
    }

    public static interface Notifier {
        public boolean canUpdate();
    }
}

