/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.ui.TreeRootNode;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public class ProjectRootNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        RubyProject rubyProject = (RubyProject)project.getLookup().lookup(RubyProject.class);
        assert (rubyProject != null);
        return new RootChildren(rubyProject);
    }

    private static class PreselectPropertiesAction
    extends AbstractAction {
        private final Project project;
        private final String nodeName;
        private final String panelName;

        PreselectPropertiesAction(Project project, String string) {
            this(project, string, null);
        }

        PreselectPropertiesAction(Project project, String string, String string2) {
            super(NbBundle.getMessage(ProjectRootNodeFactory.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = string;
            this.panelName = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            if (customizerProviderImpl != null) {
                customizerProviderImpl.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class FolderViewFilterNode
    extends FilterNode {
        protected String nodeName;
        private final Project project;
        private Action[] actions;

        FolderViewFilterNode(SourceGroup sourceGroup, Project project) {
            super(FolderViewFilterNode.getOriginalNode(sourceGroup));
            this.project = project;
            this.nodeName = "Sources";
        }

        private static Node getOriginalNode(SourceGroup sourceGroup) {
            if (sourceGroup == null) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            FileObject fileObject = sourceGroup.getRootFolder();
            if (fileObject == null || !fileObject.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            return new TreeRootNode(sourceGroup);
        }

        public Action[] getActions(boolean bl) {
            if (this.actions == null) {
                this.actions = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class), null, new PreselectPropertiesAction(this.project, this.nodeName)};
            }
            return this.actions;
        }
    }

    private static class RootChildNode {
        private final SourceGroup group;
        private final FileObject fileObject;

        RootChildNode(SourceGroup sourceGroup) {
            this.group = sourceGroup;
            this.fileObject = sourceGroup.getRootFolder();
        }

        RootChildNode(FileObject fileObject) {
            this.group = null;
            this.fileObject = fileObject;
        }

        public int hashCode() {
            return this.fileObject.hashCode();
        }

        public boolean equals(Object object) {
            String string;
            if (!(object instanceof RootChildNode)) {
                return false;
            }
            RootChildNode rootChildNode = (RootChildNode)object;
            String string2 = this.group == null ? null : this.group.getDisplayName();
            String string3 = string = rootChildNode.group == null ? null : rootChildNode.group.getDisplayName();
            return this.fileObject.equals(rootChildNode.fileObject) && (string2 == null ? string == null : string2.equals(string));
        }

        public String toString() {
            return "ProjectRootNodeFactory[fileObject: " + this.fileObject + ", group: " + this.group + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootChildren
    implements NodeList<RootChildNode>,
    ChangeListener {
        private final FileChangeListener rootFOListener = new RootFileChangeListener();
        private final RubyProject project;
        private final List<ChangeListener> changeListeners;

        public RootChildren(RubyProject rubyProject) {
            FileObject fileObject = rubyProject.getProjectDirectory();
            fileObject.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.rootFOListener, (Object)fileObject));
            this.changeListeners = new CopyOnWriteArrayList<ChangeListener>();
            this.project = rubyProject;
        }

        public List<RootChildNode> keys() {
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("ruby");
            ArrayList<RootChildNode> arrayList = new ArrayList<RootChildNode>();
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                arrayList.add(new RootChildNode(sourceGroupArray[i]));
            }
            arrayList.addAll(this.getRootFiles());
            return arrayList;
        }

        private List<? extends RootChildNode> getRootFiles() {
            FileObject fileObject = this.project.getProjectDirectory();
            ArrayList<RootChildNode> arrayList = new ArrayList<RootChildNode>();
            FileObject fileObject2 = RakeSupport.findRakeFile(this.project);
            if (fileObject2 != null && fileObject.equals(fileObject2.getParent())) {
                arrayList.add(new RootChildNode(fileObject2));
            }
            FileObject[] fileObjectArray = fileObject.getChildren();
            Comparator<FileObject> comparator = new Comparator<FileObject>(){

                @Override
                public int compare(FileObject fileObject, FileObject fileObject2) {
                    return fileObject.getNameExt().toLowerCase().compareTo(fileObject2.getNameExt().toLowerCase());
                }
            };
            Arrays.sort(fileObjectArray, comparator);
            for (FileObject fileObject3 : fileObjectArray) {
                if (fileObject3.isFolder() || RakeSupport.isMainRakeFile(fileObject3)) continue;
                arrayList.add(new RootChildNode(fileObject3));
            }
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeListeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeListeners.remove(changeListener);
        }

        private void fireChange() {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(RootChildNode rootChildNode) {
            if (rootChildNode.group == null) {
                try {
                    if (RakeSupport.isRakeFile(rootChildNode.fileObject)) {
                        return new RakeSupport.RakeNode(rootChildNode.fileObject);
                    }
                    DataObject dataObject = DataObject.find((FileObject)rootChildNode.fileObject);
                    return new FilterNode(dataObject.getNodeDelegate());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
            return new FolderViewFilterNode(rootChildNode.group, this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RootChildren.this.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }

        final class RootFileChangeListener
        extends FileChangeAdapter {
            RootFileChangeListener() {
            }

            public void fileFolderCreated(FileEvent fileEvent) {
                RootChildren.this.stateChanged(null);
            }

            public void fileDataCreated(FileEvent fileEvent) {
                RootChildren.this.stateChanged(null);
            }

            public void fileDeleted(FileEvent fileEvent) {
                RootChildren.this.stateChanged(null);
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                RootChildren.this.stateChanged(null);
            }
        }
    }
}

