/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.SimpleNameFactory;

public class ClassObfuscator
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    private final boolean useMixedCaseClassNames;
    private final String flattenPackageHierarchy;
    private final String repackageClasses;
    private final boolean allowAccessModification;
    private final Set classNamesToAvoid = new HashSet();
    private final Map packagePrefixMap = new HashMap();
    private final Map packagePrefixPackageNameFactoryMap = new HashMap();
    private final Map packagePrefixClassNameFactoryMap = new HashMap();
    private String newClassName;

    public ClassObfuscator(ClassPool classPool, boolean bl, String string, String string2, boolean bl2) {
        if (string != null && string.length() > 0) {
            string = string + '/';
        }
        if (string2 != null && string2.length() > 0) {
            string2 = string2 + '/';
        }
        this.useMixedCaseClassNames = bl;
        this.flattenPackageHierarchy = string;
        this.repackageClasses = string2;
        this.allowAccessModification = bl2;
        this.packagePrefixMap.put("", "");
        classPool.classesAccept(new MyKeepCollector());
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.newClassName = ClassObfuscator.newClassName(programClass);
        if (this.newClassName == null) {
            programClass.attributesAccept(this);
            String string = this.newClassName != null ? this.newClassName + '$' : this.newPackagePrefix(ClassUtil.internalPackagePrefix(programClass.getName()));
            this.newClassName = this.generateUniqueClassName(string);
            ClassObfuscator.setNewClassName(programClass, this.newClassName);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        enclosingMethodAttribute.referencedClassAccept(this);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        int n = innerClassesInfo.u2innerClassIndex;
        int n2 = innerClassesInfo.u2outerClassIndex;
        if (n != 0 && n2 != 0 && clazz.getClassName(n).equals(clazz.getName())) {
            clazz.constantPoolEntryAccept(n2, this);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    private String newPackagePrefix(String string) {
        String string2 = (String)this.packagePrefixMap.get(string);
        if (string2 == null) {
            if (this.repackageClasses != null) {
                return this.repackageClasses;
            }
            String string3 = this.flattenPackageHierarchy != null ? this.flattenPackageHierarchy : this.newPackagePrefix(ClassUtil.internalPackagePrefix(string));
            string2 = this.generateUniquePackagePrefix(string3);
            this.packagePrefixMap.put(string, string2);
        }
        return string2;
    }

    private String generateUniquePackagePrefix(String string) {
        String string2;
        NameFactory nameFactory = (NameFactory)this.packagePrefixPackageNameFactoryMap.get(string);
        if (nameFactory == null) {
            nameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            this.packagePrefixPackageNameFactoryMap.put(string, nameFactory);
        }
        while (this.packagePrefixMap.containsValue(string2 = string + nameFactory.nextName() + '/')) {
        }
        return string2;
    }

    private String generateUniqueClassName(String string) {
        String string2;
        NameFactory nameFactory = (NameFactory)this.packagePrefixClassNameFactoryMap.get(string);
        if (nameFactory == null) {
            nameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            this.packagePrefixClassNameFactoryMap.put(string, nameFactory);
        }
        while (this.classNamesToAvoid.contains(this.mixedCaseClassName(string2 = string + nameFactory.nextName()))) {
        }
        return string2;
    }

    private String mixedCaseClassName(String string) {
        return this.useMixedCaseClassNames ? string : string.toLowerCase();
    }

    static void setNewClassName(Clazz clazz, String string) {
        clazz.setVisitorInfo(string);
    }

    static String newClassName(Clazz clazz) {
        Object object = clazz.getVisitorInfo();
        return object instanceof String ? (String)object : null;
    }

    private class MyKeepCollector
    implements ClassVisitor {
        private MyKeepCollector() {
        }

        public void visitProgramClass(ProgramClass programClass) {
            String string = ClassObfuscator.newClassName(programClass);
            if (string != null) {
                ClassObfuscator.this.classNamesToAvoid.add(ClassObfuscator.this.mixedCaseClassName(string));
                if (ClassObfuscator.this.repackageClasses == null || !ClassObfuscator.this.allowAccessModification) {
                    String string2 = programClass.getName();
                    this.mapPackageName(string2, string, ClassObfuscator.this.repackageClasses == null && ClassObfuscator.this.flattenPackageHierarchy == null);
                }
            }
        }

        public void visitLibraryClass(LibraryClass libraryClass) {
        }

        private void mapPackageName(String string, String string2, boolean bl) {
            String string3 = ClassUtil.internalPackagePrefix(string);
            String string4 = ClassUtil.internalPackagePrefix(string2);
            do {
                ClassObfuscator.this.packagePrefixMap.put(string3, string4);
                if (!bl) break;
                string3 = ClassUtil.internalPackagePrefix(string3);
                string4 = ClassUtil.internalPackagePrefix(string4);
            } while (string3.length() > 0 && string4.length() > 0);
        }
    }
}

