/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.SingleImplementationMarker;

public class SingleImplementationFixer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private final ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();

    public void visitProgramClass(ProgramClass programClass) {
        Clazz clazz = SingleImplementationMarker.singleImplementation(programClass);
        if (clazz != null) {
            this.fixThisClassReference(programClass);
            this.fixInterfaceReference((ProgramClass)programClass.subClasses[0], programClass);
        }
        programClass.constantPoolEntriesAccept(this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        Clazz clazz2 = SingleImplementationMarker.singleImplementation(fieldrefConstant.referencedClass);
        if (clazz2 != null) {
            this.fixFieldrefClassReference((ProgramClass)clazz, fieldrefConstant);
        }
    }

    private void fixThisClassReference(ProgramClass programClass) {
        int n = this.constantPoolEditor.addUtf8Constant(programClass, programClass.getName());
        programClass.u2thisClass = this.constantPoolEditor.addConstant(programClass, new ClassConstant(n, programClass));
    }

    private void fixInterfaceReference(ProgramClass programClass, ProgramClass programClass2) {
        String string = programClass2.getName();
        int n = programClass.u2interfacesCount;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(programClass.getInterfaceName(i))) continue;
            int n2 = this.constantPoolEditor.addUtf8Constant(programClass, string);
            programClass.u2interfaces[i] = this.constantPoolEditor.addConstant(programClass, new ClassConstant(n2, programClass2));
            break;
        }
    }

    private void fixFieldrefClassReference(ProgramClass programClass, FieldrefConstant fieldrefConstant) {
        Clazz clazz = fieldrefConstant.referencedClass;
        int n = this.constantPoolEditor.addUtf8Constant(programClass, fieldrefConstant.getClassName(programClass));
        fieldrefConstant.u2classIndex = this.constantPoolEditor.addConstant(programClass, new ClassConstant(n, clazz));
    }
}

