/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.UsageMarker;

public class ClassShrinker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final UsageMarker usageMarker;
    private int[] constantIndexMap = new int[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    public ClassShrinker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2interfacesCount = this.shrinkConstantIndexArray(programClass.constantPool, programClass.u2interfaces, programClass.u2interfacesCount);
        programClass.u2constantPoolCount = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        programClass.u2fieldsCount = this.shrinkArray(programClass.fields, programClass.u2fieldsCount);
        programClass.u2methodsCount = this.shrinkArray(programClass.methods, programClass.u2methodsCount);
        programClass.u2attributesCount = this.shrinkArray(programClass.attributes, programClass.u2attributesCount);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
        this.constantPoolRemapper.visitProgramClass(programClass);
        programClass.attributesAccept(new SignatureShrinker());
        programClass.subClasses = this.shrinkToNewArray(programClass.subClasses);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.subClasses = this.shrinkToNewArray(libraryClass.subClasses);
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.u2attributesCount = this.shrinkArray(programMember.attributes, programMember.u2attributesCount);
        programMember.attributesAccept(programClass, this);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.u2classesCount = this.shrinkArray(innerClassesAttribute.classes, innerClassesAttribute.u2classesCount);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        if (enclosingMethodAttribute.referencedMethod != null && !this.usageMarker.isUsed(enclosingMethodAttribute.referencedMethod)) {
            enclosingMethodAttribute.u2nameAndTypeIndex = 0;
            enclosingMethodAttribute.referencedMethod = null;
        }
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.u2attributesCount = this.shrinkArray(codeAttribute.attributes, codeAttribute.u2attributesCount);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.u2annotationsCount = this.shrinkArray(annotationsAttribute.annotations, annotationsAttribute.u2annotationsCount);
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        for (int i = 0; i < parameterAnnotationsAttribute.u2parametersCount; ++i) {
            parameterAnnotationsAttribute.u2parameterAnnotationsCount[i] = this.shrinkArray(parameterAnnotationsAttribute.parameterAnnotations[i], parameterAnnotationsAttribute.u2parameterAnnotationsCount[i]);
        }
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.u2elementValuesCount = this.shrinkArray(annotation.elementValues, annotation.u2elementValuesCount);
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.u2elementValuesCount = this.shrinkArray(arrayElementValue.elementValues, arrayElementValue.u2elementValuesCount);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private int shrinkConstantPool(Constant[] constantArray, int n) {
        int n2;
        if (this.constantIndexMap.length < n) {
            this.constantIndexMap = new int[n];
        }
        int n3 = 1;
        boolean bl = false;
        for (n2 = 1; n2 < n; ++n2) {
            this.constantIndexMap[n2] = n3;
            Constant constant = constantArray[n2];
            if (constant != null) {
                bl = this.usageMarker.isUsed(constant);
            }
            if (!bl) continue;
            constantArray[n3++] = constant;
        }
        for (n2 = n3; n2 < n; ++n2) {
            constantArray[n2] = null;
        }
        return n3;
    }

    private int shrinkConstantIndexArray(Constant[] constantArray, int[] nArray, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (!this.usageMarker.isUsed(constantArray[nArray[n2]])) continue;
            nArray[n3++] = nArray[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            nArray[n2] = 0;
        }
        return n3;
    }

    private Clazz[] shrinkToNewArray(Clazz[] clazzArray) {
        if (clazzArray == null) {
            return null;
        }
        int n = this.shrinkArray(clazzArray, clazzArray.length);
        if (n == 0) {
            return null;
        }
        if (n == clazzArray.length) {
            return clazzArray;
        }
        Clazz[] clazzArray2 = new Clazz[n];
        System.arraycopy(clazzArray, 0, clazzArray2, 0, n);
        return clazzArray2;
    }

    private int shrinkArray(VisitorAccepter[] visitorAccepterArray, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (!this.usageMarker.isUsed(visitorAccepterArray[n2])) continue;
            visitorAccepterArray[n3++] = visitorAccepterArray[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            visitorAccepterArray[n2] = null;
        }
        return n3;
    }

    private class SignatureShrinker
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private SignatureShrinker() {
        }

        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
            String string = clazz.getString(signatureAttribute.u2signatureIndex);
            Clazz[] clazzArray = signatureAttribute.referencedClasses;
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = 0;
            while (internalTypeEnumeration.hasMoreTypes()) {
                String string2 = internalTypeEnumeration.nextType();
                int n3 = new DescriptorClassEnumeration(string2).classCount();
                Clazz clazz2 = clazzArray[n];
                if (clazz2 == null || ClassShrinker.this.usageMarker.isUsed(clazz2)) {
                    stringBuffer.append(string2);
                    for (int i = 0; i < n3; ++i) {
                        clazzArray[n2++] = clazzArray[n++];
                    }
                    continue;
                }
                n += n3;
            }
            if (n2 < n) {
                ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(stringBuffer.toString());
                while (n2 < n) {
                    clazzArray[n2++] = null;
                }
            }
        }
    }
}

