/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.jruby;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.glassfish.jruby.ui.JRubyServerCustomizer;
import org.netbeans.modules.glassfish.spi.CustomizerCookie;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.RegexpOutputRecognizer;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyServerModule
implements RubyInstance,
CustomizerCookie,
RecognizerCookie {
    public static final String USE_ROOT_CONTEXT_ATTR = "jruby.useRootContext";
    private Lookup lookup;
    private static final String FILE_CHAR = "[^\\s\\[\\]\\:\\\"]";
    private static final String FILE = "((?:[^\\s\\[\\]\\:\\\"]*))";
    private static final String LINE = "([1-9][0-9]*)";
    private static final String ROL = ".*\\s?";
    private static final String SEP = "\\:";
    private static final String STD_SUFFIX = "((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?";
    private static final RegexpOutputRecognizer RAILS_RECOGNIZER = new RegexpOutputRecognizer(".*#\\{RAILS_ROOT\\}/((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");

    JRubyServerModule(Lookup lookup) {
        this.lookup = lookup;
    }

    public String toString() {
        return "GlassFish V3 / JRuby Support";
    }

    public String getServerUri() {
        String string = null;
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            string = (String)glassfishModule.getInstanceProperties().get("url");
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.INFO, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return string;
    }

    public String getDisplayName() {
        String string = null;
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            string = (String)glassfishModule.getInstanceProperties().get("displayName");
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.INFO, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return string;
    }

    public RubyInstance.ServerState getServerState() {
        RubyInstance.ServerState serverState = null;
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            serverState = JRubyServerModule.translateServerState(glassfishModule.getServerState());
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.INFO, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return serverState;
    }

    public Future<RubyInstance.OperationState> startServer(RubyPlatform rubyPlatform) {
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            glassfishModule.setEnvironmentProperty("jruby.home", rubyPlatform.getHome().getAbsolutePath(), false);
            return JRubyServerModule.wrapTask(glassfishModule.startServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                    Logger.getLogger("glassfish-jruby").log(Level.FINEST, "startServer V3/JRuby: " + operationState + " - " + string);
                }
            }));
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public Future<RubyInstance.OperationState> runApplication(RubyPlatform rubyPlatform, String string, File file) {
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            GlassfishModule.ServerState serverState;
            String string2;
            String string3 = rubyPlatform.getHome().getAbsolutePath();
            if (!string3.equals(string2 = glassfishModule.setEnvironmentProperty("jruby.home", string3, false))) {
                Logger.getLogger("glassfish-jruby").log(Level.WARNING, "Running project with current V3 Rails platform " + string2 + " rather than requested platform " + string3);
            }
            if ((serverState = glassfishModule.getServerState()) == GlassfishModule.ServerState.STOPPED || serverState == GlassfishModule.ServerState.RUNNING) {
                FutureTask<RubyInstance.OperationState> futureTask = new FutureTask<RubyInstance.OperationState>(new RunAppTask(glassfishModule, string, file, serverState == GlassfishModule.ServerState.STOPPED));
                RequestProcessor.getDefault().post(futureTask);
                return futureTask;
            }
            return JRubyServerModule.failedOperation();
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public Future<RubyInstance.OperationState> stopServer() {
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            return JRubyServerModule.wrapTask(glassfishModule.stopServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                    Logger.getLogger("glassfish-jruby").log(Level.FINEST, "stopServer V3/JRuby: " + operationState + " - " + string);
                }
            }));
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public Future<RubyInstance.OperationState> deploy(String string, File file) {
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            FutureTask<RubyInstance.OperationState> futureTask = new FutureTask<RubyInstance.OperationState>(new RunAppTask(glassfishModule, string, file, false));
            RequestProcessor.getDefault().post(futureTask);
            return futureTask;
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public Future<RubyInstance.OperationState> stop(String string) {
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            return JRubyServerModule.wrapTask(glassfishModule.undeploy(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                    Logger.getLogger("glassfish-jruby").log(Level.FINEST, "undeploy V3/JRuby: " + operationState + " - " + string);
                }
            }, string.replaceAll("[ \t]", "_")));
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public boolean isPlatformSupported(RubyPlatform rubyPlatform) {
        return rubyPlatform.isJRuby();
    }

    public void addChangeListener(ChangeListener changeListener) {
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            glassfishModule.addChangeListener(changeListener);
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.WARNING, "No V3 Common Server support found for V3/Ruby server instance");
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            glassfishModule.removeChangeListener(changeListener);
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.WARNING, "No V3 Common Server support found for V3/Ruby server instance");
        }
    }

    public String getContextRoot(String string) {
        String string2 = string;
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            string2 = JRubyServerModule.calculateContextRoot(glassfishModule, string);
        }
        return string2;
    }

    public int getRailsPort() {
        int n = 8080;
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            try {
                String string = (String)glassfishModule.getInstanceProperties().get("httpportnumber");
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger("glassfish-jruby").log(Level.WARNING, "Server's HTTP port value is not a valid integer.");
            }
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.WARNING, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return n;
    }

    public String getServerCommand(RubyPlatform rubyPlatform, String string, File file, int n, boolean bl) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("-cp ");
        List<String> list = this.getServerJars();
        for (String object22 : list) {
            stringBuilder.append(object22);
            stringBuilder.append(File.pathSeparatorChar);
        }
        String string2 = rubyPlatform.getHome().getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "jruby.jar";
        stringBuilder.append(ServerUtilities.quote((String)string2));
        if (string != null && string.length() > 0) {
            String[] stringArray;
            object = stringArray = string.split(File.pathSeparator);
            int n2 = ((String[])object).length;
            for (int i = 0; i < n2; ++i) {
                String string3 = object[i];
                stringBuilder.append(File.pathSeparatorChar);
                stringBuilder.append(ServerUtilities.quote((String)string3));
            }
        }
        stringBuilder.append(" -client");
        stringBuilder.append(" -Djruby.home=");
        stringBuilder.append(ServerUtilities.quote((String)rubyPlatform.getHome().getAbsolutePath()));
        stringBuilder.append(" -Djruby.runtime.max=1");
        String string4 = System.getProperty("grizzly.jruby.vm.params");
        if (string4 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(string4);
        }
        if ((object = Integer.getInteger("grizzly.jruby.vm.debugport")) != null) {
            stringBuilder.append(" -Xdebug -Xrunjdwp:transport=dt_socket,address=" + object + ",server=y,suspend=y");
        }
        if (bl) {
            stringBuilder.append(" -Djruby.reflection=true -Djruby.compile.mode=OFF");
            stringBuilder.append(" -Dglassfish.rdebug=${rdebug.path} -Dglassfish.rdebug.port=${rdebug.port} -Dglassfish.rdebug.version=${rdebug.version} -Dglassfish.rdebug.iosynch=${rdebug.iosynch}");
            if ("true".equals(System.getProperty("glassfish.rdebug.verbose"))) {
                stringBuilder.append(" -Dglassfish.rdebug.verbose=true");
            }
        }
        stringBuilder.append(" com.sun.grizzly.standalone.JRuby");
        stringBuilder.append(" -p ");
        stringBuilder.append(n);
        stringBuilder.append(" -n 1 ");
        stringBuilder.append(ServerUtilities.quote((String)file.getAbsolutePath()));
        return stringBuilder.toString();
    }

    private List<String> getServerJars() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GlassfishModule glassfishModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            String string = (String)glassfishModule.getInstanceProperties().get("homefolder");
            File file = new File(string, "modules");
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String string = file.getName();
                    return string.startsWith("grizzly") && string.endsWith(".jar") && !string.contains("jruby-module");
                }
            });
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    Logger.getLogger("glassfish-jruby").log(Level.FINER, "Found jar for grizzly path: " + file2.getAbsolutePath());
                    arrayList.add(ServerUtilities.quote((String)file2.getAbsolutePath()));
                }
            } else {
                Logger.getLogger("glassfish-jruby").log(Level.WARNING, "Problem accessing " + file.getAbsolutePath() + " when searching for Grizzly Jars.");
            }
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.WARNING, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return arrayList;
    }

    private static String calculateContextRoot(GlassfishModule glassfishModule, String string) {
        boolean bl = Boolean.valueOf((String)glassfishModule.getInstanceProperties().get(USE_ROOT_CONTEXT_ATTR));
        return bl ? "/" : "/" + string.replaceAll("[ \t]", "_");
    }

    private static Future<RubyInstance.OperationState> failedOperation() {
        return new Future<RubyInstance.OperationState>(){

            @Override
            public boolean cancel(boolean bl) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public RubyInstance.OperationState get() throws InterruptedException, ExecutionException {
                return RubyInstance.OperationState.FAILED;
            }

            @Override
            public RubyInstance.OperationState get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return RubyInstance.OperationState.FAILED;
            }
        };
    }

    private static Future<RubyInstance.OperationState> wrapTask(final Future<GlassfishModule.OperationState> future) {
        return new Future<RubyInstance.OperationState>(){

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public RubyInstance.OperationState get() throws InterruptedException, ExecutionException {
                GlassfishModule.OperationState operationState = (GlassfishModule.OperationState)future.get();
                return JRubyServerModule.translateOperationState(operationState);
            }

            @Override
            public RubyInstance.OperationState get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                GlassfishModule.OperationState operationState = (GlassfishModule.OperationState)future.get(l, timeUnit);
                return JRubyServerModule.translateOperationState(operationState);
            }
        };
    }

    private static RubyInstance.ServerState translateServerState(GlassfishModule.ServerState serverState) {
        switch (serverState) {
            case STARTING: {
                return RubyInstance.ServerState.STARTING;
            }
            case RUNNING: 
            case RUNNING_JVM_DEBUG: {
                return RubyInstance.ServerState.RUNNING;
            }
            case STOPPING: {
                return RubyInstance.ServerState.STOPPING;
            }
            case STOPPED: 
            case STOPPED_JVM_BP: {
                return RubyInstance.ServerState.STOPPED;
            }
        }
        Logger.getLogger("glassfish-jruby").log(Level.INFO, "Invalid server state: " + serverState);
        return RubyInstance.ServerState.STOPPED;
    }

    private static RubyInstance.OperationState translateOperationState(GlassfishModule.OperationState operationState) {
        switch (operationState) {
            case RUNNING: {
                return RubyInstance.OperationState.RUNNING;
            }
            case COMPLETED: {
                return RubyInstance.OperationState.COMPLETED;
            }
            case FAILED: {
                return RubyInstance.OperationState.FAILED;
            }
        }
        Logger.getLogger("glassfish-jruby").log(Level.INFO, "Invalid operation state: " + operationState);
        return RubyInstance.OperationState.FAILED;
    }

    public Collection<JPanel> getCustomizerPages() {
        LinkedList<JPanel> linkedList = new LinkedList<JPanel>();
        linkedList.add(new JRubyServerCustomizer((GlassfishModule)this.lookup.lookup(GlassfishModule.class)));
        return linkedList;
    }

    public Collection<? extends Recognizer> getRecognizers() {
        return Collections.singleton(this.wrapRubyRecognizer((FileLocator)new DirectoryFileLocator(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File("/")))), (OutputRecognizer)RAILS_RECOGNIZER));
    }

    private Recognizer wrapRubyRecognizer(final FileLocator fileLocator, final OutputRecognizer outputRecognizer) {
        return new Recognizer(){

            public OutputListener processLine(String string) {
                OutputProcessor outputProcessor = null;
                OutputRecognizer.RecognizedOutput recognizedOutput = outputRecognizer.processLine(string);
                if (recognizedOutput instanceof OutputRecognizer.FileLocation) {
                    OutputRecognizer.FileLocation fileLocation = (OutputRecognizer.FileLocation)recognizedOutput;
                    outputProcessor = new OutputProcessor(fileLocation.file, fileLocation.line, fileLocator);
                }
                return outputProcessor;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RunAppTask
    implements Callable<RubyInstance.OperationState>,
    OperationStateListener {
        private final GlassfishModule commonModule;
        private final String applicationName;
        private final File applicationDir;
        private final boolean doStart;
        private String contextRoot;
        private String step;

        public RunAppTask(GlassfishModule glassfishModule, String string, File file, boolean bl) {
            this.commonModule = glassfishModule;
            this.applicationName = string.replaceAll("[ \t]", "_");
            this.applicationDir = file;
            this.contextRoot = JRubyServerModule.calculateContextRoot(glassfishModule, string);
            this.doStart = bl;
            this.step = "start";
        }

        @Override
        public RubyInstance.OperationState call() throws Exception {
            Future future;
            GlassfishModule.OperationState operationState = GlassfishModule.OperationState.COMPLETED;
            if (this.doStart) {
                future = this.commonModule.startServer((OperationStateListener)this);
                operationState = (GlassfishModule.OperationState)future.get();
            }
            if (operationState == GlassfishModule.OperationState.COMPLETED) {
                if (this.isDeployed()) {
                    operationState = GlassfishModule.OperationState.COMPLETED;
                } else {
                    this.step = "deploy";
                    future = this.commonModule.deploy((OperationStateListener)this, this.applicationDir, this.applicationName, this.contextRoot);
                    operationState = (GlassfishModule.OperationState)future.get();
                }
            }
            return JRubyServerModule.translateOperationState(operationState);
        }

        public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
            Logger.getLogger("glassfish-jruby").log(Level.FINEST, "runApplication/" + this.step + " V3/JRuby: " + operationState + " - " + string);
        }

        private boolean isDeployed() {
            this.step = "checkdeployed";
            String string = "applications.application." + this.applicationName;
            ServerCommand.GetPropertyCommand getPropertyCommand = new ServerCommand.GetPropertyCommand(string);
            Future future = this.commonModule.execute((ServerCommand)getPropertyCommand);
            try {
                ServerCommand.SetPropertyCommand setPropertyCommand;
                GlassfishModule.OperationState operationState = (GlassfishModule.OperationState)future.get(15000L, TimeUnit.MILLISECONDS);
                if (operationState != GlassfishModule.OperationState.COMPLETED) {
                    return false;
                }
                Map map = getPropertyCommand.getData();
                String string2 = (String)map.get(string + ".name");
                if (string2 == null || !string2.equals(this.applicationName)) {
                    return false;
                }
                String string3 = (String)map.get(string + ".location");
                if (string3 == null || !string3.startsWith("file:") || !this.match(this.applicationDir, string3.substring(5))) {
                    return false;
                }
                String string4 = string + ".context-root";
                String string5 = (String)map.get(string4);
                if (string5 == null) {
                    return false;
                }
                if (!string5.equals(this.contextRoot) && (operationState = (GlassfishModule.OperationState)this.commonModule.execute((ServerCommand)(setPropertyCommand = new ServerCommand.SetPropertyCommand(string4, this.contextRoot))).get(15000L, TimeUnit.MILLISECONDS)) != GlassfishModule.OperationState.COMPLETED) {
                    return false;
                }
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish.javaee").log(Level.FINE, exception.getLocalizedMessage(), exception);
                return false;
            }
            return true;
        }

        private boolean match(File file, String string) {
            String string2 = file.getAbsolutePath().replaceAll("[ \t]", "%20");
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            return string2.equals(string);
        }
    }
}

