/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.dataconnectivity;

import java.awt.Point;
import java.io.File;
import javax.swing.tree.TreePath;
import junit.framework.Assert;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.AddDataSourceOperator;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.DataSource;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.EditServerTypesOperator;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.ModifyDataSourceOperator;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.ServerExplorerOperator;

public class ServerNavigatorOperator
extends ServerExplorerOperator {
    private static final String pointbaseName = "Bundled Database";
    private static final String[] pbParams = new String[]{"", "Bundled Database"};
    JTreeOperator tree = null;

    public ServerNavigatorOperator(ContainerOperator containerOperator) {
        super(containerOperator);
        this.getTree();
    }

    public ServerNavigatorOperator() {
        this((ContainerOperator)Util.getMainWindow());
    }

    public static ServerNavigatorOperator showNavigatorOperator() {
        Util.getMainMenu().pushMenuNoBlock("Window|Services");
        Util.wait(1000);
        new QueueTool().waitEmpty();
        return new ServerNavigatorOperator();
    }

    public void addTable(TreePath treePath) {
        JPopupMenuOperator jPopupMenuOperator = new JPopupMenuOperator(this.getTree().callPopupOnPath(treePath));
        jPopupMenuOperator.pushMenu(ServerNavigatorOperator.getBundleString("Add_to_Form"));
    }

    public boolean addDataSource(String string, DataSource dataSource) {
        this.pushPopup(ServerNavigatorOperator.getBundleString("Databases"), ServerNavigatorOperator.getBundleString("New connection..."));
        AddDataSourceOperator addDataSourceOperator = new AddDataSourceOperator();
        JComboBoxOperator jComboBoxOperator = addDataSourceOperator.cboServerType();
        System.out.println("DBType=" + dataSource.getDbType());
        System.out.println("DBType now=" + jComboBoxOperator.getSelectedItem());
        if (dataSource.getDbType() != null && dataSource.getDbType().length() > 0) {
            jComboBoxOperator.selectItem(dataSource.getDbType());
        }
        Util.wait(1000);
        System.out.println("DB URL=" + dataSource.getDbUrl());
        if (dataSource.getDbUrl() != null && dataSource.getDbUrl().length() > 0) {
            addDataSourceOperator.cboURL().clearText();
            addDataSourceOperator.cboURL().typeText(dataSource.getDbUrl());
        }
        Util.wait(500);
        addDataSourceOperator.txtUser().clearText();
        addDataSourceOperator.txtUser().typeText(dataSource.getUser());
        Util.wait(500);
        addDataSourceOperator.txtPassword().clearText();
        addDataSourceOperator.txtPassword().typeText(dataSource.getPassword());
        Util.wait(500);
        new JButtonOperator((ContainerOperator)addDataSourceOperator, ServerNavigatorOperator.getBundleString("OK")).push();
        Util.wait(10000);
        if (dataSource.getDbType().equalsIgnoreCase("mysql")) {
            new JButtonOperator((ContainerOperator)addDataSourceOperator, ServerNavigatorOperator.getBundleString("OK")).push();
        }
        return true;
    }

    public void connectToDataSource(String string, DataSource dataSource) {
        String[] stringArray = new String[]{ServerNavigatorOperator.getBundleString("Databases"), string};
        this.pushPopup(stringArray, ServerNavigatorOperator.getBundleString("Connect..."));
        Util.wait(1000);
        JDialogOperator jDialogOperator = new JDialogOperator();
        Util.wait(1000);
        JTextFieldOperator jTextFieldOperator = new JTextFieldOperator((ContainerOperator)jDialogOperator, 0);
        jTextFieldOperator.clearText();
        jTextFieldOperator.typeText(dataSource.getUser());
        Util.wait(500);
        JTextFieldOperator jTextFieldOperator2 = new JTextFieldOperator((ContainerOperator)jDialogOperator, 1);
        jTextFieldOperator2.clearText();
        jTextFieldOperator2.typeText(dataSource.getPassword());
        Util.wait(500);
        JCheckBoxOperator jCheckBoxOperator = new JCheckBoxOperator((ContainerOperator)jDialogOperator);
        jCheckBoxOperator.setSelected(true);
        new JButtonOperator((ContainerOperator)jDialogOperator, ServerNavigatorOperator.getBundleString("OK")).pushNoBlock();
        Util.wait(2000);
        try {
            new TopComponentOperator("Output").close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean modifyDataSource(String string, DataSource dataSource) {
        String[] stringArray = new String[]{ServerNavigatorOperator.getBundleString("Databases"), string};
        this.pushPopup(stringArray, ServerNavigatorOperator.getBundleString("MODIFY_DATASOURCE"));
        ModifyDataSourceOperator modifyDataSourceOperator = new ModifyDataSourceOperator();
        JTextFieldOperator jTextFieldOperator = modifyDataSourceOperator.txtDSName();
        jTextFieldOperator.clearText();
        jTextFieldOperator.typeText(string);
        Util.wait(500);
        jTextFieldOperator = modifyDataSourceOperator.txtUser();
        jTextFieldOperator.clearText();
        jTextFieldOperator.typeText(dataSource.getUser());
        Util.wait(500);
        jTextFieldOperator = modifyDataSourceOperator.txtPassword();
        jTextFieldOperator.clearText();
        jTextFieldOperator.typeText(dataSource.getPassword());
        Util.wait(500);
        jTextFieldOperator = modifyDataSourceOperator.txtURL();
        jTextFieldOperator.clearText();
        jTextFieldOperator.typeText(dataSource.getDbUrl());
        Util.wait(2000);
        new QueueTool().waitEmpty();
        modifyDataSourceOperator.btTestConnection().push();
        JDialogOperator jDialogOperator = new JDialogOperator((WindowOperator)modifyDataSourceOperator, 0);
        boolean bl = jDialogOperator.getTitle().equals("Information");
        new JButtonOperator((ContainerOperator)jDialogOperator, ServerNavigatorOperator.getBundleString("OK")).push();
        new JButtonOperator((ContainerOperator)modifyDataSourceOperator, ServerNavigatorOperator.getBundleString(bl ? "MODIFY" : "CANCEL")).push();
        return bl;
    }

    public boolean removeDataSource(String string) {
        String[] stringArray = new String[]{ServerNavigatorOperator.getBundleString("Databases"), string};
        this.pushPopup(stringArray, ServerNavigatorOperator.getBundleString("REMOVE_CONNECTION"));
        Util.wait(1000);
        return true;
    }

    public void addNewServerType(String string, String string2, String string3) {
        this.addNewServerType(string, string2, string3, "");
    }

    public void addNewServerType(String string, String string2, String string3, String string4) {
        this.pushPopup(new String[]{ServerNavigatorOperator.getBundleString("Databases"), ServerNavigatorOperator.getBundleString("Drivers")}, ServerNavigatorOperator.getBundleString("New driver..."));
        EditServerTypesOperator editServerTypesOperator = new EditServerTypesOperator();
        Util.wait(1000);
        editServerTypesOperator.btNew().pushNoBlock();
        JDialogOperator jDialogOperator = new JDialogOperator(ServerNavigatorOperator.getBundleString("Select Driver"));
        if (System.getProperty("os.name").equals("Mac OS X")) {
            String[] stringArray = string3.substring(1, string3.length()).split(File.separator);
            TestUtils.wait(1000);
            JComboBoxOperator jComboBoxOperator = new JComboBoxOperator((ContainerOperator)jDialogOperator);
            for (int i = 0; i < jComboBoxOperator.getItemCount(); ++i) {
                if (!jComboBoxOperator.getItemAt(i).toString().equals(File.separator)) continue;
                jComboBoxOperator.setSelectedIndex(i);
                break;
            }
            String string5 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                JTableOperator jTableOperator = new JTableOperator((ContainerOperator)jDialogOperator);
                string5 = string5 + "/" + stringArray[i];
                System.out.println("toComapre=" + string5);
                Point point = jTableOperator.findCell(string5, (Operator.StringComparator)new Operator.DefaultStringComparator(true, true), 0);
                TestUtils.wait(1000);
                jTableOperator.clickOnCell((int)point.getY(), (int)point.getX(), 2);
                TestUtils.wait(1000);
            }
        } else {
            JTextFieldOperator jTextFieldOperator = new JTextFieldOperator((ContainerOperator)jDialogOperator);
            jTextFieldOperator.typeText(string3);
            Util.wait(500);
            new JButtonOperator((ContainerOperator)jDialogOperator, "Open").push();
            Util.wait(1000);
        }
        Util.wait(1000);
        editServerTypesOperator.btOK().push();
    }

    public void deleteServerType(String string) {
        this.pushPopup(ServerNavigatorOperator.getBundleString("Databases"), ServerNavigatorOperator.getBundleString("CONFIGURE_JDBC_DRIVER"));
        EditServerTypesOperator editServerTypesOperator = new EditServerTypesOperator();
        Util.wait(1000);
        editServerTypesOperator.lstServerTypes().setSelectedValue((Object)string, true);
        editServerTypesOperator.btRemove().pushNoBlock();
        Util.wait(1000);
        editServerTypesOperator.closeByButton();
    }

    public void viewData(String string) {
        this.pushPopup(string, ServerNavigatorOperator.getBundleString("VIEW_DATA"));
    }

    public void viewData(String[] stringArray) {
        this.pushPopup(stringArray, ServerNavigatorOperator.getBundleString("VIEW_DATA"));
    }

    public void closeDataView() {
        Util.closeWindow();
    }

    public void showSchema(String string, String[] stringArray) {
        this.pushPopup(ServerNavigatorOperator.getBundleString("Databases") + "/" + string, ServerNavigatorOperator.getBundleString("VIEW_DATA"));
    }

    public static String getBundleString(String string) {
        System.out.println("Getting bundle for " + string);
        return string;
    }

    public static boolean isPBRunning() {
        boolean bl = true;
        JPopupMenuOperator jPopupMenuOperator = ServerNavigatorOperator.getTreeNodePopupMenu(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_ServerNav_NodeName", (Object[])pbParams));
        if (jPopupMenuOperator != null) {
            bl = !TestUtils.findPopupMenuItemByLabel(jPopupMenuOperator, Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_Start", (Object[])pbParams)).isEnabled();
        } else {
            Assert.fail((String)"Popup menu for bundled server not found");
        }
        jPopupMenuOperator.pressKey(27);
        new QueueTool().waitEmpty();
        Util.wait(500);
        return bl;
    }

    public static void stopPB() {
        JPopupMenuOperator jPopupMenuOperator = ServerNavigatorOperator.getTreeNodePopupMenu(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_ServerNav_NodeName", (Object[])pbParams));
        if (jPopupMenuOperator != null) {
            jPopupMenuOperator.pushMenuNoBlock(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_Stop", (Object[])pbParams));
            new QueueTool().waitEmpty();
            Util.wait(2000);
            System.out.println("Pointbase Database Server has been stopped.");
        }
        new QueueTool().waitEmpty();
        Util.wait(1000);
    }

    public static void startPB() {
        JPopupMenuOperator jPopupMenuOperator = ServerNavigatorOperator.getTreeNodePopupMenu(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_ServerNav_NodeName", (Object[])pbParams));
        if (jPopupMenuOperator != null) {
            jPopupMenuOperator.pushMenuNoBlock(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_Start", (Object[])pbParams));
            new QueueTool().waitEmpty();
            Util.wait(2000);
            System.out.println("Pointbase Database Server has started.");
        }
        new QueueTool().waitEmpty();
        Util.wait(1000);
    }

    private static JTreeOperator selectTreeNode(String string) {
        try {
            QueueTool queueTool = new QueueTool();
            queueTool.waitEmpty(100L);
            ServerNavigatorOperator serverNavigatorOperator = ServerNavigatorOperator.showNavigatorOperator();
            serverNavigatorOperator.makeComponentVisible();
            JTreeOperator jTreeOperator = serverNavigatorOperator.getTree();
            jTreeOperator.getTimeouts().setTimeout("JTreeOperator.WaitNodeExpandedTimeout", 60000L);
            jTreeOperator.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 60000L);
            jTreeOperator.getTimeouts().setTimeout("JTreeOperator.WaitNodeVisibleTimeout", 60000L);
            TreePath treePath = jTreeOperator.findPath(string);
            serverNavigatorOperator.getTree().selectPath(treePath);
            queueTool.waitEmpty(100L);
            return jTreeOperator;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static JPopupMenuOperator getTreeNodePopupMenu(String string) {
        try {
            QueueTool queueTool = new QueueTool();
            JTreeOperator jTreeOperator = ServerNavigatorOperator.selectTreeNode(string);
            TreePath treePath = jTreeOperator.findPath(string);
            queueTool.waitEmpty(100L);
            JPopupMenuOperator jPopupMenuOperator = new JPopupMenuOperator(jTreeOperator.callPopupOnPath(treePath));
            queueTool.waitEmpty(100L);
            Util.wait(100);
            return jPopupMenuOperator;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

